/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.session.SessionContextHolder;

public class MultiKeyIdentityIterator
implements Iterator<KeyPair>,
SessionContextHolder {
    protected Iterator<KeyPair> currentProvider;
    protected boolean finished;
    private final SessionContext sessionContext;
    private final Iterator<? extends KeyIdentityProvider> providers;

    public MultiKeyIdentityIterator(SessionContext session, Iterable<? extends KeyIdentityProvider> providers) {
        this.providers = providers == null ? null : providers.iterator();
        this.sessionContext = session;
    }

    public Iterator<? extends KeyIdentityProvider> getProviders() {
        return this.providers;
    }

    @Override
    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        Iterator<? extends KeyIdentityProvider> provs = this.getProviders();
        if (provs == null) {
            this.finished = true;
            return false;
        }
        if (this.currentProvider != null && this.currentProvider.hasNext()) {
            return true;
        }
        SessionContext session = this.getSessionContext();
        while (provs.hasNext()) {
            Iterable<KeyPair> keys2;
            KeyIdentityProvider p = provs.next();
            try {
                keys2 = p == null ? null : p.loadKeys(session);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new IllegalArgumentException("Unexpected " + e.getClass().getSimpleName() + ") keys loading exception: " + e.getMessage(), e);
            }
            Iterator<KeyPair> iterator2 = this.currentProvider = keys2 == null ? null : keys2.iterator();
            if (this.currentProvider == null || !this.currentProvider.hasNext()) continue;
            return true;
        }
        this.finished = false;
        return false;
    }

    @Override
    public KeyPair next() {
        if (this.finished) {
            throw new NoSuchElementException("All identities have been exhausted");
        }
        if (this.currentProvider == null) {
            throw new IllegalStateException("'next()' called without asking 'hasNext()'");
        }
        return this.currentProvider.next();
    }
}

