/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImAlloc;
import de.peeeq.wurstscript.jassIm.ImAnyType;
import de.peeeq.wurstscript.jassIm.ImArrayType;
import de.peeeq.wurstscript.jassIm.ImArrayTypeMulti;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImClassRelatedExprWithClass;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImDealloc;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImInstanceof;
import de.peeeq.wurstscript.jassIm.ImMemberAccess;
import de.peeeq.wurstscript.jassIm.ImMemberOrMethodAccess;
import de.peeeq.wurstscript.jassIm.ImMethod;
import de.peeeq.wurstscript.jassIm.ImMethodCall;
import de.peeeq.wurstscript.jassIm.ImNull;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImSimpleType;
import de.peeeq.wurstscript.jassIm.ImTupleType;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImTypeArguments;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfClass;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfObj;
import de.peeeq.wurstscript.jassIm.ImTypeVar;
import de.peeeq.wurstscript.jassIm.ImTypeVarRef;
import de.peeeq.wurstscript.jassIm.ImTypeVars;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVoid;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtojass.ImAttrType;
import de.peeeq.wurstscript.translation.imtojass.TypeRewriteMatcher;
import de.peeeq.wurstscript.translation.imtranslation.GenericTypes;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class EliminateGenerics {
    private final ImTranslator translator;
    private final ImProg prog;
    private final Deque<GenericUse> genericsUses = new ArrayDeque<GenericUse>();
    private final Table<ImFunction, GenericTypes, ImFunction> specializedFunctions = HashBasedTable.create();
    private final Table<ImMethod, GenericTypes, ImMethod> specializedMethods = HashBasedTable.create();
    private final Table<ImClass, GenericTypes, ImClass> specializedClasses = HashBasedTable.create();
    private final Multimap<ImClass, BiConsumer<GenericTypes, ImClass>> onSpecializedClassTriggers = HashMultimap.create();

    public EliminateGenerics(ImTranslator tr, ImProg prog) {
        this.translator = tr;
        this.prog = prog;
    }

    public void transform() {
        this.simplifyClasses();
        this.addMemberTypeArguments();
        this.collectGenericUsages();
        this.eliminateGenericUses();
        this.removeGenericConstructs();
    }

    private void onSpecializeClass(ImClass orig, BiConsumer<GenericTypes, ImClass> action) {
        this.onSpecializedClassTriggers.put((Object)orig, action);
        this.specializedClasses.row((Object)orig).forEach(action);
    }

    private void addMemberTypeArguments() {
        this.prog.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImMethodCall mc) {
                super.visit(mc);
                this.handle(mc, mc.getMethod().attrClass());
            }

            @Override
            public void visit(ImMemberAccess ma) {
                super.visit(ma);
                this.handle(ma, (ImClass)ma.getVar().getParent().getParent());
            }

            private void handle(ImMemberOrMethodAccess ma, ImClass owningClass) {
                ImType receiverType = ma.getReceiver().attrTyp();
                if (!(receiverType instanceof ImClassType)) {
                    return;
                }
                ImClassType rt = (ImClassType)receiverType;
                ImClassType ct = EliminateGenerics.adaptToSuperclass(rt, owningClass);
                if (ct == null) {
                    throw new CompileError(ma, "Could not adapt receiver " + rt + " to superclass " + owningClass + " in member access " + ma);
                }
                List typeArgs = ct.getTypeArguments().stream().map(ImTypeArgument::copy).collect(Collectors.toList());
                ma.getTypeArguments().addAll(0, (Collection)typeArgs);
            }
        });
    }

    private static ImClassType adaptToSuperclass(ImClassType ct, ImClass owningClass) {
        if (ct.getClassDef() == owningClass) {
            return ct;
        }
        for (ImClassType sc : EliminateGenerics.superTypes(ct)) {
            ImClassType r = EliminateGenerics.adaptToSuperclass(sc, owningClass);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private static Iterable<ImClassType> superTypes(ImClassType ct) {
        GenericTypes generics = new GenericTypes(ct.getTypeArguments());
        ImTypeVars typeVars = ct.getClassDef().getTypeVariables();
        return () -> ct.getClassDef().getSuperClasses().stream().map(sc -> (ImClassType)EliminateGenerics.transformType(sc, generics, typeVars)).iterator();
    }

    private void simplifyClasses() {
        for (ImClass c : this.prog.getClasses()) {
            this.simplifyClass(c);
        }
    }

    private void simplifyClass(ImClass c) {
        this.moveMethodsOutOfClass(c);
        this.moveFunctionsOutOfClass(c);
    }

    private void moveMethodsOutOfClass(ImClass c) {
        List methods = c.getMethods().removeAll();
        this.prog.getMethods().addAll((Collection)methods);
    }

    private void moveFunctionsOutOfClass(ImClass c) {
        List functions = c.getFunctions().removeAll();
        for (ImFunction f : functions) {
            this.prog.getFunctions().add(f);
            List newTypeVars = c.getTypeVariables().stream().map(ImTypeVar::copy).collect(Collectors.toList());
            f.getTypeVariables().addAll(0, (Collection)newTypeVars);
            List<ImTypeArgument> typeArgs = newTypeVars.stream().map(ta -> JassIm.ImTypeArgument(JassIm.ImTypeVarRef(ta), Collections.emptyMap())).collect(Collectors.toList());
            this.rewriteGenerics(f, new GenericTypes(typeArgs), c.getTypeVariables());
        }
    }

    private void removeGenericConstructs() {
        this.prog.getFunctions().removeIf(f -> !f.getTypeVariables().isEmpty());
        this.prog.getMethods().removeIf(m -> !m.getImplementation().getTypeVariables().isEmpty());
        this.prog.getClasses().removeIf(c -> !c.getTypeVariables().isEmpty());
        for (ImClass c2 : this.prog.getClasses()) {
            c2.getFields().removeIf(f -> EliminateGenerics.isGenericType(f.getType()));
        }
    }

    private void eliminateGenericUses() {
        while (!this.genericsUses.isEmpty()) {
            GenericUse gu = this.genericsUses.removeFirst();
            gu.eliminate();
        }
    }

    private ImFunction specializeFunction(ImFunction f, GenericTypes generics) {
        ImFunction specialized = (ImFunction)this.specializedFunctions.get((Object)f, (Object)generics);
        if (specialized != null) {
            return specialized;
        }
        if (f.getTypeVariables().isEmpty()) {
            return f;
        }
        if (generics.containsTypeVariable()) {
            throw new CompileError(f, "Generics should not contain type variables");
        }
        ImFunction newF = f.copyWithRefs();
        this.specializedFunctions.put((Object)f, (Object)generics, (Object)newF);
        this.prog.getFunctions().add(newF);
        newF.getTypeVariables().removeAll();
        ImTypeVars typeVars = f.getTypeVariables();
        newF.setName(f.getName() + "\u27ea" + generics.makeName() + "\u27eb");
        this.rewriteGenerics(newF, generics, typeVars);
        this.collectGenericUsages(newF);
        return newF;
    }

    private ImMethod specializeMethod(ImMethod m, GenericTypes generics) {
        ImMethod specialized = (ImMethod)this.specializedMethods.get((Object)m, (Object)generics);
        if (specialized != null) {
            return specialized;
        }
        if (generics.containsTypeVariable()) {
            throw new CompileError(m, "Generics should not contain type variables.");
        }
        ImMethod newM = m.copyWithRefs();
        this.specializedMethods.put((Object)m, (Object)generics, (Object)newM);
        this.prog.getMethods().add(newM);
        ImClassType newClassType = newM.getMethodClass().copy();
        for (int i = 0; i < newClassType.getTypeArguments().size(); ++i) {
            newClassType.getTypeArguments().set(i, (Object)generics.getTypeArguments().get(i).copy());
        }
        newM.setMethodClass(this.specializeType(newClassType));
        newM.setName(m.getName() + "\u27ea" + generics.makeName() + "\u27eb");
        newM.setImplementation(this.specializeFunction(newM.getImplementation(), generics));
        this.adaptSubmethods(m.getSubMethods(), newM);
        return newM;
    }

    private void adaptSubmethods(List<ImMethod> oldSubMethods, ImMethod newM) {
        newM.setSubMethods(new ArrayList<ImMethod>());
        ImClassType newClassT = newM.getMethodClass();
        ImClass newMClass = newClassT.getClassDef();
        for (ImMethod subMethod : oldSubMethods) {
            ImClassType subClassT = subMethod.getMethodClass();
            ImClass subClass = subClassT.getClassDef();
            if (EliminateGenerics.isGenericType(subClassT)) {
                this.onSpecializeClass(subClass, (subGenerics, specializedSubClass) -> {
                    if (specializedSubClass.isSubclassOf(newMClass)) {
                        ImMethod specializedSubMethod = this.specializeMethod(subMethod, (GenericTypes)subGenerics);
                        newM.getSubMethods().add(specializedSubMethod);
                    }
                });
                continue;
            }
            subClass.getSuperClasses().replaceAll(this::specializeType);
            ImClassType newClassTspecialized = this.specializeType(newClassT);
            if (!subClass.isSubclassOf(newClassTspecialized.getClassDef())) continue;
            newM.getSubMethods().add(subMethod);
        }
    }

    private void rewriteGenerics(Element element, final GenericTypes generics, final List<ImTypeVar> typeVars) {
        if (generics.getTypeArguments().size() != typeVars.size()) {
            throw new RuntimeException("Rewrite generics with wrong sizes\ngenerics: " + generics + "\ntypevars: " + typeVars + "\nin\n: " + element);
        }
        element.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImClass c) {
                c.getSuperClasses().replaceAll(t -> (ImClassType)EliminateGenerics.transformType(t, generics, typeVars));
                super.visit(c);
            }

            @Override
            public void visit(ImTypeArgument ta) {
                ta.setType(EliminateGenerics.transformType(ta.getType(), generics, typeVars));
            }

            @Override
            public void visit(ImNull e) {
                e.setType(EliminateGenerics.transformType(e.getType(), generics, typeVars));
                super.visit(e);
            }

            @Override
            public void visit(ImFunction e) {
                e.setReturnType(EliminateGenerics.transformType(e.getReturnType(), generics, typeVars));
                super.visit(e);
            }

            @Override
            public void visit(ImVar e) {
                e.setType(EliminateGenerics.transformType(e.getType(), generics, typeVars));
                super.visit(e);
            }

            @Override
            public void visit(ImAlloc e) {
                e.setClazz((ImClassType)EliminateGenerics.transformType(e.getClazz(), generics, typeVars));
                super.visit(e);
            }

            @Override
            public void visit(ImInstanceof e) {
                e.setClazz((ImClassType)EliminateGenerics.transformType(e.getClazz(), generics, typeVars));
                super.visit(e);
            }

            @Override
            public void visit(ImTypeIdOfClass e) {
                e.setClazz((ImClassType)EliminateGenerics.transformType(e.getClazz(), generics, typeVars));
                super.visit(e);
            }

            @Override
            public void visit(ImTypeIdOfObj e) {
                e.setClazz((ImClassType)EliminateGenerics.transformType(e.getClazz(), generics, typeVars));
                super.visit(e);
            }

            @Override
            public void visit(ImDealloc e) {
                e.setClazz((ImClassType)EliminateGenerics.transformType(e.getClazz(), generics, typeVars));
                super.visit(e);
            }
        });
    }

    private static ImType transformType(ImType type, GenericTypes generics, List<ImTypeVar> typeVars) {
        return ImAttrType.substituteType(type, generics.getTypeArguments(), typeVars);
    }

    private ImClass specializeClass(ImClass c, GenericTypes generics) {
        if (c.getTypeVariables().isEmpty()) {
            return c;
        }
        ImClass specialized = (ImClass)this.specializedClasses.get((Object)c, (Object)generics);
        if (specialized != null) {
            return specialized;
        }
        if (generics.containsTypeVariable()) {
            throw new CompileError(c, "Generics should not contain type variables.");
        }
        ImClass newC = c.copyWithRefs();
        newC.setSuperClasses(new ArrayList<ImClassType>(newC.getSuperClasses()));
        this.specializedClasses.put((Object)c, (Object)generics, (Object)newC);
        this.prog.getClasses().add(newC);
        newC.getTypeVariables().removeAll();
        newC.setName(c.getName() + "\u27ea" + generics.makeName() + "\u27eb");
        ImTypeVars typeVars = c.getTypeVariables();
        this.rewriteGenerics(newC, generics, typeVars);
        newC.getSuperClasses().replaceAll(this::specializeType);
        this.onSpecializedClassTriggers.get((Object)c).forEach(consumer -> consumer.accept(generics, newC));
        return newC;
    }

    private void collectGenericUsages() {
        this.collectGenericUsages(this.prog);
    }

    private void collectGenericUsages(Element element) {
        element.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImFunctionCall f) {
                super.visit(f);
                if (!f.getTypeArguments().isEmpty()) {
                    EliminateGenerics.this.genericsUses.add(new GenericImFunctionCall(f));
                }
            }

            @Override
            public void visit(ImMethodCall mc) {
                super.visit(mc);
                if (!mc.getTypeArguments().isEmpty()) {
                    EliminateGenerics.this.genericsUses.add(new GenericMethodCall(mc));
                }
            }

            @Override
            public void visit(ImMemberAccess ma) {
                super.visit(ma);
                if (!ma.getTypeArguments().isEmpty()) {
                    EliminateGenerics.this.genericsUses.add(new GenericMemberAccess(ma));
                }
            }

            @Override
            public void visit(ImVar v) {
                super.visit(v);
                if (EliminateGenerics.isGenericType(v.getType())) {
                    if (EliminateGenerics.containsTypeVariable(v.getType())) {
                        throw new CompileError(v, "Var should not have type variables.");
                    }
                    EliminateGenerics.this.genericsUses.add(new GenericVar(v));
                }
            }

            @Override
            public void visit(ImClass c) {
                if (!c.getTypeVariables().isEmpty()) {
                    return;
                }
                EliminateGenerics.this.genericsUses.add(() -> {
                    List<ImClassType> newSuperClasses = c.getSuperClasses().stream().map(x$0 -> EliminateGenerics.this.specializeType((ImClassType)x$0)).collect(Collectors.toList());
                    c.setSuperClasses(newSuperClasses);
                });
                super.visit(c);
            }

            @Override
            public void visit(ImFunction f) {
                if (!f.getTypeVariables().isEmpty()) {
                    return;
                }
                super.visit(f);
                if (EliminateGenerics.isGenericType(f.getReturnType())) {
                    EliminateGenerics.this.genericsUses.add(new GenericReturnTypeFunc(f));
                }
            }

            @Override
            public void visit(ImAlloc f) {
                if (EliminateGenerics.isGenericType(f.getClazz())) {
                    EliminateGenerics.this.genericsUses.add(new GenericClazzUse(f));
                }
            }

            @Override
            public void visit(ImDealloc f) {
                if (EliminateGenerics.isGenericType(f.getClazz())) {
                    EliminateGenerics.this.genericsUses.add(new GenericClazzUse(f));
                }
            }

            @Override
            public void visit(ImInstanceof f) {
                if (EliminateGenerics.isGenericType(f.getClazz())) {
                    EliminateGenerics.this.genericsUses.add(new GenericClazzUse(f));
                }
            }

            @Override
            public void visit(ImTypeIdOfObj f) {
                if (EliminateGenerics.isGenericType(f.getClazz())) {
                    EliminateGenerics.this.genericsUses.add(new GenericClazzUse(f));
                }
            }

            @Override
            public void visit(ImTypeIdOfClass f) {
                if (EliminateGenerics.isGenericType(f.getClazz())) {
                    EliminateGenerics.this.genericsUses.add(new GenericClazzUse(f));
                }
            }
        });
    }

    static boolean isGenericType(ImType type) {
        return type.match(new ImType.Matcher<Boolean>(){

            @Override
            public Boolean case_ImArrayTypeMulti(ImArrayTypeMulti t) {
                return EliminateGenerics.isGenericType(t.getEntryType());
            }

            @Override
            public Boolean case_ImArrayType(ImArrayType t) {
                return EliminateGenerics.isGenericType(t.getEntryType());
            }

            @Override
            public Boolean case_ImClassType(ImClassType t) {
                return !t.getTypeArguments().isEmpty();
            }

            @Override
            public Boolean case_ImVoid(ImVoid t) {
                return false;
            }

            @Override
            public Boolean case_ImAnyType(ImAnyType imAnyType) {
                return false;
            }

            @Override
            public Boolean case_ImTupleType(ImTupleType t) {
                for (ImType tt : t.getTypes()) {
                    if (!EliminateGenerics.isGenericType(tt)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean case_ImSimpleType(ImSimpleType t) {
                return false;
            }

            @Override
            public Boolean case_ImTypeVarRef(ImTypeVarRef t) {
                return false;
            }
        });
    }

    static boolean containsTypeVariable(ImType type) {
        return type.match(new ImType.Matcher<Boolean>(){

            @Override
            public Boolean case_ImArrayTypeMulti(ImArrayTypeMulti t) {
                return EliminateGenerics.containsTypeVariable(t.getEntryType());
            }

            @Override
            public Boolean case_ImArrayType(ImArrayType t) {
                return EliminateGenerics.containsTypeVariable(t.getEntryType());
            }

            @Override
            public Boolean case_ImClassType(ImClassType t) {
                return t.getTypeArguments().stream().anyMatch(tt -> EliminateGenerics.containsTypeVariable(tt.getType()));
            }

            @Override
            public Boolean case_ImVoid(ImVoid t) {
                return false;
            }

            @Override
            public Boolean case_ImAnyType(ImAnyType imAnyType) {
                return false;
            }

            @Override
            public Boolean case_ImTupleType(ImTupleType t) {
                for (ImType tt : t.getTypes()) {
                    if (!EliminateGenerics.containsTypeVariable(tt)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean case_ImSimpleType(ImSimpleType t) {
                return false;
            }

            @Override
            public Boolean case_ImTypeVarRef(ImTypeVarRef t) {
                return true;
            }
        });
    }

    private ImClassType specializeType(ImClassType type) {
        return (ImClassType)this.specializeType((ImType)type);
    }

    private ImType specializeType(ImType type) {
        return type.match(new TypeRewriteMatcher(){

            @Override
            public ImType case_ImClassType(ImClassType t) {
                ImTypeArguments typeArgs = t.getTypeArguments();
                List<ImTypeArgument> newTypeArgs = EliminateGenerics.this.specializeTypeArgs(typeArgs);
                ImClass specializedClass = EliminateGenerics.this.specializeClass(t.getClassDef(), new GenericTypes(newTypeArgs));
                return JassIm.ImClassType(specializedClass, JassIm.ImTypeArguments(new ImTypeArgument[0]));
            }
        });
    }

    @NotNull
    private List<ImTypeArgument> specializeTypeArgs(ImTypeArguments typeArgs) {
        return typeArgs.stream().map(ta -> JassIm.ImTypeArgument(this.specializeType(ta.getType()), ta.getTypeClassBinding())).collect(Collectors.toList());
    }

    private class GenericClazzUse
    implements GenericUse {
        private final ImClassRelatedExprWithClass f;

        public GenericClazzUse(ImClassRelatedExprWithClass f) {
            this.f = f;
        }

        @Override
        public void eliminate() {
            this.f.setClazz(EliminateGenerics.this.specializeType(this.f.getClazz()));
        }
    }

    class GenericReturnTypeFunc
    implements GenericUse {
        private final ImFunction mc;

        GenericReturnTypeFunc(ImFunction mc) {
            this.mc = mc;
        }

        @Override
        public void eliminate() {
            this.mc.setReturnType(EliminateGenerics.this.specializeType(this.mc.getReturnType()));
        }
    }

    class GenericVar
    implements GenericUse {
        private final ImVar mc;

        GenericVar(ImVar mc) {
            this.mc = mc;
        }

        @Override
        public void eliminate() {
            this.mc.setType(EliminateGenerics.this.specializeType(this.mc.getType()));
        }
    }

    class GenericMemberAccess
    implements GenericUse {
        private final ImMemberAccess ma;

        GenericMemberAccess(ImMemberAccess ma) {
            this.ma = ma;
        }

        @Override
        public void eliminate() {
            ImVar f = this.ma.getVar();
            ImClass owningClass = (ImClass)f.getParent().getParent();
            GenericTypes generics = new GenericTypes(EliminateGenerics.this.specializeTypeArgs(this.ma.getTypeArguments()));
            ImClass specializedClass = EliminateGenerics.this.specializeClass(owningClass, generics);
            int fieldIndex = owningClass.getFields().indexOf(f);
            ImVar newVar = (ImVar)specializedClass.getFields().get(fieldIndex);
            this.ma.setVar(newVar);
            this.ma.getTypeArguments().removeAll();
            newVar.setType(EliminateGenerics.this.specializeType(newVar.getType()));
        }
    }

    class GenericMethodCall
    implements GenericUse {
        private final ImMethodCall mc;

        GenericMethodCall(ImMethodCall mc) {
            this.mc = mc;
        }

        @Override
        public void eliminate() {
            ImMethod f = this.mc.getMethod();
            GenericTypes generics = new GenericTypes(EliminateGenerics.this.specializeTypeArgs(this.mc.getTypeArguments()));
            ImMethod specializedMethod = EliminateGenerics.this.specializeMethod(f, generics);
            this.mc.setMethod(specializedMethod);
            this.mc.getTypeArguments().removeAll();
        }
    }

    class GenericImFunctionCall
    implements GenericUse {
        private final ImFunctionCall fc;

        GenericImFunctionCall(ImFunctionCall fc) {
            this.fc = fc;
        }

        @Override
        public void eliminate() {
            GenericTypes generics;
            ImFunction f = this.fc.getFunc();
            ImFunction specializedFunc = (ImFunction)EliminateGenerics.this.specializedFunctions.get((Object)f, (Object)(generics = new GenericTypes(EliminateGenerics.this.specializeTypeArgs(this.fc.getTypeArguments()))));
            if (specializedFunc == null) {
                specializedFunc = EliminateGenerics.this.specializeFunction(f, generics);
            }
            this.fc.setFunc(specializedFunc);
            this.fc.getTypeArguments().removeAll();
        }
    }

    static interface GenericUse {
        public void eliminate();
    }
}

