/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.port.win.registry;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.GameExe;
import net.moonlightflower.wc3libs.port.AlreadyTriedException;
import net.moonlightflower.wc3libs.port.GameExeFinder;
import net.moonlightflower.wc3libs.port.GameVersion;
import net.moonlightflower.wc3libs.port.GameVersionFinder;
import net.moonlightflower.wc3libs.port.NotFoundException;
import net.moonlightflower.wc3libs.port.win.registry.WinRegistryGameExeFinder;

public class WinRegistryGameVersionFinder
extends GameVersionFinder {
    @Override
    @Nonnull
    public GameVersion find() throws NotFoundException {
        GameExeFinder gameExeFinder = this.getRegistryGameExeFinder();
        try {
            File gameExeFile = (File)gameExeFinder.get();
            return GameExe.getVersion(gameExeFile);
        }
        catch (IOException | AlreadyTriedException e) {
            throw new NotFoundException(e);
        }
    }

    protected GameExeFinder getRegistryGameExeFinder() {
        return new WinRegistryGameExeFinder();
    }
}

