/*
 * Decompiled with CFR 0.152.
 */
package de.ralleytn.simple.registry;

import de.ralleytn.simple.registry.Registry;
import de.ralleytn.simple.registry.Reloadable;
import de.ralleytn.simple.registry.Value;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Key
implements Reloadable {
    private List<String> childs;
    private String parent;
    private List<Value> values;
    private Value defaultValue;
    private String name;
    private String path;

    Key(String path, String name, List<Value> values2, Value defaultValue, String parent, List<String> childs) {
        this.path = path;
        this.name = name;
        this.defaultValue = defaultValue;
        this.values = values2;
        this.parent = parent;
        this.childs = childs;
    }

    public final void deleteValue(String name) throws IOException {
        Registry.deleteValue(this.path, name);
    }

    public final void deleteDefaultValue() throws IOException {
        Registry.deleteDefaultValue(this.path);
    }

    public final void deleteAllValues() throws IOException {
        Registry.deleteAllValues(this.path);
    }

    public final void export(File exportFile) throws IOException {
        Registry.exportKey(this.path, exportFile);
    }

    public final void delete() throws IOException {
        Registry.deleteKey(this.path);
    }

    @Override
    public final void reload() throws IOException {
        Key key = Registry.getKey(this.path);
        this.childs = key.childs;
        this.parent = key.parent;
        this.values = key.values;
        this.defaultValue = key.defaultValue;
        this.name = key.name;
        this.path = key.path;
    }

    public final void setDefaultValue(Value.Type type2, char seperator, String rawValue) throws IOException {
        Registry.setDeafultValue(this.path, type2, seperator, rawValue);
    }

    public final void setValue(String name, Value.Type type2, char seperator, String rawValue) throws IOException {
        Registry.setValue(this.path, name, type2, seperator, rawValue);
    }

    public final Value getDefaultValue() {
        return this.defaultValue;
    }

    public final String getPath() {
        return this.path;
    }

    public final String getName() {
        return this.name;
    }

    public final Key getChild(String name) throws IOException {
        for (String child : this.childs) {
            String[] parts = child.split("\\\\");
            if (!parts[parts.length - 1].toUpperCase().equals(name.toUpperCase())) continue;
            return Registry.getKey(child);
        }
        return null;
    }

    public final List<Key> getChilds() throws IOException {
        ArrayList<Key> list = new ArrayList<Key>();
        for (String child : this.childs) {
            list.add(Registry.getKey(child));
        }
        return list;
    }

    public final Key getParent() throws IOException {
        return Registry.getKey(this.parent);
    }

    public final List<Value> getValues() {
        return Key.clone(this.values);
    }

    public final Value getValueByName(String name) {
        for (Value value : this.values) {
            if (!value.getName().toUpperCase().equals(name.toUpperCase())) continue;
            return value;
        }
        return null;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("path=").append(this.path).append(';');
        builder.append("parent=").append(this.parent).append(';');
        builder.append("name=").append(this.name).append(';');
        builder.append("defaultValue=").append(this.defaultValue).append(';');
        builder.append("values=[");
        boolean first = true;
        for (Value value : this.values) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(value.toString());
        }
        builder.append("];childs=[");
        first = true;
        for (String child : this.childs) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(child.toString());
        }
        builder.append("]");
        return builder.toString();
    }

    private static final <T> List<T> clone(List<T> list) {
        try {
            List clonedList = (List)list.getClass().newInstance();
            for (T element : list) {
                clonedList.add(element);
            }
            return clonedList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

