/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.datastructures;

import com.google.common.collect.Maps;
import java.util.Map;

public class Partitions<T> {
    private final Map<T, Partition> partitions = Maps.newLinkedHashMap();

    public void union(T a, T b) {
        this.getPartition(a).unionWith(this.getPartition(b));
    }

    public void add(T t) {
        this.getPartition(t);
    }

    public T getRep(T t) {
        return this.getPartition(t).getRep().item;
    }

    private Partition getPartition(T b) {
        return this.partitions.computeIfAbsent(b, k -> new Partition(b));
    }

    public boolean contains(T t) {
        return this.partitions.containsKey(t);
    }

    private class Partition {
        private Partition rep = this;
        private final T item;

        public Partition(T item) {
            this.item = item;
        }

        public void unionWith(Partition other) {
            this.getRep().rep = other.getRep();
        }

        private Partition getRep() {
            if (this.rep == this) {
                return this;
            }
            this.rep = this.rep.getRep();
            return this.rep;
        }
    }
}

