/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.txt.app.jass.statement;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.antlr.LightJassParser;
import net.moonlightflower.wc3libs.txt.app.jass.Condition;
import net.moonlightflower.wc3libs.txt.app.jass.statement.Statement;

public class SelectionStatement
extends Statement {
    private ConditionalBranch _thenBranch;
    private final List<ConditionalBranch> _elseifBranches = new ArrayList<ConditionalBranch>();
    private List<Statement> _elseStmts = new ArrayList<Statement>();

    public SelectionStatement(@Nonnull ConditionalBranch thenBranch, @Nonnull List<ConditionalBranch> elseifBranches, @Nonnull List<Statement> elseStmts) {
        this._thenBranch = thenBranch;
        this._elseifBranches.addAll(elseifBranches);
        this._elseStmts.addAll(elseStmts);
    }

    public static SelectionStatement create(@Nonnull LightJassParser.SelectionContext selectionContext) {
        LightJassParser.Statement_listContext elseStatement_listContext;
        Condition thenCondition = Condition.create(selectionContext.condition());
        ArrayList<Statement> thenStatements = new ArrayList<Statement>();
        LightJassParser.Statement_listContext thenStatement_listContext = selectionContext.thenStatements;
        if (thenStatement_listContext != null) {
            for (LightJassParser.StatementContext statementContext : thenStatement_listContext.statement()) {
                thenStatements.add(Statement.create(statementContext));
            }
        }
        ConditionalBranch thenBranch = new ConditionalBranch(thenCondition, thenStatements);
        ArrayList<ConditionalBranch> elseifBranches = new ArrayList<ConditionalBranch>();
        for (LightJassParser.Selection_elseif_branchContext elseif_branchContext : selectionContext.elseif_branches) {
            Condition elseifCondition = Condition.create(elseif_branchContext.condition());
            ArrayList<Statement> elseifStmts = new ArrayList<Statement>();
            LightJassParser.Statement_listContext statement_listContext = elseif_branchContext.statement_list();
            if (statement_listContext != null) {
                for (LightJassParser.StatementContext statementContext : statement_listContext.statement()) {
                    elseifStmts.add(Statement.create(statementContext));
                }
            }
            ConditionalBranch elseifBranch = new ConditionalBranch(elseifCondition, elseifStmts);
            elseifBranches.add(elseifBranch);
        }
        LightJassParser.Selection_else_branchContext else_branchContext = selectionContext.else_branch;
        ArrayList<Statement> elseStmts = new ArrayList<Statement>();
        if (else_branchContext != null && (elseStatement_listContext = else_branchContext.statement_list()) != null) {
            for (LightJassParser.StatementContext elseStatementContext : elseStatement_listContext.statement()) {
                elseStmts.add(Statement.create(elseStatementContext));
            }
        }
        return new SelectionStatement(thenBranch, elseifBranches, elseStmts);
    }

    @Override
    public void write(@Nonnull StringWriter sw, boolean isLua) {
        super.write(sw, isLua);
        sw.write("if ");
        this._thenBranch._condition.write(sw);
        sw.write(" then");
        if (!this._thenBranch._statements.isEmpty()) {
            for (Statement stmt : this._thenBranch._statements) {
                sw.write("\n");
                stmt.write(sw, isLua);
            }
        }
        for (ConditionalBranch elseifBranch : this._elseifBranches) {
            sw.write("\nelseif ");
            elseifBranch._condition.write(sw);
            sw.write(" then");
            for (Statement stmt : elseifBranch._statements) {
                sw.write("\n");
                stmt.write(sw, isLua);
            }
        }
        if (!this._elseStmts.isEmpty()) {
            sw.write("\nelse");
            for (Statement stmt : this._elseStmts) {
                sw.write("\n");
                stmt.write(sw, isLua);
            }
        }
        sw.write("\nendif");
    }

    public static class ConditionalBranch {
        private Condition _condition;
        private final List<Statement> _statements = new ArrayList<Statement>();

        public ConditionalBranch(@Nonnull Condition condition, List<Statement> statements) {
            this._condition = condition;
            this._statements.clear();
            this._statements.addAll(statements);
        }
    }
}

