/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.luaAst;

import de.peeeq.wurstscript.luaAst.Element;
import de.peeeq.wurstscript.luaAst.LuaExpr;
import de.peeeq.wurstscript.luaAst.LuaExprArrayAccess;
import de.peeeq.wurstscript.luaAst.LuaExprFuncRef;
import de.peeeq.wurstscript.luaAst.LuaExprFunctionCall;
import de.peeeq.wurstscript.luaAst.LuaExprMethodCall;
import de.peeeq.wurstscript.luaAst.LuaExprOpt;
import de.peeeq.wurstscript.luaAst.LuaExprVarAccess;
import de.peeeq.wurstscript.luaAst.LuaExprlist;
import de.peeeq.wurstscript.luaAst.LuaFunction;
import de.peeeq.wurstscript.luaAst.LuaMethod;
import de.peeeq.wurstscript.luaAst.LuaStatement;
import de.peeeq.wurstscript.luaAst.LuaVariable;
import de.peeeq.wurstscript.translation.lua.printing.LuaPrinter;
import java.util.function.Consumer;

class LuaExprArrayAccessImpl
implements LuaExprArrayAccess {
    private Element parent;
    private LuaExpr left;
    private LuaExprlist indexes;

    LuaExprArrayAccessImpl(LuaExpr left, LuaExprlist indexes) {
        if (left == null) {
            throw new IllegalArgumentException("Element left must not be null.");
        }
        if (indexes == null) {
            throw new IllegalArgumentException("Element indexes must not be null.");
        }
        this.left = left;
        this.indexes = indexes;
        left.setParent(this);
        indexes.setParent(this);
    }

    @Override
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree.Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    @Override
    public void replaceBy(Element other) {
        if (this.parent == null) {
            throw new RuntimeException("Node not attached to tree.");
        }
        for (int i = 0; i < this.parent.size(); ++i) {
            if (this.parent.get(i) != this) continue;
            this.parent.set(i, other);
            return;
        }
    }

    @Override
    public void setLeft(LuaExpr left) {
        if (left == null) {
            throw new IllegalArgumentException();
        }
        this.left.setParent(null);
        left.setParent(this);
        this.left = left;
    }

    @Override
    public LuaExpr getLeft() {
        return this.left;
    }

    @Override
    public void setIndexes(LuaExprlist indexes) {
        if (indexes == null) {
            throw new IllegalArgumentException();
        }
        this.indexes.setParent(null);
        indexes.setParent(this);
        this.indexes = indexes;
    }

    @Override
    public LuaExprlist getIndexes() {
        return this.indexes;
    }

    @Override
    public Element get(int i) {
        switch (i) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.indexes;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public Element set(int i, Element newElem) {
        switch (i) {
            case 0: {
                LuaExpr oldElem = this.left;
                this.setLeft((LuaExpr)newElem);
                return oldElem;
            }
            case 1: {
                LuaExprlist oldElem = this.indexes;
                this.setIndexes((LuaExprlist)newElem);
                return oldElem;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public void forEachElement(Consumer<? super Element> action) {
        action.accept(this.left);
        action.accept(this.indexes);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public LuaExprArrayAccess copy() {
        LuaExprArrayAccessImpl result = new LuaExprArrayAccessImpl(this.left.copy(), this.indexes.copy());
        return result;
    }

    @Override
    public LuaExprArrayAccess copyWithRefs() {
        final LuaExprArrayAccess res = this.copy();
        final LuaExprArrayAccessImpl self = this;
        res.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(LuaExprMethodCall e) {
                Element elem;
                super.visit(e);
                for (elem = e.getMethod(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setMethod((LuaMethod)res.followPath(self.pathTo(e.getMethod())));
                }
            }

            @Override
            public void visit(LuaExprFunctionCall e) {
                Element elem;
                super.visit(e);
                for (elem = e.getFunc(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setFunc((LuaFunction)res.followPath(self.pathTo(e.getFunc())));
                }
            }

            @Override
            public void visit(LuaExprVarAccess e) {
                Element elem;
                super.visit(e);
                for (elem = e.getVar(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setVar((LuaVariable)res.followPath(self.pathTo(e.getVar())));
                }
            }

            @Override
            public void visit(LuaExprFuncRef e) {
                Element elem;
                super.visit(e);
                for (elem = e.getFunc(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setFunc((LuaFunction)res.followPath(self.pathTo(e.getFunc())));
                }
            }
        });
        return res;
    }

    @Override
    public void clearAttributes() {
        this.left.clearAttributes();
        this.indexes.clearAttributes();
        this.clearAttributesLocal();
    }

    @Override
    public void clearAttributesLocal() {
    }

    @Override
    public void accept(Element.Visitor v) {
        v.visit(this);
    }

    @Override
    public <T> T match(LuaStatement.Matcher<T> matcher) {
        return matcher.case_LuaExprArrayAccess(this);
    }

    @Override
    public void match(LuaStatement.MatcherVoid matcher) {
        matcher.case_LuaExprArrayAccess(this);
    }

    @Override
    public <T> T match(LuaExpr.Matcher<T> matcher) {
        return matcher.case_LuaExprArrayAccess(this);
    }

    @Override
    public void match(LuaExpr.MatcherVoid matcher) {
        matcher.case_LuaExprArrayAccess(this);
    }

    @Override
    public <T> T match(LuaExprOpt.Matcher<T> matcher) {
        return matcher.case_LuaExprArrayAccess(this);
    }

    @Override
    public void match(LuaExprOpt.MatcherVoid matcher) {
        matcher.case_LuaExprArrayAccess(this);
    }

    @Override
    public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_LuaExprArrayAccess(this);
    }

    @Override
    public void match(Element.MatcherVoid matcher) {
        matcher.case_LuaExprArrayAccess(this);
    }

    public String toString() {
        return "LuaExprArrayAccess(" + this.left + ", " + this.indexes + ")";
    }

    @Override
    public boolean structuralEquals(Element e) {
        if (e instanceof LuaExprArrayAccess) {
            LuaExprArrayAccess o = (LuaExprArrayAccess)e;
            return this.left.structuralEquals(o.getLeft()) && this.indexes.structuralEquals(o.getIndexes());
        }
        return false;
    }

    @Override
    public void print(StringBuilder sb, int indent) {
        LuaPrinter.print(this, sb, indent);
    }
}

