/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.gui;

import com.google.common.base.Preconditions;
import de.peeeq.wurstio.gui.AboutDialog;
import de.peeeq.wurstio.gui.GuiUtils;
import de.peeeq.wurstio.gui.WurstStatusWindow;
import de.peeeq.wurstio.utils.FileReading;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.utils.Utils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import org.eclipse.jdt.annotation.Nullable;

public class WurstErrorWindow
extends JFrame {
    private static final long serialVersionUID = -451256551943066085L;
    private JButton closeButton;
    private JTextPane codeArea;
    private JLabel currentStatus;
    private JTextArea errorDetailsPanel;
    private DefaultListModel<CompileError> errorListModel;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JButton aboutButton;
    private File currentFile = null;
    public AboutDialog ab;
    private final String workspaceRoot;
    private final SimpleAttributeSet attributes = new SimpleAttributeSet();

    public WurstErrorWindow(String workspaceRoot) {
        super("Errors");
        this.workspaceRoot = workspaceRoot;
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getClassLoader().getResource("icon.png"));
        }
        catch (IOException e) {
            WLogger.severe(e);
        }
        this.setIconImage(image);
        try {
            this.ab = new AboutDialog((Frame)this, true);
        }
        catch (URISyntaxException e) {
            Logger.getLogger(WurstStatusWindow.class.getName()).log(Level.SEVERE, null, e);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(WurstStatusWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.initComponents();
        this.setSize(800, 650);
        this.setDefaultCloseOperation(2);
        GuiUtils.setWindowToCenterOfScreen(this);
        this.toFront();
        this.setState(0);
    }

    public void setTabs(JTextPane textPane, float charactersPerTab) {
        FontMetrics fm = textPane.getFontMetrics(textPane.getFont());
        int charWidth = fm.charWidth('w');
        int tabWidth = (int)((float)charWidth * charactersPerTab);
        TabStop[] tabs = new TabStop[10];
        for (int j = 0; j < tabs.length; ++j) {
            int tab = j + 1;
            tabs[j] = new TabStop(tab * tabWidth);
        }
        TabSet tabSet = new TabSet(tabs);
        StyleConstants.setTabSet(this.attributes, tabSet);
        int length = textPane.getDocument().getLength();
        textPane.getStyledDocument().setParagraphAttributes(0, length, this.attributes, true);
    }

    private void initComponents() {
        this.currentStatus = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.errorListModel = new DefaultListModel();
        JList<CompileError> errorList = new JList<CompileError>(this.errorListModel);
        this.closeButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.codeArea = new JTextPane();
        this.jScrollPane3 = new JScrollPane();
        this.errorDetailsPanel = new JTextArea();
        this.aboutButton = new JButton();
        errorList.addListSelectionListener(e -> {
            int index = errorList.getSelectedIndex();
            if (index >= 0) {
                CompileError err = this.errorListModel.get(index);
                this.viewErrorDetail(err);
            }
        });
        this.setDefaultCloseOperation(2);
        this.codeArea.setEditable(false);
        this.currentStatus.setFont(new Font("Tahoma", 1, 12));
        this.currentStatus.setText("Status");
        this.jScrollPane1.setViewportView(errorList);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.closeButton.setText("Close");
        this.closeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@Nullable MouseEvent evt) {
                Preconditions.checkNotNull((Object)evt);
                WurstErrorWindow.this.closeButtonMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.codeArea);
        this.aboutButton.setText("AboutDialog...");
        this.aboutButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@Nullable MouseEvent evt) {
                Preconditions.checkNotNull((Object)evt);
                WurstErrorWindow.this.aboutButtonMouseClicked(evt);
            }
        });
        this.errorDetailsPanel.setFont(new Font("Tahoma", 0, 12));
        this.errorDetailsPanel.setLineWrap(true);
        this.errorDetailsPanel.setWrapStyleWord(true);
        this.errorDetailsPanel.setEditable(false);
        this.errorDetailsPanel.setFont(this.getFont());
        this.errorDetailsPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.errorDetailsPanel.setBackground(this.getBackground());
        this.errorDetailsPanel.setDragEnabled(true);
        this.jScrollPane3.setViewportView(this.errorDetailsPanel);
        this.jScrollPane3.setHorizontalScrollBarPolicy(31);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane3, GroupLayout.Alignment.LEADING, -1, 801, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 801, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 801, Short.MAX_VALUE).addComponent(this.currentStatus, GroupLayout.Alignment.LEADING, -2, 700, -2).addGroup(layout.createSequentialGroup().addComponent(this.aboutButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 669, Short.MAX_VALUE).addComponent(this.closeButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.currentStatus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 159, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 39, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 327, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.aboutButton, -1, -1, Short.MAX_VALUE).addComponent(this.closeButton, -1, 30, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void closeButtonMouseClicked(MouseEvent evt) {
        this.dispose();
    }

    private void aboutButtonMouseClicked(MouseEvent evt) {
        this.ab.setVisible(true);
    }

    private void viewErrorDetail(CompileError err) {
        this.setVisible(true);
        this.errorDetailsPanel.setText(err.getMessage());
        File errFile = new File(err.getSource().getFile());
        File workspaceErrFile = new File(this.workspaceRoot + "/" + err.getSource().getFile());
        if (!errFile.exists() && workspaceErrFile.exists()) {
            errFile = workspaceErrFile;
        }
        try {
            if (!Objects.equals(this.currentFile, errFile)) {
                this.currentFile = errFile;
                try (Reader fr = FileReading.getFileReader(errFile);){
                    this.codeArea.read(fr, (Object)errFile);
                }
            }
            String text = this.codeArea.getText();
            StyleConstants.setUnderline(this.attributes, false);
            StyleConstants.setBackground(this.attributes, new Color(255, 255, 255));
            this.codeArea.getStyledDocument().setCharacterAttributes(0, text.length() - 1, this.attributes, true);
            int selectionStart = err.getSource().getLeftPos();
            int selectionEnd = err.getSource().getRightPos();
            if (selectionStart == selectionEnd && selectionStart > 0) {
                --selectionStart;
            }
            StyledDocument doc = this.codeArea.getStyledDocument();
            String docText = doc.getText(0, doc.getLength());
            int ignoredChars = 0;
            for (int i = 0; i < selectionStart - ignoredChars; ++i) {
                char docChar = docText.charAt(i);
                char textChar = text.charAt(i + ignoredChars);
                if (docChar == '\n' && textChar == '\r') {
                    ++ignoredChars;
                    continue;
                }
                if (docChar == textChar) continue;
                System.err.println("unexpected deviation in texts: " + docChar + " != " + textChar);
                break;
            }
            selectionStart -= ignoredChars;
            selectionEnd -= ignoredChars;
            selectionStart = Utils.inBorders(0, selectionStart, docText.length() - 2);
            selectionEnd = Utils.inBorders(1, selectionEnd, docText.length() - 1);
            StyleConstants.setUnderline(this.attributes, true);
            StyleConstants.setBackground(this.attributes, new Color(255, 150, 150));
            doc.setCharacterAttributes(selectionStart, selectionEnd - selectionStart, this.attributes, true);
            this.codeArea.select(selectionStart, selectionEnd);
            this.setTabs(this.codeArea, 4.0f);
        }
        catch (FileNotFoundException e) {
            this.codeArea.setText("Could not load file: " + errFile);
        }
        catch (IOException e) {
            this.codeArea.setText("Could not read file: " + errFile);
            WLogger.info(e);
        }
        catch (BadLocationException e) {
            WLogger.severe(e);
        }
    }

    public void sendError(CompileError elem) {
        if (this.errorListModel.isEmpty()) {
            this.viewErrorDetail(elem);
        }
        this.errorListModel.addElement(elem);
        this.requestFocus();
    }

    public void sendFinished() {
        if (this.errorListModel.isEmpty()) {
            this.dispose();
        }
    }
}

