/*
 * Decompiled with CFR 0.152.
 */
package ru.eustas.zopfli;

import java.io.IOException;
import java.io.OutputStream;
import ru.eustas.zopfli.BitWriter;
import ru.eustas.zopfli.Cookie;
import ru.eustas.zopfli.Deflate;
import ru.eustas.zopfli.Options;
import ru.eustas.zopfli.ZopfliRuntimeException;

public final class Zopfli {
    private final Cookie cookie;

    public synchronized void compress(Options options, byte[] input, OutputStream output) throws IOException {
        try {
            BitWriter bitWriter = new BitWriter(output);
            Options.OutputFormat format = options.outputType;
            Checksum digest = Zopfli.createDigest(format);
            Zopfli.writePrologue(format, bitWriter);
            if (input.length == 0) {
                Zopfli.writeEmptyBlock(bitWriter, true);
            } else {
                int i = 0;
                while (i < input.length) {
                    int j = Math.min(i + this.cookie.masterBlockSize, input.length);
                    boolean isFinal = j == input.length;
                    Deflate.deflatePart(this.cookie, options, input, i, j, isFinal, bitWriter);
                    i = j;
                }
            }
            digest.update(input, 0, input.length);
            Zopfli.writeEpilogue(format, bitWriter, digest);
        }
        catch (ZopfliRuntimeException ex) {
            throw new IOException(ex);
        }
    }

    static Checksum createDigest(Options.OutputFormat format) {
        switch (format) {
            case GZIP: {
                return new GzipChecksum();
            }
            case ZLIB: {
                return new ZlibChecksum();
            }
            case DEFLATE: {
                return new Checksum();
            }
        }
        throw new IllegalArgumentException();
    }

    static void writePrologue(Options.OutputFormat format, BitWriter output) throws IOException {
        try {
            switch (format) {
                case GZIP: {
                    output.addBits(35615, 16);
                    output.addBits(8, 16);
                    output.addBits(0, 16);
                    output.addBits(0, 16);
                    output.addBits(770, 16);
                    return;
                }
                case ZLIB: {
                    output.addBits(55928, 16);
                    return;
                }
                case DEFLATE: {
                    return;
                }
            }
            throw new IllegalArgumentException();
        }
        catch (ZopfliRuntimeException ex) {
            throw new IOException(ex);
        }
    }

    static void writeEpilogue(Options.OutputFormat format, BitWriter output, Checksum digest) throws IOException {
        try {
            output.jumpToByteBoundary();
            int checksum = digest.checksum();
            int dataLength = digest.size();
            switch (format) {
                case GZIP: {
                    output.addBits(checksum & 0xFFFF, 16);
                    output.addBits(checksum >> 16 & 0xFFFF, 16);
                    output.addBits(dataLength & 0xFFFF, 16);
                    output.addBits(dataLength >> 16 & 0xFFFF, 16);
                    break;
                }
                case ZLIB: {
                    output.addBits(checksum >> 24 & 0xFF, 8);
                    output.addBits(checksum >> 16 & 0xFF, 8);
                    output.addBits(checksum >> 8 & 0xFF, 8);
                    output.addBits(checksum & 0xFF, 8);
                    break;
                }
                case DEFLATE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            output.flush();
        }
        catch (ZopfliRuntimeException ex) {
            throw new IOException(ex);
        }
    }

    static void writeEmptyBlock(BitWriter output, boolean isLast) throws IOException {
        try {
            output.addBits(isLast ? 1 : 0, 1);
            output.addBits(1, 2);
            output.addBits(0, 7);
        }
        catch (ZopfliRuntimeException ex) {
            throw new IOException(ex);
        }
    }

    public Zopfli(int masterBlockSize) {
        this.cookie = new Cookie(masterBlockSize);
    }

    static final class ZlibChecksum
    extends Checksum {
        private int lo = 1;
        private int hi = 0;

        ZlibChecksum() {
        }

        void update(byte[] input, int from, int length) {
            super.update(input, from, length);
            int s1 = this.lo;
            int s2 = this.hi;
            int i = 0;
            while (i < length) {
                int fence = Math.min(length, i + 3854);
                while (i < fence) {
                    s2 += (s1 += input[from + i++] & 0xFF);
                }
                s1 %= 65521;
                s2 %= 65521;
            }
            this.lo = s1;
            this.hi = s2;
        }

        int checksum() {
            return this.hi << 16 | this.lo;
        }
    }

    static final class GzipChecksum
    extends Checksum {
        private static final int[] table = GzipChecksum.makeTable();
        private int value = -1;

        GzipChecksum() {
        }

        private static int[] makeTable() {
            int[] result = new int[256];
            for (int n = 0; n < 256; ++n) {
                int c = n;
                for (int k = 0; k < 8; ++k) {
                    if ((c & 1) == 1) {
                        c = 0xEDB88320 ^ c >>> 1;
                        continue;
                    }
                    c >>>= 1;
                }
                result[n] = c;
            }
            return result;
        }

        void update(byte[] input, int from, int length) {
            super.update(input, from, length);
            int c = this.value;
            for (int i = 0; i < length; ++i) {
                c = table[(c ^ input[from + i]) & 0xFF] ^ c >>> 8;
            }
            this.value = c;
        }

        int checksum() {
            return ~this.value;
        }
    }

    static class Checksum {
        private int totalLength;

        Checksum() {
        }

        void update(byte[] input, int from, int length) {
            this.totalLength += length;
        }

        int checksum() {
            return 0;
        }

        int size() {
            return this.totalLength;
        }
    }
}

