/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.jassinterpreter;

import com.google.common.collect.Maps;
import de.peeeq.wurstio.jassinterpreter.ExecutableJassFunction;
import de.peeeq.wurstio.jassinterpreter.InterpreterException;
import de.peeeq.wurstio.jassinterpreter.JassArray;
import de.peeeq.wurstio.jassinterpreter.NativeJassFunction;
import de.peeeq.wurstio.jassinterpreter.ReflectionNativeProvider;
import de.peeeq.wurstio.jassinterpreter.UnknownJassFunction;
import de.peeeq.wurstio.jassinterpreter.UserDefinedJassFunction;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.intermediatelang.ILconst;
import de.peeeq.wurstscript.intermediatelang.ILconstAddable;
import de.peeeq.wurstscript.intermediatelang.ILconstBool;
import de.peeeq.wurstscript.intermediatelang.ILconstFuncRef;
import de.peeeq.wurstscript.intermediatelang.ILconstInt;
import de.peeeq.wurstscript.intermediatelang.ILconstNull;
import de.peeeq.wurstscript.intermediatelang.ILconstNum;
import de.peeeq.wurstscript.intermediatelang.ILconstReal;
import de.peeeq.wurstscript.intermediatelang.ILconstString;
import de.peeeq.wurstscript.intermediatelang.interpreter.AbstractInterpreter;
import de.peeeq.wurstscript.intermediatelang.interpreter.TimerMockHandler;
import de.peeeq.wurstscript.jassAst.JassArrayVar;
import de.peeeq.wurstscript.jassAst.JassExpr;
import de.peeeq.wurstscript.jassAst.JassExprBinary;
import de.peeeq.wurstscript.jassAst.JassExprBoolVal;
import de.peeeq.wurstscript.jassAst.JassExprFuncRef;
import de.peeeq.wurstscript.jassAst.JassExprFunctionCall;
import de.peeeq.wurstscript.jassAst.JassExprIntVal;
import de.peeeq.wurstscript.jassAst.JassExprNull;
import de.peeeq.wurstscript.jassAst.JassExprRealVal;
import de.peeeq.wurstscript.jassAst.JassExprStringVal;
import de.peeeq.wurstscript.jassAst.JassExprUnary;
import de.peeeq.wurstscript.jassAst.JassExprVarAccess;
import de.peeeq.wurstscript.jassAst.JassExprVarArrayAccess;
import de.peeeq.wurstscript.jassAst.JassFunction;
import de.peeeq.wurstscript.jassAst.JassInitializedVar;
import de.peeeq.wurstscript.jassAst.JassOpAnd;
import de.peeeq.wurstscript.jassAst.JassOpBinary;
import de.peeeq.wurstscript.jassAst.JassOpDiv;
import de.peeeq.wurstscript.jassAst.JassOpEquals;
import de.peeeq.wurstscript.jassAst.JassOpGreater;
import de.peeeq.wurstscript.jassAst.JassOpGreaterEq;
import de.peeeq.wurstscript.jassAst.JassOpLess;
import de.peeeq.wurstscript.jassAst.JassOpLessEq;
import de.peeeq.wurstscript.jassAst.JassOpMinus;
import de.peeeq.wurstscript.jassAst.JassOpMult;
import de.peeeq.wurstscript.jassAst.JassOpNot;
import de.peeeq.wurstscript.jassAst.JassOpOr;
import de.peeeq.wurstscript.jassAst.JassOpPlus;
import de.peeeq.wurstscript.jassAst.JassOpUnary;
import de.peeeq.wurstscript.jassAst.JassOpUnequals;
import de.peeeq.wurstscript.jassAst.JassProg;
import de.peeeq.wurstscript.jassAst.JassSimpleVar;
import de.peeeq.wurstscript.jassAst.JassStatement;
import de.peeeq.wurstscript.jassAst.JassStatements;
import de.peeeq.wurstscript.jassAst.JassStmtCall;
import de.peeeq.wurstscript.jassAst.JassStmtExitwhen;
import de.peeeq.wurstscript.jassAst.JassStmtIf;
import de.peeeq.wurstscript.jassAst.JassStmtLoop;
import de.peeeq.wurstscript.jassAst.JassStmtReturn;
import de.peeeq.wurstscript.jassAst.JassStmtReturnVoid;
import de.peeeq.wurstscript.jassAst.JassStmtSet;
import de.peeeq.wurstscript.jassAst.JassStmtSetArray;
import de.peeeq.wurstscript.jassAst.JassVar;
import de.peeeq.wurstscript.jassAst.JassVars;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassinterpreter.ExitwhenException;
import de.peeeq.wurstscript.jassinterpreter.ReturnException;
import de.peeeq.wurstscript.utils.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public class JassInterpreter
implements AbstractInterpreter {
    private JassProg prog;
    private static final ReturnException staticReturnException = new ReturnException(null);
    private Map<String, ILconst> globalVarMap;
    private boolean trace = false;
    private final Map<String, ExecutableJassFunction> functionCache = new HashMap<String, ExecutableJassFunction>();
    private final TimerMockHandler timerMockHandler = new TimerMockHandler();

    public void loadProgram(JassProg prog) {
        this.prog = prog;
        this.globalVarMap = Maps.newLinkedHashMap();
        JassVars globals = prog.getGlobals();
        for (JassVar v : globals) {
            JassArray value = null;
            if (v instanceof JassArrayVar) {
                value = new JassArray(v.getType());
            }
            this.globalVarMap.put(v.getName(), value);
        }
    }

    public static ILconst getDefaultValue(String type) {
        switch (type) {
            case "integer": {
                return new ILconstInt(0);
            }
            case "boolean": {
                return ILconstBool.FALSE;
            }
            case "real": {
                return new ILconstReal(0.0);
            }
        }
        return ILconstNull.instance();
    }

    public ILconst executeFunction(String name, ILconst ... arguments) {
        if (this.trace) {
            WLogger.trace(name + "( " + Utils.join(arguments, ", ") + ")");
        }
        ExecutableJassFunction func = this.searchFunction(name);
        return func.execute(this, arguments);
    }

    @Nullable ILconst executeJassFunction(JassFunction func, ILconst ... arguments) {
        JassVars locals = func.getLocals();
        JassStatements body = func.getBody();
        LinkedHashMap localVarMap = Maps.newLinkedHashMap();
        for (Object v : locals) {
            JassArray value = null;
            if (v instanceof JassArrayVar) {
                value = new JassArray(v.getType());
            }
            localVarMap.put(v.getName(), value);
        }
        if (func.getParams().size() != arguments.length) {
            throw new InterpreterException("Wrong number of parameters: " + func.getParams().size() + " != " + arguments.length);
        }
        int i = 0;
        for (JassSimpleVar v : func.getParams()) {
            localVarMap.put(v.getName(), arguments[i]);
            ++i;
        }
        try {
            this.executeStatements(localVarMap, body);
        }
        catch (ReturnException e) {
            if (this.trace) {
                WLogger.trace("end function " + func.getName() + " returns " + e.getVal());
            }
            return e.getVal();
        }
        if (this.trace) {
            WLogger.trace("end function " + func.getName());
        }
        return null;
    }

    private void executeStatements(Map<String, ILconst> localVarMap, List<JassStatement> body) {
        for (JassStatement s : body) {
            this.executeStatement(localVarMap, s);
        }
    }

    private void executeStatement(final Map<String, ILconst> localVarMap, JassStatement s) {
        s.match(new JassStatement.MatcherVoid(){

            @Override
            public void case_JassStmtSetArray(JassStmtSetArray jassStmtSetArray) {
                ILconst right = JassInterpreter.this.executeExpr(localVarMap, jassStmtSetArray.getRight());
                ILconstInt index = (ILconstInt)JassInterpreter.this.executeExpr(localVarMap, jassStmtSetArray.getIndex());
                JassArray v = (JassArray)JassInterpreter.this.getVarValue(localVarMap, jassStmtSetArray.getLeft());
                v.set(index.getVal(), right);
            }

            @Override
            public void case_JassStmtSet(JassStmtSet jassStmtSet) {
                ILconst right = JassInterpreter.this.executeExpr(localVarMap, jassStmtSet.getRight());
                JassInterpreter.this.setVarValue(localVarMap, jassStmtSet.getLeft(), right);
            }

            @Override
            public void case_JassStmtReturnVoid(JassStmtReturnVoid jassStmtReturnVoid) {
                throw staticReturnException.setVal(null);
            }

            @Override
            public void case_JassStmtReturn(JassStmtReturn jassStmtReturn) {
                ILconst c = JassInterpreter.this.executeExpr(localVarMap, jassStmtReturn.getReturnValue());
                throw staticReturnException.setVal(c);
            }

            @Override
            public void case_JassStmtLoop(JassStmtLoop jassStmtLoop) {
                try {
                    while (true) {
                        JassInterpreter.this.executeStatements(localVarMap, jassStmtLoop.getBody());
                    }
                }
                catch (ExitwhenException exitwhenException) {
                    return;
                }
            }

            @Override
            public void case_JassStmtIf(JassStmtIf jassStmtIf) {
                ILconstBool cond = (ILconstBool)JassInterpreter.this.executeExpr(localVarMap, jassStmtIf.getCond());
                if (cond.getVal()) {
                    JassInterpreter.this.executeStatements(localVarMap, jassStmtIf.getThenBlock());
                } else {
                    JassInterpreter.this.executeStatements(localVarMap, jassStmtIf.getElseBlock());
                }
            }

            @Override
            public void case_JassStmtExitwhen(JassStmtExitwhen jassStmtExitwhen) {
                ILconstBool cond = (ILconstBool)JassInterpreter.this.executeExpr(localVarMap, jassStmtExitwhen.getCond());
                if (cond.getVal()) {
                    throw ExitwhenException.instance();
                }
            }

            @Override
            public void case_JassStmtCall(JassStmtCall jassStmtCall) {
                ILconst[] args = new ILconst[jassStmtCall.getArguments().size()];
                int i = 0;
                for (JassExpr arg : jassStmtCall.getArguments()) {
                    args[i] = JassInterpreter.this.executeExpr(localVarMap, arg);
                    ++i;
                }
                JassInterpreter.this.executeFunction(jassStmtCall.getFuncName(), args);
            }
        });
    }

    private ILconst executeExpr(final Map<String, ILconst> localVarMap, JassExpr expr) {
        return expr.match(new JassExpr.Matcher<ILconst>(){

            @Override
            public ILconst case_JassExprVarArrayAccess(JassExprVarArrayAccess e) {
                JassArray ar = (JassArray)JassInterpreter.this.getVarValue(localVarMap, e.getVarName());
                ILconstInt index = (ILconstInt)JassInterpreter.this.executeExpr(localVarMap, e.getIndex());
                return ar.get(index.getVal());
            }

            @Override
            public ILconst case_JassExprRealVal(JassExprRealVal e) {
                return new ILconstReal(e.getValR());
            }

            @Override
            public ILconst case_JassExprUnary(JassExprUnary e) {
                final ILconst right = JassInterpreter.this.executeExpr(localVarMap, e.getRight());
                return e.getOpU().match(new JassOpUnary.Matcher<ILconst>(){

                    @Override
                    public ILconst case_JassOpNot(JassOpNot jassOpNot) {
                        ILconstBool b = (ILconstBool)right;
                        return b.negate();
                    }

                    @Override
                    public ILconst case_JassOpMinus(JassOpMinus jassOpMinus) {
                        return ((ILconstNum)right).negate();
                    }
                });
            }

            @Override
            public ILconst case_JassExprFuncRef(JassExprFuncRef e) {
                return new ILconstFuncRef(e.getFuncName());
            }

            @Override
            public ILconst case_JassExprBoolVal(JassExprBoolVal e) {
                return ILconstBool.instance(e.getValB());
            }

            @Override
            public ILconst case_JassExprBinary(final JassExprBinary e) {
                return e.getOp().match(new JassOpBinary.Matcher<ILconst>(){

                    ILconst getLeft() {
                        return JassInterpreter.this.executeExpr(localVarMap, e.getLeftExpr());
                    }

                    ILconstNum getLeftNum() {
                        return (ILconstNum)this.getLeft();
                    }

                    ILconstAddable getLeftAddable() {
                        return (ILconstAddable)this.getLeft();
                    }

                    ILconstBool getLeftBool() {
                        return (ILconstBool)this.getLeft();
                    }

                    ILconst getRight() {
                        return JassInterpreter.this.executeExpr(localVarMap, e.getRight());
                    }

                    ILconstNum getRightNum() {
                        return (ILconstNum)this.getRight();
                    }

                    ILconstAddable getRightAddable() {
                        return (ILconstAddable)this.getRight();
                    }

                    ILconstBool getRightBool() {
                        return (ILconstBool)this.getRight();
                    }

                    @Override
                    public ILconst case_JassOpDiv(JassOpDiv jassOpDiv) {
                        return this.getLeftNum().div(this.getRightNum());
                    }

                    @Override
                    public ILconst case_JassOpLess(JassOpLess jassOpLess) {
                        return this.getLeftNum().less(this.getRightNum());
                    }

                    @Override
                    public ILconst case_JassOpAnd(JassOpAnd jassOpAnd) {
                        if (this.getLeftBool().getVal()) {
                            return this.getRightBool();
                        }
                        return ILconstBool.FALSE;
                    }

                    @Override
                    public ILconst case_JassOpUnequals(JassOpUnequals jassOpUnequals) {
                        return ILconstBool.instance(!this.getLeft().isEqualTo(this.getRight()));
                    }

                    @Override
                    public ILconst case_JassOpGreaterEq(JassOpGreaterEq jassOpGreaterEq) {
                        return this.getLeftNum().greaterEq(this.getRightNum());
                    }

                    @Override
                    public ILconst case_JassOpMinus(JassOpMinus jassOpMinus) {
                        return this.getLeftNum().sub(this.getRightNum());
                    }

                    @Override
                    public ILconst case_JassOpMult(JassOpMult jassOpMult) {
                        return this.getLeftNum().mul(this.getRightNum());
                    }

                    @Override
                    public ILconst case_JassOpGreater(JassOpGreater jassOpGreater) {
                        return this.getLeftNum().greater(this.getRightNum());
                    }

                    @Override
                    public ILconst case_JassOpPlus(JassOpPlus jassOpPlus) {
                        return this.getLeftAddable().add(this.getRightAddable());
                    }

                    @Override
                    public ILconst case_JassOpLessEq(JassOpLessEq jassOpLessEq) {
                        return this.getLeftNum().lessEq(this.getRightNum());
                    }

                    @Override
                    public ILconst case_JassOpOr(JassOpOr jassOpOr) {
                        if (this.getLeftBool().getVal()) {
                            return ILconstBool.TRUE;
                        }
                        return this.getRightBool();
                    }

                    @Override
                    public ILconst case_JassOpEquals(JassOpEquals jassOpEquals) {
                        return ILconstBool.instance(this.getLeft().isEqualTo(this.getRight()));
                    }
                });
            }

            @Override
            public ILconst case_JassExprStringVal(JassExprStringVal e) {
                return new ILconstString(e.getValS());
            }

            @Override
            public ILconst case_JassExprIntVal(JassExprIntVal e) {
                return ILconstInt.create(Integer.parseInt(e.getValI()));
            }

            @Override
            public ILconst case_JassExprFunctionCall(JassExprFunctionCall e) {
                ILconst[] args = new ILconst[e.getArguments().size()];
                int i = 0;
                for (JassExpr arg : e.getArguments()) {
                    args[i] = JassInterpreter.this.executeExpr(localVarMap, arg);
                    ++i;
                }
                return JassInterpreter.this.executeFunction(e.getFuncName(), args);
            }

            @Override
            public ILconst case_JassExprVarAccess(JassExprVarAccess e) {
                return JassInterpreter.this.getVarValue(localVarMap, e.getVarName());
            }

            @Override
            public ILconst case_JassExprNull(JassExprNull e) {
                return ILconstNull.instance();
            }
        });
    }

    private void setVarValue(Map<String, ILconst> localVarMap, String varName, ILconst s) {
        if (this.isLocal(localVarMap, varName)) {
            localVarMap.put(varName, s);
        } else if (this.isGlobal(varName)) {
            this.globalVarMap.put(varName, s);
        } else {
            throw new InterpreterException("var " + varName + " is neither local nor global?");
        }
    }

    private boolean isLocal(Map<String, ILconst> localVarMap, String varName) {
        return localVarMap.containsKey(varName);
    }

    private boolean isGlobal(String varName) {
        return this.globalVarMap.containsKey(varName);
    }

    private ILconst getVarValue(Map<String, ILconst> localVarMap, String name) {
        ILconst value = localVarMap.get(name);
        if (value == null && (value = this.globalVarMap.get(name)) == null) {
            throw new InterpreterException("Variable " + name + " not found.");
        }
        return value;
    }

    private ExecutableJassFunction searchFunction(String fname) {
        return this.functionCache.computeIfAbsent(fname, name -> {
            for (JassFunction f : this.prog.getFunctions()) {
                if (!f.getName().equals(name) || f.getIsCompiletimeNative()) continue;
                return new UserDefinedJassFunction(f);
            }
            return this.searchNativeJassFunction((String)name);
        });
    }

    private ExecutableJassFunction searchNativeJassFunction(String name) {
        if (name.equals("ExecuteFunc")) {
            return this.executeFuncNative();
        }
        ReflectionNativeProvider nf = new ReflectionNativeProvider(this);
        NativeJassFunction functionPair = nf.getFunctionPair(name);
        return functionPair != null ? functionPair : new UnknownJassFunction(name);
    }

    private ExecutableJassFunction executeFuncNative() {
        return (jassInterpreter, arguments) -> {
            ILconstString funcName = (ILconstString)arguments[0];
            jassInterpreter.executeFunction(funcName.getVal(), new ILconst[0]);
            return ILconstBool.TRUE;
        };
    }

    public void trace(boolean b) {
        this.trace = b;
    }

    @Override
    public void runFuncRef(ILconstFuncRef f, @Nullable Element trace) {
        if (f == null) {
            throw new RuntimeException("Function was null in " + trace);
        }
        ExecutableJassFunction func = this.searchFunction(f.getFuncName());
        func.execute(this, new ILconst[0]);
    }

    @Override
    public TimerMockHandler getTimerMockHandler() {
        return this.timerMockHandler;
    }

    public void runProgram() {
        for (JassVar var : this.prog.getGlobals()) {
            if (!(var instanceof JassInitializedVar)) continue;
            JassInitializedVar iVar = (JassInitializedVar)var;
            this.globalVarMap.put(iVar.getName(), this.executeExpr(Collections.emptyMap(), iVar.getVal()));
        }
        this.executeFunction("main", new ILconst[0]);
        this.timerMockHandler.completeTimers();
    }

    @Override
    public void completeTimers() {
        this.timerMockHandler.completeTimers();
    }

    @Override
    public ImProg getImProg() {
        throw new UnsupportedOperationException("Not supported in Jass interpreter.");
    }

    @Override
    public int getInstanceCount(int val) {
        throw new UnsupportedOperationException("Not supported in Jass interpreter.");
    }

    @Override
    public int getMaxInstanceCount(int val) {
        throw new UnsupportedOperationException("Not supported in Jass interpreter.");
    }
}

