/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.gui.WurstGui;
import de.peeeq.wurstscript.utils.NotNullList;
import java.util.List;

public class ErrorHandler {
    private final List<CompileError> errors = new NotNullList<CompileError>();
    private final List<CompileError> warnings = new NotNullList<CompileError>();
    private final WurstGui gui;
    private boolean unitTestMode = false;

    public ErrorHandler(WurstGui gui) {
        this.gui = gui;
    }

    public int getErrorCount() {
        return this.getErrors().size();
    }

    public List<CompileError> getWarnings() {
        return this.warnings;
    }

    public List<CompileError> getErrors() {
        return this.errors;
    }

    public void setProgress(String message, double percent) {
        this.getGui().sendProgress(message);
    }

    public WurstGui getGui() {
        return this.gui;
    }

    public void sendError(CompileError err) {
        if (err.getErrorType() == CompileError.ErrorType.ERROR) {
            this.errors.add(err);
        } else {
            this.warnings.add(err);
        }
        this.gui.sendError(err);
    }

    public void enableUnitTestMode() {
        this.unitTestMode = true;
    }

    public boolean isUnitTestMode() {
        return this.unitTestMode;
    }
}

