/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.slk.app.terrainArts;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.AlphaMode;
import net.moonlightflower.wc3libs.dataTypes.app.Color;
import net.moonlightflower.wc3libs.dataTypes.app.Coords2DF;
import net.moonlightflower.wc3libs.dataTypes.app.Coords3DF;
import net.moonlightflower.wc3libs.dataTypes.app.War3Bool;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.dataTypes.app.WaterId;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.ObjId;
import net.moonlightflower.wc3libs.slk.ObjSLK;
import net.moonlightflower.wc3libs.slk.RawSLK;
import net.moonlightflower.wc3libs.slk.SLK;
import net.moonlightflower.wc3libs.slk.SLKState;

public class WaterSLK
extends ObjSLK<WaterSLK, WaterId, Obj> {
    public static final File GAME_PATH = new File("TerrainArt\\Water.slk");

    @Override
    @Nonnull
    public Map<WaterId, Obj> getObjs() {
        return this._objs;
    }

    @Override
    public void addObj(@Nonnull Obj val) {
        this._objs.put((WaterId)val.getId(), val);
    }

    @Override
    @Nonnull
    public Obj addObj(@Nonnull WaterId id) {
        if (this._objs.containsKey(id)) {
            return (Obj)this._objs.get(id);
        }
        Obj obj = new Obj(id);
        this.addObj(obj);
        return obj;
    }

    public RawSLK toRawSLK() {
        RawSLK slk = new RawSLK();
        for (Obj obj : this.getObjs().values()) {
            Object id = obj.getId();
            Object slkObj = slk.addObj(id);
            ((SLK.Obj)slkObj).merge(obj, true);
        }
        return slk;
    }

    @Override
    protected void read(@Nonnull SLK<?, ? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slk) {
        for (Map.Entry<? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slkEntry : slk.getObjs().entrySet()) {
            ObjId id = slkEntry.getKey();
            SLK.Obj<? extends ObjId> slkObj = slkEntry.getValue();
            Obj obj = new Obj(slkObj);
            this.addObj(obj);
            obj.merge(slkObj, true);
        }
    }

    @Override
    public void read(@Nonnull File file) throws IOException {
        this.read(new RawSLK(file));
    }

    @Override
    public void write(@Nonnull File file) throws IOException {
        this.toRawSLK().write(file);
    }

    public WaterSLK() {
        this.addField(State.OBJ_ID);
        for (State state : State.values(State.class)) {
            this.addField(state);
        }
    }

    @Override
    @Nonnull
    public Obj createObj(@Nonnull ObjId id) {
        return new Obj(WaterId.valueOf(id));
    }

    @Override
    public void merge(@Nonnull WaterSLK other, boolean overwrite) {
    }

    public static class Obj
    extends SLK.Obj<WaterId> {
        private final Map<State, DataType> _stateVals = new LinkedHashMap<State, DataType>();
        private Color _minimapColor = Color.fromBGRA255(0, 0, 0, 0);

        @Override
        public Map<State, DataType> getStateVals() {
            return new LinkedHashMap<State, DataType>(this._stateVals);
        }

        @Override
        protected void on_set(@Nonnull FieldId fieldId, @Nullable DataType val) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.put(state, val);
            }
        }

        @Override
        protected void on_remove(@Nonnull FieldId fieldId) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.remove(state);
            }
        }

        @Override
        protected void on_clear() {
            this._stateVals.clear();
        }

        public War3Real getHeight() {
            return this.get(State.HEIGHT);
        }

        public void setHeight(War3Real val) {
            this.set(State.HEIGHT, val);
        }

        public War3Bool getImpassable() {
            return this.get(State.IMPASSABLE);
        }

        public void setImpassable(War3Bool val) {
            this.set(State.IMPASSABLE, val);
        }

        public Path getTex() {
            return Paths.get(this.get(State.TEX_FILE).toString(), new String[0]);
        }

        public void setTex(Path val) {
            this.set(State.TEX_FILE, War3String.valueOf(val.toString()));
        }

        public Color getMinimapColor() {
            return Color.fromBGRA255(this.get(State.MINIMAP_COLOR_BLUE).toInt(), this.get(State.MINIMAP_COLOR_GREEN).toInt(), this.get(State.MINIMAP_COLOR_RED).toInt(), this.get(State.MINIMAP_COLOR_ALPHA).toInt());
        }

        public void setMinimapColor(Color val) {
            this.set(State.MINIMAP_COLOR_ALPHA, War3Int.valueOf(val.getAlpha255()));
            this.set(State.MINIMAP_COLOR_BLUE, War3Int.valueOf(val.getBlue255()));
            this.set(State.MINIMAP_COLOR_GREEN, War3Int.valueOf(val.getGreen255()));
            this.set(State.MINIMAP_COLOR_RED, War3Int.valueOf(val.getRed255()));
        }

        public War3Int getNumTex() {
            return this.get(State.TEX_NUM);
        }

        public void setNumTex(War3Int val) {
            this.set(State.TEX_NUM, val);
        }

        public War3Real getTexOffset() {
            return this.get(State.TEX_OFFSET);
        }

        public void setTexOffset(War3Real val) {
            this.set(State.TEX_OFFSET, val);
        }

        public War3Real getTexRate() {
            return this.get(State.TEX_RATE);
        }

        public void setTexRate(War3Real val) {
            this.set(State.TEX_RATE, val);
        }

        public AlphaMode getAlphaMode() {
            return this.get(State.ALPHA_MODE);
        }

        public void setAlphaMode(AlphaMode val) {
            this.set(State.ALPHA_MODE, val);
        }

        public War3Bool getLighting() {
            return this.get(State.LIGHTING);
        }

        public void setLighting(War3Bool val) {
            this.set(State.LIGHTING, val);
        }

        public War3Int getCells() {
            return this.get(State.CELLS);
        }

        public void setCells(War3Int val) {
            this.set(State.CELLS, val);
        }

        public Coords3DF getMinExtents() {
            return new Coords3DF(this.get(State.MIN_X), this.get(State.MIN_Y), this.get(State.MIN_Z));
        }

        public void setMinExtents(Coords3DF val) {
            this.set(State.MIN_X, val.getX());
            this.set(State.MIN_Y, val.getY());
            this.set(State.MIN_Z, val.getZ());
        }

        public Coords3DF getMaxExtents() {
            return new Coords3DF(this.get(State.MAX_X), this.get(State.MAX_Y), this.get(State.MAX_Z));
        }

        public void setMaxExtents(Coords3DF val) {
            this.set(State.MAX_X, val.getX());
            this.set(State.MAX_Y, val.getY());
            this.set(State.MAX_Z, val.getZ());
        }

        public Coords3DF getRates() {
            return new Coords3DF(this.get(State.RATE_X), this.get(State.RATE_Y), this.get(State.RATE_Z));
        }

        public void setRates(Coords3DF val) {
            this.set(State.RATE_X, val.getX());
            this.set(State.RATE_Y, val.getY());
            this.set(State.RATE_Z, val.getZ());
        }

        public Coords2DF getRevs() {
            return new Coords2DF(this.get(State.REV_X), this.get(State.REV_Y));
        }

        public void setRevs(Coords2DF val) {
            this.set(State.REV_X, val.getX());
            this.set(State.REV_Y, val.getY());
        }

        public War3Bool getShoreInFog() {
            return this.get(State.SHORE_IN_FOG);
        }

        public void setShoreInFog(War3Bool val) {
            this.set(State.SHORE_IN_FOG, val);
        }

        public String getShoreDir() {
            return this.get(State.SHORE_DIR).toString();
        }

        public void setShoreDir(String val) {
            this.set(State.SHORE_DIR, War3String.valueOf(val));
        }

        public String getShoreSFile() {
            return this.get(State.SHORE_S_FILE).toString();
        }

        public void setShoreSFile(String val) {
            this.set(State.SHORE_S_FILE, War3String.valueOf(val));
        }

        public War3Real getShoreSVar() {
            return this.get(State.SHORE_S_VAR);
        }

        public void setShoreSVar(War3Real val) {
            this.set(State.SHORE_S_VAR, val);
        }

        public String getShoreOCFile() {
            return this.get(State.SHORE_OC_FILE).toString();
        }

        public void setShoreOCFile(String val) {
            this.set(State.SHORE_OC_FILE, War3String.valueOf(val));
        }

        public War3Real getShoreOCVar() {
            return this.get(State.SHORE_OC_VAR);
        }

        public void setShoreOCVar(War3Real val) {
            this.set(State.SHORE_OC_VAR, val);
        }

        public String getShoreICFile() {
            return this.get(State.SHORE_IC_FILE).toString();
        }

        public void setShoreICFile(String val) {
            this.set(State.SHORE_IC_FILE, War3String.valueOf(val));
        }

        public War3Real getShoreICVar() {
            return this.get(State.SHORE_IC_VAR);
        }

        public void setShoreICVar(War3Real val) {
            this.set(State.SHORE_IC_VAR, val);
        }

        public Color getSMinColor() {
            return Color.fromBGRA255(this.get(State.S_MIN_BLUE).toInt(), this.get(State.S_MIN_GREEN).toInt(), this.get(State.S_MIN_RED).toInt(), this.get(State.S_MIN_ALPHA).toInt());
        }

        public void setSMinColor(Color val) {
            this.set(State.S_MIN_ALPHA, War3Int.valueOf(val.getAlpha255()));
            this.set(State.S_MIN_BLUE, War3Int.valueOf(val.getBlue255()));
            this.set(State.S_MIN_GREEN, War3Int.valueOf(val.getGreen255()));
            this.set(State.S_MIN_RED, War3Int.valueOf(val.getRed255()));
        }

        public Color getSMaxColor() {
            return Color.fromBGRA255(this.get(State.S_MAX_BLUE).toInt(), this.get(State.S_MAX_GREEN).toInt(), this.get(State.S_MAX_RED).toInt(), this.get(State.S_MAX_ALPHA).toInt());
        }

        public void setSMaxColor(Color val) {
            this.set(State.S_MAX_ALPHA, War3Int.valueOf(val.getAlpha255()));
            this.set(State.S_MAX_BLUE, War3Int.valueOf(val.getBlue255()));
            this.set(State.S_MAX_GREEN, War3Int.valueOf(val.getGreen255()));
            this.set(State.S_MAX_RED, War3Int.valueOf(val.getRed255()));
        }

        public Color getDMinColor() {
            return Color.fromBGRA255(this.get(State.D_MIN_BLUE).toInt(), this.get(State.D_MIN_GREEN).toInt(), this.get(State.D_MIN_RED).toInt(), this.get(State.D_MIN_ALPHA).toInt());
        }

        public void setDMinColor(Color val) {
            this.set(State.D_MIN_ALPHA, War3Int.valueOf(val.getAlpha255()));
            this.set(State.D_MIN_BLUE, War3Int.valueOf(val.getBlue255()));
            this.set(State.D_MIN_GREEN, War3Int.valueOf(val.getGreen255()));
            this.set(State.D_MIN_RED, War3Int.valueOf(val.getRed255()));
        }

        public Color getDMaxColor() {
            return Color.fromBGRA255(this.get(State.D_MAX_BLUE).toInt(), this.get(State.D_MAX_GREEN).toInt(), this.get(State.D_MAX_RED).toInt(), this.get(State.D_MAX_ALPHA).toInt());
        }

        public void setDMaxColor(Color val) {
            this.set(State.D_MAX_ALPHA, War3Int.valueOf(val.getAlpha255()));
            this.set(State.D_MAX_BLUE, War3Int.valueOf(val.getBlue255()));
            this.set(State.D_MAX_GREEN, War3Int.valueOf(val.getGreen255()));
            this.set(State.D_MAX_RED, War3Int.valueOf(val.getRed255()));
        }

        public <T extends DataType> T get(State<T> state) {
            try {
                return state.tryCastVal(super.get(state));
            }
            catch (DataTypeInfo.CastException castException) {
                return null;
            }
        }

        public <T extends DataType> void set(State<T> state, T val) {
            super.set(state, val);
        }

        public <T extends DataType> void remove(State<T> state) {
            super.set(state, null);
        }

        private void read(SLK.Obj<? extends ObjId> slkObj) {
            this.merge(slkObj, true);
        }

        public Obj(SLK.Obj<? extends ObjId> slkObj) {
            super(WaterId.valueOf(slkObj.getId()));
            this.read(slkObj);
        }

        public Obj(WaterId id) {
            super(id);
            for (State state : State.values(State.class)) {
                this.set((SLKState)state, (DataType)state.getDefVal());
            }
        }

        @Override
        public void reduce() {
        }
    }

    public static class State<T extends DataType>
    extends ObjSLK.State<T> {
        public static final State<WaterId> OBJ_ID = new State<WaterId>("waterID", WaterId.class);
        public static final State<AlphaMode> ALPHA_MODE = new State<AlphaMode>("alphaMode", AlphaMode.class);
        public static final State<War3Int> CELLS = new State<War3Int>("cells", War3Int.class);
        public static final State<War3Int> D_MAX_ALPHA = new State<War3Int>("DmaxA", War3Int.class);
        public static final State<War3Int> D_MAX_BLUE = new State<War3Int>("DmaxB", War3Int.class);
        public static final State<War3Int> D_MAX_GREEN = new State<War3Int>("DmaxG", War3Int.class);
        public static final State<War3Int> D_MAX_RED = new State<War3Int>("DmaxR", War3Int.class);
        public static final State<War3Int> D_MIN_ALPHA = new State<War3Int>("DminA", War3Int.class);
        public static final State<War3Int> D_MIN_BLUE = new State<War3Int>("DminB", War3Int.class);
        public static final State<War3Int> D_MIN_GREEN = new State<War3Int>("DminG", War3Int.class);
        public static final State<War3Int> D_MIN_RED = new State<War3Int>("DminR", War3Int.class);
        public static final State<War3Real> HEIGHT = new State<War3Real>("height", War3Real.class);
        public static final State<War3Bool> IMPASSABLE = new State<War3Bool>("impassable", War3Bool.class);
        public static final State<War3Bool> LIGHTING = new State<War3Bool>("lighting", War3Bool.class);
        public static final State<War3Real> MAX_X = new State<War3Real>("maxX", War3Real.class);
        public static final State<War3Real> MAX_Y = new State<War3Real>("maxY", War3Real.class);
        public static final State<War3Real> MAX_Z = new State<War3Real>("maxZ", War3Real.class);
        public static final State<War3Real> MIN_X = new State<War3Real>("minX", War3Real.class);
        public static final State<War3Real> MIN_Y = new State<War3Real>("minX", War3Real.class);
        public static final State<War3Real> MIN_Z = new State<War3Real>("minX", War3Real.class);
        public static final State<War3Int> MINIMAP_COLOR_ALPHA = new State<War3Int>("mmAlpha", War3Int.class);
        public static final State<War3Int> MINIMAP_COLOR_BLUE = new State<War3Int>("mmBlue", War3Int.class);
        public static final State<War3Int> MINIMAP_COLOR_GREEN = new State<War3Int>("mmGreen", War3Int.class);
        public static final State<War3Int> MINIMAP_COLOR_RED = new State<War3Int>("mmRed", War3Int.class);
        public static final State<War3Real> RATE_X = new State<War3Real>("rateX", War3Real.class);
        public static final State<War3Real> RATE_Y = new State<War3Real>("rateY", War3Real.class);
        public static final State<War3Real> RATE_Z = new State<War3Real>("rateZ", War3Real.class);
        public static final State<War3Real> REV_X = new State<War3Real>("revX", War3Real.class);
        public static final State<War3Real> REV_Y = new State<War3Real>("revY", War3Real.class);
        public static final State<War3Int> S_MAX_ALPHA = new State<War3Int>("SmaxA", War3Int.class);
        public static final State<War3Int> S_MAX_BLUE = new State<War3Int>("SmaxB", War3Int.class);
        public static final State<War3Int> S_MAX_GREEN = new State<War3Int>("SmaxG", War3Int.class);
        public static final State<War3Int> S_MAX_RED = new State<War3Int>("SmaxR", War3Int.class);
        public static final State<War3Int> S_MIN_ALPHA = new State<War3Int>("SminA", War3Int.class);
        public static final State<War3Int> S_MIN_BLUE = new State<War3Int>("SminB", War3Int.class);
        public static final State<War3Int> S_MIN_GREEN = new State<War3Int>("SminG", War3Int.class);
        public static final State<War3Int> S_MIN_RED = new State<War3Int>("SminR", War3Int.class);
        public static final State<War3Bool> SHORE_IN_FOG = new State<War3Bool>("shoreInFog", War3Bool.class);
        public static final State<War3String> SHORE_DIR = new State<War3String>("shoreDir", War3String.class);
        public static final State<War3String> SHORE_IC_FILE = new State<War3String>("shoreICFile", War3String.class);
        public static final State<War3Real> SHORE_IC_VAR = new State<War3Real>("shoreICVar", War3Real.class);
        public static final State<War3String> SHORE_OC_FILE = new State<War3String>("shoreOCFile", War3String.class);
        public static final State<War3Real> SHORE_OC_VAR = new State<War3Real>("shoreOCVar", War3Real.class);
        public static final State<War3String> SHORE_S_FILE = new State<War3String>("shoreSFile", War3String.class);
        public static final State<War3Real> SHORE_S_VAR = new State<War3Real>("shoreSVar", War3Real.class);
        public static final State<War3String> TEX_FILE = new State<War3String>("texFile", War3String.class);
        public static final State<War3Int> TEX_NUM = new State<War3Int>("numTex", War3Int.class);
        public static final State<War3Real> TEX_RATE = new State<War3Real>("texRate", War3Real.class);
        public static final State<War3Real> TEX_OFFSET = new State<War3Real>("texOffset", War3Real.class);

        public State(String idString, DataTypeInfo typeInfo, T defVal) {
            super(idString, typeInfo, defVal);
        }

        public State(String idString, DataTypeInfo typeInfo) {
            super(idString, typeInfo);
        }

        public State(String idString, Class<T> type) {
            super(idString, type);
        }

        public State(String idString, Class<T> type, T defVal) {
            super(idString, type, defVal);
        }
    }
}

