/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSet;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.MDXObject;
import net.moonlightflower.wc3libs.misc.model.mdx.Node;
import net.moonlightflower.wc3libs.misc.model.mdx.Track;
import net.moonlightflower.wc3libs.misc.model.mdx.TrackChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.VisibilityTrack;

public class Attachment
extends MDXObject {
    private long _inclusiveSize = 0L;
    private Node _node;
    private String _path = "unset";
    private long _attachmentId = 0L;
    private final LinkedHashSet<VisibilityTrackChunk> _visibilityTrackChunks = new ObservableLinkedHashSet<VisibilityTrackChunk>();

    public long getInclusiveSize() {
        return this._inclusiveSize;
    }

    @Nonnull
    public Node getNode() {
        return this._node;
    }

    public void setNode(@Nonnull Node node) {
        this._node = node;
    }

    @Nonnull
    public String getPath() {
        return this._path;
    }

    public void setPath(@Nonnull String path) {
        this._path = path;
    }

    public long getAttachmentId() {
        return this._attachmentId;
    }

    public void setAttachmentId(long attachmentId) {
        this._attachmentId = attachmentId;
    }

    public LinkedHashSet<VisibilityTrackChunk> getVisibilityTrackChunks() {
        return this._visibilityTrackChunks;
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        MDXObject.SizeWriter sizeWriter = new MDXObject.SizeWriter();
        sizeWriter.write(stream);
        this._node.write(stream);
        stream.writeBytes(Arrays.copyOf(this._path.getBytes(), 260));
        stream.writeUInt32(this._attachmentId);
        for (VisibilityTrackChunk visibilityTrackChunk : this.getVisibilityTrackChunks()) {
            visibilityTrackChunk.write(stream);
        }
        sizeWriter.rewrite();
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public Attachment(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this._inclusiveSize = stream.readUInt32("inclusiveSize");
        this._node = new Node(stream);
        this._path = new String(stream.readBytes(260), StandardCharsets.US_ASCII);
        this._attachmentId = stream.readUInt32("attachmentId");
        LinkedHashMap<Id, MDX.TokenHandler> _tokenMap = new LinkedHashMap<Id, MDX.TokenHandler>();
        _tokenMap.put(VisibilityTrackChunk.TOKEN, () -> this._visibilityTrackChunks.add(new VisibilityTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        while (!stream.eof()) {
            Id trackToken = stream.readId("trackToken");
            stream.rewind(4L);
            if (!_tokenMap.containsKey(trackToken)) break;
            MDX.TokenHandler handler = (MDX.TokenHandler)_tokenMap.get(trackToken);
            handler.run();
        }
    }

    public Attachment() {
        this._node = new Node();
    }

    public static class VisibilityTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KATV");
        private final LinkedHashSet<VisibilityTrack> _visibilityTracks = new ObservableLinkedHashSet<VisibilityTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._visibilityTracks;
        }

        public LinkedHashSet<VisibilityTrack> getVisibilityTracks() {
            return this._visibilityTracks;
        }

        public VisibilityTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._visibilityTracks.add(new VisibilityTrack(stream, this.getInterpolationType(), format));
            }
        }

        public VisibilityTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }
    }
}

