/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Scanner;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class AssetsGenerator {
    private static final Pattern namePattern = Pattern.compile("\\d\\w+");
    static HashSet<String> forbidden = new HashSet<String>(Arrays.asList("step", "switch", "nothing", "lightning"));
    static HashSet<String> names = new HashSet();
    private static final TreeSet<Entry>[] entries = new TreeSet[Category.values().length];

    private static File getFile(String name) {
        return new File(AssetsGenerator.class.getClassLoader().getResource(name).getFile());
    }

    public static void main(String[] args) {
        try {
            AssetsGenerator.generate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void generate() throws IOException {
        File rocfile = AssetsGenerator.getFile("rocfile");
        File tftfile = AssetsGenerator.getFile("tftfile");
        File localfile = AssetsGenerator.getFile("localfile");
        File file = new File("output.txt");
        String input = new String(Files.readAllBytes(rocfile.toPath())) + new String(Files.readAllBytes(tftfile.toPath())) + new String(Files.readAllBytes(localfile.toPath()));
        Scanner scanner = new Scanner(input);
        while (scanner.hasNextLine()) {
            Category category;
            String line = scanner.nextLine();
            String filename = line.substring(line.lastIndexOf("\\") + 1);
            Type type = AssetsGenerator.getType(filename);
            if (type == null) continue;
            switch (type) {
                case ICON: {
                    category = Category.ICONS;
                    break;
                }
                case SOUND: {
                    category = Category.SOUND;
                    break;
                }
                case TEXTURE: {
                    category = Category.TEXTURES;
                    break;
                }
                default: {
                    category = AssetsGenerator.getCategory(line);
                }
            }
            Entry entry = new Entry(category, type, line, filename.substring(0, filename.indexOf(".")));
            if (category == null) continue;
            entries[category.ordinal()].add(entry);
        }
        StringBuilder output = new StringBuilder("package Assets\nimport NoWurst\n\n");
        for (Category category : Category.values()) {
            output.append("public class ").append(category.toName()).append("\n");
            TreeSet<Entry> entries = AssetsGenerator.entries[category.ordinal()];
            for (Entry e : entries) {
                output.append("\t").append(e.print());
            }
            output.append("\n\n");
        }
        Files.write(file.toPath(), output.toString().getBytes(), StandardOpenOption.CREATE);
    }

    private static Type getType(String filename) {
        for (Type t : Type.values()) {
            if (!t.checker.run(filename)) continue;
            return t;
        }
        return null;
    }

    public static Category getCategory(String line) {
        for (Category c : Category.values()) {
            if (!c.checker.run(line)) continue;
            return c;
        }
        return null;
    }

    static {
        for (Category category : Category.values()) {
            AssetsGenerator.entries[category.ordinal()] = new TreeSet();
        }
    }

    static enum Category {
        UNIT(l -> l.startsWith("Units"), "Units"),
        BUILDING(l -> l.startsWith("buildings") || l.startsWith("Buildings"), "Buildings"),
        ABILITIES(l -> l.startsWith("Abilities"), "Abilities"),
        OBJECTS(l -> l.startsWith("Objects"), "Objects"),
        DOODAD(l -> l.startsWith("Doodads"), "Doodads"),
        SOUND(l -> l.startsWith("Sound") || l.startsWith("Music"), "Sounds"),
        UI(l -> l.startsWith("UI"), "UI"),
        TEXTURES(l -> l.startsWith("Textures") | l.startsWith("ReplaceableTextures"), "Textures"),
        ICONS(l -> l.startsWith("ReplaceableTextures"), "Icons");

        Checker checker;
        private final String name;

        private Category(Checker checker, String name) {
            this.checker = checker;
            this.name = name;
        }

        public String toName() {
            return this.name;
        }
    }

    static enum Type {
        MODEL(s -> s.endsWith(".mdx") | s.endsWith(".mdl")),
        ICON(s -> s.endsWith(".blp") && s.contains("BTN")),
        TEXTURE(s -> s.endsWith(".blp") | s.endsWith(".dds")),
        SOUND(s -> s.endsWith(".mp3") | s.endsWith(".wav"));

        Checker checker;

        private Type(Checker checker) {
            this.checker = checker;
        }
    }

    static class Entry
    implements Comparable<Entry> {
        Category category;
        Type type;
        String path;
        String name;

        public Entry(Category category, Type type, String path, String name) {
            this.category = category;
            this.type = type;
            this.path = path.replaceAll("\\\\", "\\\\\\\\");
            this.name = name.replaceAll("['&! ]", "").replaceAll("-", "_");
            this.name = this.name.substring(0, 1).toLowerCase() + this.name.substring(1);
            if (forbidden.contains(this.name)) {
                this.name = this.name + "0";
            }
            while (namePattern.matcher(this.name).matches()) {
                this.name = this.name.substring(1);
            }
            if (names.contains(this.name)) {
                this.name = this.name + "1";
            }
            names.add(this.name);
        }

        @Override
        public int compareTo(Entry o) {
            return this.name.compareTo(o.name);
        }

        public String print() {
            return "static constant " + this.name + " = \"" + this.path + "\"\n";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.category != entry.category) {
                return false;
            }
            if (this.type != entry.type) {
                return false;
            }
            if (!Objects.equals(this.path, entry.path)) {
                return false;
            }
            return Objects.equals(this.name, entry.name);
        }

        public int hashCode() {
            int result = this.category != null ? this.category.hashCode() : 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }

    static interface Checker {
        public boolean run(String var1);
    }
}

