/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.port;

import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.port.GameVersion;
import net.moonlightflower.wc3libs.port.GameVersionFinder;
import net.moonlightflower.wc3libs.port.NotFoundException;
import net.moonlightflower.wc3libs.port.Orient;
import net.moonlightflower.wc3libs.port.mac.MacGameVersionFinder;
import net.moonlightflower.wc3libs.port.win.WinGameVersionFinder;

public class StdGameVersionFinder
extends GameVersionFinder {
    protected GameVersionFinder getMacGameVersionFinder() {
        return new MacGameVersionFinder();
    }

    protected GameVersionFinder getWinGameVersionFinder() {
        return new WinGameVersionFinder();
    }

    @Override
    @Nonnull
    public GameVersion find() throws NotFoundException {
        if (Orient.isMacSystem()) {
            try {
                GameVersionFinder macGameVersionFinder = this.getMacGameVersionFinder();
                return (GameVersion)macGameVersionFinder.get();
            }
            catch (NotFoundException e) {
                throw new NotFoundException(e);
            }
        }
        if (Orient.isWindowsSystem()) {
            try {
                GameVersionFinder winGameVersionFinder = this.getWinGameVersionFinder();
                return (GameVersion)winGameVersionFinder.get();
            }
            catch (NotFoundException e) {
                throw new NotFoundException(e);
            }
        }
        throw new NotFoundException(new Exception("system not supported: " + Orient.getSystem()));
    }
}

