/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import de.peeeq.datastructures.Partitions;
import de.peeeq.datastructures.TransitiveClosure;
import de.peeeq.wurstscript.RunArgs;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.ast.Annotation;
import de.peeeq.wurstscript.ast.ArrayInitializer;
import de.peeeq.wurstscript.ast.Ast;
import de.peeeq.wurstscript.ast.AstElementWithNameId;
import de.peeeq.wurstscript.ast.AstElementWithParameters;
import de.peeeq.wurstscript.ast.AstElementWithTypeParameters;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ClassOrInterface;
import de.peeeq.wurstscript.ast.ClassOrModuleInstanciation;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.EnumMember;
import de.peeeq.wurstscript.ast.EnumMembers;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprFunctionCall;
import de.peeeq.wurstscript.ast.ExprSuper;
import de.peeeq.wurstscript.ast.ExprThis;
import de.peeeq.wurstscript.ast.ExtensionFuncDef;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.FunctionCall;
import de.peeeq.wurstscript.ast.HasModifier;
import de.peeeq.wurstscript.ast.InitBlock;
import de.peeeq.wurstscript.ast.InterfaceDef;
import de.peeeq.wurstscript.ast.JassToplevelDeclaration;
import de.peeeq.wurstscript.ast.Modifier;
import de.peeeq.wurstscript.ast.ModuleInstanciation;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NamedScope;
import de.peeeq.wurstscript.ast.NativeFunc;
import de.peeeq.wurstscript.ast.NoExpr;
import de.peeeq.wurstscript.ast.OnDestroyDef;
import de.peeeq.wurstscript.ast.PackageOrGlobal;
import de.peeeq.wurstscript.ast.StructureDef;
import de.peeeq.wurstscript.ast.TranslatedToImFunction;
import de.peeeq.wurstscript.ast.TupleDef;
import de.peeeq.wurstscript.ast.TypeExprArray;
import de.peeeq.wurstscript.ast.TypeExprList;
import de.peeeq.wurstscript.ast.TypeExprSimple;
import de.peeeq.wurstscript.ast.TypeExprThis;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.TypeParamDefs;
import de.peeeq.wurstscript.ast.VarDef;
import de.peeeq.wurstscript.ast.VarInitialization;
import de.peeeq.wurstscript.ast.WEntity;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.ast.WParameters;
import de.peeeq.wurstscript.ast.WStatement;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.attributes.names.PackageLink;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ElementWithVar;
import de.peeeq.wurstscript.jassIm.ImAnyType;
import de.peeeq.wurstscript.jassIm.ImArrayType;
import de.peeeq.wurstscript.jassIm.ImArrayTypeMulti;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImExprs;
import de.peeeq.wurstscript.jassIm.ImFuncRef;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImMethod;
import de.peeeq.wurstscript.jassIm.ImOperatorCall;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImReturn;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImSimpleType;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImTupleType;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImTypeArguments;
import de.peeeq.wurstscript.jassIm.ImTypeClassFunc;
import de.peeeq.wurstscript.jassIm.ImTypeVar;
import de.peeeq.wurstscript.jassIm.ImTypeVarRef;
import de.peeeq.wurstscript.jassIm.ImTypeVars;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVars;
import de.peeeq.wurstscript.jassIm.ImVoid;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.translation.imtranslation.AssertProperty;
import de.peeeq.wurstscript.translation.imtranslation.CallType;
import de.peeeq.wurstscript.translation.imtranslation.ClassManagementVars;
import de.peeeq.wurstscript.translation.imtranslation.EliminateCallFunctionsWithAnnotation;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlag;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlagAnnotation;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlagCompiletime;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlagEnum;
import de.peeeq.wurstscript.translation.imtranslation.GetAForB;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.types.TypesHelper;
import de.peeeq.wurstscript.types.WurstTypeBool;
import de.peeeq.wurstscript.types.WurstTypeClass;
import de.peeeq.wurstscript.types.WurstTypeInt;
import de.peeeq.wurstscript.types.WurstTypeInterface;
import de.peeeq.wurstscript.types.WurstTypeReal;
import de.peeeq.wurstscript.types.WurstTypeString;
import de.peeeq.wurstscript.utils.Pair;
import de.peeeq.wurstscript.utils.Utils;
import de.peeeq.wurstscript.validation.TRVEHelper;
import de.peeeq.wurstscript.validation.WurstValidator;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class ImTranslator {
    public static final String $DEBUG_PRINT = "$debugPrint";
    private static final de.peeeq.wurstscript.ast.Element emptyTrace = Ast.NoExpr();
    private @Nullable Multimap<ImFunction, ImFunction> callRelations = null;
    private @Nullable Set<ImVar> usedVariables = null;
    private @Nullable Set<ImVar> readVariables = null;
    private @Nullable Set<ImFunction> usedFunctions = null;
    private @Nullable ImFunction debugPrintFunction;
    private final Map<TranslatedToImFunction, ImFunction> functionMap = new LinkedHashMap<TranslatedToImFunction, ImFunction>();
    private @Nullable ImFunction globalInitFunc;
    private final ImProg imProg;
    final Map<WPackage, ImFunction> initFuncMap = new LinkedHashMap<WPackage, ImFunction>();
    private final Map<TranslatedToImFunction, ImVar> thisVarMap = new LinkedHashMap<TranslatedToImFunction, ImVar>();
    private final Set<WPackage> translatedPackages = new LinkedHashSet<WPackage>();
    private final Set<ClassDef> translatedClasses = new LinkedHashSet<ClassDef>();
    private final Map<VarDef, ImVar> varMap = new LinkedHashMap<VarDef, ImVar>();
    private final WurstModel wurstProg;
    private @Nullable ImFunction mainFunc = null;
    private @Nullable ImFunction configFunc = null;
    public @Nullable ImFunction ensureIntFunc = null;
    public @Nullable ImFunction ensureBoolFunc = null;
    public @Nullable ImFunction ensureRealFunc = null;
    public @Nullable ImFunction ensureStrFunc = null;
    public @Nullable ImFunction stringConcatFunc = null;
    private final Map<ImVar, VarsForTupleResult> varsForTupleVar = new LinkedHashMap<ImVar, VarsForTupleResult>();
    private final boolean isUnitTestMode;
    private final ImVar lastInitFunc = JassIm.ImVar(emptyTrace, WurstTypeString.instance().imTranslateType(this), "lastInitFunc", false);
    private int compiletimeOrderCounter = 1;
    private final Map<TranslatedToImFunction, FunctionFlagCompiletime> compiletimeFlags = new HashMap<TranslatedToImFunction, FunctionFlagCompiletime>();
    private final Map<ExprFunctionCall, Integer> compiletimeExpressionsOrder = new HashMap<ExprFunctionCall, Integer>();
    de.peeeq.wurstscript.ast.Element lasttranslatedThing;
    private final boolean debug = false;
    private final RunArgs runArgs;
    public GetAForB<StructureDef, ImFunction> destroyFunc = new GetAForB<StructureDef, ImFunction>(){

        @Override
        public ImFunction initFor(StructureDef classDef) {
            ImVars params = JassIm.ImVars(JassIm.ImVar(classDef, ImTranslator.this.selfType(classDef), "this", false));
            ImFunction f = JassIm.ImFunction(classDef.getOnDestroy(), "destroy" + classDef.getName(), JassIm.ImTypeVars(new ImTypeVar[0]), params, TypesHelper.imVoid(), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), ImTranslator.this.flags(new FunctionFlag[0]));
            ImTranslator.this.addFunction(f, classDef);
            return f;
        }
    };
    public GetAForB<StructureDef, ImMethod> destroyMethod = new GetAForB<StructureDef, ImMethod>(){

        @Override
        public ImMethod initFor(StructureDef classDef) {
            ImFunction impl = ImTranslator.this.destroyFunc.getFor(classDef);
            ImMethod m = JassIm.ImMethod(classDef, ImTranslator.this.selfType(classDef), "destroy" + classDef.getName(), impl, Lists.newArrayList(), false);
            return m;
        }
    };
    public GetAForB<ImClass, ImFunction> allocFunc = new GetAForB<ImClass, ImFunction>(){

        @Override
        public ImFunction initFor(ImClass c) {
            return JassIm.ImFunction(c.getTrace(), "alloc_" + c.getName(), JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(new ImVar[0]), TypesHelper.imInt(), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), Collections.emptyList());
        }
    };
    public GetAForB<ImClass, ImFunction> deallocFunc = new GetAForB<ImClass, ImFunction>(){

        @Override
        public ImFunction initFor(ImClass c) {
            return JassIm.ImFunction(c.getTrace(), "dealloc_" + c.getName(), JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(JassIm.ImVar(c.getTrace(), TypesHelper.imInt(), "obj", false)), TypesHelper.imVoid(), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), Collections.emptyList());
        }
    };
    private final Map<ImTypeVar, TypeParamDef> typeVariableReverse = new HashMap<ImTypeVar, TypeParamDef>();
    private final GetAForB<TypeParamDef, ImTypeVar> typeVariable = new GetAForB<TypeParamDef, ImTypeVar>(){

        @Override
        public ImTypeVar initFor(TypeParamDef a) {
            ImTypeVar v = JassIm.ImTypeVar(a.getName());
            ImTranslator.this.typeVariableReverse.put(v, a);
            return v;
        }
    };
    private final Map<ClassDef, List<Pair<ImVar, VarInitialization>>> classDynamicInitMap = Maps.newLinkedHashMap();
    private final Map<ClassDef, List<WStatement>> classInitStatements = Maps.newLinkedHashMap();
    private final Map<ConstructorDef, ImFunction> constructorFuncs = Maps.newLinkedHashMap();
    Map<ConstructorDef, ImFunction> constrNewFuncs = Maps.newLinkedHashMap();
    private Multimap<InterfaceDef, ClassDef> interfaceInstances = null;
    private TransitiveClosure<ClassDef> subclasses = null;
    private Multimap<ClassDef, ClassDef> directSubclasses = null;
    private boolean isEclipseMode = false;
    private final Map<ImFunction, VarsForTupleResult> tempReturnVars = Maps.newLinkedHashMap();
    private final Map<ImFunction, ImType> originalReturnValues = Maps.newLinkedHashMap();
    private final Map<ExprClosure, ImClass> classForClosure = Maps.newLinkedHashMap();
    private final Map<ClassOrInterface, @Nullable ImClass> classForStructureDef = Maps.newLinkedHashMap();
    Map<FuncDef, ImMethod> methodForFuncDef = Maps.newLinkedHashMap();
    private Map<ImClass, ClassManagementVars> classManagementVars = null;
    private @Nullable ImFunction errorFunc;

    public ImTranslator(WurstModel wurstProg, boolean isUnitTestMode, RunArgs runArgs) {
        this.wurstProg = wurstProg;
        this.lasttranslatedThing = wurstProg;
        this.isUnitTestMode = isUnitTestMode;
        this.imProg = JassIm.ImProg(wurstProg, JassIm.ImVars(new ImVar[0]), JassIm.ImFunctions(new ImFunction[0]), JassIm.ImMethods(new ImMethod[0]), JassIm.ImClasses(new ImClass[0]), JassIm.ImTypeClassFuncs(new ImTypeClassFunc[0]), new LinkedHashMap<ImVar, List<ImSet>>());
        this.runArgs = runArgs;
    }

    public ImProg translateProg() {
        try {
            this.globalInitFunc = JassIm.ImFunction(emptyTrace, "initGlobals", JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(new ImVar[0]), JassIm.ImVoid(), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), this.flags(new FunctionFlag[0]));
            this.addFunction(this.getGlobalInitFunc());
            this.debugPrintFunction = JassIm.ImFunction(emptyTrace, $DEBUG_PRINT, JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(JassIm.ImVar(this.wurstProg, WurstTypeString.instance().imTranslateType(this), "msg", false)), JassIm.ImVoid(), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), this.flags(FunctionFlagEnum.IS_NATIVE, FunctionFlagEnum.IS_BJ));
            if (this.isLuaTarget()) {
                this.ensureIntFunc = JassIm.ImFunction(emptyTrace, "intEnsure", JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(JassIm.ImVar(this.wurstProg, WurstTypeInt.instance().imTranslateType(this), "x", false)), WurstTypeInt.instance().imTranslateType(this), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), this.flags(FunctionFlagEnum.IS_NATIVE, FunctionFlagEnum.IS_BJ));
                this.ensureBoolFunc = JassIm.ImFunction(emptyTrace, "boolEnsure", JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(JassIm.ImVar(this.wurstProg, WurstTypeBool.instance().imTranslateType(this), "x", false)), WurstTypeBool.instance().imTranslateType(this), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), this.flags(FunctionFlagEnum.IS_NATIVE, FunctionFlagEnum.IS_BJ));
                this.ensureRealFunc = JassIm.ImFunction(emptyTrace, "realEnsure", JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(JassIm.ImVar(this.wurstProg, WurstTypeReal.instance().imTranslateType(this), "x", false)), WurstTypeReal.instance().imTranslateType(this), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), this.flags(FunctionFlagEnum.IS_NATIVE, FunctionFlagEnum.IS_BJ));
                this.ensureStrFunc = JassIm.ImFunction(emptyTrace, "stringEnsure", JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(JassIm.ImVar(this.wurstProg, WurstTypeString.instance().imTranslateType(this), "x", false)), WurstTypeString.instance().imTranslateType(this), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), this.flags(FunctionFlagEnum.IS_NATIVE, FunctionFlagEnum.IS_BJ));
                this.stringConcatFunc = JassIm.ImFunction(emptyTrace, "stringConcat", JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(JassIm.ImVar(this.wurstProg, WurstTypeString.instance().imTranslateType(this), "x", false), JassIm.ImVar(this.wurstProg, WurstTypeString.instance().imTranslateType(this), "y", false)), WurstTypeString.instance().imTranslateType(this), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), this.flags(FunctionFlagEnum.IS_NATIVE, FunctionFlagEnum.IS_BJ));
                this.addFunction(this.ensureIntFunc);
                this.addFunction(this.ensureBoolFunc);
                this.addFunction(this.ensureRealFunc);
                this.addFunction(this.ensureStrFunc);
                this.addFunction(this.stringConcatFunc);
            }
            this.calculateCompiletimeOrder();
            for (CompilationUnit cu : this.wurstProg) {
                this.translateCompilationUnit(cu);
            }
            if (this.mainFunc == null) {
                this.mainFunc = JassIm.ImFunction(emptyTrace, "main", JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(new ImVar[0]), JassIm.ImVoid(), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), this.flags(new FunctionFlag[0]));
                this.addFunction(this.mainFunc);
            }
            if (this.configFunc == null) {
                this.configFunc = JassIm.ImFunction(emptyTrace, "config", JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(new ImVar[0]), JassIm.ImVoid(), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), this.flags(new FunctionFlag[0]));
                this.addFunction(this.configFunc);
            }
            this.finishInitFunctions();
            EliminateCallFunctionsWithAnnotation.process(this.imProg);
            this.removeDuplicateNatives(this.imProg);
            this.sortEverything();
            return this.imProg;
        }
        catch (CompileError t) {
            throw t;
        }
        catch (Throwable t) {
            WLogger.severe(t);
            throw new RuntimeException("There was a Wurst bug in the translation of " + Utils.printElementWithSource(Optional.of(this.lasttranslatedThing)) + ": " + t.getMessage() + "\nPlease open a ticket with source code and the error log.", t);
        }
    }

    private void calculateCompiletimeOrder() {
        HashSet<WPackage> visited = new HashSet<WPackage>();
        ImmutableCollection packages = this.wurstProg.attrPackages().values();
        for (WPackage p : packages) {
            this.calculateCompiletimeOrder_walk(p, visited);
        }
    }

    private void calculateCompiletimeOrder_walk(WPackage p, Set<WPackage> visited) {
        if (!visited.add(p)) {
            return;
        }
        for (WPackage dep : p.attrInitDependencies()) {
            this.calculateCompiletimeOrder_walk(dep, visited);
        }
        p.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(FuncDef funcDef) {
                super.visit(funcDef);
                if (funcDef.attrIsCompiletime()) {
                    ImTranslator.this.compiletimeFlags.put(funcDef, new FunctionFlagCompiletime(ImTranslator.this.compiletimeOrderCounter++));
                }
            }

            @Override
            public void visit(ExprFunctionCall fc) {
                super.visit(fc);
                if (fc.getFuncName().equals("compiletime")) {
                    ImTranslator.this.compiletimeExpressionsOrder.put(fc, ImTranslator.this.compiletimeOrderCounter++);
                }
            }
        });
    }

    private void sortEverything() {
        this.sortList(this.imProg.getClasses());
        this.sortList(this.imProg.getGlobals());
        this.sortList(this.imProg.getFunctions());
        for (ImClass c : this.imProg.getClasses()) {
            this.sortList(c.getFields());
            this.sortList(c.getMethods());
        }
    }

    private <T extends Element> void sortList(List<T> list) {
        List<T> classes = this.removeAll(list);
        Comparator<Element> comparator = Comparator.comparing(this::getQualifiedClassName);
        classes.sort(comparator);
        list.addAll(classes);
    }

    public <T> List<T> removeAll(List<T> list) {
        ArrayList<T> result = new ArrayList<T>();
        while (!list.isEmpty()) {
            result.add(0, list.remove(list.size() - 1));
        }
        return result;
    }

    private String getQualifiedClassName(Element c) {
        return this.getQualifiedClassName(c.attrTrace());
    }

    private String getQualifiedClassName(de.peeeq.wurstscript.ast.Element e) {
        de.peeeq.wurstscript.ast.Element parent;
        String result = "";
        if (e instanceof NamedScope) {
            NamedScope ns = (NamedScope)e;
            result = ns.getName();
        }
        if ((parent = e.getParent()) == null) {
            return result;
        }
        if ((parent = parent.attrNearestNamedScope()) == null) {
            return result;
        }
        return this.getQualifiedClassName(parent) + "_" + result;
    }

    private void removeDuplicateNatives(ImProg imProg) {
        HashMap<String, ImFunction> natives = new HashMap<String, ImFunction>();
        final HashMap<ImFunction, ImFunction> removed = new HashMap<ImFunction, ImFunction>();
        ListIterator it = imProg.getFunctions().listIterator();
        while (it.hasNext()) {
            ImFunction f = (ImFunction)it.next();
            if (f.isNative() && natives.containsKey(f.getName())) {
                ImFunction existing = (ImFunction)natives.get(f.getName());
                if (!this.compatibleTypes(f, existing)) {
                    throw new CompileError(f, "Native function definition conflicts with other native function defined in " + existing.attrTrace().attrErrorPos());
                }
                it.remove();
                removed.put(f, existing);
                continue;
            }
            natives.put(f.getName(), f);
        }
        imProg.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImFunctionCall e) {
                super.visit(e);
                if (removed.containsKey(e.getFunc())) {
                    e.setFunc((ImFunction)removed.get(e.getFunc()));
                }
            }

            @Override
            public void visit(ImFuncRef e) {
                super.visit(e);
                if (removed.containsKey(e.getFunc())) {
                    e.setFunc((ImFunction)removed.get(e.getFunc()));
                }
            }
        });
    }

    private boolean compatibleTypes(ImFunction f, ImFunction g) {
        if (!f.getReturnType().equalsType(g.getReturnType())) {
            return false;
        }
        if (f.getParameters().size() != g.getParameters().size()) {
            return false;
        }
        for (int i = 0; i < f.getParameters().size(); ++i) {
            if (((ImVar)f.getParameters().get(i)).getType().equalsType(((ImVar)g.getParameters().get(i)).getType())) continue;
            return false;
        }
        return true;
    }

    private ArrayList<FunctionFlag> flags(FunctionFlag ... flags) {
        return Lists.newArrayList((Object[])flags);
    }

    private void translateCompilationUnit(CompilationUnit cu) {
        this.lasttranslatedThing = cu;
        for (WPackage p : cu.getPackages()) {
            this.lasttranslatedThing = p;
            p.imTranslateTLD(this);
        }
        for (JassToplevelDeclaration tld : cu.getJassDecls()) {
            this.lasttranslatedThing = tld;
            tld.imTranslateTLD(this);
        }
    }

    private void finishInitFunctions() {
        this.getMainFunc().getBody().add(0, JassIm.ImFunctionCall(emptyTrace, this.globalInitFunc, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(new ImExpr[0]), false, CallType.NORMAL));
        for (ImFunction initFunc : this.initFuncMap.values()) {
            this.addFunction(initFunc);
        }
        LinkedHashSet calledInitializers = Sets.newLinkedHashSet();
        ImVar initTrigVar = this.prepareTrigger();
        for (WPackage p : Utils.sortByName(this.initFuncMap.keySet())) {
            this.callInitFunc(calledInitializers, p, initTrigVar);
        }
        ImFunction native_DestroyTrigger = this.getNativeFunc("DestroyTrigger");
        if (native_DestroyTrigger != null) {
            this.getMainFunc().getBody().add(JassIm.ImFunctionCall(emptyTrace, native_DestroyTrigger, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(JassIm.ImVarAccess(initTrigVar)), false, CallType.NORMAL));
        }
    }

    @NotNull
    private ImVar prepareTrigger() {
        ImVar initTrigVar = JassIm.ImVar(emptyTrace, JassIm.ImSimpleType("trigger"), "initTrig", false);
        this.getMainFunc().getLocals().add(initTrigVar);
        ImFunction createTrigger = this.getNativeFunc("CreateTrigger");
        if (createTrigger != null) {
            this.getMainFunc().getBody().add(JassIm.ImSet(this.getMainFunc().getTrace(), JassIm.ImVarAccess(initTrigVar), JassIm.ImFunctionCall(this.getMainFunc().getTrace(), this.getNativeFunc("CreateTrigger"), JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(new ImExpr[0]), false, CallType.NORMAL)));
        }
        return initTrigVar;
    }

    private ImFunction getNativeFunc(String funcName) {
        ImmutableCollection<FuncLink> wurstFunc = this.wurstProg.lookupFuncs(funcName);
        if (wurstFunc.isEmpty()) {
            return null;
        }
        return this.getFuncFor(Utils.getFirst(wurstFunc).getDef());
    }

    private void callInitFunc(Set<WPackage> calledInitializers, WPackage p, ImVar initTrigVar) {
        Preconditions.checkNotNull((Object)p);
        if (calledInitializers.contains(p)) {
            return;
        }
        calledInitializers.add(p);
        for (WPackage dep : p.attrInitDependencies()) {
            this.callInitFunc(calledInitializers, dep, initTrigVar);
        }
        ImFunction initFunc = this.initFuncMap.get(p);
        if (initFunc == null) {
            return;
        }
        if (initFunc.getBody().size() == 0) {
            return;
        }
        boolean successful = this.createInitFuncCall(p, initTrigVar, initFunc);
        if (!successful) {
            this.getMainFunc().getBody().add(JassIm.ImFunctionCall(initFunc.getTrace(), initFunc, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(new ImExpr[0]), false, CallType.NORMAL));
        }
    }

    private boolean createInitFuncCall(WPackage p, ImVar initTrigVar, ImFunction initFunc) {
        ImStmts mainBody = this.getMainFunc().getBody();
        ImFunction native_ClearTrigger = this.getNativeFunc("TriggerClearConditions");
        ImFunction native_TriggerAddCondition = this.getNativeFunc("TriggerAddCondition");
        ImFunction native_Condition = this.getNativeFunc("Condition");
        ImFunction native_TriggerEvaluate = this.getNativeFunc("TriggerEvaluate");
        ImFunction native_DisplayTimedTextToPlayer = this.getNativeFunc("DisplayTimedTextToPlayer");
        ImFunction native_GetLocalPlayer = this.getNativeFunc("GetLocalPlayer");
        if (native_ClearTrigger == null || native_TriggerAddCondition == null || native_Condition == null || native_TriggerEvaluate == null || native_DisplayTimedTextToPlayer == null || native_GetLocalPlayer == null) {
            return false;
        }
        initFunc.setReturnType(WurstTypeBool.instance().imTranslateType(this));
        initFunc.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImReturn imReturn) {
                super.visit(imReturn);
                imReturn.setReturnValue(JassIm.ImBoolVal(true));
            }
        });
        de.peeeq.wurstscript.ast.Element trace = initFunc.getTrace();
        initFunc.getBody().add(JassIm.ImReturn(trace, JassIm.ImBoolVal(true)));
        mainBody.add(JassIm.ImFunctionCall(trace, native_TriggerAddCondition, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(JassIm.ImVarAccess(initTrigVar), JassIm.ImFunctionCall(trace, native_Condition, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(JassIm.ImFuncRef(trace, initFunc)), false, CallType.NORMAL)), true, CallType.NORMAL));
        mainBody.add(JassIm.ImIf(trace, JassIm.ImOperatorCall(WurstOperator.NOT, JassIm.ImExprs(JassIm.ImFunctionCall(trace, native_TriggerEvaluate, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(JassIm.ImVarAccess(initTrigVar)), false, CallType.NORMAL))), JassIm.ImStmts(this.imError(trace, JassIm.ImStringVal("Could not initialize package " + p.getName() + "."))), JassIm.ImStmts(new ImStmt[0])));
        mainBody.add(JassIm.ImFunctionCall(trace, native_ClearTrigger, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(JassIm.ImVarAccess(initTrigVar)), false, CallType.NORMAL));
        return true;
    }

    private void addFunction(ImFunction f, StructureDef s) {
        ImClass c = this.getClassFor(s.attrNearestClassOrInterface());
        c.getFunctions().add(f);
    }

    private void addFunction(ImFunction f, TranslatedToImFunction funcDef) {
        ImClass classForFunc = this.getClassForFunc(funcDef);
        if (classForFunc != null) {
            classForFunc.getFunctions().add(f);
        } else {
            this.addFunction(f);
        }
    }

    private void addFunction(ImFunction f) {
        this.imProg.getFunctions().add(f);
    }

    public void addGlobal(ImVar v) {
        this.imProg.getGlobals().add(v);
    }

    public void addGlobalInitalizer(ImVar v, PackageOrGlobal packageOrGlobal, VarInitialization initialExpr) {
        de.peeeq.wurstscript.ast.Element trace;
        ImFunction f;
        if (initialExpr instanceof NoExpr) {
            return;
        }
        if (packageOrGlobal instanceof WPackage) {
            WPackage p = (WPackage)packageOrGlobal;
            f = this.getInitFuncFor(p);
        } else {
            f = this.globalInitFunc;
        }
        de.peeeq.wurstscript.ast.Element element = trace = packageOrGlobal == null ? emptyTrace : packageOrGlobal;
        if (initialExpr instanceof Expr) {
            Expr expr2 = (Expr)initialExpr;
            ImExpr translated = expr2.imTranslateExpr(this, f);
            ImSet imSet = JassIm.ImSet(trace, JassIm.ImVarAccess(v), translated);
            if (!v.getIsBJ()) {
                f.getBody().add(imSet);
            }
            this.imProg.getGlobalInits().put(v, Collections.singletonList(imSet));
        } else if (initialExpr instanceof ArrayInitializer) {
            ArrayInitializer arInit = (ArrayInitializer)initialExpr;
            List translatedExprs = arInit.getValues().stream().map(expr -> expr.imTranslateExpr(this, f)).collect(Collectors.toList());
            ArrayList<ImSet> imSets = new ArrayList<ImSet>();
            for (int i = 0; i < arInit.getValues().size(); ++i) {
                ImExpr translated = (ImExpr)translatedExprs.get(i);
                ImSet imSet = JassIm.ImSet(trace, JassIm.ImVarArrayAccess(trace, v, JassIm.ImExprs(JassIm.ImIntVal(i))), translated);
                imSets.add(imSet);
            }
            f.getBody().addAll(imSets);
            this.imProg.getGlobalInits().put(v, imSets);
        }
    }

    public void addGlobalWithInitalizer(ImVar g, ImExpr initial) {
        this.imProg.getGlobals().add(g);
        ImSet imSet = JassIm.ImSet(g.getTrace(), JassIm.ImVarAccess(g), initial);
        this.getGlobalInitFunc().getBody().add(imSet);
        this.imProg.getGlobalInits().put(g, Collections.singletonList(imSet));
    }

    public ImExpr getDefaultValueForJassType(ImType type) {
        if (type instanceof ImSimpleType) {
            ImSimpleType imSimpleType = (ImSimpleType)type;
            return ImHelper.defaultValueForType(imSimpleType);
        }
        if (type instanceof ImAnyType) {
            return JassIm.ImIntVal(0);
        }
        if (type instanceof ImTupleType) {
            ImTupleType imTupleType = (ImTupleType)type;
            return this.getDefaultValueForJassType(imTupleType.getTypes().get(0));
        }
        throw new IllegalArgumentException("could not get default value for type " + type);
    }

    private ImType selfType(TranslatedToImFunction f) {
        return f.match(new TranslatedToImFunction.Matcher<ImType>(){

            @Override
            public ImType case_FuncDef(FuncDef f) {
                return ImTranslator.this.selfType(f);
            }

            @Override
            public ImType case_ConstructorDef(ConstructorDef f) {
                return ImTranslator.this.selfType(f.attrNearestClassOrInterface());
            }

            @Override
            public ImType case_NativeFunc(NativeFunc f) {
                throw new CompileError(f, "Cannot use 'this' here.");
            }

            @Override
            public ImType case_OnDestroyDef(OnDestroyDef f) {
                return ImTranslator.this.selfType(f.attrNearestClassOrInterface());
            }

            @Override
            public ImType case_TupleDef(TupleDef f) {
                throw new CompileError(f, "Cannot use 'this' here.");
            }

            @Override
            public ImType case_ExprClosure(ExprClosure f) {
                return ImTranslator.this.selfType(ImTranslator.this.getClassForClosure(f));
            }

            @Override
            public ImType case_InitBlock(InitBlock f) {
                throw new CompileError(f, "Cannot use 'this' here.");
            }

            @Override
            public ImType case_ExtensionFuncDef(ExtensionFuncDef f) {
                return f.getExtendedType().attrTyp().imTranslateType(ImTranslator.this);
            }
        });
    }

    private ImClassType selfType(FuncDef f) {
        return this.selfType(f.attrNearestClassOrInterface());
    }

    public ImClassType selfType(StructureDef classDef) {
        ImClass imClass = this.getClassFor(classDef.attrNearestClassOrInterface());
        return this.selfType(imClass);
    }

    public ImClassType selfType(ImClass imClass) {
        ImTypeArguments typeArgs = JassIm.ImTypeArguments(new ImTypeArgument[0]);
        for (ImTypeVar tv : imClass.getTypeVariables()) {
            typeArgs.add(JassIm.ImTypeArgument(JassIm.ImTypeVarRef(tv), Collections.emptyMap()));
        }
        return JassIm.ImClassType(imClass, typeArgs);
    }

    public ImFunction getFuncFor(TranslatedToImFunction funcDef) {
        WParameters params;
        if (this.functionMap.containsKey(funcDef)) {
            return this.functionMap.get(funcDef);
        }
        String name = this.getNameFor(funcDef);
        ArrayList<FunctionFlag> flags = this.flags(new FunctionFlag[0]);
        if (funcDef instanceof NativeFunc) {
            flags.add(FunctionFlagEnum.IS_NATIVE);
        }
        if (this.isBJ(funcDef.getSource())) {
            flags.add(FunctionFlagEnum.IS_BJ);
        }
        if (this.isExtern(funcDef)) {
            flags.add(FunctionFlagEnum.IS_EXTERN);
        }
        if (funcDef instanceof FuncDef) {
            FuncDef funcDef2 = (FuncDef)funcDef;
            if (funcDef2.attrIsCompiletime()) {
                FunctionFlagCompiletime flag = this.compiletimeFlags.get(funcDef);
                if (flag == null) {
                    throw new CompileError(funcDef.getSource(), "Compiletime flag not supported here.");
                }
                flags.add(flag);
            }
            if (funcDef2.attrHasAnnotation("compiletimenative")) {
                flags.add(FunctionFlagEnum.IS_COMPILETIME_NATIVE);
            }
            if (funcDef2.attrHasAnnotation("test")) {
                flags.add(FunctionFlagEnum.IS_TEST);
            }
        }
        if (funcDef instanceof AstElementWithParameters && (params = ((AstElementWithParameters)((Object)funcDef)).getParameters()).size() >= 1 && ((WParameter)params.get(params.size() - 1)).attrIsVararg()) {
            flags.add(FunctionFlagEnum.IS_VARARG);
        }
        if (funcDef instanceof HasModifier) {
            HasModifier awm = (HasModifier)((Object)funcDef);
            for (Modifier m : awm.getModifiers()) {
                if (!(m instanceof Annotation)) continue;
                Annotation annotation = (Annotation)m;
                flags.add(new FunctionFlagAnnotation(annotation.getAnnotationType()));
            }
        }
        ImTypeVars typeVars = this.collectTypeVarsForFunction(funcDef);
        ImFunction f = JassIm.ImFunction(funcDef, name, typeVars, JassIm.ImVars(new ImVar[0]), JassIm.ImVoid(), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), flags);
        funcDef.imCreateFuncSkeleton(this, f);
        this.addFunction(f, funcDef);
        this.functionMap.put(funcDef, f);
        return f;
    }

    private ImClass getClassForFunc(TranslatedToImFunction funcDef) {
        if (funcDef == null) {
            return null;
        }
        return funcDef.match(new TranslatedToImFunction.Matcher<ImClass>(){

            @Override
            public ImClass case_TupleDef(TupleDef tupleDef) {
                return null;
            }

            @Override
            public ImClass case_FuncDef(FuncDef funcDef) {
                if (funcDef.attrIsDynamicClassMember()) {
                    return ImTranslator.this.getClassFor(funcDef.attrNearestClassOrInterface());
                }
                return null;
            }

            @Override
            public ImClass case_NativeFunc(NativeFunc nativeFunc) {
                return null;
            }

            @Override
            public ImClass case_OnDestroyDef(OnDestroyDef funcDef) {
                return ImTranslator.this.getClassFor(funcDef.attrNearestClassOrInterface());
            }

            @Override
            public ImClass case_InitBlock(InitBlock initBlock) {
                return null;
            }

            @Override
            public ImClass case_ExtensionFuncDef(ExtensionFuncDef extensionFuncDef) {
                return null;
            }

            @Override
            public ImClass case_ConstructorDef(ConstructorDef funcDef) {
                return ImTranslator.this.getClassFor(funcDef.attrNearestClassOrInterface());
            }

            @Override
            public ImClass case_ExprClosure(ExprClosure exprClosure) {
                return null;
            }
        });
    }

    private ImTypeVars collectTypeVarsForFunction(TranslatedToImFunction funcDef) {
        final ImTypeVars typeVars = JassIm.ImTypeVars(new ImTypeVar[0]);
        funcDef.match(new TranslatedToImFunction.MatcherVoid(){

            @Override
            public void case_FuncDef(FuncDef funcDef) {
                this.handleTypeParameters(funcDef.getTypeParameters());
            }

            private void handleTypeParameters(TypeParamDefs tps) {
                for (TypeParamDef tp : tps) {
                    this.handleTypeParameter(tp);
                }
            }

            private void handleTypeParameter(TypeParamDef tp) {
                if (tp.getTypeParamConstraints() instanceof TypeExprList) {
                    typeVars.add(ImTranslator.this.typeVariable.getFor(tp));
                }
            }

            @Override
            public void case_ConstructorDef(ConstructorDef constructorDef) {
            }

            @Override
            public void case_NativeFunc(NativeFunc nativeFunc) {
            }

            @Override
            public void case_OnDestroyDef(OnDestroyDef onDestroyDef) {
            }

            @Override
            public void case_TupleDef(TupleDef tupleDef) {
            }

            @Override
            public void case_ExprClosure(ExprClosure exprClosure) {
            }

            @Override
            public void case_InitBlock(InitBlock initBlock) {
            }

            @Override
            public void case_ExtensionFuncDef(ExtensionFuncDef funcDef) {
                this.handleTypeParameters(funcDef.getTypeParameters());
            }
        });
        return typeVars;
    }

    private boolean isExtern(TranslatedToImFunction funcDef) {
        if (funcDef instanceof HasModifier) {
            HasModifier f = (HasModifier)((Object)funcDef);
            for (Modifier m : f.getModifiers()) {
                Annotation a;
                if (!(m instanceof Annotation) || !(a = (Annotation)m).getAnnotationType().equals("@extern")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBJ(WPos source) {
        String f = source.getFile().toLowerCase();
        return f.endsWith("blizzard.j") || f.endsWith("common.j");
    }

    public ImFunction getInitFuncFor(WPackage p) {
        return this.initFuncMap.computeIfAbsent(p, p1 -> JassIm.ImFunction(p1, "init_" + p1.getName(), JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(new ImVar[0]), JassIm.ImVoid(), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), this.flags(new FunctionFlag[0])));
    }

    public String getNameFor(de.peeeq.wurstscript.ast.Element e) {
        if (e instanceof FuncDef) {
            FuncDef f = (FuncDef)e;
            if (f.attrNearestStructureDef() != null) {
                return this.getNameFor(f.attrNearestStructureDef()) + "_" + f.getName();
            }
        } else {
            if (e instanceof ExtensionFuncDef) {
                ExtensionFuncDef f = (ExtensionFuncDef)e;
                return this.getNameFor(f.getExtendedType()) + "_" + f.getName();
            }
            if (e instanceof TypeExprSimple) {
                TypeExprSimple t = (TypeExprSimple)e;
                return t.getTypeName();
            }
            if (e instanceof TypeExprThis) {
                return "thistype";
            }
            if (e instanceof TypeExprArray) {
                TypeExprArray t = (TypeExprArray)e;
                return this.getNameFor(t.getBase()) + "Array";
            }
            if (e instanceof ModuleInstanciation) {
                ModuleInstanciation mi = (ModuleInstanciation)e;
                return this.getNameFor(mi.getParent().attrNearestNamedScope()) + "_" + mi.getName();
            }
        }
        if (e instanceof AstElementWithNameId) {
            AstElementWithNameId wn = (AstElementWithNameId)e;
            return wn.getNameId().getName();
        }
        if (e instanceof ConstructorDef) {
            return "new_" + e.attrNearestClassDef().getName();
        }
        if (e instanceof OnDestroyDef) {
            return "ondestroy_" + e.attrNearestClassDef().getName();
        }
        if (e instanceof ExprClosure) {
            return e.attrNearestNamedScope().getName() + "_closure";
        }
        throw new RuntimeException("unhandled case: " + e.getClass().getName());
    }

    public ImVar getThisVar(TranslatedToImFunction f) {
        OnDestroyDef od;
        if (f instanceof OnDestroyDef && (od = (OnDestroyDef)f).getParent() instanceof ModuleInstanciation) {
            ModuleInstanciation mi = (ModuleInstanciation)od.getParent();
            ClassDef c = mi.attrNearestClassDef();
            f = c.getOnDestroy();
        }
        if (this.thisVarMap.containsKey(f)) {
            return this.thisVarMap.get(f);
        }
        ImVar v = JassIm.ImVar(f, this.selfType(f), "this", false);
        this.thisVarMap.put(f, v);
        return v;
    }

    public ImVar getThisVar(ImFunction f, ExprThis e) {
        return this.getThisVarForNode(f, e);
    }

    public ImVar getThisVar(ImFunction f, ExprSuper e) {
        return this.getThisVarForNode(f, e);
    }

    private ImVar getThisVarForNode(ImFunction f, de.peeeq.wurstscript.ast.Element node1) {
        for (de.peeeq.wurstscript.ast.Element node = node1; node != null; node = node.getParent()) {
            if (!(node instanceof TranslatedToImFunction) || node instanceof ExprClosure) continue;
            return this.getThisVar((TranslatedToImFunction)node);
        }
        if (f.getParameters().isEmpty()) {
            throw new CompileError(node1.attrSource(), "Could not get 'this'.");
        }
        return (ImVar)f.getParameters().get(0);
    }

    public int getTupleIndex(TupleDef tupleDef, VarDef parameter) {
        int i = 0;
        for (WParameter p : tupleDef.getParameters()) {
            if (p == parameter) {
                return i;
            }
            ++i;
        }
        throw new Error("");
    }

    public ImVar getVarFor(VarDef varDef) {
        ImVar v = this.varMap.get(varDef);
        if (v == null) {
            ImType type = varDef.attrTyp().imTranslateType(this);
            Object name = varDef.getName();
            if (this.isNamedScopeVar(varDef)) {
                name = this.getNameFor(varDef.attrNearestNamedScope()) + "_" + (String)name;
            }
            boolean isBj = this.isBJ(varDef.getSource());
            v = JassIm.ImVar(varDef, type, (String)name, isBj);
            this.varMap.put(varDef, v);
        }
        return v;
    }

    private boolean isNamedScopeVar(VarDef varDef) {
        if (varDef.getParent() == null) {
            return false;
        }
        return varDef.getParent().getParent() instanceof NamedScope;
    }

    public WurstModel getWurstProg() {
        return this.wurstProg;
    }

    public ImProg imProg() {
        return this.imProg;
    }

    public boolean isTranslated(WPackage pack) {
        return this.translatedPackages.contains(pack);
    }

    public void setTranslated(WPackage pack) {
        this.translatedPackages.add(pack);
    }

    public boolean isTranslated(ClassDef c) {
        return this.translatedClasses.contains(c);
    }

    public void setTranslated(ClassDef c) {
        this.translatedClasses.add(c);
    }

    public List<ImStmt> translateStatements(ImFunction f, List<WStatement> statements) {
        ArrayList result = Lists.newArrayList();
        for (WStatement s : statements) {
            this.lasttranslatedThing = s;
            ImStmt translated = s.imTranslateStmt(this, f);
            result.add(translated);
        }
        return result;
    }

    public void setMainFunc(ImFunction f) {
        if (this.mainFunc != null) {
            throw new Error("mainFunction already set");
        }
        this.mainFunc = f;
    }

    public void setConfigFunc(ImFunction f) {
        if (this.configFunc != null) {
            throw new Error("configFunction already set");
        }
        this.configFunc = f;
    }

    public Multimap<ImFunction, ImFunction> getCalledFunctions() {
        if (this.callRelations == null) {
            this.calculateCallRelationsAndUsedVariables();
        }
        return this.callRelations;
    }

    public void calculateCallRelationsAndUsedVariables() {
        this.callRelations = LinkedHashMultimap.create();
        this.usedVariables = Sets.newLinkedHashSet();
        this.readVariables = Sets.newLinkedHashSet();
        this.usedFunctions = Sets.newLinkedHashSet();
        this.calculateCallRelations(this.getMainFunc());
        this.calculateCallRelations(this.getConfFunc());
        this.imProg.getGlobals().forEach(global -> {
            if (TRVEHelper.protectedVariables.contains(global.getName())) {
                this.getReadVariables().add((ImVar)global);
            }
        });
    }

    private void calculateCallRelations(ImFunction rootFunction) {
        if (this.getUsedFunctions().contains(rootFunction)) {
            return;
        }
        Stack<ImFunction> functionStack = new Stack<ImFunction>();
        functionStack.push(rootFunction);
        while (!functionStack.isEmpty()) {
            ImFunction f = (ImFunction)functionStack.pop();
            if (this.getUsedFunctions().contains(f)) continue;
            this.getUsedFunctions().add(f);
            this.getUsedVariables().addAll(f.calcUsedVariables());
            this.getReadVariables().addAll(f.calcReadVariables());
            Set<ImFunction> calledFuncs = f.calcUsedFunctions();
            for (ImFunction called : calledFuncs) {
                if (f != called) {
                    this.getCallRelations().put((Object)f, (Object)called);
                }
                functionStack.push(called);
            }
        }
    }

    private Multimap<ImFunction, ImFunction> getCallRelations() {
        return this.callRelations;
    }

    public ImFunction getMainFunc() {
        return this.mainFunc;
    }

    public ImFunction getConfFunc() {
        return this.configFunc;
    }

    public Map<ClassDef, FuncDef> getClassesWithImplementation(Collection<ClassDef> instances, FuncDef func) {
        if (func.attrIsPrivate()) {
            return Collections.emptyMap();
        }
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (ClassDef c : instances) {
            FuncLink funcNameLink = null;
            WurstTypeClass cType = c.attrTypC();
            for (NameLink nameLink : func.lookupMemberFuncs(cType, func.getName())) {
                if (((FuncLink)nameLink).getDef() != func) continue;
                funcNameLink = nameLink;
            }
            if (funcNameLink == null) {
                throw new Error("Could not find " + Utils.printElementWithSource(Optional.of(func)) + " in " + Utils.printElementWithSource(Optional.of(c)));
            }
            for (NameLink nameLink : c.attrNameLinks().get((Object)func.getName())) {
                NameDef nameDef = nameLink.getDef();
                if (nameLink.getDefinedIn() != c || !(nameLink instanceof FuncLink) || !(nameLink.getDef() instanceof FuncDef)) continue;
                FuncLink funcLink = (FuncLink)nameLink;
                FuncDef f = (FuncDef)funcLink.getDef();
                if (!WurstValidator.canOverride(funcLink, funcNameLink, false)) continue;
                result.put(c, f);
            }
        }
        return result;
    }

    public List<Pair<ImVar, VarInitialization>> getDynamicInits(ClassDef c) {
        return this.classDynamicInitMap.computeIfAbsent(c, k -> Lists.newArrayList());
    }

    public ImFunction getConstructFunc(ConstructorDef constr) {
        ImFunction f = this.constructorFuncs.get(constr);
        if (f == null) {
            String name = this.constructorName(constr);
            ImVars params = JassIm.ImVars(this.getThisVar(constr));
            for (WParameter p : constr.getParameters()) {
                params.add(this.getVarFor(p));
            }
            f = JassIm.ImFunction(constr, name, JassIm.ImTypeVars(new ImTypeVar[0]), params, JassIm.ImVoid(), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), this.flags(new FunctionFlag[0]));
            this.addFunction(f, constr);
            this.constructorFuncs.put(constr, f);
        }
        return f;
    }

    private String constructorName(ConstructorDef constr) {
        ArrayDeque<CallSite> names = new ArrayDeque<CallSite>();
        for (de.peeeq.wurstscript.ast.Element e = constr; e != null; e = e.getParent()) {
            if (!(e instanceof ClassOrModuleInstanciation)) continue;
            ClassOrModuleInstanciation mi = (ClassOrModuleInstanciation)e;
            int index = mi.getConstructors().indexOf(constr);
            names.addFirst((CallSite)((Object)(mi.getName() + (Serializable)(index > 0 ? Integer.valueOf(1 + index) : ""))));
            if (e instanceof ClassDef) break;
        }
        return "construct_" + String.join((CharSequence)"_", names);
    }

    public ImFunction getConstructNewFunc(ConstructorDef constr) {
        ImFunction f = this.constrNewFuncs.get(constr);
        if (f == null) {
            String name = "new_" + constr.attrNearestClassDef().getName();
            f = JassIm.ImFunction(constr, name, JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(new ImVar[0]), this.selfType(constr.attrNearestClassOrInterface()), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), this.flags(new FunctionFlag[0]));
            this.addFunction(f, constr);
            this.constrNewFuncs.put(constr, f);
        }
        return f;
    }

    public ImProg getImProg() {
        return this.imProg;
    }

    public Collection<ClassDef> getInterfaceInstances(InterfaceDef interfaceDef) {
        if (this.interfaceInstances == null) {
            this.calculateInterfaceInstances();
        }
        return this.interfaceInstances.get((Object)interfaceDef);
    }

    private void calculateInterfaceInstances() {
        this.interfaceInstances = HashMultimap.create();
        for (CompilationUnit cu : this.wurstProg) {
            for (ClassDef c : cu.attrGetByType().classes) {
                for (WurstTypeInterface i : c.attrTypC().transitiveSuperInterfaces()) {
                    this.interfaceInstances.put((Object)i.getDef(), (Object)c);
                }
            }
        }
    }

    public List<ClassDef> getSubClasses(ClassDef classDef) {
        this.calculateSubclasses();
        return this.subclasses.getAsList(classDef);
    }

    private void calculateSubclasses() {
        if (this.subclasses != null) {
            return;
        }
        this.calculateDirectSubclasses();
        this.subclasses = new TransitiveClosure<ClassDef>(this.directSubclasses);
    }

    private void calculateDirectSubclasses() {
        if (this.directSubclasses != null) {
            return;
        }
        this.directSubclasses = HashMultimap.create();
        for (ClassDef c : this.classes()) {
            WurstTypeClass extendedClass = c.attrTypC().extendedClass();
            if (extendedClass == null) continue;
            this.directSubclasses.put((Object)extendedClass.getDef(), (Object)c);
        }
    }

    private List<ClassDef> classes() {
        ArrayList<ClassDef> result = new ArrayList<ClassDef>();
        for (CompilationUnit cu : this.wurstProg) {
            for (WPackage p : cu.getPackages()) {
                for (WEntity e : p.getElements()) {
                    if (!(e instanceof ClassDef)) continue;
                    ClassDef c = (ClassDef)e;
                    this.classesAdd(result, c);
                }
            }
        }
        return result;
    }

    private void classesAdd(List<ClassDef> result, ClassOrModuleInstanciation c) {
        if (c instanceof ClassDef) {
            result.add((ClassDef)c);
        }
        for (ClassDef ic : c.getInnerClasses()) {
            this.classesAdd(result, ic);
        }
        for (ModuleInstanciation mi : c.getModuleInstanciations()) {
            this.classesAdd(result, mi);
        }
    }

    public int getEnumMemberId(EnumMember enumMember) {
        return ((EnumMembers)enumMember.getParent()).indexOf(enumMember);
    }

    private ImFunction getDebugPrintFunction() {
        return this.debugPrintFunction;
    }

    public boolean isEclipseMode() {
        return this.isEclipseMode;
    }

    public void setEclipseMode(boolean enabled) {
        this.isEclipseMode = enabled;
    }

    public TypeParamDef getTypeParamDef(ImTypeVar tv) {
        return this.typeVariableReverse.get(tv);
    }

    public ImTypeVar getTypeVar(TypeParamDef tv) {
        return this.typeVariable.getFor(tv);
    }

    public boolean isLuaTarget() {
        return this.runArgs.isLua();
    }

    public VarsForTupleResult getVarsForTuple(ImVar v) {
        VarsForTupleResult result = this.varsForTupleVar.get(v);
        if (result == null) {
            result = TypesHelper.typeContainsTuples(v.getType()) ? this.createVarsForType(v.getName(), v.getType(), Function.identity(), v.getTrace()) : new SingleVarResult(v);
            this.varsForTupleVar.put(v, result);
        }
        return result;
    }

    private VarsForTupleResult createVarsForType(final String name, final ImType type, final Function<ImType, ImType> typeConstructor, final de.peeeq.wurstscript.ast.Element tr) {
        return type.match(new ImType.Matcher<VarsForTupleResult>(){

            @Override
            public VarsForTupleResult case_ImArrayType(ImArrayType at) {
                if (at.getEntryType() instanceof ImTupleType) {
                    ImTupleType tt = (ImTupleType)at.getEntryType();
                    ImmutableList.Builder ts = ImmutableList.builder();
                    int i = 0;
                    for (ImType t : tt.getTypes()) {
                        ts.add((Object)ImTranslator.this.createVarsForType(name + "_" + tt.getNames().get(i), t, JassIm::ImArrayType, tr));
                        ++i;
                    }
                    return new TupleResult((List<VarsForTupleResult>)ts.build());
                }
                return new SingleVarResult(JassIm.ImVar(tr, type, name, false));
            }

            @Override
            public VarsForTupleResult case_ImTypeVarRef(ImTypeVarRef imTypeVarRef) {
                throw new RuntimeException("Should be called after eliminating generics.");
            }

            @Override
            public VarsForTupleResult case_ImArrayTypeMulti(ImArrayTypeMulti at) {
                if (at.getEntryType() instanceof ImTupleType) {
                    ImTupleType tt = (ImTupleType)at.getEntryType();
                    ImmutableList.Builder ts = ImmutableList.builder();
                    int i = 0;
                    for (ImType t : tt.getTypes()) {
                        ts.add((Object)ImTranslator.this.createVarsForType(name + "_" + tt.getNames().get(i), t, et -> JassIm.ImArrayTypeMulti(et, new ArrayList<Integer>(at.getArraySize())), tr));
                        ++i;
                    }
                    return new TupleResult((List<VarsForTupleResult>)ts.build());
                }
                return new SingleVarResult(JassIm.ImVar(tr, type, name, false));
            }

            @Override
            public VarsForTupleResult case_ImVoid(ImVoid imVoid) {
                return new TupleResult(Collections.emptyList());
            }

            @Override
            public VarsForTupleResult case_ImClassType(ImClassType st) {
                ImType type2 = (ImType)typeConstructor.apply(st);
                return new SingleVarResult(JassIm.ImVar(tr, type2, name, false));
            }

            @Override
            public VarsForTupleResult case_ImSimpleType(ImSimpleType st) {
                ImType type2 = (ImType)typeConstructor.apply(st);
                return new SingleVarResult(JassIm.ImVar(tr, type2, name, false));
            }

            @Override
            public VarsForTupleResult case_ImAnyType(ImAnyType at) {
                ImType type2 = (ImType)typeConstructor.apply(at);
                return new SingleVarResult(JassIm.ImVar(tr, type2, name, false));
            }

            @Override
            public VarsForTupleResult case_ImTupleType(ImTupleType tt) {
                int i = 0;
                ImmutableList.Builder ts = ImmutableList.builder();
                for (ImType t : tt.getTypes()) {
                    ts.add((Object)ImTranslator.this.createVarsForType(name + "_" + tt.getNames().get(i), t, typeConstructor, tr));
                    ++i;
                }
                return new TupleResult((List<VarsForTupleResult>)ts.build());
            }
        });
    }

    private void addVarsForType(List<ImVar> result, String name, ImType type, de.peeeq.wurstscript.ast.Element tr) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull(result);
        if (type instanceof ImTupleType) {
            ImTupleType tt = (ImTupleType)type;
            int i = 0;
            for (ImType t : tt.getTypes()) {
                this.addVarsForType(result, name + "_" + tt.getNames().get(i), t, tr);
                ++i;
            }
        } else if (!(type instanceof ImVoid)) {
            result.add(JassIm.ImVar(tr, type, name, false));
        }
    }

    public VarsForTupleResult getTupleTempReturnVarsFor(ImFunction f) {
        VarsForTupleResult result = this.tempReturnVars.get(f);
        if (result == null) {
            result = this.createVarsForType(f.getName() + "_return", this.getOriginalReturnValue(f), Function.identity(), f.getTrace());
            for (ImVar value : result.allValues()) {
                this.imProg.getGlobals().add(value);
            }
            this.tempReturnVars.put(f, result);
        }
        return result;
    }

    public void setOriginalReturnValue(ImFunction f, ImType t) {
        this.originalReturnValues.put(f, t);
    }

    public ImType getOriginalReturnValue(ImFunction f) {
        return this.originalReturnValues.computeIfAbsent(f, ImFunction::getReturnType);
    }

    public void assertProperties(AssertProperty ... properties1) {
    }

    public void assertProperties(Set<AssertProperty> properties, Element e) {
        if (e instanceof ElementWithVar) {
            this.checkVar(((ElementWithVar)e).getVar(), properties);
        }
        properties.parallelStream().forEach(p -> p.check(e));
        if (properties.contains(AssertProperty.NOTUPLES)) {
            // empty if block
        }
        if (properties.contains(AssertProperty.FLAT)) {
            // empty if block
        }
        for (int i = 0; i < e.size(); ++i) {
            Element child = e.get(i);
            if (child.getParent() == null) {
                throw new Error("Child " + i + " (" + child + ") of " + e + " not attached to tree");
            }
            if (child.getParent() != e) {
                throw new Error("Child " + i + " (" + child + ") of " + e + " attached to wrong tree");
            }
            this.assertProperties(properties, child);
        }
    }

    private void checkVar(ImVar left, Set<AssertProperty> properties) {
        if (left.getParent() == null) {
            throw new Error("var not attached: " + left);
        }
        if (properties.contains(AssertProperty.NOTUPLES) && TypesHelper.typeContainsTuples(left.getType())) {
            throw new Error("program contains tuple var " + left);
        }
    }

    public Set<ImVar> getUsedVariables() {
        if (this.usedVariables == null) {
            this.calculateCallRelationsAndUsedVariables();
        }
        return this.usedVariables;
    }

    public Set<ImVar> getReadVariables() {
        if (this.readVariables == null) {
            this.calculateCallRelationsAndUsedVariables();
        }
        return this.readVariables;
    }

    public Set<ImFunction> getUsedFunctions() {
        if (this.usedFunctions == null) {
            this.calculateCallRelationsAndUsedVariables();
        }
        return this.usedFunctions;
    }

    public boolean isUnitTestMode() {
        return this.isUnitTestMode;
    }

    public ImClass getClassForClosure(ExprClosure s) {
        Preconditions.checkNotNull((Object)s);
        return this.classForClosure.computeIfAbsent(s, s1 -> JassIm.ImClass(s1, "Closure", JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(new ImVar[0]), JassIm.ImMethods(new ImMethod[0]), JassIm.ImFunctions(new ImFunction[0]), Lists.newArrayList()));
    }

    public ImClass getClassFor(ClassOrInterface s) {
        Preconditions.checkNotNull((Object)s);
        return this.classForStructureDef.computeIfAbsent(s, s1 -> {
            ImTypeVars typeVariables = JassIm.ImTypeVars(new ImTypeVar[0]);
            if (s instanceof AstElementWithTypeParameters) {
                for (TypeParamDef tp : ((AstElementWithTypeParameters)((Object)s)).getTypeParameters()) {
                    if (!(tp.getTypeParamConstraints() instanceof TypeExprList)) continue;
                    ImTypeVar tv = this.getTypeVar(tp);
                    typeVariables.add(tv);
                }
            }
            return JassIm.ImClass(s1, s1.getName(), typeVariables, JassIm.ImVars(new ImVar[0]), JassIm.ImMethods(new ImMethod[0]), JassIm.ImFunctions(new ImFunction[0]), Lists.newArrayList());
        });
    }

    public ImMethod getMethodFor(FuncDef f) {
        ImMethod m = this.methodForFuncDef.get(f);
        if (m == null) {
            ImFunction imFunc = this.getFuncFor(f);
            m = JassIm.ImMethod(f, this.selfType(f), Utils.elementNameWithPath(f), imFunc, Lists.newArrayList(), false);
            this.methodForFuncDef.put(f, m);
        }
        return m;
    }

    public ClassManagementVars getClassManagementVarsFor(ImClass c) {
        return this.getClassManagementVars().get(c);
    }

    public Map<ImClass, ClassManagementVars> getClassManagementVars() {
        if (this.classManagementVars != null) {
            return this.classManagementVars;
        }
        Partitions<ImClass> p = new Partitions<ImClass>();
        for (ImClass c : this.imProg.getClasses()) {
            p.add(c);
            for (ImClassType sc : c.getSuperClasses()) {
                p.union(c, sc.getClassDef());
            }
        }
        this.classManagementVars = Maps.newLinkedHashMap();
        for (ImClass c : this.imProg.getClasses()) {
            ImClass rep = p.getRep(c);
            ClassManagementVars v = this.classManagementVars.computeIfAbsent(rep, r -> new ClassManagementVars((ImClass)r, this));
            this.classManagementVars.put(c, v);
        }
        return this.classManagementVars;
    }

    public ImFunction getGlobalInitFunc() {
        return this.globalInitFunc;
    }

    public ImFunctionCall imError(de.peeeq.wurstscript.ast.Element trace, ImExpr message) {
        ImFunction ef = this.errorFunc;
        if (ef == null) {
            Optional<ImFunction> f = this.findErrorFunc().map(this::getFuncFor);
            ef = this.errorFunc = f.orElseGet(this::makeDefaultErrorFunc);
        }
        ImExprs arguments = JassIm.ImExprs(message);
        return JassIm.ImFunctionCall(trace, ef, JassIm.ImTypeArguments(new ImTypeArgument[0]), arguments, false, CallType.NORMAL);
    }

    private ImFunction makeDefaultErrorFunc() {
        ImVar msgVar = JassIm.ImVar(emptyTrace, TypesHelper.imString(), "msg", false);
        ImVars parameters = JassIm.ImVars(msgVar);
        ImVoid returnType = JassIm.ImVoid();
        ImVars locals = JassIm.ImVars(new ImVar[0]);
        ImStmts body = JassIm.ImStmts(new ImStmt[0]);
        ImOperatorCall msg = JassIm.ImOperatorCall(WurstOperator.PLUS, JassIm.ImExprs(JassIm.ImVarAccess(msgVar), JassIm.ImOperatorCall(WurstOperator.PLUS, JassIm.ImExprs(JassIm.ImStringVal("\n"), JassIm.ImGetStackTrace()))));
        body.add(JassIm.ImFunctionCall(emptyTrace, this.getDebugPrintFunction(), JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(msg), false, CallType.NORMAL));
        ArrayList flags = Lists.newArrayList();
        ImFunction errorFunc = JassIm.ImFunction(emptyTrace, "error", JassIm.ImTypeVars(new ImTypeVar[0]), parameters, returnType, locals, body, flags);
        this.imProg.getFunctions().add(errorFunc);
        return errorFunc;
    }

    private Optional<FuncDef> findErrorFunc() throws CompileError {
        PackageLink p = this.wurstProg.lookupPackage("ErrorHandling");
        if (p == null) {
            return Optional.empty();
        }
        ImmutableCollection<FuncLink> funcs = p.getDef().getElements().lookupFuncs("error");
        if (funcs.isEmpty()) {
            return Optional.empty();
        }
        if (funcs.size() > 1) {
            return Optional.empty();
        }
        FuncDef f = (FuncDef)((FuncLink)funcs.stream().findAny().get()).getDef();
        return Optional.of(f);
    }

    int getCompiletimeExpressionsOrder(FunctionCall fc) {
        return this.compiletimeExpressionsOrder.getOrDefault(fc, 0);
    }

    public RunArgs getRunArgs() {
        return this.runArgs;
    }

    static class TupleResult
    implements VarsForTupleResult {
        private final List<VarsForTupleResult> items;

        public TupleResult(List<VarsForTupleResult> items) {
            this.items = items;
        }

        public List<VarsForTupleResult> getItems() {
            return this.items;
        }

        @Override
        public Stream<ImVar> allValuesStream() {
            return this.items.stream().flatMap(VarsForTupleResult::allValuesStream);
        }

        @Override
        public <T> T map(Function<Stream<T>, T> nodeBuilder, Function<ImVar, T> leafBuilder) {
            return nodeBuilder.apply(this.items.stream().map(e -> e.map(nodeBuilder, leafBuilder)));
        }

        public String toString() {
            return "<" + Utils.printSep(", ", this.items) + ">";
        }
    }

    static class SingleVarResult
    implements VarsForTupleResult {
        private final ImVar var;

        public SingleVarResult(ImVar var) {
            this.var = var;
        }

        public ImVar getVar() {
            return this.var;
        }

        @Override
        public Stream<ImVar> allValuesStream() {
            return Stream.of(this.var);
        }

        @Override
        public <T> T map(Function<Stream<T>, T> nodeBuilder, Function<ImVar, T> leafBuilder) {
            return leafBuilder.apply(this.var);
        }

        public String toString() {
            return this.var.toString();
        }
    }

    static interface VarsForTupleResult {
        default public Iterable<ImVar> allValues() {
            return this.allValuesStream()::iterator;
        }

        public Stream<ImVar> allValuesStream();

        public <T> T map(Function<Stream<T>, T> var1, Function<ImVar, T> var2);
    }
}

