/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtojass;

import de.peeeq.wurstscript.jassAst.Element;
import de.peeeq.wurstscript.jassAst.JassAst;
import de.peeeq.wurstscript.jassAst.JassExpr;
import de.peeeq.wurstscript.jassAst.JassExprFunctionCall;
import de.peeeq.wurstscript.jassAst.JassFunction;
import de.peeeq.wurstscript.jassAst.JassStatement;
import de.peeeq.wurstscript.jassAst.JassStatements;
import de.peeeq.wurstscript.jassAst.JassVar;
import de.peeeq.wurstscript.jassIm.ImExitwhen;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImIf;
import de.peeeq.wurstscript.jassIm.ImLExpr;
import de.peeeq.wurstscript.jassIm.ImLoop;
import de.peeeq.wurstscript.jassIm.ImNoExpr;
import de.peeeq.wurstscript.jassIm.ImReturn;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.jassIm.ImVarargLoop;
import de.peeeq.wurstscript.translation.imtojass.ImToJassTranslator;
import java.util.List;

public class StatementTranslation {
    public static void translate(ImExitwhen imExitwhen, List<JassStatement> stmts, JassFunction f, ImToJassTranslator translator) {
        stmts.add(JassAst.JassStmtExitwhen(imExitwhen.getCondition().translate(translator)));
    }

    public static void translate(ImIf imIf, List<JassStatement> stmts, JassFunction f, ImToJassTranslator translator) {
        JassExpr cond = imIf.getCondition().translate(translator);
        JassStatements thenBlock = JassAst.JassStatements(new JassStatement[0]);
        imIf.getThenBlock().translate(thenBlock, f, translator);
        JassStatements elseBlock = JassAst.JassStatements(new JassStatement[0]);
        imIf.getElseBlock().translate(elseBlock, f, translator);
        stmts.add(JassAst.JassStmtIf(cond, thenBlock, elseBlock));
    }

    public static void translate(ImLoop imLoop, List<JassStatement> stmts, JassFunction f, ImToJassTranslator translator) {
        JassStatements body = JassAst.JassStatements(new JassStatement[0]);
        imLoop.getBody().translate(body, f, translator);
        stmts.add(JassAst.JassStmtLoop(body));
    }

    public static void translate(ImReturn imReturn, List<JassStatement> stmts, JassFunction f, ImToJassTranslator translator) {
        if (imReturn.getReturnValue() instanceof ImNoExpr) {
            stmts.add(JassAst.JassStmtReturnVoid());
        } else {
            ImExpr e = (ImExpr)imReturn.getReturnValue();
            JassExpr returnValue = e.translate(translator);
            stmts.add(JassAst.JassStmtReturn(returnValue));
        }
    }

    public static void translate(ImSet imSet, List<JassStatement> stmts, JassFunction f, ImToJassTranslator translator) {
        ImLExpr updatedExpr = imSet.getLeft();
        if (updatedExpr instanceof ImVarAccess) {
            ImVarAccess va = (ImVarAccess)updatedExpr;
            JassVar var = translator.getJassVarFor(va.getVar());
            JassExpr exprs = imSet.getRight().translate(translator);
            stmts.add(JassAst.JassStmtSet(var.getName(), exprs));
        } else if (updatedExpr instanceof ImVarArrayAccess) {
            ImVarArrayAccess vaa = (ImVarArrayAccess)updatedExpr;
            JassVar var = translator.getJassVarFor(vaa.getVar());
            JassExpr indexes = ((ImExpr)vaa.getIndexes().get(0)).translate(translator);
            JassExpr exprs = imSet.getRight().translate(translator);
            stmts.add(JassAst.JassStmtSetArray(var.getName(), indexes, exprs));
        }
    }

    public static void translate(ImExpr imExpr, List<JassStatement> stmts, JassFunction f, ImToJassTranslator translator) {
        JassExpr expr = imExpr.translate(translator);
        StatementTranslation.addAllCalls(stmts, expr);
    }

    private static void addAllCalls(List<JassStatement> stmts, Element expr) {
        if (expr instanceof JassExprFunctionCall) {
            JassExprFunctionCall fc = (JassExprFunctionCall)expr;
            stmts.add(JassAst.JassStmtCall(fc.getFuncName(), fc.getArguments().copy()));
        } else {
            for (int i = 0; i < expr.size(); ++i) {
                StatementTranslation.addAllCalls(stmts, expr.get(i));
            }
        }
    }

    public static void translate(ImStmts imStmts, List<JassStatement> stmts, JassFunction f, ImToJassTranslator translator) {
        for (ImStmt s : imStmts) {
            s.translate(stmts, f, translator);
        }
    }

    public static void translate(ImVarargLoop imVarargLoop, List<JassStatement> stmts, JassFunction f, ImToJassTranslator translator) {
        throw new Error("not implemented");
    }
}

