/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.intermediatelang.interpreter;

import de.peeeq.wurstio.jassinterpreter.mocks.TimerMock;
import java.util.Comparator;
import java.util.PriorityQueue;

public class TimerMockHandler {
    private float virtualTime = 0.0f;
    private final PriorityQueue<RunTask> nextRunnable = new PriorityQueue<RunTask>(Comparator.comparing(r -> Float.valueOf(r.time)));

    public void cancelTask(RunTask runTask) {
        this.nextRunnable.remove(runTask);
    }

    public RunTask registerTimedAction(float timeOut, Runnable toRun) {
        RunTask t = new RunTask(this.virtualTime + timeOut, toRun);
        this.nextRunnable.add(t);
        return t;
    }

    public PausedTask pauseTask(RunTask t) {
        TimerMock.TimerMockRunnable runnable = (TimerMock.TimerMockRunnable)t.runnable;
        runnable.cancel();
        boolean removed = this.nextRunnable.remove(t);
        if (!removed) {
            return null;
        }
        return new PausedTask(t.time - this.virtualTime, t.runnable);
    }

    public RunTask resumeTask(PausedTask t) {
        TimerMock.TimerMockRunnable runnable = (TimerMock.TimerMockRunnable)t.runnable;
        runnable.resume();
        return this.registerTimedAction(this.virtualTime + t.remainingTime, t.runnable);
    }

    public void completeTimers() {
        while (!this.nextRunnable.isEmpty()) {
            RunTask r = (RunTask)this.nextRunnable.remove();
            this.virtualTime = Math.max(this.virtualTime, r.time);
            r.runnable.run();
        }
    }

    public static class RunTask {
        private final float time;
        private final Runnable runnable;

        private RunTask(float time, Runnable runnable) {
            this.time = time;
            this.runnable = runnable;
        }
    }

    public static class PausedTask {
        private final float remainingTime;
        private final Runnable runnable;

        private PausedTask(float remainingTime, Runnable runnable) {
            this.remainingTime = remainingTime;
            this.runnable = runnable;
        }
    }
}

