/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImStringVal;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.CallType;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlagAnnotation;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class EliminateCallFunctionsWithAnnotation {
    private static final String CALL_FUNCTIONS_WITH_ANNOTATION = "callFunctionsWithAnnotation";

    public static void process(ImProg prog) {
        List<ImFunctionCall> specialCalls = EliminateCallFunctionsWithAnnotation.collectSpecialCalls(prog);
        Set<String> calledAnnotations = EliminateCallFunctionsWithAnnotation.getAnnotations(specialCalls);
        Multimap<String, ImFunction> annotatedFunctions = EliminateCallFunctionsWithAnnotation.collectAnnotatedFunctions(prog, calledAnnotations);
        EliminateCallFunctionsWithAnnotation.rewriteSpecialCalls(specialCalls, annotatedFunctions);
    }

    private static void rewriteSpecialCalls(List<ImFunctionCall> specialCalls, Multimap<String, ImFunction> annotatedFunctions) {
        for (ImFunctionCall fc : specialCalls) {
            EliminateCallFunctionsWithAnnotation.rewriteSpecialCall(fc, annotatedFunctions);
        }
    }

    private static void rewriteSpecialCall(ImFunctionCall fc, Multimap<String, ImFunction> annotatedFunctions) {
        ImStmts statements = JassIm.ImStmts(new ImStmt[0]);
        for (ImFunction f : annotatedFunctions.get((Object)EliminateCallFunctionsWithAnnotation.calledAnnotation(fc))) {
            statements.add(JassIm.ImFunctionCall(fc.getTrace(), f, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(new ImExpr[0]), false, CallType.NORMAL));
        }
        fc.replaceBy(ImHelper.statementExprVoid(statements));
    }

    private static Multimap<String, ImFunction> collectAnnotatedFunctions(ImProg prog, Set<String> calledAnnotations) {
        LinkedHashMultimap res = LinkedHashMultimap.create();
        for (ImFunction f : prog.getFunctions()) {
            for (String a : calledAnnotations) {
                if (!f.hasFlag(new FunctionFlagAnnotation(a))) continue;
                res.put((Object)a, (Object)f);
            }
        }
        return res;
    }

    private static Set<String> getAnnotations(List<ImFunctionCall> specialCalls) {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        for (ImFunctionCall fc : specialCalls) {
            res.add(EliminateCallFunctionsWithAnnotation.calledAnnotation(fc));
        }
        return res;
    }

    private static String calledAnnotation(ImFunctionCall fc) throws CompileError {
        if (fc.getArguments().size() != 1) {
            throw new CompileError(fc.attrTrace().attrSource(), "wrong number of arguments");
        }
        ImExpr arg = (ImExpr)fc.getArguments().get(0);
        if (arg instanceof ImStringVal) {
            ImStringVal sArg = (ImStringVal)arg;
            return sArg.getValS();
        }
        throw new CompileError(fc.attrTrace().attrSource(), "argument must be a constant string");
    }

    private static List<ImFunctionCall> collectSpecialCalls(ImProg prog) {
        final ArrayList<ImFunctionCall> specialCalls = new ArrayList<ImFunctionCall>();
        prog.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImFunctionCall fc) {
                super.visit(fc);
                if (fc.getFunc().getName().equals(EliminateCallFunctionsWithAnnotation.CALL_FUNCTIONS_WITH_ANNOTATION)) {
                    specialCalls.add(fc);
                }
            }
        });
        return specialCalls;
    }
}

