/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.luaAst;

import de.peeeq.wurstscript.luaAst.Element;
import de.peeeq.wurstscript.luaAst.LuaExpr;
import de.peeeq.wurstscript.luaAst.LuaExprFuncRef;
import de.peeeq.wurstscript.luaAst.LuaExprFunctionCall;
import de.peeeq.wurstscript.luaAst.LuaExprMethodCall;
import de.peeeq.wurstscript.luaAst.LuaExprVarAccess;
import de.peeeq.wurstscript.luaAst.LuaFunction;
import de.peeeq.wurstscript.luaAst.LuaMethod;
import de.peeeq.wurstscript.luaAst.LuaStatement;
import de.peeeq.wurstscript.luaAst.LuaStatements;
import de.peeeq.wurstscript.luaAst.LuaVariable;
import de.peeeq.wurstscript.luaAst.LuaWhile;
import de.peeeq.wurstscript.translation.lua.printing.LuaPrinter;
import java.util.function.Consumer;

class LuaWhileImpl
implements LuaWhile {
    private Element parent;
    private LuaExpr cond;
    private LuaStatements body;

    LuaWhileImpl(LuaExpr cond, LuaStatements body) {
        if (cond == null) {
            throw new IllegalArgumentException("Element cond must not be null.");
        }
        if (body == null) {
            throw new IllegalArgumentException("Element body must not be null.");
        }
        this.cond = cond;
        this.body = body;
        cond.setParent(this);
        body.setParent(this);
    }

    @Override
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree.Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    @Override
    public void replaceBy(Element other) {
        if (this.parent == null) {
            throw new RuntimeException("Node not attached to tree.");
        }
        for (int i = 0; i < this.parent.size(); ++i) {
            if (this.parent.get(i) != this) continue;
            this.parent.set(i, other);
            return;
        }
    }

    @Override
    public void setCond(LuaExpr cond) {
        if (cond == null) {
            throw new IllegalArgumentException();
        }
        this.cond.setParent(null);
        cond.setParent(this);
        this.cond = cond;
    }

    @Override
    public LuaExpr getCond() {
        return this.cond;
    }

    @Override
    public void setBody(LuaStatements body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        this.body.setParent(null);
        body.setParent(this);
        this.body = body;
    }

    @Override
    public LuaStatements getBody() {
        return this.body;
    }

    @Override
    public Element get(int i) {
        switch (i) {
            case 0: {
                return this.cond;
            }
            case 1: {
                return this.body;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public Element set(int i, Element newElem) {
        switch (i) {
            case 0: {
                LuaExpr oldElem = this.cond;
                this.setCond((LuaExpr)newElem);
                return oldElem;
            }
            case 1: {
                LuaStatements oldElem = this.body;
                this.setBody((LuaStatements)newElem);
                return oldElem;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public void forEachElement(Consumer<? super Element> action) {
        action.accept(this.cond);
        action.accept(this.body);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public LuaWhile copy() {
        LuaWhileImpl result = new LuaWhileImpl(this.cond.copy(), this.body.copy());
        return result;
    }

    @Override
    public LuaWhile copyWithRefs() {
        final LuaWhile res = this.copy();
        final LuaWhileImpl self = this;
        res.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(LuaExprMethodCall e) {
                Element elem;
                super.visit(e);
                for (elem = e.getMethod(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setMethod((LuaMethod)res.followPath(self.pathTo(e.getMethod())));
                }
            }

            @Override
            public void visit(LuaExprFunctionCall e) {
                Element elem;
                super.visit(e);
                for (elem = e.getFunc(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setFunc((LuaFunction)res.followPath(self.pathTo(e.getFunc())));
                }
            }

            @Override
            public void visit(LuaExprVarAccess e) {
                Element elem;
                super.visit(e);
                for (elem = e.getVar(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setVar((LuaVariable)res.followPath(self.pathTo(e.getVar())));
                }
            }

            @Override
            public void visit(LuaExprFuncRef e) {
                Element elem;
                super.visit(e);
                for (elem = e.getFunc(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setFunc((LuaFunction)res.followPath(self.pathTo(e.getFunc())));
                }
            }
        });
        return res;
    }

    @Override
    public void clearAttributes() {
        this.cond.clearAttributes();
        this.body.clearAttributes();
        this.clearAttributesLocal();
    }

    @Override
    public void clearAttributesLocal() {
    }

    @Override
    public void accept(Element.Visitor v) {
        v.visit(this);
    }

    @Override
    public <T> T match(LuaStatement.Matcher<T> matcher) {
        return matcher.case_LuaWhile(this);
    }

    @Override
    public void match(LuaStatement.MatcherVoid matcher) {
        matcher.case_LuaWhile(this);
    }

    @Override
    public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_LuaWhile(this);
    }

    @Override
    public void match(Element.MatcherVoid matcher) {
        matcher.case_LuaWhile(this);
    }

    public String toString() {
        return "LuaWhile(" + this.cond + ", " + this.body + ")";
    }

    @Override
    public boolean structuralEquals(Element e) {
        if (e instanceof LuaWhile) {
            LuaWhile o = (LuaWhile)e;
            return this.cond.structuralEquals(o.getCond()) && this.body.structuralEquals(o.getBody());
        }
        return false;
    }

    @Override
    public void print(StringBuilder sb, int indent) {
        LuaPrinter.print(this, sb, indent);
    }
}

