/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.Stringable;
import net.moonlightflower.wc3libs.dataTypes.app.War3Char;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;
import net.moonlightflower.wc3libs.misc.Id;

public class Wc3BinOutputStream
extends BinOutputStream {
    private static final byte[] _shortBytes = new byte[2];
    private static final ByteBuffer _shortBuf = ByteBuffer.wrap(_shortBytes);
    private static final byte[] _intBytes = new byte[4];
    private static final ByteBuffer _intBuf = ByteBuffer.wrap(_intBytes);

    public void writeUByte(int val) {
        this.writeByte((byte)val);
    }

    public void writeInt8(short val) {
        this.writeByte((byte)(val & 0xFF));
    }

    public void writeUInt8(int val) {
        this.writeInt8((short)val);
    }

    public void writeInt16(short val) {
        ((Buffer)_shortBuf).rewind();
        _shortBuf.order(ByteOrder.LITTLE_ENDIAN);
        _shortBuf.putShort(val);
        this.writeBytes(_shortBytes);
    }

    public void writeUInt16(int val) {
        this.writeInt16((short)val);
    }

    public void writeInt32(int val) {
        ((Buffer)_intBuf).rewind();
        _intBuf.order(ByteOrder.LITTLE_ENDIAN);
        _intBuf.putInt(val);
        this.writeBytes(_intBytes);
    }

    public void writeInt32(@Nonnull War3Int val) {
        this.writeInt32(val.getVal());
    }

    public void writeUInt32(long val) {
        this.writeInt32((int)val);
    }

    public void writeFloat32(float val) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putFloat(val);
        this.writeBytes(buf.array());
    }

    public void writeFloat32(@Nullable War3Real val) {
        this.writeFloat32(val != null ? val.toFloat() : 0.0f);
    }

    public void writeReal(@Nullable War3Real val) {
        this.writeFloat32(val);
    }

    public void writeChar(char val) {
        this.writeByte((byte)val);
    }

    public void writeChar(@Nullable War3Char val) {
        this.writeChar(val != null ? val.getVal().charValue() : (char)'\u0000');
    }

    @Nullable
    public byte[] stringToByteArray(@Nullable String val) {
        if (val == null) {
            return null;
        }
        return val.getBytes(StandardCharsets.UTF_8);
    }

    public void writeString(@Nullable String val) {
        if (val == null) {
            val = "";
        }
        byte[] valBytes = this.stringToByteArray(val);
        this.writeBytes(valBytes);
        this.writeByte((byte)0);
    }

    public void writeString(@Nullable Stringable val) {
        if (val == null) {
            this.writeString((String)null);
        } else {
            this.writeString(val.toString());
        }
    }

    public void writeId(@Nullable Id val) {
        if (val == null) {
            val = Id.valueOf("\u0000\u0000\u0000\u0000");
        }
        byte[] valBytes = val.toString().getBytes(StandardCharsets.US_ASCII);
        byte[] sub = new byte[4];
        System.arraycopy(valBytes, 0, sub, 0, valBytes.length);
        this.writeBytes(sub);
    }

    public Wc3BinOutputStream(@Nonnull OutputStream outStream) {
        super(outStream);
    }

    public Wc3BinOutputStream(@Nonnull File file) throws IOException {
        super(file);
    }
}

