/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.datastructures;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.peeeq.wurstscript.utils.Utils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.Nullable;

public abstract class GraphInterpreter<T> {
    protected abstract Collection<T> getIncidentNodes(T var1);

    public TopsortResult<T> topSort(List<T> nodes) {
        HashSet seen = Sets.newHashSet();
        ArrayList seenStack = Lists.newArrayList();
        ArrayList result = Lists.newArrayList();
        for (T t : nodes) {
            TopsortResult<T> r;
            if (seen.contains(t) || (r = this.topSort_add(result, seen, seenStack, t)) == null) continue;
            return r;
        }
        return new TopsortResult(false, result);
    }

    private @Nullable TopsortResult<T> topSort_add(List<T> result, Set<T> seen, List<T> seenStack, T n) {
        for (int i = seenStack.size() - 1; i >= 0; --i) {
            if (seenStack.get(i) != n) continue;
            return new TopsortResult<T>(true, Utils.subList(seenStack, i));
        }
        if (!seen.contains(n)) {
            seenStack.add(n);
            for (T m : this.getIncidentNodes(n)) {
                TopsortResult<T> r = this.topSort_add(result, seen, seenStack, m);
                if (r == null) continue;
                return r;
            }
            seenStack.remove(seenStack.size() - 1);
            seen.add(n);
            result.add(n);
        }
        return null;
    }

    public Set<Set<T>> findStronglyConnectedComponents(List<T> nodes) {
        ArrayDeque s = new ArrayDeque();
        ArrayDeque p = new ArrayDeque();
        AtomicInteger c = new AtomicInteger();
        AtomicInteger componentCount = new AtomicInteger();
        LinkedHashMap preorderNumber = new LinkedHashMap();
        LinkedHashMap component = new LinkedHashMap();
        for (T v : nodes) {
            if (preorderNumber.containsKey(v)) continue;
            this.findStronglyConnectedComponentsRec(v, s, p, c, preorderNumber, component, componentCount);
        }
        return ImmutableSet.copyOf(Utils.inverseMapToSet(component).values());
    }

    private void findStronglyConnectedComponentsRec(T v, Deque<T> s, Deque<T> p, AtomicInteger c, Map<T, Integer> preorderNumber, Map<T, Integer> component, AtomicInteger componentCount) {
        preorderNumber.put(v, c.getAndIncrement());
        s.push(v);
        p.push(v);
        for (T w : this.getIncidentNodes(v)) {
            if (!preorderNumber.containsKey(w)) {
                this.findStronglyConnectedComponentsRec(w, s, p, c, preorderNumber, component, componentCount);
                continue;
            }
            if (component.containsKey(w)) continue;
            while (!p.isEmpty() && preorderNumber.getOrDefault(p.peek(), -1) > preorderNumber.get(w)) {
                p.pop();
            }
        }
        if (!p.isEmpty() && p.peek() == v) {
            T popped;
            Integer newComponent = componentCount.incrementAndGet();
            do {
                popped = s.pop();
                component.put(popped, newComponent);
            } while (popped != v);
            popped = p.pop();
            assert (popped == v);
        }
    }

    public String generateDotFile(List<T> nodes) {
        StringBuilder sb = new StringBuilder();
        HashSet visited = new HashSet();
        ArrayDeque<T> todo = new ArrayDeque<T>(nodes);
        sb.append("digraph G{\n");
        while (!todo.isEmpty()) {
            Object node = todo.removeFirst();
            if (!visited.add(node)) continue;
            sb.append("  \"").append(node).append("\";\n");
            for (Object n : this.getIncidentNodes(node)) {
                sb.append("  ");
                sb.append("\"").append(node).append("\" -> ");
                sb.append("\"").append(n.toString()).append("\";\n\n");
                todo.addFirst(n);
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    public static class TopsortResult<T> {
        private final boolean isCycle;
        private final List<T> result;

        public TopsortResult(boolean isCycle, List<T> result) {
            this.isCycle = isCycle;
            this.result = result;
        }

        public boolean isCycle() {
            return this.isCycle;
        }

        public List<T> getResult() {
            return this.result;
        }
    }
}

