/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.dataTypes.app;

import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.dataTypes.DataType;

public class Color
extends DataType {
    private final int _red;
    private final int _green;
    private final int _blue;
    private final int _alpha;

    public int getRed255() {
        return this._red;
    }

    public int getGreen255() {
        return this._green;
    }

    public int getBlue255() {
        return this._blue;
    }

    public int getAlpha255() {
        return this._alpha;
    }

    public boolean equals(Object other) {
        if (other instanceof Color) {
            return this.equals((Color)other);
        }
        return super.equals(other);
    }

    public boolean equals(Color other) {
        return this.getRed255() == other.getRed255() && this.getGreen255() == other.getGreen255() && this.getBlue255() == other.getBlue255() && this.getAlpha255() == other.getAlpha255();
    }

    public String toString() {
        return String.format("red=%d green=%d blue=%d alpha=%d", this._red, this._green, this._blue, this._alpha);
    }

    private Color(int red, int green, int blue) {
        this._red = red;
        this._green = green;
        this._blue = blue;
        this._alpha = 255;
    }

    private Color(int red, int green, int blue, int alpha) {
        this._red = red;
        this._green = green;
        this._blue = blue;
        this._alpha = alpha;
    }

    @Nonnull
    public static Color fromRGB255(int red, int green, int blue) {
        return new Color(red, green, blue);
    }

    @Nonnull
    public static Color fromRGBA255(int red, int green, int blue, int alpha) {
        return new Color(red, green, blue, alpha);
    }

    @Nonnull
    public static Color fromBGR255(int blue, int green, int red) {
        return new Color(red, green, blue);
    }

    @Nonnull
    public static Color fromBGRA255(int blue, int green, int red, int alpha) {
        return new Color(red, green, blue, alpha);
    }

    @Override
    public DataType decode(Object val) {
        return Color.decodeStatic(val);
    }

    public static DataType decodeStatic(Object val) {
        if (val instanceof Color) {
            return Color.fromBGRA255(((Color)val).getBlue255(), ((Color)val).getGreen255(), ((Color)val).getRed255(), ((Color)val).getAlpha255());
        }
        return null;
    }

    @Override
    public Object toSLKVal() {
        return null;
    }

    @Override
    public Object toTXTVal() {
        return null;
    }
}

