/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Extent;
import net.moonlightflower.wc3libs.misc.model.mdx.MDXObject;

public class Sequence
extends MDXObject {
    private String _name = "unset";
    private long _intervalStart = 0L;
    private long _intervalEnd = 0L;
    private float _moveSpeed = 0.0f;
    private long _flags = 0L;
    private Extent _extent;
    private float _rarity = 0.0f;
    private long _syncPt = 0L;

    @Nonnull
    public String getName() {
        return this._name;
    }

    public void setName(@Nonnull String name) {
        this._name = name;
    }

    public long getIntervalStart() {
        return this._intervalStart;
    }

    public void setIntervalStart(long intervalStart) {
        this._intervalStart = intervalStart;
    }

    public long getIntervalEnd() {
        return this._intervalEnd;
    }

    public void setIntervalEnd(long intervalEnd) {
        this._intervalEnd = intervalEnd;
    }

    public float getMoveSpeed() {
        return this._moveSpeed;
    }

    public void setMoveSpeed(float moveSpeed) {
        this._moveSpeed = moveSpeed;
    }

    public long getFlags() {
        return this._flags;
    }

    public void setFlags(long flags) {
        this._flags = flags;
    }

    public boolean isLooping() {
        return (this._flags & 1L) > 0L;
    }

    public void setLooping(boolean val) {
        this._flags = val ? (this._flags |= 1L) : (this._flags &= 0xFFFFFFFFFFFFFFFEL);
    }

    public Extent getExtent() {
        return this._extent;
    }

    public void setExtent(@Nonnull Extent extent) {
        this._extent = extent;
    }

    public float getRarity() {
        return this._rarity;
    }

    public void setRarity(float rarity) {
        this._rarity = rarity;
    }

    public long getSyncPt() {
        return this._syncPt;
    }

    public void setSyncPt(long syncPt) {
        this._syncPt = syncPt;
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        stream.writeBytes(Arrays.copyOf(this._name.getBytes(StandardCharsets.US_ASCII), 80));
        stream.writeUInt32(this._intervalStart);
        stream.writeUInt32(this._intervalEnd);
        stream.writeFloat32(this._moveSpeed);
        stream.writeUInt32(this._flags);
        stream.writeFloat32(this._rarity);
        stream.writeUInt32(this._syncPt);
        this._extent.write(stream);
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public Sequence(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this._name = new String(stream.readBytes(80, "name"), StandardCharsets.US_ASCII);
        this._intervalStart = stream.readUInt32("intervalStart");
        this._intervalEnd = stream.readUInt32("intervalEnd");
        this._moveSpeed = stream.readFloat32("moveSpeed").floatValue();
        this._flags = stream.readUInt32("flags");
        this._rarity = stream.readFloat32("rarity").floatValue();
        this._syncPt = stream.readUInt32("syncPoint");
        this._extent = new Extent(stream);
    }

    public Sequence() {
        this._extent = new Extent();
    }
}

