/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.intermediatelang.interpreter;

import de.peeeq.wurstio.jassinterpreter.DebugPrintError;
import de.peeeq.wurstio.jassinterpreter.InterpreterException;
import de.peeeq.wurstio.jassinterpreter.VarargArray;
import de.peeeq.wurstscript.ast.Annotation;
import de.peeeq.wurstscript.ast.HasModifier;
import de.peeeq.wurstscript.ast.Modifier;
import de.peeeq.wurstscript.gui.WurstGui;
import de.peeeq.wurstscript.intermediatelang.ILconst;
import de.peeeq.wurstscript.intermediatelang.ILconstFuncRef;
import de.peeeq.wurstscript.intermediatelang.ILconstInt;
import de.peeeq.wurstscript.intermediatelang.ILconstNull;
import de.peeeq.wurstscript.intermediatelang.ILconstReal;
import de.peeeq.wurstscript.intermediatelang.ILconstString;
import de.peeeq.wurstscript.intermediatelang.interpreter.AbstractInterpreter;
import de.peeeq.wurstscript.intermediatelang.interpreter.BuiltinFuncs;
import de.peeeq.wurstscript.intermediatelang.interpreter.LocalState;
import de.peeeq.wurstscript.intermediatelang.interpreter.NativesProvider;
import de.peeeq.wurstscript.intermediatelang.interpreter.NoSuchNativeException;
import de.peeeq.wurstscript.intermediatelang.interpreter.ProgramState;
import de.peeeq.wurstscript.intermediatelang.interpreter.TimerMockHandler;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImSimpleType;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVoid;
import de.peeeq.wurstscript.jassinterpreter.ReturnException;
import de.peeeq.wurstscript.jassinterpreter.TestFailException;
import de.peeeq.wurstscript.jassinterpreter.TestSuccessException;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.translation.imoptimizer.UselessFunctionCallsRemover;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlagEnum;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;

public class ILInterpreter
implements AbstractInterpreter {
    private ImProg prog;
    private static boolean cache = false;
    private final ProgramState globalState;
    private final TimerMockHandler timerMockHandler = new TimerMockHandler();
    public static LinkedHashMap<ImFunction, LinkedHashMap<Integer, LocalState>> localStateCache = new LinkedHashMap();

    public ILInterpreter(ImProg prog, WurstGui gui, Optional<File> mapFile, ProgramState globalState, boolean cache) {
        this.prog = prog;
        this.globalState = globalState;
        ILInterpreter.cache = cache;
        globalState.addNativeProvider(new BuiltinFuncs(globalState));
    }

    public ILInterpreter(ImProg prog, WurstGui gui, Optional<File> mapFile, boolean isCompiletime, boolean cache) {
        this(prog, gui, mapFile, new ProgramState(gui, prog, isCompiletime), cache);
    }

    public static LocalState runFunc(ProgramState globalState, ImFunction f, @Nullable Element caller, ILconst ... args) {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterpreterException(globalState, "Execution interrupted");
        }
        try {
            if (f.hasFlag(FunctionFlagEnum.IS_VARARG)) {
                ILconst[] newArgs = new ILconst[f.getParameters().size()];
                if (newArgs.length - 1 >= 0) {
                    System.arraycopy(args, 0, newArgs, 0, newArgs.length - 1);
                }
                ILconst[] varargArray = new ILconst[1 + args.length - newArgs.length];
                int i = newArgs.length - 1;
                int j = 0;
                while (i < args.length) {
                    varargArray[j] = args[i];
                    ++i;
                    ++j;
                }
                newArgs[newArgs.length - 1] = new VarargArray(varargArray);
                args = newArgs;
            }
            if (f.getParameters().size() != args.length) {
                throw new Error("wrong number of parameters when calling func " + f.getName() + "(" + Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", ")) + ")");
            }
            for (int i = 0; i < f.getParameters().size(); ++i) {
                args[i] = ILInterpreter.adjustTypeOfConstant(args[i], ((ImVar)f.getParameters().get(i)).getType());
            }
            if (ILInterpreter.isCompiletimeNative(f)) {
                return ILInterpreter.runBuiltinFunction(globalState, f, args);
            }
            if (f.isNative()) {
                return ILInterpreter.runBuiltinFunction(globalState, f, args);
            }
            LocalState localState = new LocalState();
            int i = 0;
            for (ImVar p : f.getParameters()) {
                localState.setVal(p, args[i]);
                ++i;
            }
            if (f.getBody().isEmpty()) {
                return localState.setReturnVal(ILconstNull.instance());
            }
            globalState.setLastStatement((ImStmt)f.getBody().get(0));
            globalState.pushStackframe(f, args, (caller == null ? f : caller).attrTrace().attrErrorPos());
            try {
                f.getBody().runStatements(globalState, localState);
                globalState.popStackframe();
            }
            catch (ReturnException e) {
                globalState.popStackframe();
                ILconst retVal = e.getVal();
                retVal = ILInterpreter.adjustTypeOfConstant(retVal, f.getReturnType());
                return localState.setReturnVal(retVal);
            }
            if (f.getReturnType() instanceof ImVoid) {
                return localState;
            }
            throw new InterpreterException("function " + f.getName() + " did not return any value...");
        }
        catch (InterpreterException e) {
            String msg = ILInterpreter.buildStacktrace(globalState, e);
            e.setStacktrace(msg);
            e.setTrace(ILInterpreter.getTrace(globalState, f));
            throw e;
        }
        catch (DebugPrintError | TestFailException | TestSuccessException e) {
            throw e;
        }
        catch (Throwable e) {
            String msg = ILInterpreter.buildStacktrace(globalState, e);
            de.peeeq.wurstscript.ast.Element trace = ILInterpreter.getTrace(globalState, f);
            throw new InterpreterException(trace, "You encountered a bug in the interpreter: " + e, e).setStacktrace(msg);
        }
    }

    public static de.peeeq.wurstscript.ast.Element getTrace(ProgramState globalState, ImFunction f) {
        Element lastStatement = globalState.getLastStatement();
        return lastStatement == null ? f.attrTrace() : lastStatement.attrTrace();
    }

    public static String buildStacktrace(ProgramState globalState, Throwable e) {
        StringBuilder err = new StringBuilder();
        try {
            WPos src = globalState.getLastStatement().attrTrace().attrSource();
            err.append("at : ").append(new File(src.getFile()).getName()).append(", line ").append(src.getLine()).append("\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        globalState.getStackFrames().appendTo(err);
        return err.toString();
    }

    private static ILconst adjustTypeOfConstant(@Nullable ILconst retVal, ImType expectedType) {
        if (retVal instanceof ILconstInt && ILInterpreter.isTypeReal(expectedType)) {
            ILconstInt retValI = (ILconstInt)retVal;
            retVal = new ILconstReal(retValI.getVal());
        }
        return retVal;
    }

    private static boolean isTypeReal(ImType t) {
        if (t instanceof ImSimpleType) {
            ImSimpleType st = (ImSimpleType)t;
            return st.getTypename().equals("real");
        }
        return false;
    }

    private static LocalState runBuiltinFunction(ProgramState globalState, ImFunction f, ILconst ... args) {
        if (cache && UselessFunctionCallsRemover.isFunctionPure(f.getName())) {
            int combinedHash = Objects.hash(args);
            if (localStateCache.containsKey(f) && localStateCache.get(f).containsKey(combinedHash)) {
                return localStateCache.get(f).get(combinedHash);
            }
        }
        StringBuilder errors = new StringBuilder();
        for (NativesProvider natives : globalState.getNativeProviders()) {
            try {
                LocalState localState = new LocalState(natives.invoke(f.getName(), args));
                if (cache && UselessFunctionCallsRemover.isFunctionPure(f.getName())) {
                    int combinedHash = Objects.hash(args);
                    LinkedHashMap<Integer, LocalState> cached = localStateCache.getOrDefault(f, new LinkedHashMap());
                    cached.put(combinedHash, localState);
                    localStateCache.put(f, cached);
                }
                return localState;
            }
            catch (NoSuchNativeException e) {
                errors.append("\n").append(e.getMessage());
            }
        }
        globalState.compilationError("function " + f.getName() + " cannot be used from the Wurst interpreter.\n" + errors);
        if (f.getReturnType() instanceof ImVoid) {
            return new LocalState();
        }
        ILconst returnValue = ImHelper.defaultValueForComplexType(f.getReturnType()).evaluate(globalState, new LocalState());
        return new LocalState(returnValue);
    }

    private static boolean isCompiletimeNative(ImFunction f) {
        if (f.getTrace() instanceof HasModifier) {
            HasModifier f2 = (HasModifier)f.getTrace();
            for (Modifier m : f2.getModifiers()) {
                Annotation annotation;
                if (!(m instanceof Annotation) || !(annotation = (Annotation)m).getAnnotationType().equals("@compiletimenative")) continue;
                return true;
            }
        }
        return false;
    }

    public LocalState executeFunction(String funcName, @Nullable Element trace) {
        this.globalState.resetStackframes();
        for (ImFunction f : this.prog.getFunctions()) {
            if (!f.getName().equals(funcName)) continue;
            return ILInterpreter.runFunc(this.globalState, f, trace, new ILconst[0]);
        }
        throw new Error("no function with name " + funcName + "was found.");
    }

    public void runVoidFunc(ImFunction f, @Nullable Element trace) {
        this.globalState.resetStackframes();
        ILconst[] args = new ILconst[]{};
        if (!f.getParameters().isEmpty()) {
            args = new ILconstString[]{new ILconstString("initial call")};
        }
        ILInterpreter.runFunc(this.globalState, f, trace, args);
    }

    public Element getLastStatement() {
        return this.globalState.getLastStatement();
    }

    public void writebackGlobalState(boolean injectObjects) {
        this.globalState.writeBack(injectObjects);
    }

    public ProgramState getGlobalState() {
        return this.globalState;
    }

    public void addNativeProvider(NativesProvider np) {
        this.globalState.addNativeProvider(np);
    }

    public void setProgram(ImProg imProg) {
        this.prog = imProg;
        this.getGlobalState().setProg(imProg);
        this.globalState.resetStackframes();
    }

    public ProgramState.StackTrace getStackFrames() {
        return this.globalState.getStackFrames();
    }

    @Override
    public void runFuncRef(ILconstFuncRef obj, @Nullable Element trace) {
        this.runVoidFunc(obj.getFunc(), trace);
    }

    @Override
    public TimerMockHandler getTimerMockHandler() {
        return this.timerMockHandler;
    }

    @Override
    public void completeTimers() {
        this.timerMockHandler.completeTimers();
    }

    @Override
    public ImProg getImProg() {
        return this.prog;
    }

    @Override
    public int getInstanceCount(int val) {
        return (int)this.globalState.getAllObjects().stream().filter(o -> o.getType().getClassDef().attrTypeId() == val).filter(o -> !o.isDestroyed()).count();
    }

    @Override
    public int getMaxInstanceCount(int val) {
        return (int)this.globalState.getAllObjects().stream().filter(o -> o.getType().getClassDef().attrTypeId() == val).count();
    }
}

