/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver.requests;

import config.WurstProjectConfig;
import config.WurstProjectConfigData;
import de.peeeq.wurstio.gui.WurstGuiImpl;
import de.peeeq.wurstio.languageserver.ModelManager;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstio.languageserver.WurstLanguageServer;
import de.peeeq.wurstio.languageserver.requests.MapRequest;
import de.peeeq.wurstio.languageserver.requests.RequestFailedException;
import de.peeeq.wurstio.mpq.MpqEditor;
import de.peeeq.wurstio.mpq.MpqEditorFactory;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.gui.WurstGui;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.MessageType;

public class BuildMap
extends MapRequest {
    public BuildMap(WurstLanguageServer languageServer, WFile workspaceRoot, Optional<String> wc3Path, Optional<File> map, List<String> compileArgs) {
        super(languageServer, map, compileArgs, workspaceRoot, wc3Path);
    }

    @Override
    public Object execute(ModelManager modelManager) throws IOException {
        if (modelManager.hasErrors()) {
            throw new RequestFailedException(MessageType.Error, "Fix errors in your code before building a release.\n" + modelManager.getFirstErrorDescription());
        }
        WurstProjectConfigData projectConfig = WurstProjectConfig.INSTANCE.loadProject(this.workspaceRoot.getFile().toPath().resolve("wurst.build"));
        if (projectConfig == null) {
            throw new RequestFailedException(MessageType.Error, "wurst.build file doesn't exist or is invalid. Please install your project using grill or the wurst setup tool.");
        }
        WLogger.info("buildMap " + this.map + " " + this.compileArgs);
        WurstGuiImpl gui = new WurstGuiImpl(this.workspaceRoot.getFile().getAbsolutePath());
        try {
            if (!this.map.isPresent()) {
                throw new RequestFailedException(MessageType.Error, "Map is null");
            }
            if (!((File)this.map.get()).exists()) {
                throw new RequestFailedException(MessageType.Error, ((File)this.map.get()).getAbsolutePath() + " does not exist.");
            }
            MapRequest.mapLastModified = ((File)this.map.get()).lastModified();
            MapRequest.mapPath = ((File)this.map.get()).getAbsolutePath();
            ((WurstGui)gui).sendProgress("Copying map");
            File buildDir = this.getBuildDir();
            String fileName = projectConfig.getBuildMapData().getFileName();
            Optional<File> targetMap = Optional.of(new File(buildDir, fileName.isEmpty() ? projectConfig.getProjectName() + ".w3x" : fileName + ".w3x"));
            MapRequest.CompilationResult result = this.compileScript(modelManager, gui, targetMap, projectConfig, buildDir, true);
            this.injectMapData(gui, targetMap, result);
            MpqEditor ignored = MpqEditorFactory.getEditor(targetMap);
            if (ignored != null) {
                ignored.close();
            }
            ((WurstGui)gui).sendProgress("Done.");
        }
        catch (CompileError e) {
            WLogger.info(e);
            throw new RequestFailedException(MessageType.Error, "A compilation error occurred when building the map:\n" + e);
        }
        catch (Exception e) {
            WLogger.warning("Exception occurred", e);
            throw new RequestFailedException(MessageType.Error, "An exception was thrown when building the map:\n" + e);
        }
        finally {
            if (gui.getErrorCount() == 0) {
                ((WurstGui)gui).sendFinished();
            }
        }
        return "ok";
    }
}

