/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.util.Set;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.Track;

public abstract class TrackChunk<Type>
extends Chunk {
    private long _tracksCount = 0L;
    private InterpolationType _interpolationType = InterpolationType.NONE;
    private long _globalSequenceId = 0L;

    @Override
    public abstract Id getToken();

    public long getTracksCount() {
        return this._tracksCount;
    }

    public abstract Set<? extends Track> getTracks();

    @Nonnull
    public InterpolationType getInterpolationType() {
        return this._interpolationType;
    }

    public void setInterpolationType(@Nonnull InterpolationType interpolationType) {
        this._interpolationType = interpolationType;
    }

    public long getGlobalSequenceId() {
        return this._globalSequenceId;
    }

    public void setGlobalSequenceId(long globalSequenceId) {
        this._globalSequenceId = globalSequenceId;
    }

    private void read_0x0(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        Id token = stream.readId("token");
        if (!token.equals(this.getToken())) {
            throw new IllegalArgumentException("invalid " + this.getToken() + " startToken (" + token + ")");
        }
        this._tracksCount = stream.readUInt32("tracksCount");
        long interpolationTypeL = stream.readUInt32("interpolationType");
        if (interpolationTypeL >= (long)InterpolationType.values().length) {
            throw new IllegalArgumentException("interpolationType out of bounds 0-" + (InterpolationType.values().length - 1) + " (" + interpolationTypeL + ")");
        }
        this._interpolationType = InterpolationType.values()[(int)interpolationTypeL];
        this._globalSequenceId = stream.readUInt32("globalSequenceId");
    }

    private void write_0x0(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        stream.writeId(this.getToken());
        stream.writeUInt32(this.getTracks().size());
        stream.writeUInt32(this._interpolationType.ordinal());
        stream.writeUInt32(this._globalSequenceId);
        for (Track track : this.getTracks()) {
            track.write(stream, this._interpolationType, MDX.EncodingFormat.MDX_0x0);
        }
    }

    public void read(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        switch ((MDX.EncodingFormat.Enum)((Object)format.toEnum())) {
            case MDX_0x0: {
                this.read_0x0(stream);
            }
        }
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        switch ((MDX.EncodingFormat.Enum)((Object)format.toEnum())) {
            case MDX_0x0: 
            case AUTO: {
                this.write_0x0(stream);
            }
        }
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public TrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        this();
        this.read(stream, format);
    }

    public TrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this();
        this.read(stream, MDX.EncodingFormat.AUTO);
    }

    public TrackChunk() {
    }

    public static enum InterpolationType {
        NONE,
        LINEAR,
        HERMITE,
        BEZIER;

    }
}

