/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.app.Coords3DF;
import net.moonlightflower.wc3libs.dataTypes.app.Coords4DF;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSet;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.MDXObject;
import net.moonlightflower.wc3libs.misc.model.mdx.Track;
import net.moonlightflower.wc3libs.misc.model.mdx.TrackChunk;

public class Node
extends MDXObject {
    private long _inclusiveSize;
    private String _name = "unset";
    private long _objectId;
    private long _parentId;
    private long _flags;
    private final LinkedHashSet<Chunk> _chunks = new ObservableLinkedHashSet<Chunk>();
    private final LinkedHashSet<TranslationTrackChunk> _translationTrackChunks = new ObservableLinkedHashSet<TranslationTrackChunk>();
    private final LinkedHashSet<RotationTrackChunk> _rotationTrackChunks = new ObservableLinkedHashSet<RotationTrackChunk>();
    private List<ScalingTrackChunk> _scalingTrackChunks = new ArrayList<ScalingTrackChunk>();

    public long getInclusiveSize() {
        return this._inclusiveSize;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    public void SetName(@Nonnull String name) {
        this._name = name;
    }

    private long getObjectId() {
        return this._objectId;
    }

    public void setObjectId(long objectId) {
        this._objectId = objectId;
    }

    public long getParentId() {
        return this._parentId;
    }

    public void setParentId(long parentId) {
        this._parentId = parentId;
    }

    public long getFlags() {
        return this._flags;
    }

    public void setFlags(long flags) {
        this._flags = flags;
    }

    public LinkedHashSet<Chunk> getChunks() {
        return this._chunks;
    }

    public LinkedHashSet<TranslationTrackChunk> getTranslationTrackChunks() {
        return this._translationTrackChunks;
    }

    public void addTranslationTrackChunk(@Nonnull TranslationTrackChunk val) {
        this._chunks.add(val);
        this._translationTrackChunks.add(val);
    }

    public LinkedHashSet<RotationTrackChunk> getRotationTrackChunks() {
        return this._rotationTrackChunks;
    }

    public void addRotationTrackChunk(@Nonnull RotationTrackChunk val) {
        this._chunks.add(val);
        this._rotationTrackChunks.add(val);
    }

    public List<ScalingTrackChunk> getScalingTrackChunks() {
        return new ArrayList<ScalingTrackChunk>(this._scalingTrackChunks);
    }

    public void addScalingTrackChunk(@Nonnull ScalingTrackChunk val) {
        this._chunks.add(val);
        this._scalingTrackChunks.add(val);
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        MDXObject.SizeWriter sizeWriter = new MDXObject.SizeWriter();
        sizeWriter.write(stream);
        stream.writeBytes(Arrays.copyOf(this._name.getBytes(), 80));
        stream.writeUInt32(this._objectId);
        stream.writeUInt32(this._parentId);
        stream.writeUInt32(this._flags);
        for (Chunk chunk : this.getChunks()) {
            chunk.write(stream);
        }
        sizeWriter.rewrite();
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public Node(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this._inclusiveSize = stream.readUInt32("inclusiveSize");
        this._name = new String(stream.readBytes(80), StandardCharsets.US_ASCII);
        this._objectId = stream.readUInt32("objectId");
        this._parentId = stream.readUInt32("parentId");
        this._flags = stream.readUInt32("flags");
        LinkedHashMap<Id, MDX.TokenHandler> _tokenMap = new LinkedHashMap<Id, MDX.TokenHandler>();
        _tokenMap.put(TranslationTrackChunk.TOKEN, () -> this.addTranslationTrackChunk(new TranslationTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(RotationTrackChunk.TOKEN, () -> this.addRotationTrackChunk(new RotationTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(ScalingTrackChunk.TOKEN, () -> this.addScalingTrackChunk(new ScalingTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        while (!stream.eof()) {
            Id trackToken = stream.readId("trackToken");
            stream.rewind(4L);
            if (!_tokenMap.containsKey(trackToken)) break;
            MDX.TokenHandler handler = (MDX.TokenHandler)_tokenMap.get(trackToken);
            handler.run();
        }
    }

    public Node() {
    }

    public static class ScalingTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KGSC");
        private final LinkedHashSet<ScalingTrack> _scalingTracks = new ObservableLinkedHashSet<ScalingTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._scalingTracks;
        }

        public LinkedHashSet<ScalingTrack> getScalingTracks() {
            return this._scalingTracks;
        }

        public ScalingTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._scalingTracks.add(new ScalingTrack(stream, this.getInterpolationType(), format));
            }
        }

        public ScalingTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class ScalingTrack
        extends Track {
            private Coords3DF _scaling;
            private Coords3DF _inTan_scaling;
            private Coords3DF _outTan_scaling;

            @Nonnull
            public Coords3DF getScaling() {
                return this._scaling;
            }

            public void setScaling(@Nonnull Coords3DF scaling) {
                this._scaling = scaling;
            }

            @Nonnull
            public Coords3DF getInTanScaling() {
                return this._inTan_scaling;
            }

            public void setInTanScaling(@Nonnull Coords3DF scaling) {
                this._inTan_scaling = scaling;
            }

            @Nonnull
            public Coords3DF getOutTanScaling() {
                return this._outTan_scaling;
            }

            public void setOutTanScaling(@Nonnull Coords3DF scaling) {
                this._outTan_scaling = scaling;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._scaling = new Coords3DF(stream.readFloat32("scalingX").floatValue(), stream.readFloat32("scalingY").floatValue(), stream.readFloat32("scalingZ").floatValue());
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_scaling = new Coords3DF(stream.readFloat32("inTan_scalingX").floatValue(), stream.readFloat32("inTan_scalingY").floatValue(), stream.readFloat32("inTan_scalingZ").floatValue());
                    this._outTan_scaling = new Coords3DF(stream.readFloat32("outTan_scalingX").floatValue(), stream.readFloat32("outTan_scalingY").floatValue(), stream.readFloat32("outTan_scalingZ").floatValue());
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._scaling.getX());
                stream.writeFloat32(this._scaling.getY());
                stream.writeFloat32(this._scaling.getZ());
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_scaling.getX());
                    stream.writeFloat32(this._inTan_scaling.getY());
                    stream.writeFloat32(this._inTan_scaling.getZ());
                    stream.writeFloat32(this._outTan_scaling.getX());
                    stream.writeFloat32(this._outTan_scaling.getY());
                    stream.writeFloat32(this._outTan_scaling.getZ());
                }
            }

            public ScalingTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class RotationTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KGRT");
        private final LinkedHashSet<RotationTrack> _rotationTracks = new ObservableLinkedHashSet<RotationTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._rotationTracks;
        }

        public LinkedHashSet<RotationTrack> getRotationTracks() {
            return this._rotationTracks;
        }

        public RotationTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._rotationTracks.add(new RotationTrack(stream, this.getInterpolationType(), format));
            }
        }

        public RotationTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class RotationTrack
        extends Track {
            private Coords4DF _rotation;
            private Coords4DF _inTan_rotation;
            private Coords4DF _outTan_rotation;

            @Nonnull
            public Coords4DF getRotation() {
                return this._rotation;
            }

            public void setRotation(@Nonnull Coords4DF rotation) {
                this._rotation = rotation;
            }

            @Nonnull
            public Coords4DF getInTanRotation() {
                return this._inTan_rotation;
            }

            public void setInTanRotation(@Nonnull Coords4DF rotation) {
                this._inTan_rotation = rotation;
            }

            @Nonnull
            public Coords4DF getOutTanRotation() {
                return this._outTan_rotation;
            }

            public void setOutTanRotation(@Nonnull Coords4DF rotation) {
                this._outTan_rotation = rotation;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._rotation = new Coords4DF(stream.readFloat32("rotationX").floatValue(), stream.readFloat32("rotationY").floatValue(), stream.readFloat32("rotationZ").floatValue(), stream.readFloat32("rotationAlpha").floatValue());
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_rotation = new Coords4DF(stream.readFloat32("inTan_rotationX").floatValue(), stream.readFloat32("inTan_rotationY").floatValue(), stream.readFloat32("inTan_rotationZ").floatValue(), stream.readFloat32("inTan_rotationAlpha").floatValue());
                    this._outTan_rotation = new Coords4DF(stream.readFloat32("outTan_rotationX").floatValue(), stream.readFloat32("outTan_rotationY").floatValue(), stream.readFloat32("outTan_rotationZ").floatValue(), stream.readFloat32("outTan_rotationAlpha").floatValue());
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._rotation.getX());
                stream.writeFloat32(this._rotation.getY());
                stream.writeFloat32(this._rotation.getZ());
                stream.writeFloat32(this._rotation.getA());
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_rotation.getX());
                    stream.writeFloat32(this._inTan_rotation.getY());
                    stream.writeFloat32(this._inTan_rotation.getZ());
                    stream.writeFloat32(this._inTan_rotation.getA());
                    stream.writeFloat32(this._outTan_rotation.getX());
                    stream.writeFloat32(this._outTan_rotation.getY());
                    stream.writeFloat32(this._outTan_rotation.getZ());
                    stream.writeFloat32(this._outTan_rotation.getA());
                }
            }

            public RotationTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class TranslationTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KGTR");
        private final LinkedHashSet<TranslationTrack> _translationTracks = new ObservableLinkedHashSet<TranslationTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._translationTracks;
        }

        public LinkedHashSet<TranslationTrack> getTranslationTracks() {
            return this._translationTracks;
        }

        public TranslationTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._translationTracks.add(new TranslationTrack(stream, this.getInterpolationType(), format));
            }
        }

        public TranslationTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class TranslationTrack
        extends Track {
            private Coords3DF _translation;
            private Coords3DF _inTan_translation;
            private Coords3DF _outTan_translation;

            @Nonnull
            public Coords3DF getTranslation() {
                return this._translation;
            }

            public void setTranslation(@Nonnull Coords3DF translation) {
                this._translation = translation;
            }

            @Nonnull
            public Coords3DF getInTanTranslation() {
                return this._inTan_translation;
            }

            public void setInTanTranslation(@Nonnull Coords3DF translation) {
                this._inTan_translation = translation;
            }

            @Nonnull
            public Coords3DF getOutTanTranslation() {
                return this._outTan_translation;
            }

            public void setOutTanTranslation(@Nonnull Coords3DF translation) {
                this._outTan_translation = translation;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._translation = new Coords3DF(stream.readFloat32("translationX").floatValue(), stream.readFloat32("translationY").floatValue(), stream.readFloat32("translationZ").floatValue());
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_translation = new Coords3DF(stream.readFloat32("inTan_translationX").floatValue(), stream.readFloat32("inTan_translationY").floatValue(), stream.readFloat32("inTan_translationZ").floatValue());
                    this._outTan_translation = new Coords3DF(stream.readFloat32("outTan_translationX").floatValue(), stream.readFloat32("outTan_translationY").floatValue(), stream.readFloat32("outTan_translationZ").floatValue());
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._translation.getX());
                stream.writeFloat32(this._translation.getY());
                stream.writeFloat32(this._translation.getZ());
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_translation.getX());
                    stream.writeFloat32(this._inTan_translation.getY());
                    stream.writeFloat32(this._inTan_translation.getZ());
                    stream.writeFloat32(this._outTan_translation.getX());
                    stream.writeFloat32(this._outTan_translation.getY());
                    stream.writeFloat32(this._outTan_translation.getZ());
                }
            }

            public TranslationTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static enum Flag {
        HELPER(0),
        DONT_INHERIT_TRANSLATION(1),
        DONT_INHERIT_ROTATION(2),
        DONT_INHERIT_SCALING(4),
        BILLBOARDED(8),
        BILLBOARDED_LOCK_X(16),
        BILLBOARDED_LOCK_Y(32),
        BILLBOARDED_LOCK_Z(64),
        CAMERA_ANCHORED(128),
        BONE(256),
        LIGHT(512),
        EVENT_OBJECT(1024),
        ATTACHMENT(2048),
        PARTICLE_EMITTER(4096),
        COLLISION_SHAPE(8192),
        RIBBON_EMITTER(16384),
        EMITTER_USES_MDL_OR_UNSHADED(32768),
        EMITTER_USES_TGA_OR_SORT_PRIMITIVES_FAR_Z(65536),
        LINE_EMITTER(131072),
        UNFOGGED(262144),
        MODEL_SPACE(524288),
        XY_QUAD(0x100000);

        private int _index;

        public int getIndex() {
            return this._index;
        }

        private Flag(int index) {
            this._index = index;
        }
    }
}

