/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin.app;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.app.Bounds;
import net.moonlightflower.wc3libs.dataTypes.app.Coords2DI;
import net.moonlightflower.wc3libs.misc.ShadowMap;
import net.moonlightflower.wc3libs.misc.Size;
import net.moonlightflower.wc3libs.port.JMpqPort;
import net.moonlightflower.wc3libs.port.MpqPort;

public class SHD {
    public static final File GAME_PATH = new File("war3map.shd");
    private ShadowMap _shadowMap = new ShadowMap(new Bounds(new Size(0, 0)));

    @Nonnull
    public ShadowMap getShadowMap() {
        return this._shadowMap;
    }

    public void setBounds(@Nonnull Bounds val, boolean b) {
        this._shadowMap.setBounds(val, b, b);
    }

    private void write_0x0(@Nonnull Wc3BinOutputStream stream) {
        for (int i = 0; i < this._shadowMap.size(); ++i) {
            if (((Boolean)this._shadowMap.get(i)).booleanValue()) {
                stream.writeByte((byte)-1);
                continue;
            }
            stream.writeByte((byte)0);
        }
    }

    private void read_0x0(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        int sizeI = (int)stream.size();
        this._shadowMap.setBounds(new Bounds(new Size(1, sizeI)), false, false);
        for (int i = 0; i < sizeI; ++i) {
            Boolean val = (stream.readByte() & 0xFF) == 255;
            this._shadowMap.set(i, val);
        }
    }

    private void read_auto(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this.read(stream, EncodingFormat.SHD_0x0);
    }

    private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AUTO: {
                this.read_auto(stream);
                break;
            }
            case SHD_0x0: {
                this.read_0x0(stream);
            }
        }
    }

    private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AUTO: 
            case SHD_0x0: {
                this.write_0x0(stream);
            }
        }
    }

    private void read(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this.read(stream, EncodingFormat.AUTO);
    }

    public void write(@Nonnull Wc3BinOutputStream stream) {
        this.write(stream, EncodingFormat.AUTO);
    }

    private void read(@Nonnull File file) throws IOException {
        Wc3BinInputStream inStream = new Wc3BinInputStream(file);
        this.read(inStream, EncodingFormat.AUTO);
        inStream.close();
    }

    public void write(@Nonnull File file) throws IOException {
        Wc3BinOutputStream outStream = new Wc3BinOutputStream(file);
        this.write(outStream);
        outStream.close();
    }

    public SHD clone() throws CloneNotSupportedException {
        SHD shd = (SHD)super.clone();
        ShadowMap shadowMap = this._shadowMap;
        SHD other = new SHD(shadowMap.getBounds());
        other.getShadowMap().mergeCells(shadowMap);
        return other;
    }

    public SHD(@Nonnull BufferedImage img) {
        this(new Bounds(new Size(img.getWidth(), img.getHeight())));
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                this._shadowMap.set(new Coords2DI(x, y), Boolean.valueOf(img.getRGB(x, y) != Color.BLACK.getRGB()));
            }
        }
    }

    public SHD(@Nonnull ShadowMap shadowMap) {
        this();
        this._shadowMap = shadowMap.clone();
    }

    public SHD(@Nonnull Bounds bounds) {
        this(new ShadowMap(bounds));
    }

    public SHD(@Nonnull Wc3BinInputStream stream) throws IOException {
        this();
        this.read(stream);
    }

    public SHD() {
    }

    @Nonnull
    public static SHD ofMap(@Nonnull File mapFile) throws IOException {
        MpqPort.Out.Result portResult;
        JMpqPort.Out portOut = new JMpqPort.Out();
        portOut.add(GAME_PATH);
        try {
            portResult = portOut.commit(mapFile);
        }
        catch (Exception e) {
            throw new IOException(String.format("could not extract %s", GAME_PATH.toString()));
        }
        return new SHD(new Wc3BinInputStream(portResult.getInputStream(GAME_PATH)));
    }

    public static class EncodingFormat
    extends Format<Enum> {
        public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, -1);
        public static final EncodingFormat SHD_0x0 = new EncodingFormat(Enum.SHD_0x0, 0);

        @Nullable
        public static EncodingFormat valueOf(@Nonnull Integer version) {
            return EncodingFormat.get(EncodingFormat.class, version);
        }

        private EncodingFormat(@Nonnull Enum enumVal, int version) {
            super(enumVal, version);
        }

        public static enum Enum {
            AUTO,
            SHD_0x0;

        }
    }
}

