/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.types;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import de.peeeq.wurstscript.ast.ClassOrInterface;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.attributes.CheckHelper;
import de.peeeq.wurstscript.attributes.names.DefLink;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImTypeArguments;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.VariablePosition;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeBoundTypeParam;
import de.peeeq.wurstscript.types.WurstTypeInterface;
import de.peeeq.wurstscript.types.WurstTypeNamedScope;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class WurstTypeClassOrInterface
extends WurstTypeNamedScope {
    public WurstTypeClassOrInterface(List<WurstTypeBoundTypeParam> typeParameters, boolean isStaticRef) {
        super(typeParameters, isStaticRef);
    }

    public WurstTypeClassOrInterface(List<WurstTypeBoundTypeParam> newTypes) {
        super(newTypes);
    }

    @Override
    public abstract @NonNull ClassOrInterface getDef();

    protected int level() {
        return this.getDef().attrLevel();
    }

    @Override
    public boolean canBeUsedInInstanceOf() {
        return true;
    }

    @Override
    public boolean isCastableToInt() {
        return true;
    }

    public abstract ImmutableList<? extends WurstTypeClassOrInterface> directSupertypes();

    public ImmutableList<? extends WurstTypeClassOrInterface> transitiveSupertypes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (WurstTypeClassOrInterface st : this.directSupertypes()) {
            builder.add((Object)st);
            builder.addAll(st.transitiveSupertypes());
        }
        return builder.build();
    }

    public ImmutableList<WurstTypeInterface> transitiveSuperInterfaces() {
        return (ImmutableList)this.transitiveSupertypes().stream().filter(t -> t instanceof WurstTypeInterface).map(t -> (WurstTypeInterface)t).collect(ImmutableList.toImmutableList());
    }

    public FuncLink findSingleAbstractMethod(Element context) {
        ImmutableMultimap<String, DefLink> nameLinks = this.getDef().attrNameLinks();
        FuncLink abstractMethod = null;
        block0: for (NameLink nl : nameLinks.values()) {
            if (!(nl instanceof FuncLink) || !nl.getDef().attrIsAbstract()) continue;
            for (DefLink other : nameLinks.get((Object)nl.getName())) {
                if (other == nl || !other.getDef().attrIsOverride() || other.getDef().attrIsAbstract() || !(other instanceof FuncLink) || !CheckHelper.isRefinement(this.getTypeArgBinding(), ((FuncLink)other).getDef(), ((FuncLink)nl).getDef())) continue;
                continue block0;
            }
            if (abstractMethod != null) {
                return null;
            }
            abstractMethod = (FuncLink)nl;
        }
        if (abstractMethod != null) {
            return abstractMethod.withTypeArgBinding(context, this.getTypeArgBinding());
        }
        return null;
    }

    @Override
    VariableBinding matchAgainstSupertypeIntern(WurstType obj, @Nullable Element location, VariableBinding mapping, VariablePosition variablePosition) {
        VariableBinding superMapping = super.matchAgainstSupertypeIntern(obj, location, mapping, variablePosition);
        if (superMapping != null) {
            return superMapping;
        }
        for (WurstTypeClassOrInterface implementedInterface : this.directSupertypes()) {
            VariableBinding mapping2 = implementedInterface.matchAgainstSupertype(obj, location, mapping, VariablePosition.RIGHT);
            if (mapping2 == null) continue;
            return mapping2;
        }
        return null;
    }

    @Override
    public final ImType imTranslateType(ImTranslator tr) {
        ImTypeArguments typeArgs = JassIm.ImTypeArguments(new ImTypeArgument[0]);
        for (WurstTypeBoundTypeParam btp : this.getTypeParameters()) {
            if (!btp.isTemplateTypeParameter()) continue;
            typeArgs.add(btp.imTranslateToTypeArgument(tr));
        }
        return JassIm.ImClassType(tr.getClassFor(this.getDef()), typeArgs);
    }
}

