/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.EnumDef;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprBinary;
import de.peeeq.wurstscript.ast.ExprList;
import de.peeeq.wurstscript.ast.ExprMemberArrayVar;
import de.peeeq.wurstscript.ast.ExprMemberVar;
import de.peeeq.wurstscript.ast.ExprVarAccess;
import de.peeeq.wurstscript.ast.ExprVarArrayAccess;
import de.peeeq.wurstscript.ast.FuncRef;
import de.peeeq.wurstscript.ast.GlobalOrLocalVarDef;
import de.peeeq.wurstscript.ast.ModuleDef;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NameRef;
import de.peeeq.wurstscript.ast.StmtSet;
import de.peeeq.wurstscript.ast.SwitchCase;
import de.peeeq.wurstscript.ast.SwitchStmt;
import de.peeeq.wurstscript.ast.TypeRef;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeEnum;
import de.peeeq.wurstscript.types.WurstTypeModule;
import org.eclipse.jdt.annotation.Nullable;

public class AttrNameDef {
    public static NameLink calculate(ExprVarArrayAccess term) {
        return AttrNameDef.searchNameInScope(term.getVarName(), term);
    }

    public static NameLink calculate(ExprVarAccess term) {
        NameLink result = AttrNameDef.specialEnumLookupRules(term);
        if (result != null) {
            return result;
        }
        return AttrNameDef.searchNameInScope(term.getVarName(), term);
    }

    public static @Nullable NameLink specialEnumLookupRules(ExprVarAccess term) {
        ExprBinary binary;
        NameLink result = null;
        Element parent = term.getParent();
        String varName = term.getVarName();
        if (parent instanceof ExprList) {
            if ((parent = parent.getParent()) instanceof SwitchCase) {
                SwitchStmt s = (SwitchStmt)parent.getParent().getParent();
                result = AttrNameDef.lookupEnumConst(varName, s.getExpr().attrTyp());
            }
        } else if (parent instanceof StmtSet) {
            StmtSet s = (StmtSet)parent;
            if (s.getRight() == term) {
                result = AttrNameDef.lookupEnumConst(varName, s.getUpdatedExpr().attrTyp());
            }
        } else if (parent instanceof GlobalOrLocalVarDef) {
            GlobalOrLocalVarDef v = (GlobalOrLocalVarDef)parent;
            result = AttrNameDef.lookupEnumConst(varName, v.getOptTyp().attrTyp());
        } else if (parent instanceof ExprBinary && (binary = (ExprBinary)parent).getRight() == term) {
            result = AttrNameDef.lookupEnumConst(varName, binary.getLeft().attrTyp());
        }
        return result;
    }

    public static @Nullable NameLink lookupEnumConst(String varName, WurstType t) {
        if (t instanceof WurstTypeEnum) {
            WurstTypeEnum e = (WurstTypeEnum)t;
            EnumDef eDef = e.getDef();
            return eDef.lookupMemberVar(e, varName, false);
        }
        return null;
    }

    public static NameLink calculate(ExprMemberVar term) {
        return AttrNameDef.memberVarCase(term.getLeft(), term.getVarName(), AttrNameDef.isWriteAccess(term), term);
    }

    public static @Nullable NameLink calculate(ExprMemberArrayVar term) {
        return AttrNameDef.memberVarCase(term.getLeft(), term.getVarName(), AttrNameDef.isWriteAccess(term), term);
    }

    protected static NameLink searchNameInScope(String varName, NameRef node) {
        boolean showErrors = !varName.startsWith("gg_");
        NameLink result = node.lookupVar(varName, showErrors);
        return result;
    }

    private static boolean isWriteAccess(NameRef node) {
        if (node.getParent() instanceof StmtSet) {
            StmtSet stmtSet = (StmtSet)node.getParent();
            return stmtSet.getUpdatedExpr() == node;
        }
        return false;
    }

    private static @Nullable NameLink memberVarCase(Expr left, String varName, boolean writeAccess, Expr node) {
        WurstTypeModule wurstTypeModule;
        ModuleDef module;
        WurstType receiverType = left.attrTyp();
        NameLink result = node.lookupMemberVar(receiverType, varName);
        if (result == null) {
            node.addError("Could not resolve reference to variable " + varName + " for receiver of type " + receiverType + ".");
        }
        if (receiverType instanceof WurstTypeModule && !left.isSubtreeOf(module = (wurstTypeModule = (WurstTypeModule)receiverType).getDef())) {
            node.addError("Can only reference module variables from within the module.");
        }
        return result;
    }

    public static @Nullable NameDef tryGetNameDef(NameRef e) {
        NameLink link = e.attrNameLink();
        if (link == null) {
            return null;
        }
        return link.getDef();
    }

    public static @Nullable NameDef tryGetNameDef(NameDef e) {
        return e;
    }

    public static @Nullable NameDef tryGetNameDef(FuncRef e) {
        FuncLink link = e.attrFuncLink();
        if (link == null) {
            return null;
        }
        return link.getDef();
    }

    public static @Nullable NameDef tryGetNameDef(TypeRef e) {
        return e.attrTypeDef();
    }

    public static @Nullable NameDef tryGetNameDef(Element elem) {
        return null;
    }

    public static NameDef calculateDef(NameRef nameRef) {
        NameLink l = nameRef.attrNameLink();
        return l == null ? null : l.getDef();
    }
}

