/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.slk.app.splats;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.BlendMode;
import net.moonlightflower.wc3libs.dataTypes.app.Color;
import net.moonlightflower.wc3libs.dataTypes.app.SoundLabel;
import net.moonlightflower.wc3libs.dataTypes.app.SplatId;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.dataTypes.app.WaterCode;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.ObjId;
import net.moonlightflower.wc3libs.slk.ObjSLK;
import net.moonlightflower.wc3libs.slk.RawSLK;
import net.moonlightflower.wc3libs.slk.SLK;
import net.moonlightflower.wc3libs.slk.SLKState;

public class SplatSLK
extends SLK<SplatSLK, SplatId, Obj> {
    public static final File GAME_PATH = new File("Splats\\SplatData.slk");

    @Override
    @Nonnull
    public Map<SplatId, Obj> getObjs() {
        return this._objs;
    }

    @Override
    public void addObj(@Nonnull Obj val) {
        this._objs.put((SplatId)val.getId(), val);
    }

    @Override
    @Nonnull
    public Obj addObj(@Nonnull SplatId id) {
        if (this._objs.containsKey(id)) {
            return (Obj)this._objs.get(id);
        }
        Obj obj = new Obj(id);
        this.addObj(obj);
        return obj;
    }

    @Override
    protected void read(@Nonnull SLK<?, ? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slk) {
        for (Map.Entry<? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slkEntry : slk.getObjs().entrySet()) {
            ObjId id = slkEntry.getKey();
            SLK.Obj<? extends ObjId> slkObj = slkEntry.getValue();
            Obj obj = new Obj(slkObj);
            this.addObj(obj);
        }
    }

    private RawSLK toSlk() {
        RawSLK slk = new RawSLK();
        for (Obj obj : this.getObjs().values()) {
            Object id = obj.getId();
            Object slkObj = slk.addObj(id);
            ((SLK.Obj)slkObj).merge(obj, true);
            if (obj.getSound() != null) continue;
            ((SLK.Obj)slkObj).set(State.SOUND_LABEL, (DataType)SoundLabel.valueOf("NULL"));
        }
        return slk;
    }

    @Override
    public void read(@Nonnull File file) throws IOException {
        this.read(new RawSLK(file));
    }

    public SplatSLK() {
        this.addField(State.OBJ_ID);
        for (State state : State.values(State.class)) {
            this.addField(state);
        }
    }

    @Override
    @Nonnull
    public Obj createObj(@Nonnull ObjId id) {
        return new Obj(SplatId.valueOf(id));
    }

    @Override
    public void merge(@Nonnull SplatSLK other, boolean overwrite) {
    }

    public static class Obj
    extends SLK.Obj<SplatId> {
        private final Map<ObjSLK.State, DataType> _stateVals = new LinkedHashMap<ObjSLK.State, DataType>();

        @Override
        public Map<ObjSLK.State, DataType> getStateVals() {
            return new LinkedHashMap<ObjSLK.State, DataType>(this._stateVals);
        }

        @Override
        protected void on_set(@Nonnull FieldId fieldId, @Nullable DataType val) {
            ObjSLK.State state = (ObjSLK.State)ObjSLK.State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.put(state, val);
            }
        }

        @Override
        protected void on_remove(@Nonnull FieldId fieldId) {
            ObjSLK.State state = (ObjSLK.State)ObjSLK.State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.remove(state);
            }
        }

        @Override
        protected void on_clear() {
            this._stateVals.clear();
        }

        public Path getTex() {
            return Paths.get(this.get(State.ART_TEX_DIR).toString(), this.get(State.ART_TEX_FILE).toString());
        }

        public void setTex(Path val) {
            this.set(State.ART_TEX_DIR, War3String.valueOf(val.getParent().toString()));
            this.set(State.ART_TEX_FILE, War3String.valueOf(val.getFileName().toString()));
        }

        public War3Int getRows() {
            return this.get(State.ART_ROWS);
        }

        public void setRows(War3Int val) {
            this.set(State.ART_ROWS, val);
        }

        public War3Int getCols() {
            return this.get(State.ART_COLS);
        }

        public void setCols(War3Int val) {
            this.set(State.ART_COLS, val);
        }

        public BlendMode getBlendMode() {
            return this.get(State.ART_BLEND_MODE);
        }

        public void setBlendMode(BlendMode val) {
            this.set(State.ART_BLEND_MODE, val);
        }

        public War3Real getScale() {
            return this.get(State.ART_SCALE);
        }

        public void setScale(War3Real val) {
            this.set(State.ART_SCALE, val);
        }

        public War3Real getLifespan() {
            return this.get(State.ART_LIFESPAN);
        }

        public void setLifespan(War3Real val) {
            this.set(State.ART_LIFESPAN, val);
        }

        public War3Real getLifespanRepeat() {
            return this.get(State.ART_LIFESPAN_REPEAT);
        }

        public War3Real getLifespanUVStart() {
            return this.get(State.ART_LIFESPAN_UV_START);
        }

        public War3Real getLifespanUVEnd() {
            return this.get(State.ART_LIFESPAN_UV_END);
        }

        public void setLifespanParams(War3Real repeatVal, War3Real startUV, War3Real endUV) {
            this.set(State.ART_LIFESPAN_REPEAT, repeatVal);
            this.set(State.ART_LIFESPAN_UV_END, endUV);
            this.set(State.ART_LIFESPAN_UV_START, startUV);
        }

        public War3Real getDecay() {
            return this.get(State.ART_DECAY);
        }

        public void setDecay(War3Real val) {
            this.set(State.ART_DECAY, val);
        }

        public War3Real getDecayRepeat() {
            return this.get(State.ART_DECAY_REPEAT);
        }

        public War3Real getDecayUVStart() {
            return this.get(State.ART_DECAY_UV_START);
        }

        public War3Real getDecayUVEnd() {
            return this.get(State.ART_DECAY_UV_END);
        }

        public void setDecayParams(War3Real repeatVal, War3Real startUV, War3Real endUV) {
            this.set(State.ART_DECAY_REPEAT, repeatVal);
            this.set(State.ART_DECAY_UV_END, endUV);
            this.set(State.ART_DECAY_UV_START, startUV);
        }

        public Color getColorStart() {
            return Color.fromBGRA255(this.get(State.ART_COLOR_START_BLUE).toInt(), this.get(State.ART_COLOR_START_GREEN).toInt(), this.get(State.ART_COLOR_START_RED).toInt(), this.get(State.ART_COLOR_START_ALPHA).toInt());
        }

        public void setColorStart(Color val) {
            this.set(State.ART_COLOR_START_ALPHA, War3Int.valueOf(val.getAlpha255()));
            this.set(State.ART_COLOR_START_BLUE, War3Int.valueOf(val.getBlue255()));
            this.set(State.ART_COLOR_START_GREEN, War3Int.valueOf(val.getGreen255()));
            this.set(State.ART_COLOR_START_RED, War3Int.valueOf(val.getRed255()));
        }

        public Color getColorMid() {
            return Color.fromBGRA255(this.get(State.ART_COLOR_MID_BLUE).toInt(), this.get(State.ART_COLOR_MID_GREEN).toInt(), this.get(State.ART_COLOR_MID_RED).toInt(), this.get(State.ART_COLOR_MID_ALPHA).toInt());
        }

        public void setColorMid(Color val) {
            this.set(State.ART_COLOR_MID_ALPHA, War3Int.valueOf(val.getAlpha255()));
            this.set(State.ART_COLOR_MID_BLUE, War3Int.valueOf(val.getBlue255()));
            this.set(State.ART_COLOR_MID_GREEN, War3Int.valueOf(val.getGreen255()));
            this.set(State.ART_COLOR_MID_RED, War3Int.valueOf(val.getRed255()));
        }

        public Color getColorEnd() {
            return Color.fromBGRA255(this.get(State.ART_COLOR_END_BLUE).toInt(), this.get(State.ART_COLOR_END_GREEN).toInt(), this.get(State.ART_COLOR_END_RED).toInt(), this.get(State.ART_COLOR_END_ALPHA).toInt());
        }

        public void setColorEnd(Color val) {
            this.set(State.ART_COLOR_END_ALPHA, War3Int.valueOf(val.getAlpha255()));
            this.set(State.ART_COLOR_END_BLUE, War3Int.valueOf(val.getBlue255()));
            this.set(State.ART_COLOR_END_GREEN, War3Int.valueOf(val.getGreen255()));
            this.set(State.ART_COLOR_END_RED, War3Int.valueOf(val.getRed255()));
        }

        public WaterCode getWater() {
            return this.get(State.ART_WATER);
        }

        public void setWater(WaterCode val) {
            this.set(State.ART_WATER, val);
        }

        public SoundLabel getSound() {
            return this.get(State.SOUND_LABEL);
        }

        public void setSound(SoundLabel val) {
            this.set(State.SOUND_LABEL, val);
        }

        public <T extends DataType> T get(State<T> state) {
            return (T)super.get(state);
        }

        public <T extends DataType> void set(State<T> state, T val) {
            super.set(state, val);
        }

        public <T extends DataType> void remove(State<T> state) {
            super.set(state, null);
        }

        private void read(SLK.Obj slkObj) {
            this.merge(slkObj, true);
        }

        public Obj(SLK.Obj<? extends ObjId> slkObj) {
            super(SplatId.valueOf(slkObj.getId()));
            this.read(slkObj);
        }

        public Obj(SplatId id) {
            super(id);
            for (State state : State.values(State.class)) {
                this.set((SLKState)state, (DataType)state.getDefVal());
            }
        }

        @Override
        public void reduce() {
        }
    }

    public static class State<T extends DataType>
    extends ObjSLK.State<T> {
        public static final State<SplatId> OBJ_ID = new State<SplatId>("Name", SplatId.class);
        public static final State<BlendMode> ART_BLEND_MODE = new State<BlendMode>("BlendMode", BlendMode.class);
        public static final State<War3Int> ART_COLOR_END_ALPHA = new State<War3Int>("EndA", War3Int.class, War3Int.valueOf(255));
        public static final State<War3Int> ART_COLOR_END_BLUE = new State<War3Int>("EndB", War3Int.class, War3Int.valueOf(255));
        public static final State<War3Int> ART_COLOR_END_GREEN = new State<War3Int>("EndG", War3Int.class, War3Int.valueOf(255));
        public static final State<War3Int> ART_COLOR_END_RED = new State<War3Int>("EndR", War3Int.class, War3Int.valueOf(255));
        public static final State<War3Int> ART_COLOR_MID_ALPHA = new State<War3Int>("MiddleA", War3Int.class, War3Int.valueOf(255));
        public static final State<War3Int> ART_COLOR_MID_BLUE = new State<War3Int>("MiddleB", War3Int.class, War3Int.valueOf(255));
        public static final State<War3Int> ART_COLOR_MID_GREEN = new State<War3Int>("MiddleG", War3Int.class, War3Int.valueOf(255));
        public static final State<War3Int> ART_COLOR_MID_RED = new State<War3Int>("MiddleR", War3Int.class, War3Int.valueOf(255));
        public static final State<War3Int> ART_COLOR_START_ALPHA = new State<War3Int>("StartA", War3Int.class, War3Int.valueOf(255));
        public static final State<War3Int> ART_COLOR_START_BLUE = new State<War3Int>("StartB", War3Int.class, War3Int.valueOf(255));
        public static final State<War3Int> ART_COLOR_START_GREEN = new State<War3Int>("StartG", War3Int.class, War3Int.valueOf(255));
        public static final State<War3Int> ART_COLOR_START_RED = new State<War3Int>("StartR", War3Int.class, War3Int.valueOf(255));
        public static final State<War3Int> ART_COLS = new State<War3Int>("Columns", War3Int.class);
        public static final State<War3Real> ART_DECAY = new State<War3Real>("Decay", War3Real.class);
        public static final State<War3Real> ART_DECAY_REPEAT = new State<War3Real>("DecayRepeat", War3Real.class);
        public static final State<War3Real> ART_DECAY_UV_END = new State<War3Real>("UVDecayEnd", War3Real.class);
        public static final State<War3Real> ART_DECAY_UV_START = new State<War3Real>("UVDecayStart", War3Real.class);
        public static final State<War3Int> ART_ROWS = new State<War3Int>("Rows", War3Int.class);
        public static final State<War3Real> ART_LIFESPAN = new State<War3Real>("Lifespan", War3Real.class);
        public static final State<War3Real> ART_LIFESPAN_REPEAT = new State<War3Real>("LifespanRepeat", War3Real.class);
        public static final State<War3Real> ART_LIFESPAN_UV_END = new State<War3Real>("UVLifespanEnd", War3Real.class);
        public static final State<War3Real> ART_LIFESPAN_UV_START = new State<War3Real>("UVLifespanStart", War3Real.class);
        public static final State<War3Real> ART_SCALE = new State<War3Real>("Scale", War3Real.class, War3Real.valueOf(1.0f));
        public static final State<War3String> ART_TEX_DIR = new State<War3String>("Dir", War3String.class);
        public static final State<War3String> ART_TEX_FILE = new State<War3String>("file", War3String.class);
        public static final State<WaterCode> ART_WATER = new State<WaterCode>("Water", WaterCode.class);
        public static final State<War3String> EDITOR_COMMENT = new State<War3String>("comment", War3String.class);
        public static final State<SoundLabel> SOUND_LABEL = new State<SoundLabel>("Sound", SoundLabel.class);

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo, @Nullable T defVal) {
            super(idString, typeInfo, defVal);
        }

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo) {
            super(idString, typeInfo);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type) {
            super(idString, type);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type, @Nullable T defVal) {
            super(idString, type, defVal);
        }
    }
}

