/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import config.WurstProjectConfigData;
import de.peeeq.wurstio.intermediateLang.interpreter.CompiletimeNatives;
import de.peeeq.wurstio.intermediateLang.interpreter.ProgramStateIO;
import de.peeeq.wurstio.jassinterpreter.InterpreterException;
import de.peeeq.wurstio.jassinterpreter.ReflectionNativeProvider;
import de.peeeq.wurstio.jassinterpreter.providers.HashtableProvider;
import de.peeeq.wurstio.mpq.MpqEditor;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.attributes.ErrorHandler;
import de.peeeq.wurstscript.gui.WurstGui;
import de.peeeq.wurstscript.intermediatelang.ILconst;
import de.peeeq.wurstscript.intermediatelang.ILconstAbstract;
import de.peeeq.wurstscript.intermediatelang.ILconstBool;
import de.peeeq.wurstscript.intermediatelang.ILconstInt;
import de.peeeq.wurstscript.intermediatelang.ILconstNull;
import de.peeeq.wurstscript.intermediatelang.ILconstObject;
import de.peeeq.wurstscript.intermediatelang.ILconstReal;
import de.peeeq.wurstscript.intermediatelang.ILconstString;
import de.peeeq.wurstscript.intermediatelang.ILconstTuple;
import de.peeeq.wurstscript.intermediatelang.IlConstHandle;
import de.peeeq.wurstscript.intermediatelang.interpreter.ILInterpreter;
import de.peeeq.wurstscript.intermediatelang.interpreter.ILStackFrame;
import de.peeeq.wurstscript.intermediatelang.interpreter.LocalState;
import de.peeeq.wurstscript.intermediatelang.interpreter.ProgramState;
import de.peeeq.wurstscript.intermediatelang.optimizer.FunctionSplitter;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImAlloc;
import de.peeeq.wurstscript.jassIm.ImArrayLikeType;
import de.peeeq.wurstscript.jassIm.ImCompiletimeExpr;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImExprs;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImNull;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImTypeVar;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.jassinterpreter.TestFailException;
import de.peeeq.wurstscript.jassinterpreter.TestSuccessException;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.translation.imtranslation.CallType;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlag;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlagCompiletime;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlagEnum;
import de.peeeq.wurstscript.translation.imtranslation.GetAForB;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.TypesHelper;
import de.peeeq.wurstscript.utils.Pair;
import de.peeeq.wurstscript.utils.Utils;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NotNull;

public class CompiletimeFunctionRunner {
    private final ImProg imProg;
    private final ILInterpreter interpreter;
    private final WurstGui gui;
    private final FunctionFlagToRun functionFlag;
    private final List<ImFunction> successTests = Lists.newArrayList();
    private final Map<ImFunction, Pair<Element, String>> failTests = Maps.newLinkedHashMap();
    private final ProgramStateIO globalState;
    private final ImTranslator translator;
    private boolean injectObjects;
    private final Deque<Runnable> delayedActions = new ArrayDeque<Runnable>();
    private final GetAForB<ILconstObject, ImVar> globalForObject = new GetAForB<ILconstObject, ImVar>(){

        @Override
        public ImVar initFor(ILconstObject obj) {
            ImVar res = JassIm.ImVar(obj.getTrace(), obj.getType(), obj.getType() + "_compiletime", false);
            CompiletimeFunctionRunner.this.imProg.getGlobals().add(res);
            ImAlloc alloc = JassIm.ImAlloc(obj.getTrace(), obj.getType());
            CompiletimeFunctionRunner.this.addCompiletimeStateInitAlloc(alloc.getTrace(), res, alloc);
            CompiletimeFunctionRunner.this.globalState.setVal(res, obj);
            de.peeeq.wurstscript.ast.Element trace = obj.getTrace();
            CompiletimeFunctionRunner.this.delayedActions.add(() -> {
                for (Map.Entry entry : obj.getAttributes().rowMap().entrySet()) {
                    ImVar var = (ImVar)entry.getKey();
                    Map value1 = (Map)entry.getValue();
                    for (Map.Entry entry2 : value1.entrySet()) {
                        List indexes = (List)entry2.getKey();
                        ILconst attrValue = (ILconst)entry2.getValue();
                        ImExprs indexesT = indexes.stream().map(i -> CompiletimeFunctionRunner.this.constantToExpr(trace, ILconstInt.create(i))).collect(Collectors.toCollection(() -> JassIm.ImExprs(new ImExpr[0])));
                        ImExpr value2 = CompiletimeFunctionRunner.this.constantToExpr(trace, attrValue);
                        if (CompiletimeFunctionRunner.this.translator.isLuaTarget() && value2.toString().equals("0")) {
                            ImType varType = var.getType();
                            if (varType instanceof ImArrayLikeType) {
                                varType = ((ImArrayLikeType)varType).getEntryType();
                            }
                            if (!TypesHelper.isIntType(varType) && !TypesHelper.isRealType(varType)) {
                                value2 = ImHelper.nullExpr();
                            }
                        }
                        CompiletimeFunctionRunner.this.addCompiletimeStateInit(JassIm.ImSet(trace, JassIm.ImMemberAccess(trace, JassIm.ImVarAccess(res), JassIm.ImTypeArguments(new ImTypeArgument[0]), var, indexesT), value2));
                    }
                }
            });
            return res;
        }
    };
    private final GetAForB<IlConstHandle, ImVar> globalForHandle = new GetAForB<IlConstHandle, ImVar>(){

        @Override
        public ImVar initFor(IlConstHandle a) {
            de.peeeq.wurstscript.ast.Element trace = CompiletimeFunctionRunner.this.imProg.getTrace();
            Object obj = a.getObj();
            if (obj instanceof LinkedListMultimap) {
                LinkedListMultimap map = (LinkedListMultimap)obj;
                ImType type = TypesHelper.imHashTable();
                ImVar res = JassIm.ImVar(trace, type, type + "_compiletime", false);
                CompiletimeFunctionRunner.this.imProg.getGlobals().add(res);
                CompiletimeFunctionRunner.this.globalState.setVal(res, a);
                ImExpr init = CompiletimeFunctionRunner.this.constantToExprHashtable(trace, res, a, (LinkedListMultimap<HashtableProvider.KeyPair, Object>)map);
                CompiletimeFunctionRunner.this.addCompiletimeStateInitAlloc(trace, res, init);
                return res;
            }
            throw new RuntimeException("Handle value " + obj + " (" + obj.getClass() + ") can not be persistet at compiletime");
        }
    };
    private ImFunction compiletimeStateInitFunction = null;

    public ILInterpreter getInterpreter() {
        return this.interpreter;
    }

    public ProgramStateIO getGlobalState() {
        return this.globalState;
    }

    public CompiletimeFunctionRunner(ImTranslator tr, ImProg imProg, Optional<File> mapFile, MpqEditor mpqEditor, WurstGui gui, FunctionFlagToRun flag, WurstProjectConfigData projectConfigData, boolean isProd, boolean cache) {
        Preconditions.checkNotNull((Object)imProg);
        this.translator = tr;
        this.imProg = imProg;
        this.globalState = new ProgramStateIO(mapFile, mpqEditor, gui, imProg, true);
        this.interpreter = new ILInterpreter(imProg, gui, mapFile, this.globalState, cache);
        this.interpreter.addNativeProvider(new CompiletimeNatives(this.globalState, projectConfigData, isProd));
        this.interpreter.addNativeProvider(new ReflectionNativeProvider(this.interpreter));
        this.gui = gui;
        this.functionFlag = flag;
    }

    public void run() {
        block6: {
            try {
                ArrayList<Either<ImCompiletimeExpr, ImFunction>> toExecute = new ArrayList<Either<ImCompiletimeExpr, ImFunction>>();
                this.collectCompiletimeExpressions(toExecute);
                this.collectCompiletimeFunctions(toExecute);
                toExecute.sort(Comparator.comparing(this::getOrderIndex));
                this.execute(toExecute);
                if (this.functionFlag == FunctionFlagToRun.CompiletimeFunctions) {
                    this.interpreter.writebackGlobalState(this.isInjectObjects());
                }
                this.runDelayedActions();
                this.partitionCompiletimeStateInitFunction();
            }
            catch (InterpreterException e) {
                de.peeeq.wurstscript.ast.Element origin = e.getTrace();
                this.sendErrors(origin, e.getMessage(), e);
                if (this.isUnitTestMode()) {
                    throw e;
                }
            }
            catch (Throwable e) {
                de.peeeq.wurstscript.ast.Element origin;
                WLogger.severe(e);
                Element s = this.interpreter.getLastStatement();
                de.peeeq.wurstscript.ast.Element element = origin = s == null ? null : s.attrTrace();
                if (origin == null) {
                    throw new Error("could not get origin", e);
                }
                String msg = e.getMessage();
                this.sendErrors(origin, msg, e);
                if (!this.isUnitTestMode()) break block6;
                throw e;
            }
        }
    }

    private void partitionCompiletimeStateInitFunction() {
        if (this.compiletimeStateInitFunction == null) {
            return;
        }
        FunctionSplitter.splitFunc(this.translator, this.compiletimeStateInitFunction);
    }

    private boolean isUnitTestMode() {
        return Optional.ofNullable(this.imProg).map(ImProg::attrTrace).map(de.peeeq.wurstscript.ast.Element::getErrorHandler).map(ErrorHandler::isUnitTestMode).orElse(false);
    }

    private void sendErrors(de.peeeq.wurstscript.ast.Element origin, String msg, Throwable ex) {
        this.gui.sendError(new CompileError(origin.attrSource(), msg, CompileError.ErrorType.ERROR, ex));
        for (ILStackFrame sf : Utils.iterateReverse(this.interpreter.getStackFrames().getStackFrames())) {
            this.gui.sendError(sf.makeCompileError());
        }
    }

    private void runDelayedActions() {
        while (!this.delayedActions.isEmpty()) {
            this.delayedActions.removeFirst().run();
        }
    }

    private void execute(List<Either<ImCompiletimeExpr, ImFunction>> es) {
        for (Either<ImCompiletimeExpr, ImFunction> e : es) {
            if (e.isLeft()) {
                ImCompiletimeExpr cte = (ImCompiletimeExpr)e.getLeft();
                this.executeCompiletimeExpr(cte);
                continue;
            }
            ImFunction f = (ImFunction)e.getRight();
            this.executeCompiletimeFunction(f);
        }
        this.interpreter.completeTimers();
    }

    private int getOrderIndex(Either<ImCompiletimeExpr, ImFunction> e) {
        if (e.isLeft()) {
            ImCompiletimeExpr cte = (ImCompiletimeExpr)e.getLeft();
            return cte.getExecutionOrderIndex();
        }
        ImFunction f = (ImFunction)e.getRight();
        for (FunctionFlag flag : f.getFlags()) {
            if (!(flag instanceof FunctionFlagCompiletime)) continue;
            FunctionFlagCompiletime cflag = (FunctionFlagCompiletime)flag;
            return cflag.getOrderIndex();
        }
        return 0;
    }

    private void collectCompiletimeFunctions(List<Either<ImCompiletimeExpr, ImFunction>> toExecute) {
        for (ImFunction f : this.imProg.getFunctions()) {
            if (!this.functionFlag.matches(f)) continue;
            toExecute.add((Either<ImCompiletimeExpr, ImFunction>)Either.forRight((Object)f));
        }
    }

    private void collectCompiletimeExpressions(final List<Either<ImCompiletimeExpr, ImFunction>> toExecute) {
        this.imProg.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImCompiletimeExpr e) {
                super.visit(e);
                toExecute.add(Either.forLeft((Object)e));
            }
        });
    }

    private void executeCompiletimeExpr(ImCompiletimeExpr cte) {
        try {
            ProgramState globalState = this.interpreter.getGlobalState();
            globalState.setLastStatement(cte);
            globalState.resetStackframes();
            globalState.pushStackframe(cte, cte.attrTrace().attrErrorPos());
            LocalState localState = new LocalState();
            ILconst value = cte.evaluate(globalState, localState);
            ImExpr newExpr = this.constantToExpr(cte.getTrace(), value);
            if (this.translator.isLuaTarget() && value.toString().equals("0")) {
                ImExpr expr = cte.getExpr();
                if (expr instanceof ImNull) {
                    newExpr = ImHelper.nullExpr();
                } else {
                    ImType type;
                    ImType exprType = null;
                    if (expr instanceof ImFunctionCall) {
                        exprType = ((ImFunctionCall)expr).getFunc().getReturnType();
                    } else if (expr instanceof ImVarAccess) {
                        exprType = ((ImVarAccess)expr).getVar().getType();
                    } else if (expr instanceof ImVarArrayAccess && (type = ((ImVarArrayAccess)expr).getVar().getType()) instanceof ImArrayLikeType) {
                        exprType = ((ImArrayLikeType)type).getEntryType();
                    }
                    if (exprType != null && !TypesHelper.isIntType(exprType) && !TypesHelper.isRealType(exprType)) {
                        newExpr = ImHelper.nullExpr();
                    }
                }
            }
            cte.replaceBy(newExpr);
        }
        catch (InterpreterException e) {
            String msg = ILInterpreter.buildStacktrace(this.globalState, e);
            e.setStacktrace(msg);
            e.setTrace(cte.attrTrace());
            throw e;
        }
    }

    private ImExpr constantToExpr(de.peeeq.wurstscript.ast.Element trace, ILconst value) {
        if (value instanceof ILconstBool) {
            return JassIm.ImBoolVal(((ILconstBool)value).getVal());
        }
        if (value instanceof ILconstInt) {
            return JassIm.ImIntVal(((ILconstInt)value).getVal());
        }
        if (value instanceof ILconstReal) {
            return JassIm.ImRealVal("" + ((ILconstReal)value).getVal());
        }
        if (value instanceof ILconstString) {
            return JassIm.ImStringVal(((ILconstString)value).getVal());
        }
        if (value instanceof ILconstTuple) {
            return JassIm.ImTupleExpr(JassIm.ImExprs(((ILconstTuple)value).values().stream().map(e -> this.constantToExpr(trace, (ILconst)e)).collect(Collectors.toList())));
        }
        if (value instanceof IlConstHandle) {
            IlConstHandle h = (IlConstHandle)value;
            ImVar hVar = this.globalForHandle.getFor(h);
            return JassIm.ImVarAccess(hVar);
        }
        if (value instanceof ILconstObject) {
            ILconstObject obj = this.globalState.toObject(value);
            ImVar v = this.globalForObject.getFor(obj);
            return JassIm.ImVarAccess(v);
        }
        throw new InterpreterException(trace, "Compiletime expression returned unsupported value " + value);
    }

    private ImFunction getCompiletimeStateInitFunction() {
        ImFunction res = this.compiletimeStateInitFunction;
        if (res == null) {
            de.peeeq.wurstscript.ast.Element trace = this.imProg.getTrace();
            res = JassIm.ImFunction(trace, "initCompiletimeState", JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(new ImVar[0]), JassIm.ImVoid(), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), Collections.emptyList());
            this.imProg.getFunctions().add(res);
            this.compiletimeStateInitFunction = res;
            ImFunction mainFunc = this.translator.getMainFunc();
            ImFunction globalInitFunc = this.translator.getGlobalInitFunc();
            Preconditions.checkNotNull((Object)mainFunc);
            ListIterator iterator = mainFunc.getBody().listIterator();
            ImFunctionCall call = JassIm.ImFunctionCall(trace, res, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(new ImExpr[0]), true, CallType.NORMAL);
            while (iterator.hasNext()) {
                ImFunctionCall fc;
                ImStmt stmt = (ImStmt)iterator.next();
                if (!(stmt instanceof ImFunctionCall) || (fc = (ImFunctionCall)stmt).getFunc() != globalInitFunc) continue;
                iterator.add(call);
                return res;
            }
            iterator.add(call);
        }
        return res;
    }

    private void addCompiletimeStateInitAlloc(de.peeeq.wurstscript.ast.Element trace, ImVar v, ImExpr init) {
        ImSet imSet = JassIm.ImSet(trace, JassIm.ImVarAccess(v), init.copy());
        this.imProg.getGlobalInits().put(v, Collections.singletonList(imSet));
        this.getCompiletimeStateInitFunction().getBody().add(0, imSet);
    }

    private void addCompiletimeStateInit(ImStmt stmt) {
        this.getCompiletimeStateInitFunction().getBody().add(stmt);
    }

    private ImExpr constantToExprHashtable(de.peeeq.wurstscript.ast.Element trace, ImVar htVar, IlConstHandle handle, LinkedListMultimap<HashtableProvider.KeyPair, Object> map) {
        WPos errorPos = trace.attrErrorPos();
        this.delayedActions.add(() -> {
            for (Map.Entry entry : map.entries()) {
                ILconstAbstract iv;
                HashtableProvider.KeyPair key = (HashtableProvider.KeyPair)entry.getKey();
                Object v = entry.getValue();
                if (v instanceof ILconstInt) {
                    iv = (ILconstInt)v;
                    ImFunction SaveInteger = this.findNative("SaveInteger", errorPos);
                    this.addCompiletimeStateInit(JassIm.ImFunctionCall(trace, SaveInteger, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(JassIm.ImVarAccess(htVar), JassIm.ImIntVal(key.getParentkey()), JassIm.ImIntVal(key.getChildkey()), JassIm.ImIntVal(((ILconstInt)iv).getVal())), false, CallType.NORMAL));
                    continue;
                }
                if (v instanceof ILconstReal) {
                    iv = (ILconstReal)v;
                    ImFunction SaveReal = this.findNative("SaveReal", errorPos);
                    this.addCompiletimeStateInit(JassIm.ImFunctionCall(trace, SaveReal, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(JassIm.ImVarAccess(htVar), JassIm.ImIntVal(key.getParentkey()), JassIm.ImIntVal(key.getChildkey()), JassIm.ImRealVal("" + ((ILconstReal)iv).getVal())), false, CallType.NORMAL));
                    continue;
                }
                if (v instanceof ILconstString) {
                    iv = (ILconstString)v;
                    ImFunction SaveStr = this.findNative("SaveStr", errorPos);
                    this.addCompiletimeStateInit(JassIm.ImFunctionCall(trace, SaveStr, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(JassIm.ImVarAccess(htVar), JassIm.ImIntVal(key.getParentkey()), JassIm.ImIntVal(key.getChildkey()), JassIm.ImStringVal(((ILconstString)iv).getVal())), false, CallType.NORMAL));
                    continue;
                }
                if (v instanceof ILconstBool) {
                    iv = (ILconstBool)v;
                    ImFunction SaveBoolean = this.findNative("SaveBoolean", errorPos);
                    this.addCompiletimeStateInit(JassIm.ImFunctionCall(trace, SaveBoolean, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(JassIm.ImVarAccess(htVar), JassIm.ImIntVal(key.getParentkey()), JassIm.ImIntVal(key.getChildkey()), JassIm.ImBoolVal(((ILconstBool)iv).getVal())), false, CallType.NORMAL));
                    continue;
                }
                if (v instanceof ILconstNull) continue;
                throw new CompileError(errorPos, "Unsupported value stored in HashMap: " + v + " // " + v.getClass().getSimpleName());
            }
        });
        ImFunction initHashtable = this.findNative("InitHashtable", errorPos);
        return JassIm.ImFunctionCall(trace, initHashtable, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(new ImExpr[0]), false, CallType.NORMAL);
    }

    @NotNull
    private ImFunction findNative(String funcName, WPos trace) {
        return this.imProg.getFunctions().stream().filter(ImFunction::isNative).filter(func -> func.getName().equals(funcName)).findFirst().orElseGet(() -> {
            throw new CompileError(trace, "Could not find native 'InitHashtable'");
        });
    }

    private void executeCompiletimeFunction(ImFunction f) {
        if (this.functionFlag.matches(f)) {
            try {
                if (!f.getBody().isEmpty()) {
                    this.interpreter.getGlobalState().setLastStatement((ImStmt)f.getBody().get(0));
                }
                WLogger.info("running " + this.functionFlag + " function " + f.getName());
                this.interpreter.runVoidFunc(f, null);
                this.successTests.add(f);
            }
            catch (TestSuccessException e) {
                this.successTests.add(f);
            }
            catch (TestFailException e) {
                this.failTests.put(f, Pair.create(this.interpreter.getLastStatement(), e.toString()));
            }
            catch (Throwable e) {
                this.failTests.put(f, Pair.create(this.interpreter.getLastStatement(), e.toString()));
                throw e;
            }
        }
    }

    public List<ImFunction> getSuccessTests() {
        return this.successTests;
    }

    public Map<ImFunction, Pair<Element, String>> getFailTests() {
        return this.failTests;
    }

    public boolean isInjectObjects() {
        return this.injectObjects;
    }

    public void setInjectObjects(boolean injectObjects) {
        this.injectObjects = injectObjects;
    }

    public void setOutputStream(PrintStream printStream) {
        this.interpreter.getGlobalState().setOutStream(printStream);
    }

    public static enum FunctionFlagToRun {
        Tests{

            @Override
            public boolean matches(ImFunction f) {
                return f.hasFlag(FunctionFlagEnum.IS_TEST) || f.isCompiletime();
            }
        }
        ,
        CompiletimeFunctions{

            @Override
            public boolean matches(ImFunction f) {
                return f.isCompiletime();
            }
        };


        public abstract boolean matches(ImFunction var1);
    }
}

