/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.port;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.port.GameDirFinder;
import net.moonlightflower.wc3libs.port.GameExeFinder;
import net.moonlightflower.wc3libs.port.GameVersionFinder;
import net.moonlightflower.wc3libs.port.JMpqPort;
import net.moonlightflower.wc3libs.port.MpqPort;
import net.moonlightflower.wc3libs.port.StdGameDirFinder;
import net.moonlightflower.wc3libs.port.StdGameExeFinder;
import net.moonlightflower.wc3libs.port.StdGameVersionFinder;
import net.moonlightflower.wc3libs.port.mac.MacGameDirFinder;
import net.moonlightflower.wc3libs.port.mac.MacGameExeFinder;
import net.moonlightflower.wc3libs.port.mac.MacGameVersionFinder;
import net.moonlightflower.wc3libs.port.mac.MacMapsDirFinder;
import net.moonlightflower.wc3libs.port.win.WinDefaultGameDirFinder;
import net.moonlightflower.wc3libs.port.win.WinGameDirFinder;
import net.moonlightflower.wc3libs.port.win.WinGameExeFinder;
import net.moonlightflower.wc3libs.port.win.WinGameVersionFinder;
import net.moonlightflower.wc3libs.port.win.WinMapsDirFinder;
import net.moonlightflower.wc3libs.port.win.WinTelemetryGameVersionFinder;
import net.moonlightflower.wc3libs.port.win.registry.WinRegistryGameDirFinder;
import net.moonlightflower.wc3libs.port.win.registry.WinRegistryGameExeFinder;
import net.moonlightflower.wc3libs.port.win.registry.WinRegistryGameVersionFinder;

public class Context {
    private static Map<Class<?>, Stack<Object>> _services = new LinkedHashMap();

    private static Stack<Object> getServiceStack(@Nonnull Class<?> clazz) {
        if (!_services.containsKey(clazz)) {
            _services.put(clazz, new Stack());
        }
        return _services.get(clazz);
    }

    public static synchronized <T> T getService(@Nonnull Class<T> clazz) {
        return (T)Context.getServiceStack(clazz).peek();
    }

    public static synchronized <T> T popService(@Nonnull Class<T> clazz) {
        return (T)Context.getServiceStack(clazz).pop();
    }

    public static synchronized <T> void pushService(@Nonnull Class<T> clazz, @Nonnull T obj) {
        Context.getServiceStack(clazz).push(obj);
    }

    static {
        Context.pushService(GameDirFinder.class, new StdGameDirFinder());
        Context.pushService(GameExeFinder.class, new StdGameExeFinder());
        Context.pushService(GameVersionFinder.class, new StdGameVersionFinder());
        Context.pushService(MpqPort.class, new JMpqPort());
        Context.pushService(MacGameDirFinder.class, new MacGameDirFinder());
        Context.pushService(MacGameExeFinder.class, new MacGameExeFinder());
        Context.pushService(MacGameVersionFinder.class, new MacGameVersionFinder());
        Context.pushService(MacMapsDirFinder.class, new MacMapsDirFinder());
        Context.pushService(WinDefaultGameDirFinder.class, new WinDefaultGameDirFinder());
        Context.pushService(WinGameDirFinder.class, new WinGameDirFinder());
        Context.pushService(WinGameExeFinder.class, new WinGameExeFinder());
        Context.pushService(WinGameVersionFinder.class, new WinGameVersionFinder());
        Context.pushService(WinMapsDirFinder.class, new WinMapsDirFinder());
        Context.pushService(WinTelemetryGameVersionFinder.class, new WinTelemetryGameVersionFinder());
        Context.pushService(WinRegistryGameDirFinder.class, new WinRegistryGameDirFinder());
        Context.pushService(WinRegistryGameExeFinder.class, new WinRegistryGameExeFinder());
        Context.pushService(WinRegistryGameVersionFinder.class, new WinRegistryGameVersionFinder());
    }
}

