/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.jassprinter;

import de.peeeq.wurstscript.jassAst.JassExpr;
import de.peeeq.wurstscript.jassAst.JassExprBinary;
import de.peeeq.wurstscript.jassAst.JassExprBoolVal;
import de.peeeq.wurstscript.jassAst.JassExprFuncRef;
import de.peeeq.wurstscript.jassAst.JassExprFunctionCall;
import de.peeeq.wurstscript.jassAst.JassExprIntVal;
import de.peeeq.wurstscript.jassAst.JassExprNull;
import de.peeeq.wurstscript.jassAst.JassExprRealVal;
import de.peeeq.wurstscript.jassAst.JassExprStringVal;
import de.peeeq.wurstscript.jassAst.JassExprUnary;
import de.peeeq.wurstscript.jassAst.JassExprVarAccess;
import de.peeeq.wurstscript.jassAst.JassExprVarArrayAccess;
import de.peeeq.wurstscript.jassAst.JassOpAnd;
import de.peeeq.wurstscript.jassAst.JassOpMult;
import de.peeeq.wurstscript.jassAst.JassOpOr;
import de.peeeq.wurstscript.jassAst.JassOpPlus;
import de.peeeq.wurstscript.jassprinter.JassPrinter;
import de.peeeq.wurstscript.utils.Utils;

public class ExprPrinter {
    public static void print(JassExprBoolVal e, StringBuilder sb, boolean withSpace) {
        sb.append(e.getValB() ? "true" : "false");
    }

    public static void print(JassExprFuncRef e, StringBuilder sb, boolean withSpace) {
        sb.append("function ");
        sb.append(e.getFuncName());
    }

    public static void print(JassExprIntVal e, StringBuilder sb, boolean withSpace) {
        String val = String.valueOf(e.getValI());
        sb.append(val);
    }

    public static void print(JassExprNull e, StringBuilder sb, boolean withSpace) {
        sb.append("null");
    }

    public static void print(JassExprRealVal e, StringBuilder sb, boolean withSpace) {
        sb.append(e.getValR());
    }

    public static void print(JassExprStringVal e, StringBuilder sb, boolean withSpace) {
        sb.append(Utils.escapeString(e.getValS()));
    }

    public static void print(JassExprVarAccess e, StringBuilder sb, boolean withSpace) {
        sb.append(e.getVarName());
    }

    public static void print(JassExprVarArrayAccess e, StringBuilder sb, boolean withSpace) {
        sb.append(e.getVarName());
        sb.append("[");
        e.getIndex().print(sb, withSpace);
        sb.append("]");
    }

    public static void print(JassExprBinary e, StringBuilder sb, boolean withSpace) {
        boolean useParanthesesLeft = false;
        boolean useParanthesesRight = false;
        if (e.getLeftExpr() instanceof JassExprBinary) {
            JassExprBinary left = (JassExprBinary)e.getLeftExpr();
            if (JassPrinter.precedence(left.getOp()) < JassPrinter.precedence(e.getOp())) {
                useParanthesesLeft = true;
            }
        } else if (e.getLeftExpr() instanceof JassExprUnary) {
            useParanthesesLeft = true;
        }
        if (e.getRight() instanceof JassExprBinary) {
            JassExprBinary right = (JassExprBinary)e.getRight();
            if (JassPrinter.precedence(right.getOp()) < JassPrinter.precedence(e.getOp())) {
                useParanthesesRight = true;
            } else if (!(JassPrinter.precedence(right.getOp()) != JassPrinter.precedence(e.getOp()) || right.getOp() instanceof JassOpPlus && e.getOp() instanceof JassOpPlus || right.getOp() instanceof JassOpMult && e.getOp() instanceof JassOpMult || right.getOp() instanceof JassOpOr && e.getOp() instanceof JassOpOr || right.getOp() instanceof JassOpAnd && e.getOp() instanceof JassOpAnd)) {
                useParanthesesRight = true;
            }
        } else if (e.getRight() instanceof JassExprUnary) {
            useParanthesesRight = true;
        }
        sb.append(useParanthesesLeft ? "(" : "");
        e.getLeftExpr().print(sb, withSpace);
        sb.append(useParanthesesLeft ? ")" : "");
        e.getOp().print(sb, withSpace, useParanthesesLeft, useParanthesesRight);
        sb.append(useParanthesesRight ? "(" : "");
        e.getRight().print(sb, withSpace);
        sb.append(useParanthesesRight ? ")" : "");
    }

    public static void print(JassExprFunctionCall e, StringBuilder sb, boolean withSpace) {
        sb.append(e.getFuncName());
        sb.append("(");
        boolean first = true;
        for (JassExpr a : e.getArguments()) {
            if (!first) {
                sb.append(JassPrinter.comma(withSpace));
            }
            a.print(sb, withSpace);
            first = false;
        }
        sb.append(")");
    }

    public static void print(JassExprUnary e, StringBuilder sb, boolean withSpace) {
        boolean useParantheses = e.getRight() instanceof JassExprBinary;
        e.getOpU().print(sb, withSpace, false, useParantheses);
        sb.append(useParantheses ? "(" : "");
        e.getRight().print(sb, withSpace);
        sb.append(useParantheses ? ")" : "");
    }
}

