/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImAlloc;
import de.peeeq.wurstscript.jassIm.ImCast;
import de.peeeq.wurstscript.jassIm.ImCompiletimeExpr;
import de.peeeq.wurstscript.jassIm.ImConst;
import de.peeeq.wurstscript.jassIm.ImDealloc;
import de.peeeq.wurstscript.jassIm.ImExitwhen;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImExprs;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImGetStackTrace;
import de.peeeq.wurstscript.jassIm.ImIf;
import de.peeeq.wurstscript.jassIm.ImInstanceof;
import de.peeeq.wurstscript.jassIm.ImLExpr;
import de.peeeq.wurstscript.jassIm.ImLoop;
import de.peeeq.wurstscript.jassIm.ImMemberAccess;
import de.peeeq.wurstscript.jassIm.ImMethodCall;
import de.peeeq.wurstscript.jassIm.ImOperatorCall;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImReturn;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImStatementExpr;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImTupleExpr;
import de.peeeq.wurstscript.jassIm.ImTupleSelection;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfClass;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfObj;
import de.peeeq.wurstscript.jassIm.ImTypeVarDispatch;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.jassIm.ImVarargLoop;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.AssertProperty;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.translation.imtranslation.purity.Pure;
import de.peeeq.wurstscript.types.WurstTypeBool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Flatten {
    public static Result flatten(ImTypeVarDispatch imTypeVarDispatch, ImTranslator translator, ImFunction f) {
        throw new RuntimeException("called too early");
    }

    public static Result flatten(ImCast imCast, ImTranslator translator, ImFunction f) {
        Result res = imCast.getExpr().flatten(translator, f);
        return new Result(res.stmts, JassIm.ImCast(res.expr, imCast.getToType()));
    }

    public static Result flatten(ImTypeIdOfObj e, ImTranslator translator, ImFunction f) {
        Result o = e.getObj().flatten(translator, f);
        return new Result(o.stmts, JassIm.ImTypeIdOfObj(o.expr, e.getClazz()));
    }

    public static Result flatten(ImTypeIdOfClass e, ImTranslator translator, ImFunction f) {
        e.setParent(null);
        return new Result(e);
    }

    public static Result flatten(ImDealloc d, ImTranslator translator, ImFunction f) {
        Result o = d.getObj().flatten(translator, f);
        return new Result(o.stmts, JassIm.ImDealloc(d.getTrace(), d.getClazz(), o.expr));
    }

    public static Result flatten(ImInstanceof e, ImTranslator translator, ImFunction f) {
        Result res = e.getObj().flatten(translator, f);
        return new Result(res.stmts, JassIm.ImInstanceof(res.expr, e.getClazz()));
    }

    public static Result flatten(ImAlloc e, ImTranslator translator, ImFunction f) {
        e.setParent(null);
        return new Result(e);
    }

    private static void exprToStatements(List<ImStmt> result, Element e, ImTranslator t, ImFunction f) {
        if (e instanceof ImFunctionCall) {
            Result res = Flatten.flatten((ImFunctionCall)e, t, f);
            result.addAll(res.stmts);
            result.add(res.expr);
        } else if (e instanceof ImDealloc) {
            Result res = Flatten.flatten((ImDealloc)e, t, f);
            result.addAll(res.stmts);
            result.add(res.expr);
        } else if (e instanceof ImMethodCall) {
            Result res = Flatten.flatten((ImMethodCall)e, t, f);
            result.addAll(res.stmts);
            result.add(res.expr);
        } else if (e instanceof ImStatementExpr) {
            ImStatementExpr e2 = (ImStatementExpr)e;
            Flatten.flattenStatementsInto(result, e2.getStatements(), t, f);
            Flatten.exprToStatements(result, e2, t, f);
        } else if (e instanceof ImOperatorCall && (((ImOperatorCall)e).getOp() == WurstOperator.AND || ((ImOperatorCall)e).getOp() == WurstOperator.OR)) {
            ImOperatorCall oc = (ImOperatorCall)e;
            ImStmts rightStmts = JassIm.ImStmts(new ImStmt[0]);
            ImExpr right = (ImExpr)oc.getArguments().get(1);
            ImExpr left = (ImExpr)oc.getArguments().get(0);
            Flatten.exprToStatements(rightStmts, right, t, f);
            if (rightStmts.isEmpty()) {
                Flatten.exprToStatements(result, left, t, f);
            } else if (oc.getOp() == WurstOperator.AND) {
                result.add(JassIm.ImIf(e.attrTrace(), left.copy(), rightStmts, JassIm.ImStmts(new ImStmt[0])));
            } else {
                result.add(JassIm.ImIf(e.attrTrace(), left.copy(), JassIm.ImStmts(new ImStmt[0]), rightStmts));
            }
        } else {
            for (int i = 0; i < e.size(); ++i) {
                Flatten.exprToStatements(result, e.get(i), t, f);
            }
        }
    }

    private static ImStmts flattenStatements(ImStmts statements, ImTranslator t, ImFunction f) {
        ImStmts result = JassIm.ImStmts(new ImStmt[0]);
        Flatten.flattenStatementsInto(result, statements, t, f);
        return result;
    }

    private static void flattenStatementsInto(List<ImStmt> result, ImStmts statements, ImTranslator t, ImFunction f) {
        for (ImStmt s : statements) {
            s.flatten(t, f).intoStatements(result, t, f);
        }
    }

    public static Result flatten(ImExitwhen s, ImTranslator t, ImFunction f) {
        Result cond = s.getCondition().flatten(t, f);
        ArrayList stmts = Lists.newArrayList(cond.stmts);
        stmts.add(JassIm.ImExitwhen(s.getTrace(), cond.expr));
        return new Result(stmts);
    }

    public static Result flatten(ImIf s, ImTranslator t, ImFunction f) {
        Result cond = s.getCondition().flatten(t, f);
        ArrayList stmts = Lists.newArrayList(cond.stmts);
        stmts.add(JassIm.ImIf(s.getTrace(), cond.expr, Flatten.flattenStatements(s.getThenBlock(), t, f), Flatten.flattenStatements(s.getElseBlock(), t, f)));
        return new Result(stmts);
    }

    public static Result flatten(ImLoop s, ImTranslator t, ImFunction f) {
        return new Result(Collections.singletonList(JassIm.ImLoop(s.getTrace(), Flatten.flattenStatements(s.getBody(), t, f))));
    }

    public static Result flatten(ImReturn s, ImTranslator t, ImFunction f) {
        if (s.getReturnValue() instanceof ImExpr) {
            ImExpr ret = (ImExpr)s.getReturnValue();
            Result result = ret.flatten(t, f);
            ArrayList stmts = Lists.newArrayList(result.stmts);
            stmts.add(JassIm.ImReturn(s.getTrace(), result.expr));
            return new Result(stmts);
        }
        s.setParent(null);
        return new Result(Collections.singletonList(s));
    }

    public static Result flatten(ImSet s, ImTranslator t, ImFunction f) {
        Result l = s.getLeft().flatten(t, f);
        Result r = s.getRight().flatten(t, f);
        ArrayList stmts = Lists.newArrayList(l.stmts);
        stmts.addAll(r.stmts);
        stmts.add(JassIm.ImSet(s.getTrace(), (ImLExpr)l.expr, r.expr));
        return new Result(stmts);
    }

    public static Result flatten(ImFunctionCall e, ImTranslator t, ImFunction f) {
        MultiResult r = Flatten.flattenExprs(t, f, e.getArguments());
        return new Result(r.stmts, JassIm.ImFunctionCall(e.getTrace(), e.getFunc(), e.getTypeArguments().copy(), JassIm.ImExprs(r.exprs), e.getTuplesEliminated(), e.getCallType()));
    }

    public static Result flatten(ImMethodCall e, ImTranslator t, ImFunction f) {
        Result recR = e.getReceiver().flatten(t, f);
        MultiResult argsR = Flatten.flattenExprs(t, f, e.getArguments());
        Result res = new Result(recR.stmts, JassIm.ImMethodCall(e.getTrace(), e.getMethod(), e.getTypeArguments().copy(), recR.expr, JassIm.ImExprs(argsR.exprs), e.getTuplesEliminated()));
        res.addStmts(argsR.stmts);
        return res;
    }

    public static Result flatten(ImOperatorCall e, ImTranslator t, ImFunction f) {
        de.peeeq.wurstscript.ast.Element trace = e.attrTrace();
        switch (e.getOp()) {
            case AND: {
                Result left = ((ImExpr)e.getArguments().get(0)).flatten(t, f);
                Result right = ((ImExpr)e.getArguments().get(1)).flatten(t, f);
                if (right.stmts.isEmpty()) {
                    return new Result(left.stmts, JassIm.ImOperatorCall(WurstOperator.AND, JassIm.ImExprs(left.expr, right.expr)));
                }
                ArrayList stmts = Lists.newArrayList(left.stmts);
                ImVar tempVar = JassIm.ImVar(e.attrTrace(), WurstTypeBool.instance().imTranslateType(t), "andLeft", false);
                f.getLocals().add(tempVar);
                ImStmts thenBlock = JassIm.ImStmts(new ImStmt[0]);
                thenBlock.addAll(right.stmts);
                thenBlock.add(JassIm.ImSet(trace, JassIm.ImVarAccess(tempVar), right.expr));
                ImStmts elseBlock = JassIm.ImStmts(JassIm.ImSet(trace, JassIm.ImVarAccess(tempVar), JassIm.ImBoolVal(false)));
                stmts.add(JassIm.ImIf(trace, left.expr, thenBlock, elseBlock));
                return new Result(stmts, JassIm.ImVarAccess(tempVar));
            }
            case OR: {
                Result left = ((ImExpr)e.getArguments().get(0)).flatten(t, f);
                Result right = ((ImExpr)e.getArguments().get(1)).flatten(t, f);
                if (right.stmts.isEmpty()) {
                    return new Result(left.stmts, JassIm.ImOperatorCall(WurstOperator.OR, JassIm.ImExprs(left.expr, right.expr)));
                }
                ArrayList stmts = Lists.newArrayList(left.stmts);
                ImVar tempVar = JassIm.ImVar(trace, WurstTypeBool.instance().imTranslateType(t), "andLeft", false);
                f.getLocals().add(tempVar);
                ImStmts thenBlock = JassIm.ImStmts(JassIm.ImSet(trace, JassIm.ImVarAccess(tempVar), JassIm.ImBoolVal(true)));
                ImStmts elseBlock = JassIm.ImStmts(new ImStmt[0]);
                elseBlock.addAll(right.stmts);
                elseBlock.add(JassIm.ImSet(trace, JassIm.ImVarAccess(tempVar), right.expr));
                stmts.add(JassIm.ImIf(trace, left.expr, thenBlock, elseBlock));
                return new Result(stmts, JassIm.ImVarAccess(tempVar));
            }
        }
        MultiResult r = Flatten.flattenExprs(t, f, e.getArguments());
        return new Result(r.stmts, JassIm.ImOperatorCall(e.getOp(), JassIm.ImExprs(r.exprs)));
    }

    public static Result flatten(ImConst e, ImTranslator t, ImFunction f) {
        e.setParent(null);
        return new Result(e);
    }

    public static Result flatten(ImStatementExpr e, ImTranslator t, ImFunction f) {
        ArrayList stmts = Lists.newArrayList();
        Flatten.flattenStatementsInto(stmts, e.getStatements(), t, f);
        Result r = e.getExpr().flatten(t, f);
        stmts.addAll(r.stmts);
        return new Result(stmts, r.expr);
    }

    public static ResultL flattenL(ImStatementExpr e, ImTranslator t, ImFunction f) {
        ArrayList stmts = Lists.newArrayList();
        Flatten.flattenStatementsInto(stmts, e.getStatements(), t, f);
        ResultL r = ((ImLExpr)e.getExpr()).flattenL(t, f);
        stmts.addAll(r.stmts);
        return new ResultL((List<ImStmt>)stmts, r.getExpr());
    }

    public static Result flatten(ImTupleExpr e, ImTranslator t, ImFunction f) {
        MultiResult r = Flatten.flattenExprs(t, f, e.getExprs());
        return new Result(r.stmts, JassIm.ImTupleExpr(JassIm.ImExprs(r.exprs)));
    }

    public static ResultL flattenL(ImTupleExpr e, ImTranslator t, ImFunction f) {
        ImExprs exprs = e.getExprs();
        MultiResultL r = Flatten.flattenExprsL(t, f, exprs);
        ImExprs newExprs = JassIm.ImExprs(new ImExpr[0]);
        newExprs.addAll(r.getLExprs());
        return new ResultL((List<ImStmt>)r.stmts, JassIm.ImTupleExpr(newExprs));
    }

    public static Result flatten(ImTupleSelection e, ImTranslator t, ImFunction f) {
        return Flatten.flattenL(e, t, f);
    }

    public static ResultL flattenL(ImTupleSelection e, ImTranslator t, ImFunction f) {
        List<ImStmt> stmts;
        ImLExpr tupleExpr;
        Result r = e.getTupleExpr().flatten(t, f);
        if (r.expr instanceof ImLExpr) {
            tupleExpr = (ImLExpr)r.expr;
            stmts = r.stmts;
        } else {
            ImVar v = JassIm.ImVar(e.attrTrace(), r.expr.attrTyp(), "tuple_temp", false);
            f.getLocals().add(v);
            stmts = new ArrayList<ImStmt>(r.stmts);
            stmts.add(JassIm.ImSet(e.attrTrace(), JassIm.ImVarAccess(v), r.expr));
            tupleExpr = JassIm.ImVarAccess(v);
        }
        return new ResultL(stmts, JassIm.ImTupleSelection(tupleExpr, e.getTupleIndex()));
    }

    public static ResultL flattenL(ImVarAccess e, ImTranslator t, ImFunction f) {
        e.setParent(null);
        return new ResultL(e);
    }

    public static ResultL flatten(ImLExpr e, ImTranslator t, ImFunction f) {
        return e.flattenL(t, f);
    }

    public static ResultL flattenL(ImVarArrayAccess e, ImTranslator t, ImFunction f) {
        MultiResult indexes = Flatten.flattenExprs(t, f, e.getIndexes());
        return new ResultL(indexes.stmts, JassIm.ImVarArrayAccess(e.getTrace(), e.getVar(), JassIm.ImExprs(indexes.exprs)));
    }

    public static void flattenFunc(ImFunction f, ImTranslator translator) {
        ImStmts newBody = Flatten.flattenStatements(f.getBody(), translator, f);
        f.setBody(newBody);
    }

    public static void flattenProg(ImProg imProg, ImTranslator translator) {
        imProg.getFunctions().parallelStream().forEach(f -> f.flatten(translator));
        imProg.getClasses().parallelStream().forEach(c -> c.getFunctions().parallelStream().forEach(f -> f.flatten(translator)));
        translator.assertProperties(AssertProperty.FLAT);
    }

    public static Result flatten(ImCompiletimeExpr e, ImTranslator translator, ImFunction f) {
        e.setParent(null);
        return new Result(e);
    }

    private static MultiResult flattenExprs(ImTranslator t, ImFunction f, ImExpr ... exprs) {
        return Flatten.flattenExprs(t, f, Arrays.asList(exprs));
    }

    private static MultiResult flattenExprs(ImTranslator t, ImFunction f, List<ImExpr> exprs) {
        int i;
        ArrayList stmts = Lists.newArrayList();
        ArrayList newExprs = Lists.newArrayList();
        ArrayList results = Lists.newArrayList();
        int withStmts = -1;
        for (i = 0; i < exprs.size(); ++i) {
            Result r = exprs.get(i).flatten(t, f);
            results.add(r);
            if (r.stmts.isEmpty()) continue;
            withStmts = i;
        }
        for (i = 0; i < exprs.size(); ++i) {
            ImExpr e = exprs.get(i);
            Result r = (Result)results.get(i);
            stmts.addAll(r.stmts);
            if (r.expr.attrPurity() instanceof Pure || i >= withStmts) {
                newExprs.add(r.expr);
                continue;
            }
            ImVar tempVar = JassIm.ImVar(e.attrTrace(), r.expr.attrTyp(), "temp", false);
            f.getLocals().add(tempVar);
            stmts.add(JassIm.ImSet(e.attrTrace(), JassIm.ImVarAccess(tempVar), r.expr));
            newExprs.add(JassIm.ImVarAccess(tempVar));
        }
        return new MultiResult(stmts, newExprs);
    }

    private static MultiResultL flattenExprsL(ImTranslator t, ImFunction f, List<ImLExpr> exprs) {
        int i;
        ArrayList stmts = Lists.newArrayList();
        ArrayList newExprs = Lists.newArrayList();
        ArrayList results = Lists.newArrayList();
        int withStmts = -1;
        for (i = 0; i < exprs.size(); ++i) {
            ResultL r = exprs.get(i).flattenL(t, f);
            results.add(r);
            if (r.stmts.isEmpty()) continue;
            withStmts = i;
        }
        for (i = 0; i < exprs.size(); ++i) {
            ImExpr e = exprs.get(i);
            ResultL r = (ResultL)results.get(i);
            stmts.addAll(r.stmts);
            if (r.expr.attrPurity() instanceof Pure || i >= withStmts) {
                newExprs.add(r.getExpr());
                continue;
            }
            ImVar tempVar = JassIm.ImVar(e.attrTrace(), r.expr.attrTyp(), "temp", false);
            f.getLocals().add(tempVar);
            stmts.add(JassIm.ImSet(e.attrTrace(), JassIm.ImVarAccess(tempVar), r.expr));
            newExprs.add(JassIm.ImVarAccess(tempVar));
        }
        return new MultiResultL((List<ImStmt>)stmts, newExprs);
    }

    public static Result flatten(ImMemberAccess e, ImTranslator t, ImFunction f) {
        Result rr = e.getReceiver().flatten(t, f);
        MultiResult ir = Flatten.flattenExprs(t, f, e.getIndexes());
        Result res = new Result(rr.stmts, JassIm.ImMemberAccess(e.getTrace(), rr.expr, e.getTypeArguments().copy(), e.getVar(), JassIm.ImExprs(ir.exprs)));
        res.addStmts(ir.stmts);
        return res;
    }

    public static ResultL flattenL(ImMemberAccess e, ImTranslator t, ImFunction f) {
        Result rr = e.getReceiver().flatten(t, f);
        MultiResult ir = Flatten.flattenExprs(t, f, e.getIndexes());
        ResultL res = new ResultL(rr.stmts, JassIm.ImMemberAccess(e.getTrace(), rr.expr, e.getTypeArguments(), e.getVar(), JassIm.ImExprs(ir.exprs)));
        res.addStmts(ir.stmts);
        return res;
    }

    public static Result flatten(ImGetStackTrace e, ImTranslator translator, ImFunction f) {
        e.setParent(null);
        return new Result(e);
    }

    public static Result flatten(ImVarargLoop s, ImTranslator translator, ImFunction f) {
        return new Result(Collections.singletonList(JassIm.ImVarargLoop(s.getTrace(), Flatten.flattenStatements(s.getBody(), translator, f), s.getLoopVar())));
    }

    public static class MultiResultL
    extends MultiResult {
        public MultiResultL(List<ImStmt> stmts, List<ImLExpr> exprs) {
            super(stmts, (List<ImExpr>)ImmutableList.copyOf(exprs));
        }

        @Override
        public ImLExpr expr(int i) {
            return (ImLExpr)super.expr(i);
        }

        public List<ImLExpr> getLExprs() {
            return this.exprs;
        }
    }

    public static class MultiResult {
        final List<ImStmt> stmts;
        final List<ImExpr> exprs;

        public MultiResult(List<ImStmt> stmts, List<ImExpr> exprs) {
            this.stmts = stmts;
            this.exprs = exprs;
        }

        public ImExpr expr(int i) {
            return this.exprs.get(i);
        }
    }

    public static class ResultL
    extends Result {
        public ResultL(List<ImStmt> stmts, ImLExpr expr) {
            super(stmts, expr);
        }

        public ResultL(ImLExpr expr) {
            super(expr);
        }

        @Override
        public ImLExpr getExpr() {
            return (ImLExpr)super.getExpr();
        }
    }

    public static class Result {
        List<ImStmt> stmts;
        final ImExpr expr;

        public Result(List<ImStmt> stmts, ImExpr expr) {
            Preconditions.checkArgument((expr.getParent() == null ? 1 : 0) != 0, (Object)"expression must not have a parent");
            Preconditions.checkArgument((boolean)stmts.stream().allMatch(s -> s.getParent() == null), (Object)"statement must not have a parent");
            this.stmts = stmts;
            this.expr = expr;
        }

        public Result(ImExpr expr) {
            this(Collections.emptyList(), expr);
        }

        public Result(List<ImStmt> stmts) {
            this(stmts, ImHelper.nullExpr());
        }

        public void intoStatements(List<ImStmt> result, ImTranslator t, ImFunction f) {
            result.addAll(this.stmts);
            Flatten.exprToStatements(result, this.expr, t, f);
        }

        public List<ImStmt> getStmts() {
            return this.stmts;
        }

        public ImExpr getExpr() {
            return this.expr;
        }

        public ImStatementExpr toStatementExpr() {
            return JassIm.ImStatementExpr(JassIm.ImStmts(this.stmts), this.expr);
        }

        public void addStmts(List<ImStmt> stmts) {
            if (stmts.isEmpty()) {
                return;
            }
            this.stmts = new ArrayList<ImStmt>(this.stmts);
            this.stmts.addAll(stmts);
        }
    }
}

