/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TypeInfo<boundType> {
    private Class<? extends boundType> _type;
    private TypeInfo<? extends boundType>[] _generics;

    @Nonnull
    public Class<? extends boundType> getType() {
        return this._type;
    }

    @Nullable
    public TypeInfo<? extends boundType>[] getGenerics() {
        return this._generics;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" -> ");
        sb.append(this.getType().getSimpleName());
        TypeInfo<boundType>[] generics = this.getGenerics();
        if (generics != null) {
            sb.append("[");
            for (int i = 0; i < generics.length; ++i) {
                sb.append(generics[i]);
                if (i <= 0) continue;
                sb.append(";");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    @Nonnull
    public String getTypeName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType().getSimpleName());
        TypeInfo<boundType>[] generics = this.getGenerics();
        if (generics != null) {
            sb.append("<");
            for (int i = 0; i < generics.length; ++i) {
                sb.append(generics[i].getTypeName());
                if (i <= 0) continue;
                sb.append(";");
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TypeInfo && this.hashCode() == other.hashCode();
    }

    public TypeInfo(@Nonnull Class<? extends boundType> type, @Nonnull Class<? extends boundType>[] generics) {
        this._type = type;
        TypeInfo[] genericsInfo = new TypeInfo[generics.length];
        int c = 0;
        for (Class<? extends boundType> generic : generics) {
            genericsInfo[c] = new TypeInfo<boundType>(generic);
            ++c;
        }
        this._generics = genericsInfo;
    }

    public TypeInfo(@Nonnull Class<? extends boundType> type, @Nullable TypeInfo<? extends boundType>[] generics) {
        this._type = type;
        this._generics = generics;
    }

    public TypeInfo(@Nonnull Class<? extends boundType> type, @Nullable TypeInfo<? extends boundType> generics) {
        this(type, new TypeInfo[]{generics});
    }

    public TypeInfo(@Nonnull Class<? extends boundType> type, @Nullable Class<? extends boundType> generics) {
        this(type, new Class[]{generics});
    }

    public TypeInfo(@Nonnull Class<? extends boundType> type) {
        this._type = type;
        this._generics = null;
    }
}

