/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtojass;

import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImAlloc;
import de.peeeq.wurstscript.jassIm.ImCast;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImDealloc;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImInstanceof;
import de.peeeq.wurstscript.jassIm.ImMethod;
import de.peeeq.wurstscript.jassIm.ImNull;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfClass;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfObj;
import de.peeeq.wurstscript.jassIm.ImVar;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TypeRewriter {
    public static void rewriteTypes(Element e, final Function<ImType, ImType> rewriteType) {
        e.accept(new Element.DefaultVisitor(){

            private ImType rewriteType(ImType type) {
                return (ImType)rewriteType.apply(type);
            }

            @Override
            public void visit(ImVar e) {
                super.visit(e);
                e.setType(this.rewriteType(e.getType()));
            }

            @Override
            public void visit(ImFunction e) {
                super.visit(e);
                e.setReturnType(this.rewriteType(e.getReturnType()));
            }

            @Override
            public void visit(ImNull e) {
                super.visit(e);
                e.setType(this.rewriteType(e.getType()));
            }

            @Override
            public void visit(ImTypeArgument e) {
                super.visit(e);
                e.setType(this.rewriteType(e.getType()));
            }

            @Override
            public void visit(ImClass e) {
                super.visit(e);
                List<ImClassType> newSuperClasses = e.getSuperClasses().stream().map(tt -> (ImClassType)this.rewriteType((ImType)tt)).collect(Collectors.toList());
                e.setSuperClasses(newSuperClasses);
            }

            @Override
            public void visit(ImMethod e) {
                super.visit(e);
                e.setMethodClass((ImClassType)this.rewriteType(e.getMethodClass()));
            }

            @Override
            public void visit(ImAlloc e) {
                super.visit(e);
                e.setClazz((ImClassType)this.rewriteType(e.getClazz()));
            }

            @Override
            public void visit(ImDealloc e) {
                super.visit(e);
                e.setClazz((ImClassType)this.rewriteType(e.getClazz()));
            }

            @Override
            public void visit(ImInstanceof e) {
                super.visit(e);
                e.setClazz((ImClassType)this.rewriteType(e.getClazz()));
            }

            @Override
            public void visit(ImTypeIdOfObj e) {
                super.visit(e);
                e.setClazz((ImClassType)this.rewriteType(e.getClazz()));
            }

            @Override
            public void visit(ImTypeIdOfClass e) {
                super.visit(e);
                e.setClazz((ImClassType)this.rewriteType(e.getClazz()));
            }

            @Override
            public void visit(ImCast e) {
                super.visit(e);
                e.setToType(this.rewriteType(e.getToType()));
            }
        });
    }
}

