/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSet;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.FaceTypeGroup;

public class FaceTypeGroupChunk
extends Chunk {
    public static Id TOKEN = Id.valueOf("PTYP");
    private final LinkedHashSet<FaceTypeGroup> _faceTypeGroups = new ObservableLinkedHashSet<FaceTypeGroup>();

    @Override
    public Id getToken() {
        return TOKEN;
    }

    public LinkedHashSet<FaceTypeGroup> getFaceTypeGroups() {
        return this._faceTypeGroups;
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        stream.writeId(TOKEN);
        stream.writeUInt32(this._faceTypeGroups.size());
        for (FaceTypeGroup faceTypeGroup : this._faceTypeGroups) {
            faceTypeGroup.write(stream);
        }
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public FaceTypeGroupChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        Id token = stream.readId("token");
        if (!token.equals(this.getToken())) {
            throw new IllegalArgumentException("invalid " + this.getToken() + " startToken (" + token + ")");
        }
        for (long faceTypeGroupsCount = stream.readUInt32("faceTypeGroupsCount").longValue(); faceTypeGroupsCount > 0L; --faceTypeGroupsCount) {
            this._faceTypeGroups.add(new FaceTypeGroup(stream));
        }
    }

    public FaceTypeGroupChunk() {
    }
}

