/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.ast;

import com.google.common.collect.ImmutableCollection;
import de.peeeq.immutablecollections.ImmutableList;
import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.ast.AstElementWithSource;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ClassOrInterface;
import de.peeeq.wurstscript.ast.ClassOrModule;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.CyclicDependencyError;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprBinary;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprOrStatements;
import de.peeeq.wurstscript.ast.ExprStatementsBlock;
import de.peeeq.wurstscript.ast.FunctionDefinition;
import de.peeeq.wurstscript.ast.FunctionImplementation;
import de.peeeq.wurstscript.ast.HasReadVariables;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NamedScope;
import de.peeeq.wurstscript.ast.OptExpr;
import de.peeeq.wurstscript.ast.PackageOrGlobal;
import de.peeeq.wurstscript.ast.StructureDef;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.VarDef;
import de.peeeq.wurstscript.ast.VarInitialization;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.AttrConstantValue;
import de.peeeq.wurstscript.attributes.AttrExprExpectedType;
import de.peeeq.wurstscript.attributes.AttrExprType;
import de.peeeq.wurstscript.attributes.AttrFuncDef;
import de.peeeq.wurstscript.attributes.AttrImportedPackage;
import de.peeeq.wurstscript.attributes.AttrNameDef;
import de.peeeq.wurstscript.attributes.AttrNearest;
import de.peeeq.wurstscript.attributes.AttrPos;
import de.peeeq.wurstscript.attributes.Description;
import de.peeeq.wurstscript.attributes.DescriptionHtml;
import de.peeeq.wurstscript.attributes.ErrorHandler;
import de.peeeq.wurstscript.attributes.ErrorHandling;
import de.peeeq.wurstscript.attributes.IsDynamicContext;
import de.peeeq.wurstscript.attributes.PathDescription;
import de.peeeq.wurstscript.attributes.ReadVariables;
import de.peeeq.wurstscript.attributes.SmallHelpers;
import de.peeeq.wurstscript.attributes.UsedGlobalVariables;
import de.peeeq.wurstscript.attributes.UsedPackages;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.attributes.names.NameResolution;
import de.peeeq.wurstscript.attributes.names.PackageLink;
import de.peeeq.wurstscript.attributes.prettyPrint.PrettyPrinter;
import de.peeeq.wurstscript.attributes.prettyPrint.Spacer;
import de.peeeq.wurstscript.intermediatelang.ILconst;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImExprOpt;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.translation.imtranslation.ExprTranslation;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.utils.Utils;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.Nullable;

class ExprBinaryImpl
implements ExprBinary {
    private Element parent;
    private WPos source;
    private Expr left;
    private WurstOperator op;
    private Expr right;
    private int zzattr_attrReadVariables_state = 0;
    private ImmutableList<NameDef> zzattr_attrReadVariables_cache;
    private int zzattr_attrTyp_state = 0;
    private WurstType zzattr_attrTyp_cache;
    private int zzattr_attrConstantValue_state = 0;
    private ILconst zzattr_attrConstantValue_cache;
    private int zzattr_attrTypRaw_state = 0;
    private WurstType zzattr_attrTypRaw_cache;
    private int zzattr_attrExpectedTypRaw_state = 0;
    private WurstType zzattr_attrExpectedTypRaw_cache;
    private int zzattr_attrExpectedTyp_state = 0;
    private WurstType zzattr_attrExpectedTyp_cache;
    private int zzattr_attrFuncLink_state = 0;
    private FuncLink zzattr_attrFuncLink_cache;
    private int zzattr_attrUsedGlobalVariables_state = 0;
    private com.google.common.collect.ImmutableList<VarDef> zzattr_attrUsedGlobalVariables_cache;
    private int zzattr_attrReadGlobalVariables_state = 0;
    private com.google.common.collect.ImmutableList<VarDef> zzattr_attrReadGlobalVariables_cache;

    ExprBinaryImpl(WPos source, Expr left, WurstOperator op, Expr right) {
        if (source == null) {
            throw new IllegalArgumentException("Element source must not be null.");
        }
        if (left == null) {
            throw new IllegalArgumentException("Element left must not be null.");
        }
        if (op == null) {
            throw new IllegalArgumentException("Element op must not be null.");
        }
        if (right == null) {
            throw new IllegalArgumentException("Element right must not be null.");
        }
        this.source = source;
        this.left = left;
        this.op = op;
        this.right = right;
        left.setParent(this);
        right.setParent(this);
    }

    @Override
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree.Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    @Override
    public void replaceBy(Element other) {
        if (this.parent == null) {
            throw new RuntimeException("Node not attached to tree.");
        }
        for (int i = 0; i < this.parent.size(); ++i) {
            if (this.parent.get(i) != this) continue;
            this.parent.set(i, other);
            return;
        }
    }

    @Override
    public void setSource(WPos source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.source = source;
    }

    @Override
    public WPos getSource() {
        return this.source;
    }

    @Override
    public void setLeft(Expr left) {
        if (left == null) {
            throw new IllegalArgumentException();
        }
        this.left.setParent(null);
        left.setParent(this);
        this.left = left;
    }

    @Override
    public Expr getLeft() {
        return this.left;
    }

    @Override
    public void setOp(WurstOperator op) {
        if (op == null) {
            throw new IllegalArgumentException();
        }
        this.op = op;
    }

    @Override
    public WurstOperator getOp() {
        return this.op;
    }

    @Override
    public void setRight(Expr right) {
        if (right == null) {
            throw new IllegalArgumentException();
        }
        this.right.setParent(null);
        right.setParent(this);
        this.right = right;
    }

    @Override
    public Expr getRight() {
        return this.right;
    }

    @Override
    public Element get(int i) {
        switch (i) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public Element set(int i, Element newElem) {
        switch (i) {
            case 0: {
                Expr oldElem = this.left;
                this.setLeft((Expr)newElem);
                return oldElem;
            }
            case 1: {
                Expr oldElem = this.right;
                this.setRight((Expr)newElem);
                return oldElem;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public void forEachElement(Consumer<? super Element> action) {
        action.accept(this.left);
        action.accept(this.right);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public ExprBinary copy() {
        ExprBinaryImpl result = new ExprBinaryImpl(this.source, this.left.copy(), this.op, this.right.copy());
        return result;
    }

    @Override
    public ExprBinary copyWithRefs() {
        ExprBinary res = this.copy();
        return res;
    }

    @Override
    public void clearAttributes() {
        this.left.clearAttributes();
        this.right.clearAttributes();
        this.clearAttributesLocal();
    }

    @Override
    public void clearAttributesLocal() {
        this.zzattr_attrReadVariables_state = 0;
        this.zzattr_attrTyp_state = 0;
        this.zzattr_attrConstantValue_state = 0;
        this.zzattr_attrTypRaw_state = 0;
        this.zzattr_attrExpectedTypRaw_state = 0;
        this.zzattr_attrExpectedTyp_state = 0;
        this.zzattr_attrFuncLink_state = 0;
        this.zzattr_attrUsedGlobalVariables_state = 0;
        this.zzattr_attrReadGlobalVariables_state = 0;
    }

    @Override
    public void accept(Element.Visitor v) {
        v.visit(this);
    }

    @Override
    public <T> T match(VarInitialization.Matcher<T> matcher) {
        return matcher.case_ExprBinary(this);
    }

    @Override
    public void match(VarInitialization.MatcherVoid matcher) {
        matcher.case_ExprBinary(this);
    }

    @Override
    public <T> T match(HasReadVariables.Matcher<T> matcher) {
        return matcher.case_ExprBinary(this);
    }

    @Override
    public void match(HasReadVariables.MatcherVoid matcher) {
        matcher.case_ExprBinary(this);
    }

    @Override
    public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_ExprBinary(this);
    }

    @Override
    public void match(Element.MatcherVoid matcher) {
        matcher.case_ExprBinary(this);
    }

    @Override
    public <T> T match(OptExpr.Matcher<T> matcher) {
        return matcher.case_ExprBinary(this);
    }

    @Override
    public void match(OptExpr.MatcherVoid matcher) {
        matcher.case_ExprBinary(this);
    }

    @Override
    public <T> T match(Expr.Matcher<T> matcher) {
        return matcher.case_ExprBinary(this);
    }

    @Override
    public void match(Expr.MatcherVoid matcher) {
        matcher.case_ExprBinary(this);
    }

    @Override
    public <T> T match(AstElementWithSource.Matcher<T> matcher) {
        return matcher.case_ExprBinary(this);
    }

    @Override
    public void match(AstElementWithSource.MatcherVoid matcher) {
        matcher.case_ExprBinary(this);
    }

    @Override
    public <T> T match(ExprOrStatements.Matcher<T> matcher) {
        return matcher.case_ExprBinary(this);
    }

    @Override
    public void match(ExprOrStatements.MatcherVoid matcher) {
        matcher.case_ExprBinary(this);
    }

    public String toString() {
        return "ExprBinary(" + this.source + ", " + this.left + ", " + this.op + ", " + this.right + ")";
    }

    @Override
    public boolean structuralEquals(Element e) {
        if (e instanceof ExprBinary) {
            ExprBinary o = (ExprBinary)e;
            return this.left.structuralEquals(o.getLeft()) && Objects.equals((Object)this.op, (Object)o.getOp()) && this.right.structuralEquals(o.getRight());
        }
        return false;
    }

    @Override
    public ImmutableList<NameDef> attrReadVariables() {
        if (this.zzattr_attrReadVariables_state == 0) {
            try {
                this.zzattr_attrReadVariables_state = 1;
                this.zzattr_attrReadVariables_cache = ReadVariables.calculate(this);
            }
            finally {
                this.zzattr_attrReadVariables_state = 0;
            }
            this.zzattr_attrReadVariables_state = 2;
        } else if (this.zzattr_attrReadVariables_state == 1) {
            throw new CyclicDependencyError(this, "attrReadVariables");
        }
        return this.zzattr_attrReadVariables_cache;
    }

    @Override
    public WurstType attrTyp() {
        if (this.zzattr_attrTyp_state == 0) {
            try {
                this.zzattr_attrTyp_state = 1;
                this.zzattr_attrTyp_cache = AttrExprType.normalizedType(this);
            }
            finally {
                this.zzattr_attrTyp_state = 0;
            }
            this.zzattr_attrTyp_state = 2;
        } else if (this.zzattr_attrTyp_state == 1) {
            throw new CyclicDependencyError(this, "attrTyp");
        }
        return this.zzattr_attrTyp_cache;
    }

    @Override
    public ILconst attrConstantValue() {
        if (this.zzattr_attrConstantValue_state == 0) {
            try {
                this.zzattr_attrConstantValue_state = 1;
                this.zzattr_attrConstantValue_cache = AttrConstantValue.calculate(this);
            }
            finally {
                this.zzattr_attrConstantValue_state = 0;
            }
            this.zzattr_attrConstantValue_state = 2;
        } else if (this.zzattr_attrConstantValue_state == 1) {
            throw new CyclicDependencyError(this, "attrConstantValue");
        }
        return this.zzattr_attrConstantValue_cache;
    }

    @Override
    public WurstType attrTypRaw() {
        if (this.zzattr_attrTypRaw_state == 0) {
            try {
                this.zzattr_attrTypRaw_state = 1;
                this.zzattr_attrTypRaw_cache = AttrExprType.calculate(this);
            }
            finally {
                this.zzattr_attrTypRaw_state = 0;
            }
            this.zzattr_attrTypRaw_state = 2;
        } else if (this.zzattr_attrTypRaw_state == 1) {
            throw new CyclicDependencyError(this, "attrTypRaw");
        }
        return this.zzattr_attrTypRaw_cache;
    }

    @Override
    public WurstType attrExpectedTypRaw() {
        if (this.zzattr_attrExpectedTypRaw_state == 0) {
            try {
                this.zzattr_attrExpectedTypRaw_state = 1;
                this.zzattr_attrExpectedTypRaw_cache = AttrExprExpectedType.calculate(this);
            }
            finally {
                this.zzattr_attrExpectedTypRaw_state = 0;
            }
            this.zzattr_attrExpectedTypRaw_state = 2;
        } else if (this.zzattr_attrExpectedTypRaw_state == 1) {
            throw new CyclicDependencyError(this, "attrExpectedTypRaw");
        }
        return this.zzattr_attrExpectedTypRaw_cache;
    }

    @Override
    public WurstType attrExpectedTyp() {
        if (this.zzattr_attrExpectedTyp_state == 0) {
            try {
                this.zzattr_attrExpectedTyp_state = 1;
                this.zzattr_attrExpectedTyp_cache = AttrExprExpectedType.normalizedType(this);
            }
            finally {
                this.zzattr_attrExpectedTyp_state = 0;
            }
            this.zzattr_attrExpectedTyp_state = 2;
        } else if (this.zzattr_attrExpectedTyp_state == 1) {
            throw new CyclicDependencyError(this, "attrExpectedTyp");
        }
        return this.zzattr_attrExpectedTyp_cache;
    }

    @Override
    public WurstType attrExpectedTypAfterOverloading() {
        return AttrExprExpectedType.afterOverloading(this);
    }

    @Override
    public boolean attrIsDynamicContext() {
        return IsDynamicContext.calculate(this);
    }

    @Override
    public @Nullable PackageOrGlobal attrNearestPackage() {
        return AttrNearest.nearestPackage(this);
    }

    @Override
    public @Nullable NamedScope attrNearestNamedScope() {
        return AttrNearest.nearestNamedScope(this);
    }

    @Override
    public @Nullable WScope attrNearestScope() {
        return AttrNearest.nearestScope(this);
    }

    @Override
    public String attrPathDescription() {
        return PathDescription.get(this);
    }

    @Override
    public CompilationUnit attrCompilationUnit() {
        return AttrNearest.nearestCompilationUnit(this);
    }

    @Override
    public @Nullable ClassDef attrNearestClassDef() {
        return AttrNearest.nearestClassDef(this);
    }

    @Override
    public @Nullable ClassOrInterface attrNearestClassOrInterface() {
        return AttrNearest.nearestClassOrInterface(this);
    }

    @Override
    public @Nullable ClassOrModule attrNearestClassOrModule() {
        return AttrNearest.nearestClassOrModule(this);
    }

    @Override
    public @Nullable StructureDef attrNearestStructureDef() {
        return AttrNearest.nearestStructureDef(this);
    }

    @Override
    public @Nullable FunctionImplementation attrNearestFuncDef() {
        return AttrNearest.nearestFuncDef(this);
    }

    @Override
    public @Nullable ExprClosure attrNearestExprClosure() {
        return AttrNearest.nearestExprClosure(this);
    }

    @Override
    public @Nullable ExprStatementsBlock attrNearestExprStatementsBlock() {
        return AttrNearest.nearestExprStatementsBlock(this);
    }

    @Override
    public @Nullable NameDef tryGetNameDef() {
        return AttrNameDef.tryGetNameDef(this);
    }

    @Override
    public WPos attrSource() {
        return AttrPos.getPos(this);
    }

    @Override
    public WPos attrErrorPos() {
        return AttrPos.getErrorPos(this);
    }

    @Override
    public WurstModel getModel() {
        return AttrImportedPackage.getModel(this);
    }

    @Override
    public ImExpr imTranslateExpr(ImTranslator translator, ImFunction f) {
        return ExprTranslation.translate(this, translator, f);
    }

    @Override
    public ImExprOpt imTranslateExprOpt(ImTranslator translator, ImFunction f) {
        return ExprTranslation.translate(this, translator, f);
    }

    @Override
    public void addError(String msg) {
        ErrorHandling.addError(this, msg);
    }

    @Override
    public void addWarning(String msg) {
        ErrorHandling.addWarning(this, msg);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return ErrorHandling.getErrorHandler(this);
    }

    @Override
    public FuncLink attrFuncLink() {
        if (this.zzattr_attrFuncLink_state == 0) {
            try {
                this.zzattr_attrFuncLink_state = 1;
                this.zzattr_attrFuncLink_cache = AttrFuncDef.calculate(this);
            }
            finally {
                this.zzattr_attrFuncLink_state = 0;
            }
            this.zzattr_attrFuncLink_state = 2;
        } else if (this.zzattr_attrFuncLink_state == 1) {
            throw new CyclicDependencyError(this, "attrFuncLink");
        }
        return this.zzattr_attrFuncLink_cache;
    }

    @Override
    public FunctionDefinition attrFuncDef() {
        return AttrFuncDef.calculateDef(this);
    }

    @Override
    public @Nullable TypeDef lookupType(String name, boolean showErrors) {
        return NameResolution.lookupType(this, name, showErrors);
    }

    @Override
    public PackageLink lookupPackage(String name, boolean showErrors) {
        return NameResolution.lookupPackage(this, name, showErrors);
    }

    @Override
    public NameLink lookupVar(String name, boolean showErrors) {
        return NameResolution.lookupVar(this, name, showErrors);
    }

    @Override
    public NameLink lookupVarNoConfig(String name, boolean showErrors) {
        return NameResolution.lookupVarNoConfig(this, name, showErrors);
    }

    @Override
    public NameLink lookupMemberVar(WurstType receiverType, String name, boolean showErrors) {
        return NameResolution.lookupMemberVar(this, receiverType, name, showErrors);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupFuncs(String name, boolean showErrors) {
        return NameResolution.lookupFuncs(this, name, showErrors);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupFuncsNoConfig(String name, boolean showErrors) {
        return NameResolution.lookupFuncsNoConfig(this, name, showErrors);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupMemberFuncs(WurstType receiverType, String name, boolean showErrors) {
        return NameResolution.lookupMemberFuncs(this, receiverType, name, showErrors);
    }

    @Override
    public @Nullable TypeDef lookupType(String name) {
        return NameResolution.lookupTypeShort(this, name);
    }

    @Override
    public PackageLink lookupPackage(String name) {
        return NameResolution.lookupPackageShort(this, name);
    }

    @Override
    public NameLink lookupVar(String name) {
        return NameResolution.lookupVarShort(this, name);
    }

    @Override
    public NameLink lookupMemberVar(WurstType receiverType, String name) {
        return NameResolution.lookupMemberVarShort(this, receiverType, name);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupFuncs(String name) {
        return NameResolution.lookupFuncsShort(this, name);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupMemberFuncs(WurstType receiverType, String name) {
        return NameResolution.lookupMemberFuncsShort(this, receiverType, name);
    }

    @Override
    public com.google.common.collect.ImmutableList<VarDef> attrUsedGlobalVariables() {
        if (this.zzattr_attrUsedGlobalVariables_state == 0) {
            com.google.common.collect.ImmutableList<VarDef> r;
            this.zzattr_attrUsedGlobalVariables_state = 1;
            this.zzattr_attrUsedGlobalVariables_cache = Utils.emptyList();
            while (true) {
                r = UsedGlobalVariables.getUsedGlobals(this);
                if (this.zzattr_attrUsedGlobalVariables_state != 3 || this.zzattr_attrUsedGlobalVariables_cache.equals(r)) break;
                this.zzattr_attrUsedGlobalVariables_cache = r;
            }
            this.zzattr_attrUsedGlobalVariables_cache = r;
            this.zzattr_attrUsedGlobalVariables_state = 2;
        } else if (this.zzattr_attrUsedGlobalVariables_state == 1) {
            this.zzattr_attrUsedGlobalVariables_state = 3;
        }
        return this.zzattr_attrUsedGlobalVariables_cache;
    }

    @Override
    public com.google.common.collect.ImmutableList<VarDef> attrReadGlobalVariables() {
        if (this.zzattr_attrReadGlobalVariables_state == 0) {
            com.google.common.collect.ImmutableList<VarDef> r;
            this.zzattr_attrReadGlobalVariables_state = 1;
            this.zzattr_attrReadGlobalVariables_cache = Utils.emptyList();
            while (true) {
                r = UsedGlobalVariables.getReadGlobals(this);
                if (this.zzattr_attrReadGlobalVariables_state != 3 || this.zzattr_attrReadGlobalVariables_cache.equals(r)) break;
                this.zzattr_attrReadGlobalVariables_cache = r;
            }
            this.zzattr_attrReadGlobalVariables_cache = r;
            this.zzattr_attrReadGlobalVariables_state = 2;
        } else if (this.zzattr_attrReadGlobalVariables_state == 1) {
            this.zzattr_attrReadGlobalVariables_state = 3;
        }
        return this.zzattr_attrReadGlobalVariables_cache;
    }

    @Override
    public ImmutableCollection<WPackage> attrUsedPackages() {
        return UsedPackages.usedPackages(this);
    }

    @Override
    public String description() {
        return Description.description(this);
    }

    @Override
    public String descriptionHtml() {
        return DescriptionHtml.description(this);
    }

    @Override
    public boolean isSubtreeOf(Element other) {
        return SmallHelpers.isSubtreeOf(this, other);
    }

    @Override
    public void prettyPrint(Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.prettyPrint(this, spacer, sb, indent);
    }
}

