/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.port.win;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.port.Context;
import net.moonlightflower.wc3libs.port.GameDirFinder;
import net.moonlightflower.wc3libs.port.GameExeFinder;
import net.moonlightflower.wc3libs.port.GameVersion;
import net.moonlightflower.wc3libs.port.GameVersionFinder;
import net.moonlightflower.wc3libs.port.NotFoundException;
import net.moonlightflower.wc3libs.port.Orient;
import net.moonlightflower.wc3libs.port.win.WinGameDirFinder;
import net.moonlightflower.wc3libs.port.win.WinGameVersionFinder;
import net.moonlightflower.wc3libs.port.win.registry.WinRegistryGameExeFinder;

public class WinGameExeFinder
extends GameExeFinder {
    public static final Path WAR3_EXE_PATH = Paths.get("war3.exe", new String[0]);
    public static final Path WARCRAFT_III_EXE_PATH = Paths.get("Warcraft III.exe", new String[0]);
    public static final Path FROZEN_THRONE_EXE_PATH = Paths.get("Frozen Throne.exe", new String[0]);
    public static final Path X86_DIR = Paths.get("x86", new String[0]);
    public static final Path X64_DIR = Paths.get("x86_64", new String[0]);
    public static final Path RETAIL_DIR = Paths.get("_retail_", new String[0]);
    public static final Path RETAIL_X86_DIR = RETAIL_DIR.resolve("x86");
    public static final Path RETAIL_X64_DIR = RETAIL_DIR.resolve("x86_64");
    public static final Path X86_EXE_PATH_131 = X86_DIR.resolve(WARCRAFT_III_EXE_PATH);
    public static final Path X64_EXE_PATH_131 = X64_DIR.resolve(WARCRAFT_III_EXE_PATH);
    public static final Path X86_EXE_PATH_132 = RETAIL_X86_DIR.resolve(WARCRAFT_III_EXE_PATH);
    public static final Path X64_EXE_PATH_132 = RETAIL_X64_DIR.resolve(WARCRAFT_III_EXE_PATH);

    protected GameExeFinder getRegistryGameExeFinder() {
        return new WinRegistryGameExeFinder();
    }

    protected GameDirFinder getGameDirFinder() {
        return Context.getService(WinGameDirFinder.class);
    }

    protected GameVersionFinder getGameVersionFinder() {
        return Context.getService(WinGameVersionFinder.class);
    }

    @Nonnull
    public static File fromDir(@Nonnull File dir, @Nonnull GameVersion version, @Nonnull Orient.WinArch arch) throws NotFoundException {
        File inDirPath;
        if (version.compareTo(GameVersion.VERSION_1_31) >= 0) {
            switch (arch) {
                case X86: {
                    File inDirPathX86 = new File(dir, X86_EXE_PATH_131.toString());
                    if (inDirPathX86.exists()) {
                        return inDirPathX86;
                    }
                }
                case X64: {
                    File inDirPathX64 = new File(dir, X64_EXE_PATH_131.toString());
                    if (inDirPathX64.exists()) {
                        return inDirPathX64;
                    }
                    return inDirPathX64;
                }
            }
        } else if (version.compareTo(GameVersion.VERSION_1_29) >= 0 && (inDirPath = new File(dir, WARCRAFT_III_EXE_PATH.toString())).exists()) {
            return inDirPath;
        }
        inDirPath = new File(dir, WAR3_EXE_PATH.toString());
        if (inDirPath.exists()) {
            return inDirPath;
        }
        throw new NotFoundException();
    }

    @Nonnull
    public static File fromDirIgnoreVersion(@Nonnull File dir, @Nonnull Orient.WinArch arch) throws NotFoundException {
        switch (arch) {
            case X86: {
                File inDirPathX86 = new File(dir, X86_EXE_PATH_131.toString());
                if (!inDirPathX86.exists()) break;
                return inDirPathX86;
            }
            case X64: {
                File inDirPathX64 = new File(dir, X64_EXE_PATH_131.toString());
                if (!inDirPathX64.exists()) break;
                return inDirPathX64;
            }
        }
        return Stream.of(WARCRAFT_III_EXE_PATH, FROZEN_THRONE_EXE_PATH, WAR3_EXE_PATH, X86_EXE_PATH_131, X64_EXE_PATH_131, X86_EXE_PATH_132, X64_EXE_PATH_132).map(relativePath -> dir.toPath().resolve((Path)relativePath)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().orElseThrow(() -> new NotFoundException("tried all known wc3 sub-paths in " + dir.getAbsolutePath())).toFile();
    }

    @Nonnull
    public static File fromDirIgnoreVersion(@Nonnull File dir) throws NotFoundException {
        return WinGameExeFinder.fromDirIgnoreVersion(dir, Orient.getWinArch());
    }

    @Nonnull
    private File getGameExeInDir(@Nonnull File dir) throws NotFoundException {
        GameVersionFinder gameVersionFinder = this.getGameVersionFinder();
        try {
            GameVersion gameVersion = (GameVersion)gameVersionFinder.get();
            return WinGameExeFinder.fromDir(dir, gameVersion, Orient.getWinArch());
        }
        catch (NotFoundException ignored) {
            return WinGameExeFinder.fromDirIgnoreVersion(dir);
        }
    }

    @Override
    @Nonnull
    public File find() throws NotFoundException {
        GameExeFinder winRegistryGameExeFinder = this.getRegistryGameExeFinder();
        try {
            return (File)winRegistryGameExeFinder.get();
        }
        catch (NotFoundException notFoundException) {
            GameDirFinder gameDirFinder = this.getGameDirFinder();
            try {
                File gameDir = (File)gameDirFinder.get();
                return this.getGameExeInDir(gameDir);
            }
            catch (NotFoundException notFoundException2) {
                throw new NotFoundException();
            }
        }
    }
}

