/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.peeeq.wurstscript.ast.AstElementWithTypeParameters;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExtensionFuncDef;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.FunctionDefinition;
import de.peeeq.wurstscript.ast.HasFunctionSignature;
import de.peeeq.wurstscript.ast.HasModifier;
import de.peeeq.wurstscript.ast.NativeFunc;
import de.peeeq.wurstscript.ast.TupleDef;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.TypeParamDefs;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.ast.WParameters;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.VariablePosition;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeUnknown;
import de.peeeq.wurstscript.types.WurstTypeVararg;
import de.peeeq.wurstscript.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import org.eclipse.jdt.annotation.Nullable;

public class FunctionSignature {
    public static final FunctionSignature empty = new FunctionSignature(null, VariableBinding.emptyMapping(), null, "?", Collections.emptyList(), Collections.emptyList(), WurstTypeUnknown.instance());
    private final HasFunctionSignature trace;
    private final @Nullable WurstType receiverType;
    private final List<WurstType> paramTypes;
    private final List<String> paramNames;
    private final WurstType returnType;
    private final VariableBinding mapping;
    private final boolean isVararg;
    private final String name;

    public FunctionSignature(HasFunctionSignature trace, VariableBinding mapping, @Nullable WurstType receiverType, String name, List<WurstType> paramTypes, List<String> paramNames, WurstType returnType) {
        this.trace = trace;
        this.mapping = mapping;
        this.name = name;
        Preconditions.checkNotNull(paramTypes);
        Preconditions.checkNotNull((Object)returnType);
        this.isVararg = this.hasVarargParam(paramTypes);
        this.receiverType = receiverType;
        this.paramTypes = paramTypes;
        this.returnType = returnType;
        this.paramNames = paramNames;
    }

    private boolean hasVarargParam(List<WurstType> paramTypes) {
        if (paramTypes.isEmpty()) {
            return false;
        }
        return Utils.getLast(paramTypes) instanceof WurstTypeVararg;
    }

    public List<WurstType> getParamTypes() {
        return this.paramTypes;
    }

    public WurstType getReturnType() {
        return this.returnType;
    }

    public @Nullable WurstType getReceiverType() {
        return this.receiverType;
    }

    @CheckReturnValue
    public FunctionSignature setTypeArgs(Element context, VariableBinding newMapping) {
        if (newMapping.isEmpty()) {
            return this;
        }
        WurstType r2 = this.returnType.setTypeArgs(newMapping);
        ArrayList pt2 = Lists.newArrayList();
        for (WurstType p : this.paramTypes) {
            pt2.add(p.setTypeArgs(newMapping));
        }
        return new FunctionSignature(this.trace, newMapping, this.receiverType, this.name, pt2, this.paramNames, r2);
    }

    public static FunctionSignature forFunctionDefinition(@Nullable FunctionDefinition f) {
        if (f == null) {
            return empty;
        }
        WurstType returnType = f.attrReturnTyp();
        if (f instanceof TupleDef) {
            TupleDef tupleDef = (TupleDef)f;
            returnType = tupleDef.attrTyp().dynamic();
        }
        ImmutableList<WurstType> paramTypes = f.attrParameterTypes();
        List<String> paramNames = FunctionSignature.getParamNames(f.getParameters());
        TypeParamDefs typeParams = Collections.emptyList();
        if (f instanceof AstElementWithTypeParameters) {
            typeParams = ((AstElementWithTypeParameters)((Object)f)).getTypeParameters();
        }
        return new FunctionSignature(f, VariableBinding.emptyMapping().withTypeVariables(typeParams), f.attrReceiverType(), f.getName(), (List<WurstType>)paramTypes, paramNames, returnType);
    }

    public static List<String> getParamNames(WParameters parameters) {
        return parameters.stream().map(WParameter::getName).collect(Collectors.toList());
    }

    public static FunctionSignature fromNameLink(FuncLink f) {
        VariableBinding mapping = f.getVariableBinding();
        mapping = mapping.withTypeVariables(f.getTypeParams());
        return new FunctionSignature(f.getDef(), mapping, f.getReceiverType(), f.getName(), f.getParameterTypes(), FunctionSignature.getParamNames(f.getDef().getParameters()), f.getReturnType());
    }

    public boolean isEmpty() {
        return this.receiverType == null && this.paramTypes.isEmpty() && this.returnType instanceof WurstTypeUnknown;
    }

    public String getParameterDescription() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.paramTypes.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.paramTypes.get(i));
            if (i >= this.paramNames.size()) continue;
            sb.append(" ");
            sb.append(this.paramNames.get(i));
        }
        return sb.toString();
    }

    public String getParamName(int i) {
        if (i >= 0 && i < this.paramNames.size()) {
            return this.paramNames.get(i);
        }
        if (this.isVararg) {
            return this.paramNames.get(this.paramNames.size() - 1);
        }
        return "";
    }

    public boolean isValidParameterNumber(int numParams) {
        if (this.isVararg) {
            return numParams >= this.paramTypes.size() - 1;
        }
        return numParams == this.paramTypes.size();
    }

    public int getMinNumParams() {
        if (this.isVararg) {
            return this.paramTypes.size() - 1;
        }
        return this.paramTypes.size();
    }

    public int getMaxNumParams() {
        if (this.isVararg) {
            return Integer.MAX_VALUE;
        }
        return this.paramTypes.size();
    }

    public WurstType getParamType(int i) {
        if (this.isVararg && i >= this.paramTypes.size() - 1) {
            return this.getVarargType();
        }
        if (i >= 0 && i < this.paramTypes.size()) {
            return this.paramTypes.get(i);
        }
        throw new RuntimeException("Parameter index out of bounds: " + i);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.receiverType != null) {
            result.append(this.receiverType).append(".");
        }
        result.append(this.name);
        if (!this.mapping.isEmpty()) {
            result.append(this.mapping);
        }
        result.append("(");
        result.append(this.getParameterDescription());
        result.append(") returns ");
        result.append(this.returnType);
        WPos src = this.trace.attrSource();
        result.append(", defined in ").append(src.getFile()).append(": ").append(src.getLine());
        return result.toString();
    }

    public boolean isVararg() {
        return this.isVararg;
    }

    public WurstType getVarargType() {
        Preconditions.checkArgument((boolean)this.isVararg);
        return ((WurstTypeVararg)this.paramTypes.get(this.paramTypes.size() - 1)).getBaseType();
    }

    public @Nullable FunctionSignature matchAgainstArgs(List<WurstType> argTypes, Element location) {
        if (!this.isValidParameterNumber(argTypes.size())) {
            return null;
        }
        VariableBinding mapping = this.mapping;
        for (int i = 0; i < argTypes.size(); ++i) {
            WurstType pt = this.getParamType(i);
            WurstType at = argTypes.get(i);
            mapping = at.matchAgainstSupertype(pt, location, mapping, VariablePosition.RIGHT);
            if (mapping != null) continue;
            return null;
        }
        return this.setTypeArgs(location, mapping);
    }

    public List<TypeParamDef> getDefinitionTypeVariables() {
        return this.trace.match(new HasFunctionSignature.Matcher<List<TypeParamDef>>(){

            @Override
            public List<TypeParamDef> case_TupleDef(TupleDef tupleDef) {
                return Collections.emptyList();
            }

            @Override
            public List<TypeParamDef> case_NativeFunc(NativeFunc nativeFunc) {
                return Collections.emptyList();
            }

            @Override
            public List<TypeParamDef> case_FuncDef(FuncDef f) {
                return f.getTypeParameters();
            }

            @Override
            public List<TypeParamDef> case_ExtensionFuncDef(ExtensionFuncDef f) {
                return f.getTypeParameters();
            }

            @Override
            public List<TypeParamDef> case_ConstructorDef(ConstructorDef c) {
                ClassDef classDef = c.attrNearestClassDef();
                assert (classDef != null);
                return classDef.getTypeParameters();
            }
        });
    }

    public boolean hasIfNotDefinedAnnotation() {
        if (this.trace instanceof HasModifier) {
            HasModifier m = (HasModifier)((Object)this.trace);
            return m.attrHasAnnotation("ifNotDefined");
        }
        return false;
    }

    public ArgsMatchResult tryMatchAgainstArgs(List<WurstType> argTypes, List<Expr> args, Element location) {
        ImmutableList.Builder errors = ImmutableList.builder();
        int badness = 0;
        if (!this.isValidParameterNumber(argTypes.size())) {
            if (argTypes.size() > this.getMaxNumParams()) {
                errors.add((Object)new CompileError(location, "Too many arguments: " + argTypes.size() + " given, but only " + this.getMaxNumParams() + " expected."));
                badness += argTypes.size() - this.getMaxNumParams();
            } else if (argTypes.size() < this.getMinNumParams()) {
                errors.add((Object)new CompileError(location, "Not enough arguments: " + argTypes.size() + " given, but  " + this.getMinNumParams() + " expected."));
                badness += this.getMinNumParams() - argTypes.size();
            }
        }
        VariableBinding mapping = this.mapping;
        for (int i = 0; i < argTypes.size() && i < this.getMaxNumParams(); ++i) {
            WurstType pt = this.getParamType(i);
            WurstType at = argTypes.get(i);
            VariableBinding mapping2 = at.matchAgainstSupertype(pt, location, mapping, VariablePosition.RIGHT);
            if (mapping2 == null) {
                WurstType ptBound = pt.setTypeArgs(mapping);
                Expr arg = args.get(i);
                errors.add((Object)new CompileError(arg.attrErrorPos(), "Wrong argument for parameter " + this.getParamName(i) + ": expected " + ptBound + ", but found " + at + "."));
                ++badness;
                continue;
            }
            mapping = mapping2;
        }
        if (mapping.hasUnboundTypeVars()) {
            errors.add((Object)new CompileError(location, "Could not infer type for type variables " + mapping.printUnboundTypeVars()));
        }
        errors.addAll(mapping.getErrors());
        return new ArgsMatchResult(this.setTypeArgs(location, mapping), (ImmutableList<CompileError>)errors.build(), badness);
    }

    public VariableBinding getMapping() {
        return this.mapping;
    }

    public static class ArgsMatchResult {
        private final FunctionSignature sig;
        private final ImmutableList<CompileError> errors;
        private final int badness;

        public ArgsMatchResult(FunctionSignature sig, ImmutableList<CompileError> errors, int badness) {
            this.sig = sig;
            this.errors = ImmutableList.copyOf(errors);
            this.badness = badness;
        }

        public FunctionSignature getSig() {
            return this.sig;
        }

        public ImmutableList<CompileError> getErrors() {
            return this.errors;
        }

        public int getBadness() {
            return this.badness;
        }
    }
}

