/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImCast;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImExprs;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImNull;
import de.peeeq.wurstscript.jassIm.ImOperatorCall;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImSimpleType;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.CallType;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.TypesHelper;

public class EliminateLocalTypes {
    private static final ImType localSimpleType = JassIm.ImSimpleType("localSimpleType");

    public static void eliminateLocalTypesProg(ImProg imProg, ImTranslator translator) {
        EliminateLocalTypes.transformProgram(imProg, translator);
        for (ImFunction f : ImHelper.calculateFunctionsOfProg(imProg)) {
            EliminateLocalTypes.eliminateLocalTypesFunc(f, translator);
        }
    }

    private static void eliminateLocalTypesFunc(ImFunction f, ImTranslator translator) {
        for (ImVar local : f.getLocals()) {
            ImType t = local.getType();
            if (!(t instanceof ImSimpleType)) continue;
            local.setType(localSimpleType);
        }
    }

    private static void transformProgram(ImProg imProg, final ImTranslator translator) {
        imProg.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImOperatorCall imOperatorCall) {
                super.visit(imOperatorCall);
                ImExprs args = imOperatorCall.getArguments();
                if (imOperatorCall.getOp() == WurstOperator.PLUS && args.size() == 2 && TypesHelper.isStringType(((ImExpr)args.get(0)).attrTyp()) && TypesHelper.isStringType(((ImExpr)args.get(1)).attrTyp())) {
                    imOperatorCall.replaceBy(JassIm.ImFunctionCall(imOperatorCall.attrTrace(), translator.stringConcatFunc, JassIm.ImTypeArguments(new ImTypeArgument[0]), imOperatorCall.getArguments().copy(), false, CallType.NORMAL));
                }
            }

            @Override
            public void visit(ImNull imNull) {
                super.visit(imNull);
                if (TypesHelper.isStringType(imNull.getType())) {
                    imNull.replaceBy(JassIm.ImStringVal(""));
                }
            }

            @Override
            public void visit(ImCast imCast) {
                super.visit(imCast);
                if (TypesHelper.isIntType(imCast.getExpr().attrTyp()) && TypesHelper.isIntType(imCast.getToType())) {
                    imCast.replaceBy(imCast.getExpr().copy());
                }
            }
        });
    }
}

