/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.intermediatelang.optimizer;

import de.peeeq.datastructures.Worklist;
import de.peeeq.wurstscript.intermediatelang.optimizer.ControlFlowGraph;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImConst;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImLExpr;
import de.peeeq.wurstscript.jassIm.ImMemberAccess;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImTupleExpr;
import de.peeeq.wurstscript.jassIm.ImTupleSelection;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.translation.imoptimizer.OptimizerPass;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.TypesHelper;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public class ConstantAndCopyPropagation
implements OptimizerPass {
    private int totalPropagated = 0;

    @Override
    public int optimize(ImTranslator trans) {
        ImProg prog = trans.getImProg();
        this.totalPropagated = 0;
        for (ImFunction func : ImHelper.calculateFunctionsOfProg(prog)) {
            if (func.isNative() || func.isBj()) continue;
            this.optimizeFunc(func);
        }
        return this.totalPropagated;
    }

    @Override
    public String getName() {
        return "Constant and Copy Propagated";
    }

    void optimizeFunc(ImFunction func) {
        ControlFlowGraph cfg = new ControlFlowGraph(func.getBody());
        Map<ControlFlowGraph.Node, Knowledge> knowledge = this.calculateKnowledge(cfg);
        this.rewriteCode(cfg, knowledge);
    }

    private void rewriteCode(ControlFlowGraph cfg, Map<ControlFlowGraph.Node, Knowledge> knowledge) {
        for (ControlFlowGraph.Node node : cfg.getNodes()) {
            ImStmt stmt = node.getStmt();
            if (stmt == null) continue;
            final Knowledge kn = knowledge.get(node);
            stmt.accept(new Element.DefaultVisitor(){

                @Override
                public void visit(ImSet imSet) {
                    ImLExpr e = imSet.getLeft();
                    if (e instanceof ImMemberAccess) {
                        ImMemberAccess ma = (ImMemberAccess)e;
                        ma.accept(this);
                    } else if (e instanceof ImVarArrayAccess) {
                        ImVarArrayAccess vaa = (ImVarArrayAccess)e;
                        for (ImExpr ie : vaa.getIndexes()) {
                            ie.accept(this);
                        }
                    }
                    imSet.getRight().accept(this);
                }

                @Override
                public void visit(ImVarAccess va) {
                    if (va.isUsedAsLValue()) {
                        return;
                    }
                    Value val = (Value)kn.varKnowledge.get((Object)va.getVar()).getOrNull();
                    if (val == null) {
                        return;
                    }
                    if (val.constantValue != null) {
                        va.replaceBy(val.constantValue.copy());
                        ++ConstantAndCopyPropagation.this.totalPropagated;
                    } else if (val.copyVar != null) {
                        va.setVar(val.copyVar);
                        this.visit(va);
                    } else if (val.constantTuple != null) {
                        if (va.getParent() instanceof ImTupleSelection) {
                            ImTupleExpr te;
                            ImTupleSelection ts;
                            Element t = ts = (ImTupleSelection)va.getParent();
                            ImExpr constT = val.constantTuple;
                            while (t instanceof ImTupleSelection) {
                                ts = t;
                                constT = (ImExpr)constT.getExprs().get(ts.getTupleIndex());
                                t = ts.getParent();
                            }
                            boolean replace = true;
                            if (constT instanceof ImTupleExpr && ((te = constT).getExprs().size() != 1 || te.getExprs().get(0) instanceof ImTupleSelection)) {
                                replace = false;
                            }
                            if (replace) {
                                ts.replaceBy(constT.copy());
                            }
                        } else if (val.constantTuple.getExprs().size() == 1 && !(val.constantTuple.getExprs().get(0) instanceof ImTupleSelection)) {
                            va.replaceBy(val.constantTuple.copy());
                        }
                        ++ConstantAndCopyPropagation.this.totalPropagated;
                    }
                }
            });
        }
    }

    private Map<ControlFlowGraph.Node, Knowledge> calculateKnowledge(ControlFlowGraph cfg) {
        java.util.HashMap<ControlFlowGraph.Node, Knowledge> knowledge = new java.util.HashMap<ControlFlowGraph.Node, Knowledge>();
        for (ControlFlowGraph.Node n : cfg.getNodes()) {
            knowledge.put(n, new Knowledge());
        }
        Worklist<ControlFlowGraph.Node> todo = new Worklist<ControlFlowGraph.Node>(cfg.getNodes());
        while (!todo.isEmpty()) {
            ControlFlowGraph.Node n;
            n = todo.poll();
            Knowledge kn = (Knowledge)knowledge.get(n);
            HashMap newKnowledge = HashMap.empty();
            if (!n.getPredecessors().isEmpty()) {
                HashMap predKnowledgeOut;
                ControlFlowGraph.Node pred1 = n.getPredecessors().get(0);
                newKnowledge = predKnowledgeOut = ((Knowledge)knowledge.get((Object)pred1)).varKnowledgeOut;
                if (n.getPredecessors().size() > 1) {
                    for (Tuple2 e : predKnowledgeOut) {
                        ImVar var = (ImVar)e._1();
                        Value val = (Value)e._2();
                        boolean allSame = true;
                        for (int i = 1; i < n.getPredecessors().size(); ++i) {
                            ControlFlowGraph.Node predi = n.getPredecessors().get(i);
                            Value predi_val = (Value)((Knowledge)knowledge.get((Object)predi)).varKnowledgeOut.get((Object)var).getOrNull();
                            if (predi_val != null && predi_val.equalValue(val)) continue;
                            allSame = false;
                            break;
                        }
                        if (allSame) continue;
                        newKnowledge = newKnowledge.remove((Object)var);
                    }
                }
            }
            HashMap newOut = newKnowledge;
            ImStmt stmt = n.getStmt();
            if (stmt instanceof ImSet) {
                ImVar var;
                ImSet imSet = (ImSet)stmt;
                if (imSet.getLeft() instanceof ImVarAccess) {
                    var = ((ImVarAccess)imSet.getLeft()).getVar();
                    if (var != null && !var.isGlobal()) {
                        Value newValue = null;
                        ImExpr right = imSet.getRight();
                        if (right instanceof ImConst) {
                            newValue = Value.tryValue(right);
                        } else if (right instanceof ImVarAccess) {
                            ImVar varRight = ((ImVarAccess)right).getVar();
                            newValue = newOut.containsKey((Object)varRight) ? (Value)newOut.get((Object)varRight).getOrNull() : Value.tryValue(right);
                        } else if (right instanceof ImTupleExpr) {
                            newValue = Value.tryValue(right);
                        }
                        newOut = newValue == null ? newOut.remove((Object)var) : newOut.put((Object)var, (Object)newValue);
                        Value varAsValue = new Value(var);
                        for (Tuple2 p : newOut) {
                            if (!((Value)p._2()).equalValue(varAsValue)) continue;
                            newOut = newOut.remove((Object)((ImVar)p._1()));
                        }
                    }
                } else if (imSet.getLeft() instanceof ImTupleSelection && (var = TypesHelper.getSimpleAndPureTupleVar((ImTupleSelection)imSet.getLeft())) != null) {
                    Value rightVal = Value.tryValue(imSet.getRight());
                    Value existingValue = (Value)newOut.get((Object)var).getOrNull();
                    if (rightVal != null && existingValue != null && existingValue.constantTuple != null) {
                        ImTupleExpr te;
                        ImExpr knownTuple = te = existingValue.constantTuple.copy();
                        Element left = imSet.getLeft();
                        while (left instanceof ImTupleSelection) {
                            left = ((ImTupleSelection)left).getTupleExpr();
                        }
                        while (left != imSet.getLeft()) {
                            left = left.getParent();
                            knownTuple = (ImExpr)knownTuple.getExprs().get(((ImTupleSelection)left).getTupleIndex());
                        }
                        knownTuple.replaceBy(imSet.getRight().copy());
                        newOut = newOut.put((Object)var, (Object)new Value(te));
                    } else {
                        newOut = newOut.remove((Object)var);
                    }
                    Value varAsValue = new Value(var);
                    for (Tuple2 p : newOut) {
                        if (!((Value)p._2()).equalValue(varAsValue)) continue;
                        newOut = newOut.remove((Object)((ImVar)p._1()));
                    }
                }
            }
            if (!kn.varKnowledgeOut.equals((Object)newOut)) {
                todo.addAll(n.getSuccessors());
            }
            kn.varKnowledge = newKnowledge;
            kn.varKnowledgeOut = newOut;
        }
        return knowledge;
    }

    static class Knowledge {
        HashMap<ImVar, Value> varKnowledge = HashMap.empty();
        HashMap<ImVar, Value> varKnowledgeOut = HashMap.empty();

        Knowledge() {
        }

        public String toString() {
            return "[in =" + this.varKnowledge + ", out=" + this.varKnowledgeOut + "]";
        }
    }

    static class Value {
        final @Nullable ImVar copyVar;
        final @Nullable ImConst constantValue;
        ImTupleExpr constantTuple;

        public Value(ImVar copyVar) {
            this.copyVar = copyVar;
            this.constantValue = null;
            this.constantTuple = null;
            if (copyVar.isGlobal()) {
                throw new IllegalArgumentException("copyVar must not be a Global.");
            }
        }

        public Value(ImConst constantValue) {
            this.copyVar = null;
            this.constantValue = constantValue;
            this.constantTuple = null;
        }

        public Value(ImTupleExpr tupleExpr) {
            this.copyVar = null;
            this.constantValue = null;
            this.constantTuple = tupleExpr;
            for (ImExpr e : tupleExpr.getExprs()) {
                if (Value.tryValue(e) != null) continue;
                throw new IllegalArgumentException("tupleExpr must only contain constant values.");
            }
        }

        public static Value tryValue(ImExpr e) {
            try {
                if (e instanceof ImVarAccess) {
                    return new Value(((ImVarAccess)e).getVar());
                }
                if (e instanceof ImConst) {
                    return new Value((ImConst)e);
                }
                if (e instanceof ImTupleExpr) {
                    return new Value((ImTupleExpr)e);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return null;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof Value) {
                return this.equalValue((Value)obj);
            }
            return false;
        }

        public boolean equalValue(Value other) {
            if (this.copyVar != null && other.copyVar != null) {
                return this.copyVar == other.copyVar;
            }
            if (this.constantValue != null && other.constantValue != null) {
                return this.constantValue.equalValue(other.constantValue);
            }
            if (this.constantTuple != null && other.constantTuple != null) {
                ImTupleExpr a = this.constantTuple;
                ImTupleExpr b = other.constantTuple;
                if (!a.attrTyp().equalsType(b.attrTyp())) {
                    return false;
                }
                for (int i = 0; i < a.getExprs().size(); ++i) {
                    Value bV;
                    Value aV = Value.tryValue((ImExpr)a.getExprs().get(i));
                    if (aV.equalValue(bV = Value.tryValue((ImExpr)b.getExprs().get(i)))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public String toString() {
            if (this.copyVar != null) {
                return "copy of " + this.copyVar;
            }
            if (this.constantValue != null) {
                return "constant " + this.constantValue;
            }
            return "tuple of " + this.constantTuple;
        }
    }
}

