/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.ast;

import com.google.common.collect.ImmutableCollection;
import de.peeeq.immutablecollections.ImmutableList;
import de.peeeq.wurstscript.ast.AstElementWithSource;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ClassOrInterface;
import de.peeeq.wurstscript.ast.ClassOrModule;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.CompoundStatement;
import de.peeeq.wurstscript.ast.ControlflowStatement;
import de.peeeq.wurstscript.ast.CyclicDependencyError;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprOrStatements;
import de.peeeq.wurstscript.ast.ExprStatementsBlock;
import de.peeeq.wurstscript.ast.FunctionImplementation;
import de.peeeq.wurstscript.ast.HasReadVariables;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NamedScope;
import de.peeeq.wurstscript.ast.PackageOrGlobal;
import de.peeeq.wurstscript.ast.StructureDef;
import de.peeeq.wurstscript.ast.SwitchCases;
import de.peeeq.wurstscript.ast.SwitchDefaultCase;
import de.peeeq.wurstscript.ast.SwitchStmt;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.VarDef;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.ast.WStatement;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.AttrImportedPackage;
import de.peeeq.wurstscript.attributes.AttrNameDef;
import de.peeeq.wurstscript.attributes.AttrNearest;
import de.peeeq.wurstscript.attributes.AttrPos;
import de.peeeq.wurstscript.attributes.Description;
import de.peeeq.wurstscript.attributes.DescriptionHtml;
import de.peeeq.wurstscript.attributes.ErrorHandler;
import de.peeeq.wurstscript.attributes.ErrorHandling;
import de.peeeq.wurstscript.attributes.Flow;
import de.peeeq.wurstscript.attributes.IsDynamicContext;
import de.peeeq.wurstscript.attributes.PathDescription;
import de.peeeq.wurstscript.attributes.ReadVariables;
import de.peeeq.wurstscript.attributes.SmallHelpers;
import de.peeeq.wurstscript.attributes.SwitchStatements;
import de.peeeq.wurstscript.attributes.UsedGlobalVariables;
import de.peeeq.wurstscript.attributes.UsedPackages;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.attributes.names.NameResolution;
import de.peeeq.wurstscript.attributes.names.PackageLink;
import de.peeeq.wurstscript.attributes.prettyPrint.PrettyPrinter;
import de.peeeq.wurstscript.attributes.prettyPrint.Spacer;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.translation.imtranslation.StmtTranslation;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.utils.Utils;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.Nullable;

class SwitchStmtImpl
implements SwitchStmt {
    private Element parent;
    private WPos source;
    private Expr expr;
    private SwitchCases cases;
    private SwitchDefaultCase switchDefault;
    private int zzattr_attrNextStatements_state = 0;
    private List<WStatement> zzattr_attrNextStatements_cache;
    private int zzattr_attrPreviousStatements_state = 0;
    private List<WStatement> zzattr_attrPreviousStatements_cache;
    private int zzattr_attrAfterBodyStatements_state = 0;
    private List<WStatement> zzattr_attrAfterBodyStatements_cache;
    private int zzattr_attrListIndex_state = 0;
    private int zzattr_attrListIndex_cache;
    private int zzattr_attrReadVariables_state = 0;
    private ImmutableList<NameDef> zzattr_attrReadVariables_cache;
    private int zzattr_attrUsedGlobalVariables_state = 0;
    private com.google.common.collect.ImmutableList<VarDef> zzattr_attrUsedGlobalVariables_cache;
    private int zzattr_attrReadGlobalVariables_state = 0;
    private com.google.common.collect.ImmutableList<VarDef> zzattr_attrReadGlobalVariables_cache;

    SwitchStmtImpl(WPos source, Expr expr, SwitchCases cases, SwitchDefaultCase switchDefault) {
        if (source == null) {
            throw new IllegalArgumentException("Element source must not be null.");
        }
        if (expr == null) {
            throw new IllegalArgumentException("Element expr must not be null.");
        }
        if (cases == null) {
            throw new IllegalArgumentException("Element cases must not be null.");
        }
        if (switchDefault == null) {
            throw new IllegalArgumentException("Element switchDefault must not be null.");
        }
        this.source = source;
        this.expr = expr;
        this.cases = cases;
        this.switchDefault = switchDefault;
        expr.setParent(this);
        cases.setParent(this);
        switchDefault.setParent(this);
    }

    @Override
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree.Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    @Override
    public void replaceBy(Element other) {
        if (this.parent == null) {
            throw new RuntimeException("Node not attached to tree.");
        }
        for (int i = 0; i < this.parent.size(); ++i) {
            if (this.parent.get(i) != this) continue;
            this.parent.set(i, other);
            return;
        }
    }

    @Override
    public void setSource(WPos source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.source = source;
    }

    @Override
    public WPos getSource() {
        return this.source;
    }

    @Override
    public void setExpr(Expr expr) {
        if (expr == null) {
            throw new IllegalArgumentException();
        }
        this.expr.setParent(null);
        expr.setParent(this);
        this.expr = expr;
    }

    @Override
    public Expr getExpr() {
        return this.expr;
    }

    @Override
    public void setCases(SwitchCases cases) {
        if (cases == null) {
            throw new IllegalArgumentException();
        }
        this.cases.setParent(null);
        cases.setParent(this);
        this.cases = cases;
    }

    @Override
    public SwitchCases getCases() {
        return this.cases;
    }

    @Override
    public void setSwitchDefault(SwitchDefaultCase switchDefault) {
        if (switchDefault == null) {
            throw new IllegalArgumentException();
        }
        this.switchDefault.setParent(null);
        switchDefault.setParent(this);
        this.switchDefault = switchDefault;
    }

    @Override
    public SwitchDefaultCase getSwitchDefault() {
        return this.switchDefault;
    }

    @Override
    public Element get(int i) {
        switch (i) {
            case 0: {
                return this.expr;
            }
            case 1: {
                return this.cases;
            }
            case 2: {
                return this.switchDefault;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public Element set(int i, Element newElem) {
        switch (i) {
            case 0: {
                Expr oldElem = this.expr;
                this.setExpr((Expr)newElem);
                return oldElem;
            }
            case 1: {
                SwitchCases oldElem = this.cases;
                this.setCases((SwitchCases)newElem);
                return oldElem;
            }
            case 2: {
                SwitchDefaultCase oldElem = this.switchDefault;
                this.setSwitchDefault((SwitchDefaultCase)newElem);
                return oldElem;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public void forEachElement(Consumer<? super Element> action) {
        action.accept(this.expr);
        action.accept(this.cases);
        action.accept(this.switchDefault);
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    public SwitchStmt copy() {
        SwitchStmtImpl result = new SwitchStmtImpl(this.source, this.expr.copy(), this.cases.copy(), this.switchDefault.copy());
        return result;
    }

    @Override
    public SwitchStmt copyWithRefs() {
        SwitchStmt res = this.copy();
        return res;
    }

    @Override
    public void clearAttributes() {
        this.expr.clearAttributes();
        this.cases.clearAttributes();
        this.switchDefault.clearAttributes();
        this.clearAttributesLocal();
    }

    @Override
    public void clearAttributesLocal() {
        this.zzattr_attrNextStatements_state = 0;
        this.zzattr_attrPreviousStatements_state = 0;
        this.zzattr_attrAfterBodyStatements_state = 0;
        this.zzattr_attrListIndex_state = 0;
        this.zzattr_attrReadVariables_state = 0;
        this.zzattr_attrUsedGlobalVariables_state = 0;
        this.zzattr_attrReadGlobalVariables_state = 0;
    }

    @Override
    public void accept(Element.Visitor v) {
        v.visit(this);
    }

    @Override
    public <T> T match(ControlflowStatement.Matcher<T> matcher) {
        return matcher.case_SwitchStmt(this);
    }

    @Override
    public void match(ControlflowStatement.MatcherVoid matcher) {
        matcher.case_SwitchStmt(this);
    }

    @Override
    public <T> T match(HasReadVariables.Matcher<T> matcher) {
        return matcher.case_SwitchStmt(this);
    }

    @Override
    public void match(HasReadVariables.MatcherVoid matcher) {
        matcher.case_SwitchStmt(this);
    }

    @Override
    public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_SwitchStmt(this);
    }

    @Override
    public void match(Element.MatcherVoid matcher) {
        matcher.case_SwitchStmt(this);
    }

    @Override
    public <T> T match(CompoundStatement.Matcher<T> matcher) {
        return matcher.case_SwitchStmt(this);
    }

    @Override
    public void match(CompoundStatement.MatcherVoid matcher) {
        matcher.case_SwitchStmt(this);
    }

    @Override
    public <T> T match(AstElementWithSource.Matcher<T> matcher) {
        return matcher.case_SwitchStmt(this);
    }

    @Override
    public void match(AstElementWithSource.MatcherVoid matcher) {
        matcher.case_SwitchStmt(this);
    }

    @Override
    public <T> T match(WStatement.Matcher<T> matcher) {
        return matcher.case_SwitchStmt(this);
    }

    @Override
    public void match(WStatement.MatcherVoid matcher) {
        matcher.case_SwitchStmt(this);
    }

    @Override
    public <T> T match(ExprOrStatements.Matcher<T> matcher) {
        return matcher.case_SwitchStmt(this);
    }

    @Override
    public void match(ExprOrStatements.MatcherVoid matcher) {
        matcher.case_SwitchStmt(this);
    }

    public String toString() {
        return "SwitchStmt(" + this.source + ", " + this.expr + ", " + this.cases + ", " + this.switchDefault + ")";
    }

    @Override
    public boolean structuralEquals(Element e) {
        if (e instanceof SwitchStmt) {
            SwitchStmt o = (SwitchStmt)e;
            return this.expr.structuralEquals(o.getExpr()) && this.cases.structuralEquals(o.getCases()) && this.switchDefault.structuralEquals(o.getSwitchDefault());
        }
        return false;
    }

    @Override
    public List<WStatement> attrNextStatements() {
        if (this.zzattr_attrNextStatements_state == 0) {
            try {
                this.zzattr_attrNextStatements_state = 1;
                this.zzattr_attrNextStatements_cache = Flow.getNext(this);
            }
            finally {
                this.zzattr_attrNextStatements_state = 0;
            }
            this.zzattr_attrNextStatements_state = 2;
        } else if (this.zzattr_attrNextStatements_state == 1) {
            throw new CyclicDependencyError(this, "attrNextStatements");
        }
        return this.zzattr_attrNextStatements_cache;
    }

    @Override
    public List<WStatement> attrPreviousStatements() {
        if (this.zzattr_attrPreviousStatements_state == 0) {
            try {
                this.zzattr_attrPreviousStatements_state = 1;
                this.zzattr_attrPreviousStatements_cache = Flow.getPrevious(this);
            }
            finally {
                this.zzattr_attrPreviousStatements_state = 0;
            }
            this.zzattr_attrPreviousStatements_state = 2;
        } else if (this.zzattr_attrPreviousStatements_state == 1) {
            throw new CyclicDependencyError(this, "attrPreviousStatements");
        }
        return this.zzattr_attrPreviousStatements_cache;
    }

    @Override
    public List<WStatement> attrAfterBodyStatements() {
        if (this.zzattr_attrAfterBodyStatements_state == 0) {
            try {
                this.zzattr_attrAfterBodyStatements_state = 1;
                this.zzattr_attrAfterBodyStatements_cache = Flow.getAfterBody(this);
            }
            finally {
                this.zzattr_attrAfterBodyStatements_state = 0;
            }
            this.zzattr_attrAfterBodyStatements_state = 2;
        } else if (this.zzattr_attrAfterBodyStatements_state == 1) {
            throw new CyclicDependencyError(this, "attrAfterBodyStatements");
        }
        return this.zzattr_attrAfterBodyStatements_cache;
    }

    @Override
    public int attrListIndex() {
        if (this.zzattr_attrListIndex_state == 0) {
            try {
                this.zzattr_attrListIndex_state = 1;
                this.zzattr_attrListIndex_cache = Flow.getListIndex(this);
            }
            finally {
                this.zzattr_attrListIndex_state = 0;
            }
            this.zzattr_attrListIndex_state = 2;
        } else if (this.zzattr_attrListIndex_state == 1) {
            throw new CyclicDependencyError(this, "attrListIndex");
        }
        return this.zzattr_attrListIndex_cache;
    }

    @Override
    public ImmutableList<NameDef> attrReadVariables() {
        if (this.zzattr_attrReadVariables_state == 0) {
            try {
                this.zzattr_attrReadVariables_state = 1;
                this.zzattr_attrReadVariables_cache = ReadVariables.calculate(this);
            }
            finally {
                this.zzattr_attrReadVariables_state = 0;
            }
            this.zzattr_attrReadVariables_state = 2;
        } else if (this.zzattr_attrReadVariables_state == 1) {
            throw new CyclicDependencyError(this, "attrReadVariables");
        }
        return this.zzattr_attrReadVariables_cache;
    }

    @Override
    public boolean attrIsDynamicContext() {
        return IsDynamicContext.calculate(this);
    }

    @Override
    public @Nullable PackageOrGlobal attrNearestPackage() {
        return AttrNearest.nearestPackage(this);
    }

    @Override
    public @Nullable NamedScope attrNearestNamedScope() {
        return AttrNearest.nearestNamedScope(this);
    }

    @Override
    public @Nullable WScope attrNearestScope() {
        return AttrNearest.nearestScope(this);
    }

    @Override
    public String attrPathDescription() {
        return PathDescription.get(this);
    }

    @Override
    public CompilationUnit attrCompilationUnit() {
        return AttrNearest.nearestCompilationUnit(this);
    }

    @Override
    public @Nullable ClassDef attrNearestClassDef() {
        return AttrNearest.nearestClassDef(this);
    }

    @Override
    public @Nullable ClassOrInterface attrNearestClassOrInterface() {
        return AttrNearest.nearestClassOrInterface(this);
    }

    @Override
    public @Nullable ClassOrModule attrNearestClassOrModule() {
        return AttrNearest.nearestClassOrModule(this);
    }

    @Override
    public @Nullable StructureDef attrNearestStructureDef() {
        return AttrNearest.nearestStructureDef(this);
    }

    @Override
    public @Nullable FunctionImplementation attrNearestFuncDef() {
        return AttrNearest.nearestFuncDef(this);
    }

    @Override
    public @Nullable ExprClosure attrNearestExprClosure() {
        return AttrNearest.nearestExprClosure(this);
    }

    @Override
    public @Nullable ExprStatementsBlock attrNearestExprStatementsBlock() {
        return AttrNearest.nearestExprStatementsBlock(this);
    }

    @Override
    public @Nullable NameDef tryGetNameDef() {
        return AttrNameDef.tryGetNameDef(this);
    }

    @Override
    public WPos attrSource() {
        return AttrPos.getPos(this);
    }

    @Override
    public WPos attrErrorPos() {
        return AttrPos.getErrorPos(this);
    }

    @Override
    public WurstModel getModel() {
        return AttrImportedPackage.getModel(this);
    }

    @Override
    public ImStmt imTranslateStmt(ImTranslator translator, ImFunction f) {
        return StmtTranslation.translate(this, translator, f);
    }

    @Override
    public void addError(String msg) {
        ErrorHandling.addError(this, msg);
    }

    @Override
    public void addWarning(String msg) {
        ErrorHandling.addWarning(this, msg);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return ErrorHandling.getErrorHandler(this);
    }

    @Override
    public @Nullable TypeDef lookupType(String name, boolean showErrors) {
        return NameResolution.lookupType(this, name, showErrors);
    }

    @Override
    public PackageLink lookupPackage(String name, boolean showErrors) {
        return NameResolution.lookupPackage(this, name, showErrors);
    }

    @Override
    public NameLink lookupVar(String name, boolean showErrors) {
        return NameResolution.lookupVar(this, name, showErrors);
    }

    @Override
    public NameLink lookupVarNoConfig(String name, boolean showErrors) {
        return NameResolution.lookupVarNoConfig(this, name, showErrors);
    }

    @Override
    public NameLink lookupMemberVar(WurstType receiverType, String name, boolean showErrors) {
        return NameResolution.lookupMemberVar(this, receiverType, name, showErrors);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupFuncs(String name, boolean showErrors) {
        return NameResolution.lookupFuncs(this, name, showErrors);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupFuncsNoConfig(String name, boolean showErrors) {
        return NameResolution.lookupFuncsNoConfig(this, name, showErrors);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupMemberFuncs(WurstType receiverType, String name, boolean showErrors) {
        return NameResolution.lookupMemberFuncs(this, receiverType, name, showErrors);
    }

    @Override
    public @Nullable TypeDef lookupType(String name) {
        return NameResolution.lookupTypeShort(this, name);
    }

    @Override
    public PackageLink lookupPackage(String name) {
        return NameResolution.lookupPackageShort(this, name);
    }

    @Override
    public NameLink lookupVar(String name) {
        return NameResolution.lookupVarShort(this, name);
    }

    @Override
    public NameLink lookupMemberVar(WurstType receiverType, String name) {
        return NameResolution.lookupMemberVarShort(this, receiverType, name);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupFuncs(String name) {
        return NameResolution.lookupFuncsShort(this, name);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupMemberFuncs(WurstType receiverType, String name) {
        return NameResolution.lookupMemberFuncsShort(this, receiverType, name);
    }

    @Override
    public com.google.common.collect.ImmutableList<VarDef> attrUsedGlobalVariables() {
        if (this.zzattr_attrUsedGlobalVariables_state == 0) {
            com.google.common.collect.ImmutableList<VarDef> r;
            this.zzattr_attrUsedGlobalVariables_state = 1;
            this.zzattr_attrUsedGlobalVariables_cache = Utils.emptyList();
            while (true) {
                r = UsedGlobalVariables.getUsedGlobals(this);
                if (this.zzattr_attrUsedGlobalVariables_state != 3 || this.zzattr_attrUsedGlobalVariables_cache.equals(r)) break;
                this.zzattr_attrUsedGlobalVariables_cache = r;
            }
            this.zzattr_attrUsedGlobalVariables_cache = r;
            this.zzattr_attrUsedGlobalVariables_state = 2;
        } else if (this.zzattr_attrUsedGlobalVariables_state == 1) {
            this.zzattr_attrUsedGlobalVariables_state = 3;
        }
        return this.zzattr_attrUsedGlobalVariables_cache;
    }

    @Override
    public com.google.common.collect.ImmutableList<VarDef> attrReadGlobalVariables() {
        if (this.zzattr_attrReadGlobalVariables_state == 0) {
            com.google.common.collect.ImmutableList<VarDef> r;
            this.zzattr_attrReadGlobalVariables_state = 1;
            this.zzattr_attrReadGlobalVariables_cache = Utils.emptyList();
            while (true) {
                r = UsedGlobalVariables.getReadGlobals(this);
                if (this.zzattr_attrReadGlobalVariables_state != 3 || this.zzattr_attrReadGlobalVariables_cache.equals(r)) break;
                this.zzattr_attrReadGlobalVariables_cache = r;
            }
            this.zzattr_attrReadGlobalVariables_cache = r;
            this.zzattr_attrReadGlobalVariables_state = 2;
        } else if (this.zzattr_attrReadGlobalVariables_state == 1) {
            this.zzattr_attrReadGlobalVariables_state = 3;
        }
        return this.zzattr_attrReadGlobalVariables_cache;
    }

    @Override
    public ImmutableCollection<WPackage> attrUsedPackages() {
        return UsedPackages.usedPackages(this);
    }

    @Override
    public String description() {
        return Description.description(this);
    }

    @Override
    public String descriptionHtml() {
        return DescriptionHtml.description(this);
    }

    @Override
    public boolean isSubtreeOf(Element other) {
        return SmallHelpers.isSubtreeOf(this, other);
    }

    @Override
    public void prettyPrint(Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.prettyPrint(this, spacer, sb, indent);
    }

    @Override
    public List<String> calculateUnhandledCases() {
        return SwitchStatements.unhandledCases(this);
    }

    @Override
    public boolean calculateHandlesAllCases() {
        return SwitchStatements.handlesAllCases(this);
    }
}

