/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.datastructures;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;

public class Worklist<T> {
    private final ArrayDeque<T> queue = new ArrayDeque();
    private final HashSet<T> set = new HashSet();

    public Worklist() {
    }

    public Worklist(Iterable<? extends T> nodes) {
        for (T node : nodes) {
            this.addLast(node);
        }
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public void addFirst(T node) {
        if (this.set.add(node)) {
            this.queue.addFirst(node);
        }
    }

    public void addLast(T node) {
        if (this.set.add(node)) {
            this.queue.addLast(node);
        }
    }

    public T poll() {
        T result = this.queue.poll();
        if (result != null) {
            this.set.remove(result);
        }
        return result;
    }

    public int size() {
        return this.queue.size();
    }

    public void addAll(Collection<? extends T> elems) {
        for (T elem : elems) {
            this.addLast(elem);
        }
    }
}

