/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.port.Orient;

public class BinOutputStream
extends BinStream
implements AutoCloseable {
    private final OutputStream _outStream;

    private void ensureCap(long size) {
        long toAdd = size - this._bytes.size();
        for (long i = 1L; i <= toAdd; ++i) {
            this._bytes.add(null);
        }
    }

    public void writeByte(byte val) {
        this.ensureCap(this._pos + 1L);
        this._bytes.set(this._pos++, val);
    }

    public void writeBytes(byte[] vals) {
        this.ensureCap(this._pos + (long)vals.length);
        for (byte val : vals) {
            this._bytes.set(this._pos++, val);
        }
    }

    private void write(@Nonnull OutputStream outStream) throws IOException {
        int sizeI;
        BinStream.ByteList bytes = this._bytes;
        for (long size = this.size(); size > 0L; size -= (long)sizeI) {
            sizeI = (int)size;
            byte[] buf = new byte[sizeI];
            int i = 0;
            while ((long)i < bytes.size()) {
                buf[i] = bytes.get(i);
                ++i;
            }
            outStream.write(buf);
        }
        outStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.write(this._outStream);
        this._outStream.close();
    }

    public BinOutputStream(@Nonnull OutputStream outStream) {
        this._outStream = outStream;
    }

    public BinOutputStream(@Nonnull File file) throws IOException {
        this._outStream = Orient.createFileOutputStream(file);
    }
}

