/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes.names;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.ast.AstElementWithBody;
import de.peeeq.wurstscript.ast.AstElementWithParameters;
import de.peeeq.wurstscript.ast.AstElementWithTypeParameters;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ClassOrModuleOrModuleInstanciation;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.EnumDef;
import de.peeeq.wurstscript.ast.EnumMember;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.FunctionDefinition;
import de.peeeq.wurstscript.ast.InterfaceDef;
import de.peeeq.wurstscript.ast.JassGlobalBlock;
import de.peeeq.wurstscript.ast.JassToplevelDeclaration;
import de.peeeq.wurstscript.ast.LocalVarDef;
import de.peeeq.wurstscript.ast.LoopStatementWithVarDef;
import de.peeeq.wurstscript.ast.ModuleDef;
import de.peeeq.wurstscript.ast.ModuleInstanciation;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NativeFunc;
import de.peeeq.wurstscript.ast.TupleDef;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.TypeParamDefs;
import de.peeeq.wurstscript.ast.VarDef;
import de.peeeq.wurstscript.ast.WEntities;
import de.peeeq.wurstscript.ast.WEntity;
import de.peeeq.wurstscript.ast.WImport;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.ast.WShortParameter;
import de.peeeq.wurstscript.ast.WStatement;
import de.peeeq.wurstscript.ast.WStatements;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.names.DefLink;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.PackageLink;
import de.peeeq.wurstscript.attributes.names.TypeDefLink;
import de.peeeq.wurstscript.attributes.names.TypeLink;
import de.peeeq.wurstscript.attributes.names.VarLink;
import de.peeeq.wurstscript.attributes.names.Visibility;
import de.peeeq.wurstscript.types.WurstTypeClass;
import de.peeeq.wurstscript.types.WurstTypeInterface;
import de.peeeq.wurstscript.utils.Utils;
import de.peeeq.wurstscript.validation.WurstValidator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class NameLinks {
    public static ImmutableMultimap<String, DefLink> calculate(ClassOrModuleOrModuleInstanciation c) {
        HashMultimap result = HashMultimap.create();
        NameLinks.addDefinedNames((Multimap<String, DefLink>)result, c);
        Map<String, Map<FuncLink, OverrideCheckResult>> overrideCheckResults = NameLinks.initOverrideMap((Multimap<String, DefLink>)result);
        NameLinks.addNamesFromUsedModuleInstantiations(c, (Multimap<String, DefLink>)result, overrideCheckResults);
        if (c instanceof ClassDef) {
            WurstTypeClass classType = ((ClassDef)c).attrTypC();
            NameLinks.addNamesFromSuperClass((Multimap<String, DefLink>)result, classType, overrideCheckResults);
            NameLinks.addNamesFromImplementedInterfaces((Multimap<String, DefLink>)result, classType, overrideCheckResults);
        }
        NameLinks.reportOverrideErrors(overrideCheckResults);
        return ImmutableMultimap.copyOf((Multimap)result);
    }

    @NotNull
    private static Map<String, Map<FuncLink, OverrideCheckResult>> initOverrideMap(Multimap<String, DefLink> result) {
        Hashtable<String, Map<FuncLink, OverrideCheckResult>> overrideCheckResults = new Hashtable<String, Map<FuncLink, OverrideCheckResult>>();
        for (DefLink link : result.values()) {
            if (!(link instanceof FuncLink)) continue;
            Map map = overrideCheckResults.computeIfAbsent(link.getName(), s -> new HashMap());
            map.put((FuncLink)link, new OverrideCheckResult());
        }
        return overrideCheckResults;
    }

    private static void reportOverrideErrors(Map<String, Map<FuncLink, OverrideCheckResult>> overrideCheckResults) {
        for (Map<FuncLink, OverrideCheckResult> map : overrideCheckResults.values()) {
            for (Map.Entry<FuncLink, OverrideCheckResult> e : map.entrySet()) {
                FunctionDefinition f = e.getKey().getDef();
                OverrideCheckResult check = e.getValue();
                if (f.attrIsOverride() && !check.doesOverride) {
                    StringBuilder msg = new StringBuilder("Function " + f.getName() + " does not override anything.");
                    for (String overrideError : check.overrideErrors) {
                        msg.append("\n  ");
                        msg.append(overrideError);
                    }
                    f.addError(msg.toString());
                    continue;
                }
                if (f.attrIsOverride() || !check.doesOverride) continue;
                if (check.requiresOverrideMod) {
                    f.addError("Function " + f.getName() + " must be marked with the 'override' modifier.");
                    continue;
                }
                f.addWarning("Function " + f.getName() + " should be marked with the 'override' modifier.");
            }
        }
    }

    public static ImmutableMultimap<String, DefLink> calculate(InterfaceDef i) {
        HashMultimap result = HashMultimap.create();
        NameLinks.addDefinedNames((Multimap<String, DefLink>)result, (WScope)i, (List<? extends NameDef>)i.getMethods());
        Map<String, Map<FuncLink, OverrideCheckResult>> overrideCheckResults = NameLinks.initOverrideMap((Multimap<String, DefLink>)result);
        NameLinks.addNamesFromExtendedInterfaces((Multimap<String, DefLink>)result, i.attrTypI(), overrideCheckResults);
        NameLinks.reportOverrideErrors(overrideCheckResults);
        return ImmutableMultimap.copyOf((Multimap)result);
    }

    private static void addNamesFromExtendedInterfaces(Multimap<String, DefLink> result, WurstTypeInterface iType, Map<String, Map<FuncLink, OverrideCheckResult>> overrideCheckResults) {
        for (WurstTypeInterface superI : iType.extendedInterfaces()) {
            NameLinks.addNewNameLinks(result, overrideCheckResults, superI.nameLinks(), false);
        }
    }

    private static void addNamesFromImplementedInterfaces(Multimap<String, DefLink> result, WurstTypeClass classDef, Map<String, Map<FuncLink, OverrideCheckResult>> overrideCheckResults) {
        for (WurstTypeInterface interfaceType : classDef.implementedInterfaces()) {
            NameLinks.addNewNameLinks(result, overrideCheckResults, interfaceType.nameLinks(), false);
        }
    }

    private static void addNamesFromSuperClass(Multimap<String, DefLink> result, WurstTypeClass c, Map<String, Map<FuncLink, OverrideCheckResult>> overrideCheckResults) {
        @Nullable WurstTypeClass superClass = c.extendedClass();
        if (superClass != null) {
            NameLinks.addNewNameLinks(result, overrideCheckResults, superClass.nameLinks(), false);
        }
    }

    private static void addNewNameLinks(Multimap<String, DefLink> result, Map<String, Map<FuncLink, OverrideCheckResult>> overrideCheckResults, ImmutableMultimap<String, DefLink> newNameLinks, boolean allowStaticOverride) {
        for (Map.Entry e : newNameLinks.entries()) {
            DefLink def = (DefLink)e.getValue();
            if (!def.getVisibility().isInherited()) continue;
            String name = (String)e.getKey();
            boolean isOverridden = false;
            if (def instanceof FuncLink) {
                FuncLink func = (FuncLink)def;
                Map otherFuncs = overrideCheckResults.getOrDefault(name, Collections.emptyMap());
                for (Map.Entry e2 : otherFuncs.entrySet()) {
                    FuncLink otherFunc = (FuncLink)e2.getKey();
                    OverrideCheckResult checkResult = (OverrideCheckResult)e2.getValue();
                    String error = WurstValidator.checkOverride(otherFunc, func, allowStaticOverride);
                    if (error == null) {
                        checkResult.doesOverride = true;
                        if (!(func.getReceiverType() instanceof WurstTypeInterface)) {
                            checkResult.requiresOverrideMod = true;
                        }
                        isOverridden = true;
                        continue;
                    }
                    checkResult.addError(error);
                }
            }
            if (isOverridden) continue;
            result.put((Object)name, (Object)def.hidingPrivate());
        }
    }

    public static ImmutableMultimap<String, DefLink> calculate(CompilationUnit cu) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        NameLinks.addJassNames((ImmutableMultimap.Builder<String, DefLink>)result, cu);
        NameLinks.addPackages((ImmutableMultimap.Builder<String, DefLink>)result, cu);
        return result.build();
    }

    public static ImmutableMultimap<String, DefLink> calculate(AstElementWithBody c) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        WScope s = (WScope)((Object)c);
        NameLinks.addVarDefIfAny((ImmutableMultimap.Builder<String, DefLink>)result, s);
        NameLinks.addParametersIfAny((ImmutableMultimap.Builder<String, DefLink>)result, s);
        return result.build();
    }

    private static void addVarDefIfAny(ImmutableMultimap.Builder<String, DefLink> result, WScope s) {
        if (s instanceof LoopStatementWithVarDef) {
            LoopStatementWithVarDef l = (LoopStatementWithVarDef)s;
            result.put((Object)l.getLoopVar().getName(), (Object)VarLink.create(l.getLoopVar(), s));
        }
    }

    public static ImmutableMultimap<String, DefLink> calculate(EnumDef e) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        NameLinks.addDefinedNames((ImmutableMultimap.Builder<String, DefLink>)result, (WScope)e, (List<? extends NameDef>)e.getMembers());
        return result.build();
    }

    public static ImmutableMultimap<String, DefLink> calculate(NativeFunc nativeFunc) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        return result.build();
    }

    public static ImmutableMultimap<String, DefLink> calculate(TupleDef t) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        NameLinks.addDefinedNames((ImmutableMultimap.Builder<String, DefLink>)result, (WScope)t, (List<? extends NameDef>)t.getParameters());
        return result.build();
    }

    public static ImmutableMultimap<String, DefLink> calculate(WPackage p) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (WImport imp : p.getImports()) {
            if (imp.getPackagename().equals("NoWurst")) continue;
            WPackage importedPackage = imp.attrImportedPackage();
            if (importedPackage == null) {
                WLogger.info("could not resolve import: " + Utils.printElementWithSource(Optional.of(imp)));
                continue;
            }
            if (p.getName().equals("WurstREPL")) {
                result.putAll(importedPackage.getElements().attrNameLinks());
                result.putAll(importedPackage.attrNameLinks());
                continue;
            }
            result.putAll(importedPackage.attrExportedNameLinks());
        }
        return result.build();
    }

    public static ImmutableMultimap<String, DefLink> calculate(WEntities wEntities) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (WEntity e : wEntities) {
            if (e instanceof NameDef) {
                NameDef n = (NameDef)((Object)e);
                NameLinks.addNameDefDefLink((ImmutableMultimap.Builder<String, DefLink>)result, n, (WScope)wEntities);
            }
            if (!(e instanceof WScope) || e instanceof ModuleDef) continue;
            WScope scope = (WScope)((Object)e);
            TypeParamDefs typeParams = scope instanceof AstElementWithTypeParameters ? ((AstElementWithTypeParameters)((Object)scope)).getTypeParameters() : Collections.emptyList();
            NameLinks.addHidingPrivate((ImmutableMultimap.Builder<String, DefLink>)result, scope.attrNameLinks(), typeParams);
        }
        return result.build();
    }

    public static ImmutableMultimap<String, DefLink> calculate(WurstModel model) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (CompilationUnit cu : model) {
            result.putAll(cu.attrNameLinks());
        }
        return result.build();
    }

    public static ImmutableMultimap<String, DefLink> calculate(WStatements statements) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (WStatement s : statements) {
            if (!(s instanceof LocalVarDef)) continue;
            LocalVarDef var = (LocalVarDef)s;
            result.put((Object)var.getName(), (Object)VarLink.create(var, (WScope)statements));
        }
        return result.build();
    }

    private static void addParametersIfAny(ImmutableMultimap.Builder<String, DefLink> result, WScope s) {
        if (s instanceof AstElementWithParameters) {
            AstElementWithParameters withParams = (AstElementWithParameters)((Object)s);
            for (WParameter p : withParams.getParameters()) {
                result.put((Object)p.getName(), (Object)VarLink.create(p, s));
            }
        }
    }

    private static void addPackages(ImmutableMultimap.Builder<String, DefLink> result, CompilationUnit cu) {
        for (WPackage p : cu.getPackages()) {
            result.put((Object)p.getName(), (Object)PackageLink.create(p, cu));
        }
    }

    private static void addJassNames(ImmutableMultimap.Builder<String, DefLink> result, CompilationUnit cu) {
        for (JassToplevelDeclaration jd : cu.getJassDecls()) {
            if (jd instanceof NameDef) {
                NameDef def = (NameDef)((Object)jd);
                NameLinks.addNameDefDefLink(result, def, (WScope)cu);
                continue;
            }
            if (!(jd instanceof JassGlobalBlock)) continue;
            JassGlobalBlock jassGlobalBlock = (JassGlobalBlock)jd;
            NameLinks.addDefinedNames(result, (WScope)cu, (List<? extends NameDef>)jassGlobalBlock);
        }
    }

    private static void addNameDefDefLink(Consumer<DefLink> result, NameDef def, WScope scope) {
        if (def instanceof VarDef) {
            result.accept(VarLink.create((VarDef)def, scope));
        } else if (def instanceof FunctionDefinition) {
            result.accept(FuncLink.create((FunctionDefinition)def, scope));
        } else if (def instanceof WPackage) {
            result.accept(PackageLink.create((WPackage)def, scope));
        } else if (def instanceof TypeDef) {
            result.accept(TypeDefLink.create((TypeDef)def, scope));
        } else if (def instanceof EnumMember) {
            result.accept(VarLink.create((EnumMember)def, scope));
        }
    }

    private static void addNameDefDefLink(ImmutableMultimap.Builder<String, DefLink> result, NameDef def, WScope scope) {
        NameLinks.addNameDefDefLink((DefLink l) -> result.put((Object)l.getName(), l), def, scope);
    }

    private static void addNameDefDefLink(Multimap<String, DefLink> result, NameDef def, WScope scope) {
        NameLinks.addNameDefDefLink((DefLink l) -> result.put((Object)l.getName(), l), def, scope);
    }

    private static void addNamesFromUsedModuleInstantiations(ClassOrModuleOrModuleInstanciation c, Multimap<String, DefLink> result, Map<String, Map<FuncLink, OverrideCheckResult>> overrideCheckResults) {
        for (ModuleInstanciation m : c.getModuleInstanciations()) {
            NameLinks.addNewNameLinks(result, overrideCheckResults, m.attrNameLinks(), true);
        }
    }

    private static void addDefinedNames(Multimap<String, DefLink> result, ClassOrModuleOrModuleInstanciation c) {
        NameLinks.addDefinedNames(result, (WScope)c, (List<? extends NameDef>)c.getMethods());
        NameLinks.addDefinedNames(result, (WScope)c, (List<? extends NameDef>)c.getVars());
        NameLinks.addDefinedNames(result, (WScope)c, (List<? extends NameDef>)c.getModuleInstanciations());
        NameLinks.addDefinedNames(result, (WScope)c, (List<? extends NameDef>)c.getInnerClasses());
    }

    private static void addDefinedNames(ImmutableMultimap.Builder<String, DefLink> result, WScope definedIn, List<? extends NameDef> slots) {
        for (NameDef nameDef : slots) {
            NameLinks.addNameDefDefLink(result, nameDef, definedIn);
        }
    }

    private static void addDefinedNames(Multimap<String, DefLink> result, WScope definedIn, List<? extends NameDef> slots) {
        for (NameDef nameDef : slots) {
            NameLinks.addNameDefDefLink(result, nameDef, definedIn);
        }
    }

    public static void addHidingPrivate(ImmutableMultimap.Builder<String, DefLink> result, Multimap<String, DefLink> adding, List<TypeParamDef> typeParams) {
        for (Map.Entry e : adding.entries()) {
            if (((DefLink)e.getValue()).getVisibility() == Visibility.LOCAL) continue;
            result.put((Object)((String)e.getKey()), (Object)((DefLink)e.getValue()).hidingPrivate().withGenericTypeParams(typeParams));
        }
    }

    public static void addHidingPrivate(Multimap<String, DefLink> result, Multimap<String, DefLink> adding) {
        for (Map.Entry e : adding.entries()) {
            if (((DefLink)e.getValue()).getVisibility() == Visibility.LOCAL) continue;
            result.put((Object)((String)e.getKey()), (Object)((DefLink)e.getValue()).hidingPrivate());
        }
    }

    public static void addHidingPrivateAndProtected(ImmutableMultimap.Builder<String, DefLink> r, Multimap<String, ? extends DefLink> adding) {
        for (Map.Entry e : adding.entries()) {
            if (((DefLink)e.getValue()).getVisibility() == Visibility.LOCAL) continue;
            r.put((Object)((String)e.getKey()), (Object)((DefLink)e.getValue()).hidingPrivateAndProtected());
        }
    }

    public static void addTypesHidingPrivateAndProtected(ImmutableMultimap.Builder<String, TypeLink> r, Multimap<String, TypeLink> adding) {
        for (Map.Entry e : adding.entries()) {
            if (((TypeLink)e.getValue()).getVisibility() == Visibility.LOCAL) continue;
            r.put((Object)((String)e.getKey()), (Object)((TypeLink)e.getValue()).hidingPrivateAndProtected());
        }
    }

    public static ImmutableMultimap<String, DefLink> calculate(ExprClosure e) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (WShortParameter p : e.getShortParameters()) {
            result.put((Object)p.getName(), (Object)VarLink.create(p, (WScope)e));
        }
        return result.build();
    }

    private static class OverrideCheckResult {
        boolean doesOverride = false;
        boolean requiresOverrideMod = false;
        io.vavr.collection.List<String> overrideErrors = io.vavr.collection.List.empty();

        private OverrideCheckResult() {
        }

        public void addError(String error) {
            this.overrideErrors = this.overrideErrors.prepend((Object)error);
        }
    }
}

