/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.dataTypes.app;

import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.app.Coords2DF;
import net.moonlightflower.wc3libs.misc.Size;

public class Bounds
extends DataType {
    private Coords2DF _center;
    private Size _size;

    @Nonnull
    public Coords2DF getCenter() {
        return this._center;
    }

    @Nonnull
    public Size getSize() {
        return this._size;
    }

    public int getMinX() {
        return (int)(this.getCenter().getX().toFloat() - (float)this.getSize().getX() / 2.0f);
    }

    public int getMinY() {
        return (int)(this.getCenter().getY().toFloat() - (float)this.getSize().getY() / 2.0f);
    }

    public int getMaxX() {
        return (int)(this.getCenter().getX().toFloat() + (float)this.getSize().getX() / 2.0f);
    }

    public int getMaxY() {
        return (int)(this.getCenter().getY().toFloat() + (float)this.getSize().getY() / 2.0f);
    }

    public boolean equals(Object other) {
        if (other instanceof Bounds) {
            return this.equals((Bounds)other);
        }
        return super.equals(other);
    }

    public boolean equals(Bounds other) {
        return this.getCenter().equals(other.getCenter()) && this.getSize().equals(other.getSize());
    }

    public String toString() {
        return String.format("minX=%d minY=%d maxX=%d maxY=%d [%s]", this.getMinX(), this.getMinY(), this.getMaxX(), this.getMaxY(), this.getSize().toString());
    }

    @Nonnull
    public Bounds scale(double scale) {
        return new Bounds(this._size.scale(scale), this._center);
    }

    public Bounds(@Nonnull Size size, @Nonnull Coords2DF center) {
        this._center = center;
        this._size = size;
    }

    public Bounds(@Nonnull Size size) {
        this(size, new Coords2DF(0.0f, 0.0f));
    }

    public Bounds(int minX, int maxX, int minY, int maxY) {
        this(new Size(maxX - minX, maxY - minY), new Coords2DF((float)(maxX + minX) / 2.0f, (float)(maxY + minY) / 2.0f));
    }

    public static Bounds valueOf(int minX, int maxX, int minY, int maxY) {
        return new Bounds(minX, maxX, minY, maxY);
    }

    @Override
    public Bounds decode(Object val) {
        return Bounds.valueOf(0, 0, 0, 0);
    }

    public static Bounds decodeStatic(Object val) {
        if (val instanceof Bounds) {
            return Bounds.valueOf(((Bounds)val).getMinX(), ((Bounds)val).getMaxX(), ((Bounds)val).getMinY(), ((Bounds)val).getMaxY());
        }
        return null;
    }

    @Override
    public Object toSLKVal() {
        return null;
    }

    @Override
    public Object toTXTVal() {
        return null;
    }
}

