/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import de.peeeq.wurstscript.ast.ArrayInitializer;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ClassOrModuleInstanciation;
import de.peeeq.wurstscript.ast.ClassOrModuleOrModuleInstanciation;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.GlobalVarDef;
import de.peeeq.wurstscript.ast.ModuleInstanciation;
import de.peeeq.wurstscript.ast.OnDestroyDef;
import de.peeeq.wurstscript.ast.TypeExpr;
import de.peeeq.wurstscript.ast.VarInitialization;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.attributes.SmallHelpers;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImExprs;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImMethod;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImTypeArguments;
import de.peeeq.wurstscript.jassIm.ImTypeVar;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.CallType;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.translation.imtranslation.OverrideUtils;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeBoundTypeParam;
import de.peeeq.wurstscript.types.WurstTypeClass;
import de.peeeq.wurstscript.types.WurstTypeVoid;
import de.peeeq.wurstscript.utils.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ClassTranslator {
    private final ClassDef classDef;
    private final ImTranslator translator;
    private final List<Pair<ImVar, VarInitialization>> dynamicInits;
    private ImClass imClass;
    private final ImProg prog;
    private ImFunction classInitFunc;

    public ClassTranslator(ClassDef classDef, ImTranslator translator) {
        this.classDef = classDef;
        this.translator = translator;
        this.prog = translator.getImProg();
        this.dynamicInits = translator.getDynamicInits(classDef);
    }

    public static void translate(ClassDef classDef, ImTranslator translator) {
        new ClassTranslator(classDef, translator).translate();
        ClassTranslator.translateInnerClasses(classDef, translator);
    }

    private static void translateInnerClasses(ClassOrModuleOrModuleInstanciation mi, ImTranslator translator) {
        for (ModuleInstanciation mi2 : mi.getModuleInstanciations()) {
            ClassTranslator.translateInnerClasses(mi2, translator);
        }
        for (ClassDef innerClass : mi.getInnerClasses()) {
            ClassTranslator.translate(innerClass, translator);
        }
    }

    private void translate() {
        this.imClass = this.translator.getClassFor(this.classDef);
        this.prog.getClasses().add(this.imClass);
        this.addSuperClasses();
        List<ClassDef> subClasses = this.translator.getSubClasses(this.classDef);
        this.translateMethods(this.classDef, subClasses);
        this.translateVars(this.classDef);
        this.translateClassInitFunc();
        this.translateConstructors();
        this.createOnDestroyMethod();
        this.createDestroyMethod(subClasses);
    }

    private void addSuperClasses() {
        if (this.classDef.getExtendedClass() instanceof TypeExpr) {
            TypeExpr extended = (TypeExpr)this.classDef.getExtendedClass();
            this.addSuperClass(extended);
        }
        for (TypeExpr impl : this.classDef.getImplementsList()) {
            this.addSuperClass(impl);
        }
    }

    private void addSuperClass(TypeExpr extended) {
        this.imClass.getSuperClasses().add((ImClassType)extended.attrTyp().imTranslateType(this.translator));
    }

    private void createDestroyMethod(List<ClassDef> subClasses) {
        ImMethod m = this.translator.destroyMethod.getFor(this.classDef);
        this.imClass.getMethods().add(m);
        ImFunction f = this.translator.destroyFunc.getFor(this.classDef);
        for (ClassDef sc : subClasses) {
            ImMethod dm = this.translator.destroyMethod.getFor(sc);
            if (!this.hasOwnDestroy(sc, this.classDef)) continue;
            m.getSubMethods().add(dm);
        }
        OnDestroyDef trace = this.classDef.getOnDestroy();
        ImVar thisVar = (ImVar)f.getParameters().get(0);
        ClassDef c = this.classDef;
        ImFunction scOnDestroy = this.translator.getFuncFor(c.getOnDestroy());
        f.getBody().add(JassIm.ImFunctionCall(trace, scOnDestroy, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(JassIm.ImVarAccess(thisVar)), false, CallType.NORMAL));
        f.getBody().add(JassIm.ImDealloc(c.getOnDestroy(), this.imClassType(), JassIm.ImVarAccess(thisVar)));
    }

    private ImClassType imClassType() {
        ImTypeArguments typeArgs = this.imClass.getTypeVariables().stream().map(tv -> JassIm.ImTypeArgument(JassIm.ImTypeVarRef(tv), Collections.emptyMap())).collect(Collectors.toCollection(() -> JassIm.ImTypeArguments(new ImTypeArgument[0])));
        return JassIm.ImClassType(this.imClass, typeArgs);
    }

    private boolean hasOwnDestroy(ClassDef sc, ClassDef classDef2) {
        if (sc == classDef2) {
            return false;
        }
        if (sc.getOnDestroy().attrHasEmptyBody()) {
            WurstTypeClass superClass = (WurstTypeClass)sc.getExtendedClass().attrTyp();
            if (this.hasOwnDestroy(superClass.getClassDef(), classDef2)) {
                return true;
            }
            for (ModuleInstanciation mi : sc.getModuleInstanciations()) {
                if (!this.hasOwnDestroy(mi)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean hasOwnDestroy(ModuleInstanciation mi) {
        if (!mi.getOnDestroy().attrHasEmptyBody()) {
            return true;
        }
        for (ModuleInstanciation subMod : mi.getModuleInstanciations()) {
            if (!this.hasOwnDestroy(subMod)) continue;
            return true;
        }
        return false;
    }

    private void createOnDestroyMethod() {
        OnDestroyDef onDestroy = this.classDef.getOnDestroy();
        ImFunction f = this.translator.getFuncFor(onDestroy);
        this.addOnDestroyActions(f, f.getBody(), this.classDef, this.translator.getThisVar(onDestroy));
    }

    private void addOnDestroyActions(ImFunction f, List<ImStmt> addTo, ClassOrModuleInstanciation c, ImVar thisVar) {
        ClassDef cd;
        WurstTypeClass ct;
        WurstTypeClass extended;
        List<ImStmt> stmts = this.translator.translateStatements(f, c.getOnDestroy().getBody());
        this.replaceThisExpr(stmts, this.translator.getThisVar(c.getOnDestroy()), thisVar);
        addTo.addAll(stmts);
        for (ModuleInstanciation mi : c.getModuleInstanciations()) {
            this.addOnDestroyActions(f, addTo, mi, thisVar);
        }
        if (c instanceof ClassDef && (extended = (ct = (cd = (ClassDef)c).attrTypC()).extendedClass()) != null) {
            ImFunction onDestroy = this.translator.getFuncFor(extended.getClassDef().getOnDestroy());
            ImTypeArguments typeArgs = JassIm.ImTypeArguments(new ImTypeArgument[0]);
            for (WurstTypeBoundTypeParam tp : extended.getTypeParameters()) {
                if (!tp.isTemplateTypeParameter()) continue;
                typeArgs.add(tp.imTranslateToTypeArgument(this.translator));
            }
            addTo.add(JassIm.ImFunctionCall(c, onDestroy, typeArgs, JassIm.ImExprs(JassIm.ImVarAccess(thisVar)), false, CallType.NORMAL));
        }
    }

    private void replaceThisExpr(List<ImStmt> stmts, final ImVar oldThis, final ImVar newThis) {
        if (oldThis == newThis) {
            return;
        }
        Element.DefaultVisitor replacer = new Element.DefaultVisitor(){

            @Override
            public void visit(ImVarAccess v) {
                super.visit(v);
                if (v.getVar() == oldThis) {
                    v.setVar(newThis);
                }
            }
        };
        for (ImStmt s : stmts) {
            s.accept(replacer);
        }
    }

    private void translateConstructors() {
        for (ModuleInstanciation mi : this.classDef.getModuleInstanciations()) {
            this.translateModuleConstructors(mi);
        }
        for (ConstructorDef c : this.classDef.getConstructors()) {
            this.translateConstructor(c);
        }
    }

    private void translateModuleConstructors(ModuleInstanciation mi) {
        for (ModuleInstanciation child : mi.getModuleInstanciations()) {
            this.translateModuleConstructors(child);
        }
        for (ConstructorDef c : mi.getConstructors()) {
            this.translateModuleConstructor(c, mi);
        }
    }

    private void translateVars(ClassOrModuleInstanciation c) {
        for (ModuleInstanciation mi : c.getModuleInstanciations()) {
            this.translateVars(mi);
        }
        for (GlobalVarDef v : c.getVars()) {
            this.translateVar(v);
        }
    }

    private void translateVar(GlobalVarDef s) {
        ImVar v = this.translator.getVarFor(s);
        if (s.attrIsDynamicClassMember()) {
            this.imClass.getFields().add(v);
            this.dynamicInits.add(Pair.create(v, s.getInitialExpr()));
        } else {
            this.translator.addGlobalInitalizer(v, this.classDef.attrNearestPackage(), s.getInitialExpr());
            this.translator.addGlobal(v);
        }
    }

    private void translateMethods(ClassOrModuleInstanciation c, List<ClassDef> subClasses) {
        for (FuncDef f : c.getMethods()) {
            this.translateMethod(f, subClasses);
        }
        for (ModuleInstanciation mi : c.getModuleInstanciations()) {
            this.translateMethods(mi, subClasses);
        }
    }

    private void translateMethod(FuncDef s, List<ClassDef> subClasses) {
        ImFunction f = this.createStaticCallFunc(s);
        if (!s.attrIsStatic()) {
            ImMethod m = this.translator.getMethodFor(s);
            this.imClass.getMethods().add(m);
            m.setImplementation(f);
            m.setIsAbstract(s.attrIsAbstract());
            Map<ClassDef, FuncDef> subClasses2 = this.translator.getClassesWithImplementation(subClasses, s);
            for (Map.Entry<ClassDef, FuncDef> subE : subClasses2.entrySet()) {
                FuncDef subM = subE.getValue();
                ClassDef subC = subE.getKey();
                WurstTypeClass ct = this.getExtendedClassType(subC);
                VariableBinding typeBinding = ct == null ? VariableBinding.emptyMapping() : ct.getTypeArgBinding();
                ImClass subClass = this.translator.getClassFor(subC);
                ImMethod subMethod = this.translator.getMethodFor(subM);
                OverrideUtils.addOverride(this.translator, s, subClass, subMethod, subM, typeBinding);
            }
        }
    }

    private WurstTypeClass getExtendedClassType(ClassDef subC) {
        if (subC.getExtendedClass() == null) {
            return null;
        }
        WurstType t = subC.getExtendedClass().attrTyp();
        if (t instanceof WurstTypeClass) {
            WurstTypeClass ct = (WurstTypeClass)t;
            ClassDef superClass = ct.getClassDef();
            if (superClass == this.classDef) {
                return ct;
            }
            WurstTypeClass t2 = this.getExtendedClassType(superClass);
            assert (t2 != null);
            t2.setTypeArgs(ct.getTypeArgBinding());
            return t2;
        }
        return null;
    }

    private ImFunction createStaticCallFunc(FuncDef funcDef) {
        ImFunction f = this.translator.getFuncFor(funcDef);
        f.getBody().addAll(this.translator.translateStatements(f, funcDef.getBody()));
        if (funcDef.attrIsAbstract() && !(funcDef.attrReturnType() instanceof WurstTypeVoid)) {
            f.getBody().add(JassIm.ImReturn(funcDef, funcDef.attrReturnType().getDefaultValue(this.translator)));
        }
        return f;
    }

    private void translateConstructor(ConstructorDef constr) {
        this.createNewFunc(constr);
        this.createConstructFunc(constr);
    }

    private void createNewFunc(ConstructorDef constr) {
        ConstructorDef trace = constr;
        ImFunction f = this.translator.getConstructNewFunc(constr);
        for (WParameter p : constr.getParameters()) {
            ImVar imP = JassIm.ImVar(p, p.attrTyp().imTranslateType(this.translator), p.getName(), false);
            f.getParameters().add(imP);
        }
        ImVar thisVar = JassIm.ImVar(constr, this.imClassType(), "this", false);
        f.getLocals().add(thisVar);
        f.getBody().add(JassIm.ImSet(trace, JassIm.ImVarAccess(thisVar), JassIm.ImAlloc(constr, this.imClassType())));
        ImFunction constrFunc = this.translator.getConstructFunc(constr);
        ImExprs arguments = JassIm.ImExprs(JassIm.ImVarAccess(thisVar));
        for (ImVar a : f.getParameters()) {
            arguments.add(JassIm.ImVarAccess(a));
        }
        ImTypeArguments typeArgs = JassIm.ImTypeArguments(new ImTypeArgument[0]);
        for (ImTypeVar tv : this.imClass.getTypeVariables()) {
            typeArgs.add(JassIm.ImTypeArgument(JassIm.ImTypeVarRef(tv), Collections.emptyMap()));
        }
        f.getBody().add(JassIm.ImFunctionCall(trace, constrFunc, typeArgs, arguments, false, CallType.NORMAL));
        f.getBody().add(JassIm.ImReturn(trace, JassIm.ImVarAccess(thisVar)));
    }

    private void createConstructFunc(ConstructorDef constr) {
        ConstructorDef trace = constr;
        ImFunction f = this.translator.getConstructFunc(constr);
        ImVar thisVar = this.translator.getThisVar(constr);
        ConstructorDef superConstr = constr.attrSuperConstructor();
        if (superConstr != null) {
            ImFunction superConstrFunc = this.translator.getConstructFunc(superConstr);
            ImExprs arguments = JassIm.ImExprs(JassIm.ImVarAccess(thisVar));
            for (Expr a : SmallHelpers.superArgs(constr)) {
                arguments.add(a.imTranslateExpr(this.translator, f));
            }
            ImTypeArguments typeArgs = JassIm.ImTypeArguments(new ImTypeArgument[0]);
            ClassDef classDef = constr.attrNearestClassDef();
            assert (classDef != null);
            WurstType extendedType = classDef.getExtendedClass().attrTyp();
            if (extendedType instanceof WurstTypeClass) {
                WurstTypeClass extendedTypeC = (WurstTypeClass)extendedType;
                for (WurstTypeBoundTypeParam bt : extendedTypeC.getTypeParameters()) {
                    if (!bt.isTemplateTypeParameter()) continue;
                    typeArgs.add(bt.imTranslateToTypeArgument(this.translator));
                }
            }
            f.getBody().add(JassIm.ImFunctionCall(trace, superConstrFunc, typeArgs, arguments, false, CallType.NORMAL));
        }
        ImTypeArguments typeArguments = JassIm.ImTypeArguments(new ImTypeArgument[0]);
        for (ImTypeVar tv : this.imClass.getTypeVariables()) {
            typeArguments.add(JassIm.ImTypeArgument(JassIm.ImTypeVarRef(tv), Collections.emptyMap()));
        }
        f.getBody().add(JassIm.ImFunctionCall(trace, this.classInitFunc, typeArguments, JassIm.ImExprs(JassIm.ImVarAccess(thisVar)), false, CallType.NORMAL));
        f.getBody().addAll(this.translator.translateStatements(f, constr.getBody()));
    }

    private void translateClassInitFunc() {
        ClassDef trace = this.classDef;
        ImVar thisVar = JassIm.ImVar(trace, this.imClassType(), "this", false);
        this.classInitFunc = JassIm.ImFunction(this.classDef, this.translator.getNameFor(this.classDef) + "_init", JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(thisVar), JassIm.ImVoid(), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), Collections.emptyList());
        this.imClass.getFunctions().add(this.classInitFunc);
        ImFunction f = this.classInitFunc;
        for (Pair<ImVar, VarInitialization> i : this.translator.getDynamicInits(this.classDef)) {
            ImVar v = i.getA();
            if (i.getB() instanceof Expr) {
                Expr e = (Expr)i.getB();
                ImSet s = JassIm.ImSet(trace, JassIm.ImMemberAccess(trace, JassIm.ImVarAccess(thisVar), JassIm.ImTypeArguments(new ImTypeArgument[0]), v, JassIm.ImExprs(new ImExpr[0])), e.imTranslateExpr(this.translator, f));
                f.getBody().add(s);
                continue;
            }
            if (!(i.getB() instanceof ArrayInitializer)) continue;
            ArrayInitializer ai = (ArrayInitializer)i.getB();
            int index = 0;
            for (Expr e : ai.getValues()) {
                ImSet s = JassIm.ImSet(trace, JassIm.ImMemberAccess(trace, JassIm.ImVarAccess(thisVar), JassIm.ImTypeArguments(new ImTypeArgument[0]), v, JassIm.ImExprs(JassIm.ImIntVal(index))), e.imTranslateExpr(this.translator, f));
                f.getBody().add(s);
                ++index;
            }
        }
        for (ModuleInstanciation mi : this.classDef.getModuleInstanciations()) {
            this.addModuleInits(f, mi, thisVar);
        }
    }

    private void addModuleInits(ImFunction f, ModuleInstanciation mi, ImVar thisVar) {
        for (ConstructorDef c : mi.getConstructors()) {
            ImFunction moduleConstr = this.translator.getConstructFunc(c);
            f.getBody().add(JassIm.ImFunctionCall(c, moduleConstr, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(JassIm.ImVarAccess(thisVar)), false, CallType.NORMAL));
        }
    }

    private void translateModuleConstructor(ConstructorDef constr, ModuleInstanciation mi) {
        ImFunction f = this.translator.getConstructFunc(constr);
        ImVar thisVar = this.translator.getThisVar(constr);
        for (ModuleInstanciation child : mi.getModuleInstanciations()) {
            this.addModuleInits(f, child, thisVar);
        }
        f.getBody().addAll(this.translator.translateStatements(f, constr.getBody()));
    }
}

